/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkGroupsResponse extends AthenaResponse implements
        ToCopyableBuilder<ListWorkGroupsResponse.Builder, ListWorkGroupsResponse> {
    private static final SdkField<List<WorkGroupSummary>> WORK_GROUPS_FIELD = SdkField
            .<List<WorkGroupSummary>> builder(MarshallingType.LIST)
            .memberName("WorkGroups")
            .getter(getter(ListWorkGroupsResponse::workGroups))
            .setter(setter(Builder::workGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkGroupSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkGroupSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWorkGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORK_GROUPS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<WorkGroupSummary> workGroups;

    private final String nextToken;

    private ListWorkGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.workGroups = builder.workGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WorkGroups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkGroups() {
        return workGroups != null && !(workGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>WorkGroupSummary</a> objects that include the names, descriptions, creation times, and states for
     * each workgroup.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkGroups} method.
     * </p>
     * 
     * @return A list of <a>WorkGroupSummary</a> objects that include the names, descriptions, creation times, and
     *         states for each workgroup.
     */
    public final List<WorkGroupSummary> workGroups() {
        return workGroups;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkGroups() ? workGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkGroupsResponse)) {
            return false;
        }
        ListWorkGroupsResponse other = (ListWorkGroupsResponse) obj;
        return hasWorkGroups() == other.hasWorkGroups() && Objects.equals(workGroups(), other.workGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkGroupsResponse").add("WorkGroups", hasWorkGroups() ? workGroups() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkGroups":
            return Optional.ofNullable(clazz.cast(workGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListWorkGroupsResponse, T> g) {
        return obj -> g.apply((ListWorkGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AthenaResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkGroupsResponse> {
        /**
         * <p>
         * A list of <a>WorkGroupSummary</a> objects that include the names, descriptions, creation times, and states
         * for each workgroup.
         * </p>
         * 
         * @param workGroups
         *        A list of <a>WorkGroupSummary</a> objects that include the names, descriptions, creation times, and
         *        states for each workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroups(Collection<WorkGroupSummary> workGroups);

        /**
         * <p>
         * A list of <a>WorkGroupSummary</a> objects that include the names, descriptions, creation times, and states
         * for each workgroup.
         * </p>
         * 
         * @param workGroups
         *        A list of <a>WorkGroupSummary</a> objects that include the names, descriptions, creation times, and
         *        states for each workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroups(WorkGroupSummary... workGroups);

        /**
         * <p>
         * A list of <a>WorkGroupSummary</a> objects that include the names, descriptions, creation times, and states
         * for each workgroup.
         * </p>
         * This is a convenience that creates an instance of the {@link List<WorkGroupSummary>.Builder} avoiding the
         * need to create one manually via {@link List<WorkGroupSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<WorkGroupSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #workGroups(List<WorkGroupSummary>)}.
         * 
         * @param workGroups
         *        a consumer that will call methods on {@link List<WorkGroupSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workGroups(List<WorkGroupSummary>)
         */
        Builder workGroups(Consumer<WorkGroupSummary.Builder>... workGroups);

        /**
         * <p>
         * A token generated by the Athena service that specifies where to continue pagination if a previous request was
         * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of
         * the previous page call.
         * </p>
         * 
         * @param nextToken
         *        A token generated by the Athena service that specifies where to continue pagination if a previous
         *        request was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the
         *        response object of the previous page call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AthenaResponse.BuilderImpl implements Builder {
        private List<WorkGroupSummary> workGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkGroupsResponse model) {
            super(model);
            workGroups(model.workGroups);
            nextToken(model.nextToken);
        }

        public final List<WorkGroupSummary.Builder> getWorkGroups() {
            List<WorkGroupSummary.Builder> result = WorkGroupsListCopier.copyToBuilder(this.workGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkGroups(Collection<WorkGroupSummary.BuilderImpl> workGroups) {
            this.workGroups = WorkGroupsListCopier.copyFromBuilder(workGroups);
        }

        @Override
        @Transient
        public final Builder workGroups(Collection<WorkGroupSummary> workGroups) {
            this.workGroups = WorkGroupsListCopier.copy(workGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder workGroups(WorkGroupSummary... workGroups) {
            workGroups(Arrays.asList(workGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder workGroups(Consumer<WorkGroupSummary.Builder>... workGroups) {
            workGroups(Stream.of(workGroups).map(c -> WorkGroupSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListWorkGroupsResponse build() {
            return new ListWorkGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
