/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A query, where <code>QueryString</code> contains the SQL statements that make up the query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NamedQuery implements SdkPojo, Serializable, ToCopyableBuilder<NamedQuery.Builder, NamedQuery> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(NamedQuery::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(NamedQuery::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(NamedQuery::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QueryString").getter(getter(NamedQuery::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryString").build()).build();

    private static final SdkField<String> NAMED_QUERY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamedQueryId").getter(getter(NamedQuery::namedQueryId)).setter(setter(Builder::namedQueryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamedQueryId").build()).build();

    private static final SdkField<String> WORK_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkGroup").getter(getter(NamedQuery::workGroup)).setter(setter(Builder::workGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            DATABASE_FIELD, QUERY_STRING_FIELD, NAMED_QUERY_ID_FIELD, WORK_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String database;

    private final String queryString;

    private final String namedQueryId;

    private final String workGroup;

    private NamedQuery(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.database = builder.database;
        this.queryString = builder.queryString;
        this.namedQueryId = builder.namedQueryId;
        this.workGroup = builder.workGroup;
    }

    /**
     * <p>
     * The query name.
     * </p>
     * 
     * @return The query name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The query description.
     * </p>
     * 
     * @return The query description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The database to which the query belongs.
     * </p>
     * 
     * @return The database to which the query belongs.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * The SQL statements that make up the query.
     * </p>
     * 
     * @return The SQL statements that make up the query.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The unique identifier of the query.
     * </p>
     * 
     * @return The unique identifier of the query.
     */
    public final String namedQueryId() {
        return namedQueryId;
    }

    /**
     * <p>
     * The name of the workgroup that contains the named query.
     * </p>
     * 
     * @return The name of the workgroup that contains the named query.
     */
    public final String workGroup() {
        return workGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(namedQueryId());
        hashCode = 31 * hashCode + Objects.hashCode(workGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamedQuery)) {
            return false;
        }
        NamedQuery other = (NamedQuery) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(database(), other.database()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(namedQueryId(), other.namedQueryId()) && Objects.equals(workGroup(), other.workGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NamedQuery").add("Name", name()).add("Description", description()).add("Database", database())
                .add("QueryString", queryString()).add("NamedQueryId", namedQueryId()).add("WorkGroup", workGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "QueryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "NamedQueryId":
            return Optional.ofNullable(clazz.cast(namedQueryId()));
        case "WorkGroup":
            return Optional.ofNullable(clazz.cast(workGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NamedQuery, T> g) {
        return obj -> g.apply((NamedQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NamedQuery> {
        /**
         * <p>
         * The query name.
         * </p>
         * 
         * @param name
         *        The query name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The query description.
         * </p>
         * 
         * @param description
         *        The query description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The database to which the query belongs.
         * </p>
         * 
         * @param database
         *        The database to which the query belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * The SQL statements that make up the query.
         * </p>
         * 
         * @param queryString
         *        The SQL statements that make up the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The unique identifier of the query.
         * </p>
         * 
         * @param namedQueryId
         *        The unique identifier of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namedQueryId(String namedQueryId);

        /**
         * <p>
         * The name of the workgroup that contains the named query.
         * </p>
         * 
         * @param workGroup
         *        The name of the workgroup that contains the named query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workGroup(String workGroup);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String database;

        private String queryString;

        private String namedQueryId;

        private String workGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(NamedQuery model) {
            name(model.name);
            description(model.description);
            database(model.database);
            queryString(model.queryString);
            namedQueryId(model.namedQueryId);
            workGroup(model.workGroup);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        @Transient
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        @Transient
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getNamedQueryId() {
            return namedQueryId;
        }

        public final void setNamedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
        }

        @Override
        @Transient
        public final Builder namedQueryId(String namedQueryId) {
            this.namedQueryId = namedQueryId;
            return this;
        }

        public final String getWorkGroup() {
            return workGroup;
        }

        public final void setWorkGroup(String workGroup) {
            this.workGroup = workGroup;
        }

        @Override
        @Transient
        public final Builder workGroup(String workGroup) {
            this.workGroup = workGroup;
            return this;
        }

        @Override
        public NamedQuery build() {
            return new NamedQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
