/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.athena.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains metadata for a table.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableMetadata implements SdkPojo, Serializable, ToCopyableBuilder<TableMetadata.Builder, TableMetadata> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TableMetadata::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime").getter(getter(TableMetadata::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").build()).build();

    private static final SdkField<Instant> LAST_ACCESS_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastAccessTime").getter(getter(TableMetadata::lastAccessTime)).setter(setter(Builder::lastAccessTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastAccessTime").build()).build();

    private static final SdkField<String> TABLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableType").getter(getter(TableMetadata::tableType)).setter(setter(Builder::tableType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableType").build()).build();

    private static final SdkField<List<Column>> COLUMNS_FIELD = SdkField
            .<List<Column>> builder(MarshallingType.LIST)
            .memberName("Columns")
            .getter(getter(TableMetadata::columns))
            .setter(setter(Builder::columns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Columns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Column> builder(MarshallingType.SDK_POJO)
                                            .constructor(Column::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Column>> PARTITION_KEYS_FIELD = SdkField
            .<List<Column>> builder(MarshallingType.LIST)
            .memberName("PartitionKeys")
            .getter(getter(TableMetadata::partitionKeys))
            .setter(setter(Builder::partitionKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartitionKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Column> builder(MarshallingType.SDK_POJO)
                                            .constructor(Column::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(TableMetadata::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CREATE_TIME_FIELD,
            LAST_ACCESS_TIME_FIELD, TABLE_TYPE_FIELD, COLUMNS_FIELD, PARTITION_KEYS_FIELD, PARAMETERS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Instant createTime;

    private final Instant lastAccessTime;

    private final String tableType;

    private final List<Column> columns;

    private final List<Column> partitionKeys;

    private final Map<String, String> parameters;

    private TableMetadata(BuilderImpl builder) {
        this.name = builder.name;
        this.createTime = builder.createTime;
        this.lastAccessTime = builder.lastAccessTime;
        this.tableType = builder.tableType;
        this.columns = builder.columns;
        this.partitionKeys = builder.partitionKeys;
        this.parameters = builder.parameters;
    }

    /**
     * <p>
     * The name of the table.
     * </p>
     * 
     * @return The name of the table.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time that the table was created.
     * </p>
     * 
     * @return The time that the table was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The last time the table was accessed.
     * </p>
     * 
     * @return The last time the table was accessed.
     */
    public final Instant lastAccessTime() {
        return lastAccessTime;
    }

    /**
     * <p>
     * The type of table. In Athena, only <code>EXTERNAL_TABLE</code> is supported.
     * </p>
     * 
     * @return The type of table. In Athena, only <code>EXTERNAL_TABLE</code> is supported.
     */
    public final String tableType() {
        return tableType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Columns property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasColumns() {
        return columns != null && !(columns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the columns in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasColumns} method.
     * </p>
     * 
     * @return A list of the columns in the table.
     */
    public final List<Column> columns() {
        return columns;
    }

    /**
     * For responses, this returns true if the service returned a value for the PartitionKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPartitionKeys() {
        return partitionKeys != null && !(partitionKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the partition keys in the table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPartitionKeys} method.
     * </p>
     * 
     * @return A list of the partition keys in the table.
     */
    public final List<Column> partitionKeys() {
        return partitionKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A set of custom key/value pairs for table properties.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A set of custom key/value pairs for table properties.
     */
    public final Map<String, String> parameters() {
        return parameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastAccessTime());
        hashCode = 31 * hashCode + Objects.hashCode(tableType());
        hashCode = 31 * hashCode + Objects.hashCode(hasColumns() ? columns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPartitionKeys() ? partitionKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableMetadata)) {
            return false;
        }
        TableMetadata other = (TableMetadata) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(lastAccessTime(), other.lastAccessTime()) && Objects.equals(tableType(), other.tableType())
                && hasColumns() == other.hasColumns() && Objects.equals(columns(), other.columns())
                && hasPartitionKeys() == other.hasPartitionKeys() && Objects.equals(partitionKeys(), other.partitionKeys())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableMetadata").add("Name", name()).add("CreateTime", createTime())
                .add("LastAccessTime", lastAccessTime()).add("TableType", tableType())
                .add("Columns", hasColumns() ? columns() : null)
                .add("PartitionKeys", hasPartitionKeys() ? partitionKeys() : null)
                .add("Parameters", hasParameters() ? parameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "LastAccessTime":
            return Optional.ofNullable(clazz.cast(lastAccessTime()));
        case "TableType":
            return Optional.ofNullable(clazz.cast(tableType()));
        case "Columns":
            return Optional.ofNullable(clazz.cast(columns()));
        case "PartitionKeys":
            return Optional.ofNullable(clazz.cast(partitionKeys()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableMetadata, T> g) {
        return obj -> g.apply((TableMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableMetadata> {
        /**
         * <p>
         * The name of the table.
         * </p>
         * 
         * @param name
         *        The name of the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time that the table was created.
         * </p>
         * 
         * @param createTime
         *        The time that the table was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The last time the table was accessed.
         * </p>
         * 
         * @param lastAccessTime
         *        The last time the table was accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastAccessTime(Instant lastAccessTime);

        /**
         * <p>
         * The type of table. In Athena, only <code>EXTERNAL_TABLE</code> is supported.
         * </p>
         * 
         * @param tableType
         *        The type of table. In Athena, only <code>EXTERNAL_TABLE</code> is supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableType(String tableType);

        /**
         * <p>
         * A list of the columns in the table.
         * </p>
         * 
         * @param columns
         *        A list of the columns in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Collection<Column> columns);

        /**
         * <p>
         * A list of the columns in the table.
         * </p>
         * 
         * @param columns
         *        A list of the columns in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columns(Column... columns);

        /**
         * <p>
         * A list of the columns in the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Column>.Builder} avoiding the need to
         * create one manually via {@link List<Column>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Column>.Builder#build()} is called immediately and its
         * result is passed to {@link #columns(List<Column>)}.
         * 
         * @param columns
         *        a consumer that will call methods on {@link List<Column>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columns(List<Column>)
         */
        Builder columns(Consumer<Column.Builder>... columns);

        /**
         * <p>
         * A list of the partition keys in the table.
         * </p>
         * 
         * @param partitionKeys
         *        A list of the partition keys in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(Collection<Column> partitionKeys);

        /**
         * <p>
         * A list of the partition keys in the table.
         * </p>
         * 
         * @param partitionKeys
         *        A list of the partition keys in the table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partitionKeys(Column... partitionKeys);

        /**
         * <p>
         * A list of the partition keys in the table.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Column>.Builder} avoiding the need to
         * create one manually via {@link List<Column>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Column>.Builder#build()} is called immediately and its
         * result is passed to {@link #partitionKeys(List<Column>)}.
         * 
         * @param partitionKeys
         *        a consumer that will call methods on {@link List<Column>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #partitionKeys(List<Column>)
         */
        Builder partitionKeys(Consumer<Column.Builder>... partitionKeys);

        /**
         * <p>
         * A set of custom key/value pairs for table properties.
         * </p>
         * 
         * @param parameters
         *        A set of custom key/value pairs for table properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, String> parameters);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Instant createTime;

        private Instant lastAccessTime;

        private String tableType;

        private List<Column> columns = DefaultSdkAutoConstructList.getInstance();

        private List<Column> partitionKeys = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> parameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableMetadata model) {
            name(model.name);
            createTime(model.createTime);
            lastAccessTime(model.lastAccessTime);
            tableType(model.tableType);
            columns(model.columns);
            partitionKeys(model.partitionKeys);
            parameters(model.parameters);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        @Transient
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Instant getLastAccessTime() {
            return lastAccessTime;
        }

        public final void setLastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
        }

        @Override
        @Transient
        public final Builder lastAccessTime(Instant lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
            return this;
        }

        public final String getTableType() {
            return tableType;
        }

        public final void setTableType(String tableType) {
            this.tableType = tableType;
        }

        @Override
        @Transient
        public final Builder tableType(String tableType) {
            this.tableType = tableType;
            return this;
        }

        public final List<Column.Builder> getColumns() {
            List<Column.Builder> result = ColumnListCopier.copyToBuilder(this.columns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setColumns(Collection<Column.BuilderImpl> columns) {
            this.columns = ColumnListCopier.copyFromBuilder(columns);
        }

        @Override
        @Transient
        public final Builder columns(Collection<Column> columns) {
            this.columns = ColumnListCopier.copy(columns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columns(Column... columns) {
            columns(Arrays.asList(columns));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder columns(Consumer<Column.Builder>... columns) {
            columns(Stream.of(columns).map(c -> Column.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Column.Builder> getPartitionKeys() {
            List<Column.Builder> result = ColumnListCopier.copyToBuilder(this.partitionKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPartitionKeys(Collection<Column.BuilderImpl> partitionKeys) {
            this.partitionKeys = ColumnListCopier.copyFromBuilder(partitionKeys);
        }

        @Override
        @Transient
        public final Builder partitionKeys(Collection<Column> partitionKeys) {
            this.partitionKeys = ColumnListCopier.copy(partitionKeys);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder partitionKeys(Column... partitionKeys) {
            partitionKeys(Arrays.asList(partitionKeys));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder partitionKeys(Consumer<Column.Builder>... partitionKeys) {
            partitionKeys(Stream.of(partitionKeys).map(c -> Column.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Map<String, String> parameters) {
            this.parameters = ParametersMapCopier.copy(parameters);
            return this;
        }

        @Override
        public TableMetadata build() {
            return new TableMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
