/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.CalculationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartCalculationExecutionRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, StartCalculationExecutionRequest> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionId").getter(StartCalculationExecutionRequest.getter(StartCalculationExecutionRequest::sessionId)).setter(StartCalculationExecutionRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(StartCalculationExecutionRequest.getter(StartCalculationExecutionRequest::description)).setter(StartCalculationExecutionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<CalculationConfiguration> CALCULATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CalculationConfiguration").getter(StartCalculationExecutionRequest.getter(StartCalculationExecutionRequest::calculationConfiguration)).setter(StartCalculationExecutionRequest.setter(Builder::calculationConfiguration)).constructor(CalculationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculationConfiguration").build()}).build();
    private static final SdkField<String> CODE_BLOCK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodeBlock").getter(StartCalculationExecutionRequest.getter(StartCalculationExecutionRequest::codeBlock)).setter(StartCalculationExecutionRequest.setter(Builder::codeBlock)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CodeBlock").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartCalculationExecutionRequest.getter(StartCalculationExecutionRequest::clientRequestToken)).setter(StartCalculationExecutionRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD, DESCRIPTION_FIELD, CALCULATION_CONFIGURATION_FIELD, CODE_BLOCK_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartCalculationExecutionRequest.memberNameToFieldInitializer();
    private final String sessionId;
    private final String description;
    private final CalculationConfiguration calculationConfiguration;
    private final String codeBlock;
    private final String clientRequestToken;

    private StartCalculationExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.description = builder.description;
        this.calculationConfiguration = builder.calculationConfiguration;
        this.codeBlock = builder.codeBlock;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    public final String description() {
        return this.description;
    }

    @Deprecated
    public final CalculationConfiguration calculationConfiguration() {
        return this.calculationConfiguration;
    }

    public final String codeBlock() {
        return this.codeBlock;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeBlock());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartCalculationExecutionRequest)) {
            return false;
        }
        StartCalculationExecutionRequest other = (StartCalculationExecutionRequest)((Object)obj);
        return Objects.equals(this.sessionId(), other.sessionId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.calculationConfiguration(), other.calculationConfiguration()) && Objects.equals(this.codeBlock(), other.codeBlock()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"StartCalculationExecutionRequest").add("SessionId", (Object)this.sessionId()).add("Description", (Object)this.description()).add("CalculationConfiguration", (Object)this.calculationConfiguration()).add("CodeBlock", (Object)this.codeBlock()).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CalculationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.calculationConfiguration()));
            }
            case "CodeBlock": {
                return Optional.ofNullable(clazz.cast(this.codeBlock()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SessionId", SESSION_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CalculationConfiguration", CALCULATION_CONFIGURATION_FIELD);
        map.put("CodeBlock", CODE_BLOCK_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartCalculationExecutionRequest, T> g) {
        return obj -> g.apply((StartCalculationExecutionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String sessionId;
        private String description;
        private CalculationConfiguration calculationConfiguration;
        private String codeBlock;
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartCalculationExecutionRequest model) {
            super(model);
            this.sessionId(model.sessionId);
            this.description(model.description);
            this.calculationConfiguration(model.calculationConfiguration);
            this.codeBlock(model.codeBlock);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Deprecated
        public final CalculationConfiguration.Builder getCalculationConfiguration() {
            return this.calculationConfiguration != null ? this.calculationConfiguration.toBuilder() : null;
        }

        @Deprecated
        public final void setCalculationConfiguration(CalculationConfiguration.BuilderImpl calculationConfiguration) {
            this.calculationConfiguration = calculationConfiguration != null ? calculationConfiguration.build() : null;
        }

        @Override
        @Deprecated
        public final Builder calculationConfiguration(CalculationConfiguration calculationConfiguration) {
            this.calculationConfiguration = calculationConfiguration;
            return this;
        }

        public final String getCodeBlock() {
            return this.codeBlock;
        }

        public final void setCodeBlock(String codeBlock) {
            this.codeBlock = codeBlock;
        }

        @Override
        public final Builder codeBlock(String codeBlock) {
            this.codeBlock = codeBlock;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartCalculationExecutionRequest build() {
            return new StartCalculationExecutionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartCalculationExecutionRequest> {
        public Builder sessionId(String var1);

        public Builder description(String var1);

        @Deprecated
        public Builder calculationConfiguration(CalculationConfiguration var1);

        @Deprecated
        default public Builder calculationConfiguration(Consumer<CalculationConfiguration.Builder> calculationConfiguration) {
            return this.calculationConfiguration((CalculationConfiguration)((CalculationConfiguration.Builder)CalculationConfiguration.builder().applyMutation(calculationConfiguration)).build());
        }

        public Builder codeBlock(String var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

