/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingResponse;
import software.amazon.awssdk.services.autoscaling.model.MetricCollectionType;
import software.amazon.awssdk.services.autoscaling.model.MetricCollectionTypesCopier;
import software.amazon.awssdk.services.autoscaling.model.MetricGranularityType;
import software.amazon.awssdk.services.autoscaling.model.MetricGranularityTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMetricCollectionTypesResponse
extends AutoScalingResponse
implements ToCopyableBuilder<Builder, DescribeMetricCollectionTypesResponse> {
    private static final SdkField<List<MetricCollectionType>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Metrics").getter(DescribeMetricCollectionTypesResponse.getter(DescribeMetricCollectionTypesResponse::metrics)).setter(DescribeMetricCollectionTypesResponse.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricCollectionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MetricGranularityType>> GRANULARITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Granularities").getter(DescribeMetricCollectionTypesResponse.getter(DescribeMetricCollectionTypesResponse::granularities)).setter(DescribeMetricCollectionTypesResponse.setter(Builder::granularities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricGranularityType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD, GRANULARITIES_FIELD));
    private final List<MetricCollectionType> metrics;
    private final List<MetricGranularityType> granularities;

    private DescribeMetricCollectionTypesResponse(BuilderImpl builder) {
        super(builder);
        this.metrics = builder.metrics;
        this.granularities = builder.granularities;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<MetricCollectionType> metrics() {
        return this.metrics;
    }

    public final boolean hasGranularities() {
        return this.granularities != null && !(this.granularities instanceof SdkAutoConstructList);
    }

    public final List<MetricGranularityType> granularities() {
        return this.granularities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGranularities() ? this.granularities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricCollectionTypesResponse)) {
            return false;
        }
        DescribeMetricCollectionTypesResponse other = (DescribeMetricCollectionTypesResponse)((Object)obj);
        return this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && this.hasGranularities() == other.hasGranularities() && Objects.equals(this.granularities(), other.granularities());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMetricCollectionTypesResponse").add("Metrics", this.hasMetrics() ? this.metrics() : null).add("Granularities", this.hasGranularities() ? this.granularities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "Granularities": {
                return Optional.ofNullable(clazz.cast(this.granularities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetricCollectionTypesResponse, T> g) {
        return obj -> g.apply((DescribeMetricCollectionTypesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AutoScalingResponse.BuilderImpl
    implements Builder {
        private List<MetricCollectionType> metrics = DefaultSdkAutoConstructList.getInstance();
        private List<MetricGranularityType> granularities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricCollectionTypesResponse model) {
            super(model);
            this.metrics(model.metrics);
            this.granularities(model.granularities);
        }

        public final List<MetricCollectionType.Builder> getMetrics() {
            List<MetricCollectionType.Builder> result = MetricCollectionTypesCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder metrics(Collection<MetricCollectionType> metrics) {
            this.metrics = MetricCollectionTypesCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(MetricCollectionType ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<MetricCollectionType.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (MetricCollectionType)((MetricCollectionType.Builder)MetricCollectionType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetrics(Collection<MetricCollectionType.BuilderImpl> metrics) {
            this.metrics = MetricCollectionTypesCopier.copyFromBuilder(metrics);
        }

        public final List<MetricGranularityType.Builder> getGranularities() {
            List<MetricGranularityType.Builder> result = MetricGranularityTypesCopier.copyToBuilder(this.granularities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder granularities(Collection<MetricGranularityType> granularities) {
            this.granularities = MetricGranularityTypesCopier.copy(granularities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder granularities(MetricGranularityType ... granularities) {
            this.granularities(Arrays.asList(granularities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder granularities(Consumer<MetricGranularityType.Builder> ... granularities) {
            this.granularities(Stream.of(granularities).map(c -> (MetricGranularityType)((MetricGranularityType.Builder)MetricGranularityType.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setGranularities(Collection<MetricGranularityType.BuilderImpl> granularities) {
            this.granularities = MetricGranularityTypesCopier.copyFromBuilder(granularities);
        }

        @Override
        public DescribeMetricCollectionTypesResponse build() {
            return new DescribeMetricCollectionTypesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AutoScalingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMetricCollectionTypesResponse> {
        public Builder metrics(Collection<MetricCollectionType> var1);

        public Builder metrics(MetricCollectionType ... var1);

        public Builder metrics(Consumer<MetricCollectionType.Builder> ... var1);

        public Builder granularities(Collection<MetricGranularityType> var1);

        public Builder granularities(MetricGranularityType ... var1);

        public Builder granularities(Consumer<MetricGranularityType.Builder> ... var1);
    }
}

