/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.autoscaling.model.PredictiveScalingPredefinedLoadMetric;
import software.amazon.awssdk.services.autoscaling.model.PredictiveScalingPredefinedMetricPair;
import software.amazon.awssdk.services.autoscaling.model.PredictiveScalingPredefinedScalingMetric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PredictiveScalingMetricSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PredictiveScalingMetricSpecification> {
    private static final SdkField<Double> TARGET_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TargetValue").getter(PredictiveScalingMetricSpecification.getter(PredictiveScalingMetricSpecification::targetValue)).setter(PredictiveScalingMetricSpecification.setter(Builder::targetValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetValue").build()}).build();
    private static final SdkField<PredictiveScalingPredefinedMetricPair> PREDEFINED_METRIC_PAIR_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredefinedMetricPairSpecification").getter(PredictiveScalingMetricSpecification.getter(PredictiveScalingMetricSpecification::predefinedMetricPairSpecification)).setter(PredictiveScalingMetricSpecification.setter(Builder::predefinedMetricPairSpecification)).constructor(PredictiveScalingPredefinedMetricPair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedMetricPairSpecification").build()}).build();
    private static final SdkField<PredictiveScalingPredefinedScalingMetric> PREDEFINED_SCALING_METRIC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredefinedScalingMetricSpecification").getter(PredictiveScalingMetricSpecification.getter(PredictiveScalingMetricSpecification::predefinedScalingMetricSpecification)).setter(PredictiveScalingMetricSpecification.setter(Builder::predefinedScalingMetricSpecification)).constructor(PredictiveScalingPredefinedScalingMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedScalingMetricSpecification").build()}).build();
    private static final SdkField<PredictiveScalingPredefinedLoadMetric> PREDEFINED_LOAD_METRIC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PredefinedLoadMetricSpecification").getter(PredictiveScalingMetricSpecification.getter(PredictiveScalingMetricSpecification::predefinedLoadMetricSpecification)).setter(PredictiveScalingMetricSpecification.setter(Builder::predefinedLoadMetricSpecification)).constructor(PredictiveScalingPredefinedLoadMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredefinedLoadMetricSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_VALUE_FIELD, PREDEFINED_METRIC_PAIR_SPECIFICATION_FIELD, PREDEFINED_SCALING_METRIC_SPECIFICATION_FIELD, PREDEFINED_LOAD_METRIC_SPECIFICATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Double targetValue;
    private final PredictiveScalingPredefinedMetricPair predefinedMetricPairSpecification;
    private final PredictiveScalingPredefinedScalingMetric predefinedScalingMetricSpecification;
    private final PredictiveScalingPredefinedLoadMetric predefinedLoadMetricSpecification;

    private PredictiveScalingMetricSpecification(BuilderImpl builder) {
        this.targetValue = builder.targetValue;
        this.predefinedMetricPairSpecification = builder.predefinedMetricPairSpecification;
        this.predefinedScalingMetricSpecification = builder.predefinedScalingMetricSpecification;
        this.predefinedLoadMetricSpecification = builder.predefinedLoadMetricSpecification;
    }

    public final Double targetValue() {
        return this.targetValue;
    }

    public final PredictiveScalingPredefinedMetricPair predefinedMetricPairSpecification() {
        return this.predefinedMetricPairSpecification;
    }

    public final PredictiveScalingPredefinedScalingMetric predefinedScalingMetricSpecification() {
        return this.predefinedScalingMetricSpecification;
    }

    public final PredictiveScalingPredefinedLoadMetric predefinedLoadMetricSpecification() {
        return this.predefinedLoadMetricSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.predefinedMetricPairSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.predefinedScalingMetricSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.predefinedLoadMetricSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredictiveScalingMetricSpecification)) {
            return false;
        }
        PredictiveScalingMetricSpecification other = (PredictiveScalingMetricSpecification)obj;
        return Objects.equals(this.targetValue(), other.targetValue()) && Objects.equals(this.predefinedMetricPairSpecification(), other.predefinedMetricPairSpecification()) && Objects.equals(this.predefinedScalingMetricSpecification(), other.predefinedScalingMetricSpecification()) && Objects.equals(this.predefinedLoadMetricSpecification(), other.predefinedLoadMetricSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"PredictiveScalingMetricSpecification").add("TargetValue", (Object)this.targetValue()).add("PredefinedMetricPairSpecification", (Object)this.predefinedMetricPairSpecification()).add("PredefinedScalingMetricSpecification", (Object)this.predefinedScalingMetricSpecification()).add("PredefinedLoadMetricSpecification", (Object)this.predefinedLoadMetricSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetValue": {
                return Optional.ofNullable(clazz.cast(this.targetValue()));
            }
            case "PredefinedMetricPairSpecification": {
                return Optional.ofNullable(clazz.cast(this.predefinedMetricPairSpecification()));
            }
            case "PredefinedScalingMetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.predefinedScalingMetricSpecification()));
            }
            case "PredefinedLoadMetricSpecification": {
                return Optional.ofNullable(clazz.cast(this.predefinedLoadMetricSpecification()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PredictiveScalingMetricSpecification, T> g) {
        return obj -> g.apply((PredictiveScalingMetricSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Double targetValue;
        private PredictiveScalingPredefinedMetricPair predefinedMetricPairSpecification;
        private PredictiveScalingPredefinedScalingMetric predefinedScalingMetricSpecification;
        private PredictiveScalingPredefinedLoadMetric predefinedLoadMetricSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(PredictiveScalingMetricSpecification model) {
            this.targetValue(model.targetValue);
            this.predefinedMetricPairSpecification(model.predefinedMetricPairSpecification);
            this.predefinedScalingMetricSpecification(model.predefinedScalingMetricSpecification);
            this.predefinedLoadMetricSpecification(model.predefinedLoadMetricSpecification);
        }

        public final Double getTargetValue() {
            return this.targetValue;
        }

        @Override
        public final Builder targetValue(Double targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        public final void setTargetValue(Double targetValue) {
            this.targetValue = targetValue;
        }

        public final PredictiveScalingPredefinedMetricPair.Builder getPredefinedMetricPairSpecification() {
            return this.predefinedMetricPairSpecification != null ? this.predefinedMetricPairSpecification.toBuilder() : null;
        }

        @Override
        public final Builder predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPair predefinedMetricPairSpecification) {
            this.predefinedMetricPairSpecification = predefinedMetricPairSpecification;
            return this;
        }

        public final void setPredefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPair.BuilderImpl predefinedMetricPairSpecification) {
            this.predefinedMetricPairSpecification = predefinedMetricPairSpecification != null ? predefinedMetricPairSpecification.build() : null;
        }

        public final PredictiveScalingPredefinedScalingMetric.Builder getPredefinedScalingMetricSpecification() {
            return this.predefinedScalingMetricSpecification != null ? this.predefinedScalingMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetric predefinedScalingMetricSpecification) {
            this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification;
            return this;
        }

        public final void setPredefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetric.BuilderImpl predefinedScalingMetricSpecification) {
            this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification != null ? predefinedScalingMetricSpecification.build() : null;
        }

        public final PredictiveScalingPredefinedLoadMetric.Builder getPredefinedLoadMetricSpecification() {
            return this.predefinedLoadMetricSpecification != null ? this.predefinedLoadMetricSpecification.toBuilder() : null;
        }

        @Override
        public final Builder predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetric predefinedLoadMetricSpecification) {
            this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification;
            return this;
        }

        public final void setPredefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetric.BuilderImpl predefinedLoadMetricSpecification) {
            this.predefinedLoadMetricSpecification = predefinedLoadMetricSpecification != null ? predefinedLoadMetricSpecification.build() : null;
        }

        public PredictiveScalingMetricSpecification build() {
            return new PredictiveScalingMetricSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PredictiveScalingMetricSpecification> {
        public Builder targetValue(Double var1);

        public Builder predefinedMetricPairSpecification(PredictiveScalingPredefinedMetricPair var1);

        default public Builder predefinedMetricPairSpecification(Consumer<PredictiveScalingPredefinedMetricPair.Builder> predefinedMetricPairSpecification) {
            return this.predefinedMetricPairSpecification((PredictiveScalingPredefinedMetricPair)((PredictiveScalingPredefinedMetricPair.Builder)PredictiveScalingPredefinedMetricPair.builder().applyMutation(predefinedMetricPairSpecification)).build());
        }

        public Builder predefinedScalingMetricSpecification(PredictiveScalingPredefinedScalingMetric var1);

        default public Builder predefinedScalingMetricSpecification(Consumer<PredictiveScalingPredefinedScalingMetric.Builder> predefinedScalingMetricSpecification) {
            return this.predefinedScalingMetricSpecification((PredictiveScalingPredefinedScalingMetric)((PredictiveScalingPredefinedScalingMetric.Builder)PredictiveScalingPredefinedScalingMetric.builder().applyMutation(predefinedScalingMetricSpecification)).build());
        }

        public Builder predefinedLoadMetricSpecification(PredictiveScalingPredefinedLoadMetric var1);

        default public Builder predefinedLoadMetricSpecification(Consumer<PredictiveScalingPredefinedLoadMetric.Builder> predefinedLoadMetricSpecification) {
            return this.predefinedLoadMetricSpecification((PredictiveScalingPredefinedLoadMetric)((PredictiveScalingPredefinedLoadMetric.Builder)PredictiveScalingPredefinedLoadMetric.builder().applyMutation(predefinedLoadMetricSpecification)).build());
        }
    }
}

