/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.backupstorage.BackupStorageClientBuilder;
import software.amazon.awssdk.services.backupstorage.DefaultBackupStorageClientBuilder;
import software.amazon.awssdk.services.backupstorage.model.AccessDeniedException;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageException;
import software.amazon.awssdk.services.backupstorage.model.DataAlreadyExistsException;
import software.amazon.awssdk.services.backupstorage.model.DeleteObjectRequest;
import software.amazon.awssdk.services.backupstorage.model.DeleteObjectResponse;
import software.amazon.awssdk.services.backupstorage.model.GetChunkRequest;
import software.amazon.awssdk.services.backupstorage.model.GetChunkResponse;
import software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataRequest;
import software.amazon.awssdk.services.backupstorage.model.GetObjectMetadataResponse;
import software.amazon.awssdk.services.backupstorage.model.IllegalArgumentException;
import software.amazon.awssdk.services.backupstorage.model.KmsInvalidKeyUsageException;
import software.amazon.awssdk.services.backupstorage.model.ListChunksRequest;
import software.amazon.awssdk.services.backupstorage.model.ListChunksResponse;
import software.amazon.awssdk.services.backupstorage.model.ListObjectsRequest;
import software.amazon.awssdk.services.backupstorage.model.ListObjectsResponse;
import software.amazon.awssdk.services.backupstorage.model.NotReadableInputStreamException;
import software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteRequest;
import software.amazon.awssdk.services.backupstorage.model.NotifyObjectCompleteResponse;
import software.amazon.awssdk.services.backupstorage.model.PutChunkRequest;
import software.amazon.awssdk.services.backupstorage.model.PutChunkResponse;
import software.amazon.awssdk.services.backupstorage.model.PutObjectRequest;
import software.amazon.awssdk.services.backupstorage.model.PutObjectResponse;
import software.amazon.awssdk.services.backupstorage.model.ResourceNotFoundException;
import software.amazon.awssdk.services.backupstorage.model.RetryableException;
import software.amazon.awssdk.services.backupstorage.model.ServiceInternalException;
import software.amazon.awssdk.services.backupstorage.model.ServiceUnavailableException;
import software.amazon.awssdk.services.backupstorage.model.StartObjectRequest;
import software.amazon.awssdk.services.backupstorage.model.StartObjectResponse;
import software.amazon.awssdk.services.backupstorage.model.ThrottlingException;
import software.amazon.awssdk.services.backupstorage.paginators.ListChunksIterable;
import software.amazon.awssdk.services.backupstorage.paginators.ListObjectsIterable;

@SdkPublicApi
@ThreadSafe
public interface BackupStorageClient
extends SdkClient {
    public static final String SERVICE_NAME = "backup-storage";
    public static final String SERVICE_METADATA_ID = "backupstorage";

    default public DeleteObjectResponse deleteObject(DeleteObjectRequest deleteObjectRequest) throws ServiceUnavailableException, ServiceInternalException, RetryableException, IllegalArgumentException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        throw new UnsupportedOperationException();
    }

    default public DeleteObjectResponse deleteObject(Consumer<DeleteObjectRequest.Builder> deleteObjectRequest) throws ServiceUnavailableException, ServiceInternalException, RetryableException, IllegalArgumentException, ResourceNotFoundException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.deleteObject((DeleteObjectRequest)((Object)((DeleteObjectRequest.Builder)DeleteObjectRequest.builder().applyMutation(deleteObjectRequest)).build()));
    }

    default public <ReturnT> ReturnT getChunk(GetChunkRequest getChunkRequest, ResponseTransformer<GetChunkResponse, ReturnT> responseTransformer) throws IllegalArgumentException, RetryableException, ResourceNotFoundException, ServiceInternalException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getChunk(Consumer<GetChunkRequest.Builder> getChunkRequest, ResponseTransformer<GetChunkResponse, ReturnT> responseTransformer) throws IllegalArgumentException, RetryableException, ResourceNotFoundException, ServiceInternalException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.getChunk((GetChunkRequest)((Object)((GetChunkRequest.Builder)GetChunkRequest.builder().applyMutation(getChunkRequest)).build()), responseTransformer);
    }

    default public GetChunkResponse getChunk(GetChunkRequest getChunkRequest, Path destinationPath) throws IllegalArgumentException, RetryableException, ResourceNotFoundException, ServiceInternalException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return (GetChunkResponse)((Object)this.getChunk(getChunkRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public GetChunkResponse getChunk(Consumer<GetChunkRequest.Builder> getChunkRequest, Path destinationPath) throws IllegalArgumentException, RetryableException, ResourceNotFoundException, ServiceInternalException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.getChunk((GetChunkRequest)((Object)((GetChunkRequest.Builder)GetChunkRequest.builder().applyMutation(getChunkRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<GetChunkResponse> getChunk(GetChunkRequest getChunkRequest) throws IllegalArgumentException, RetryableException, ResourceNotFoundException, ServiceInternalException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return (ResponseInputStream)this.getChunk(getChunkRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetChunkResponse> getChunk(Consumer<GetChunkRequest.Builder> getChunkRequest) throws IllegalArgumentException, RetryableException, ResourceNotFoundException, ServiceInternalException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.getChunk((GetChunkRequest)((Object)((GetChunkRequest.Builder)GetChunkRequest.builder().applyMutation(getChunkRequest)).build()));
    }

    default public ResponseBytes<GetChunkResponse> getChunkAsBytes(GetChunkRequest getChunkRequest) throws IllegalArgumentException, RetryableException, ResourceNotFoundException, ServiceInternalException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return (ResponseBytes)this.getChunk(getChunkRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetChunkResponse> getChunkAsBytes(Consumer<GetChunkRequest.Builder> getChunkRequest) throws IllegalArgumentException, RetryableException, ResourceNotFoundException, ServiceInternalException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.getChunkAsBytes((GetChunkRequest)((Object)((GetChunkRequest.Builder)GetChunkRequest.builder().applyMutation(getChunkRequest)).build()));
    }

    default public <ReturnT> ReturnT getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest, ResponseTransformer<GetObjectMetadataResponse, ReturnT> responseTransformer) throws ServiceUnavailableException, ServiceInternalException, ResourceNotFoundException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> ReturnT getObjectMetadata(Consumer<GetObjectMetadataRequest.Builder> getObjectMetadataRequest, ResponseTransformer<GetObjectMetadataResponse, ReturnT> responseTransformer) throws ServiceUnavailableException, ServiceInternalException, ResourceNotFoundException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.getObjectMetadata((GetObjectMetadataRequest)((Object)((GetObjectMetadataRequest.Builder)GetObjectMetadataRequest.builder().applyMutation(getObjectMetadataRequest)).build()), responseTransformer);
    }

    default public GetObjectMetadataResponse getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest, Path destinationPath) throws ServiceUnavailableException, ServiceInternalException, ResourceNotFoundException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return (GetObjectMetadataResponse)((Object)this.getObjectMetadata(getObjectMetadataRequest, ResponseTransformer.toFile((Path)destinationPath)));
    }

    default public GetObjectMetadataResponse getObjectMetadata(Consumer<GetObjectMetadataRequest.Builder> getObjectMetadataRequest, Path destinationPath) throws ServiceUnavailableException, ServiceInternalException, ResourceNotFoundException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.getObjectMetadata((GetObjectMetadataRequest)((Object)((GetObjectMetadataRequest.Builder)GetObjectMetadataRequest.builder().applyMutation(getObjectMetadataRequest)).build()), destinationPath);
    }

    default public ResponseInputStream<GetObjectMetadataResponse> getObjectMetadata(GetObjectMetadataRequest getObjectMetadataRequest) throws ServiceUnavailableException, ServiceInternalException, ResourceNotFoundException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return (ResponseInputStream)this.getObjectMetadata(getObjectMetadataRequest, ResponseTransformer.toInputStream());
    }

    default public ResponseInputStream<GetObjectMetadataResponse> getObjectMetadata(Consumer<GetObjectMetadataRequest.Builder> getObjectMetadataRequest) throws ServiceUnavailableException, ServiceInternalException, ResourceNotFoundException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.getObjectMetadata((GetObjectMetadataRequest)((Object)((GetObjectMetadataRequest.Builder)GetObjectMetadataRequest.builder().applyMutation(getObjectMetadataRequest)).build()));
    }

    default public ResponseBytes<GetObjectMetadataResponse> getObjectMetadataAsBytes(GetObjectMetadataRequest getObjectMetadataRequest) throws ServiceUnavailableException, ServiceInternalException, ResourceNotFoundException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return (ResponseBytes)this.getObjectMetadata(getObjectMetadataRequest, ResponseTransformer.toBytes());
    }

    default public ResponseBytes<GetObjectMetadataResponse> getObjectMetadataAsBytes(Consumer<GetObjectMetadataRequest.Builder> getObjectMetadataRequest) throws ServiceUnavailableException, ServiceInternalException, ResourceNotFoundException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.getObjectMetadataAsBytes((GetObjectMetadataRequest)((Object)((GetObjectMetadataRequest.Builder)GetObjectMetadataRequest.builder().applyMutation(getObjectMetadataRequest)).build()));
    }

    default public ListChunksResponse listChunks(ListChunksRequest listChunksRequest) throws ServiceUnavailableException, ResourceNotFoundException, ServiceInternalException, RetryableException, IllegalArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        throw new UnsupportedOperationException();
    }

    default public ListChunksResponse listChunks(Consumer<ListChunksRequest.Builder> listChunksRequest) throws ServiceUnavailableException, ResourceNotFoundException, ServiceInternalException, RetryableException, IllegalArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.listChunks((ListChunksRequest)((Object)((ListChunksRequest.Builder)ListChunksRequest.builder().applyMutation(listChunksRequest)).build()));
    }

    default public ListChunksIterable listChunksPaginator(ListChunksRequest listChunksRequest) throws ServiceUnavailableException, ResourceNotFoundException, ServiceInternalException, RetryableException, IllegalArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        throw new UnsupportedOperationException();
    }

    default public ListChunksIterable listChunksPaginator(Consumer<ListChunksRequest.Builder> listChunksRequest) throws ServiceUnavailableException, ResourceNotFoundException, ServiceInternalException, RetryableException, IllegalArgumentException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.listChunksPaginator((ListChunksRequest)((Object)((ListChunksRequest.Builder)ListChunksRequest.builder().applyMutation(listChunksRequest)).build()));
    }

    default public ListObjectsResponse listObjects(ListObjectsRequest listObjectsRequest) throws ServiceUnavailableException, ServiceInternalException, RetryableException, IllegalArgumentException, ThrottlingException, ResourceNotFoundException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        throw new UnsupportedOperationException();
    }

    default public ListObjectsResponse listObjects(Consumer<ListObjectsRequest.Builder> listObjectsRequest) throws ServiceUnavailableException, ServiceInternalException, RetryableException, IllegalArgumentException, ThrottlingException, ResourceNotFoundException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.listObjects((ListObjectsRequest)((Object)((ListObjectsRequest.Builder)ListObjectsRequest.builder().applyMutation(listObjectsRequest)).build()));
    }

    default public ListObjectsIterable listObjectsPaginator(ListObjectsRequest listObjectsRequest) throws ServiceUnavailableException, ServiceInternalException, RetryableException, IllegalArgumentException, ThrottlingException, ResourceNotFoundException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        throw new UnsupportedOperationException();
    }

    default public ListObjectsIterable listObjectsPaginator(Consumer<ListObjectsRequest.Builder> listObjectsRequest) throws ServiceUnavailableException, ServiceInternalException, RetryableException, IllegalArgumentException, ThrottlingException, ResourceNotFoundException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.listObjectsPaginator((ListObjectsRequest)((Object)((ListObjectsRequest.Builder)ListObjectsRequest.builder().applyMutation(listObjectsRequest)).build()));
    }

    default public NotifyObjectCompleteResponse notifyObjectComplete(NotifyObjectCompleteRequest notifyObjectCompleteRequest, RequestBody requestBody) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        throw new UnsupportedOperationException();
    }

    default public NotifyObjectCompleteResponse notifyObjectComplete(Consumer<NotifyObjectCompleteRequest.Builder> notifyObjectCompleteRequest, RequestBody requestBody) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.notifyObjectComplete((NotifyObjectCompleteRequest)((Object)((NotifyObjectCompleteRequest.Builder)NotifyObjectCompleteRequest.builder().applyMutation(notifyObjectCompleteRequest)).build()), requestBody);
    }

    default public NotifyObjectCompleteResponse notifyObjectComplete(NotifyObjectCompleteRequest notifyObjectCompleteRequest, Path sourcePath) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.notifyObjectComplete(notifyObjectCompleteRequest, RequestBody.fromFile((Path)sourcePath));
    }

    default public NotifyObjectCompleteResponse notifyObjectComplete(Consumer<NotifyObjectCompleteRequest.Builder> notifyObjectCompleteRequest, Path sourcePath) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.notifyObjectComplete((NotifyObjectCompleteRequest)((Object)((NotifyObjectCompleteRequest.Builder)NotifyObjectCompleteRequest.builder().applyMutation(notifyObjectCompleteRequest)).build()), sourcePath);
    }

    default public PutChunkResponse putChunk(PutChunkRequest putChunkRequest, RequestBody requestBody) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        throw new UnsupportedOperationException();
    }

    default public PutChunkResponse putChunk(Consumer<PutChunkRequest.Builder> putChunkRequest, RequestBody requestBody) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.putChunk((PutChunkRequest)((Object)((PutChunkRequest.Builder)PutChunkRequest.builder().applyMutation(putChunkRequest)).build()), requestBody);
    }

    default public PutChunkResponse putChunk(PutChunkRequest putChunkRequest, Path sourcePath) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.putChunk(putChunkRequest, RequestBody.fromFile((Path)sourcePath));
    }

    default public PutChunkResponse putChunk(Consumer<PutChunkRequest.Builder> putChunkRequest, Path sourcePath) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.putChunk((PutChunkRequest)((Object)((PutChunkRequest.Builder)PutChunkRequest.builder().applyMutation(putChunkRequest)).build()), sourcePath);
    }

    default public PutObjectResponse putObject(PutObjectRequest putObjectRequest, RequestBody requestBody) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        throw new UnsupportedOperationException();
    }

    default public PutObjectResponse putObject(Consumer<PutObjectRequest.Builder> putObjectRequest, RequestBody requestBody) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.putObject((PutObjectRequest)((Object)((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(putObjectRequest)).build()), requestBody);
    }

    default public PutObjectResponse putObject(PutObjectRequest putObjectRequest, Path sourcePath) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.putObject(putObjectRequest, RequestBody.fromFile((Path)sourcePath));
    }

    default public PutObjectResponse putObject(Consumer<PutObjectRequest.Builder> putObjectRequest, Path sourcePath) throws ServiceUnavailableException, ServiceInternalException, NotReadableInputStreamException, RetryableException, IllegalArgumentException, ThrottlingException, KmsInvalidKeyUsageException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.putObject((PutObjectRequest)((Object)((PutObjectRequest.Builder)PutObjectRequest.builder().applyMutation(putObjectRequest)).build()), sourcePath);
    }

    default public StartObjectResponse startObject(StartObjectRequest startObjectRequest) throws ServiceUnavailableException, ServiceInternalException, RetryableException, IllegalArgumentException, ResourceNotFoundException, DataAlreadyExistsException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        throw new UnsupportedOperationException();
    }

    default public StartObjectResponse startObject(Consumer<StartObjectRequest.Builder> startObjectRequest) throws ServiceUnavailableException, ServiceInternalException, RetryableException, IllegalArgumentException, ResourceNotFoundException, DataAlreadyExistsException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, BackupStorageException {
        return this.startObject((StartObjectRequest)((Object)((StartObjectRequest.Builder)StartObjectRequest.builder().applyMutation(startObjectRequest)).build()));
    }

    public static BackupStorageClient create() {
        return (BackupStorageClient)BackupStorageClient.builder().build();
    }

    public static BackupStorageClientBuilder builder() {
        return new DefaultBackupStorageClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_METADATA_ID);
    }
}

