/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cleanrooms.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parameters for an AWS Clean Rooms protected query.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedQuery implements SdkPojo, Serializable, ToCopyableBuilder<ProtectedQuery.Builder, ProtectedQuery> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(ProtectedQuery::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipId").getter(getter(ProtectedQuery::membershipId)).setter(setter(Builder::membershipId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipId").build()).build();

    private static final SdkField<String> MEMBERSHIP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipArn").getter(getter(ProtectedQuery::membershipArn)).setter(setter(Builder::membershipArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipArn").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(ProtectedQuery::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<ProtectedQuerySQLParameters> SQL_PARAMETERS_FIELD = SdkField
            .<ProtectedQuerySQLParameters> builder(MarshallingType.SDK_POJO).memberName("sqlParameters")
            .getter(getter(ProtectedQuery::sqlParameters)).setter(setter(Builder::sqlParameters))
            .constructor(ProtectedQuerySQLParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqlParameters").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ProtectedQuery::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ProtectedQueryResultConfiguration> RESULT_CONFIGURATION_FIELD = SdkField
            .<ProtectedQueryResultConfiguration> builder(MarshallingType.SDK_POJO).memberName("resultConfiguration")
            .getter(getter(ProtectedQuery::resultConfiguration)).setter(setter(Builder::resultConfiguration))
            .constructor(ProtectedQueryResultConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultConfiguration").build())
            .build();

    private static final SdkField<ProtectedQueryStatistics> STATISTICS_FIELD = SdkField
            .<ProtectedQueryStatistics> builder(MarshallingType.SDK_POJO).memberName("statistics")
            .getter(getter(ProtectedQuery::statistics)).setter(setter(Builder::statistics))
            .constructor(ProtectedQueryStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build()).build();

    private static final SdkField<ProtectedQueryResult> RESULT_FIELD = SdkField
            .<ProtectedQueryResult> builder(MarshallingType.SDK_POJO).memberName("result").getter(getter(ProtectedQuery::result))
            .setter(setter(Builder::result)).constructor(ProtectedQueryResult::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("result").build()).build();

    private static final SdkField<ProtectedQueryError> ERROR_FIELD = SdkField
            .<ProtectedQueryError> builder(MarshallingType.SDK_POJO).memberName("error").getter(getter(ProtectedQuery::error))
            .setter(setter(Builder::error)).constructor(ProtectedQueryError::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, MEMBERSHIP_ID_FIELD,
            MEMBERSHIP_ARN_FIELD, CREATE_TIME_FIELD, SQL_PARAMETERS_FIELD, STATUS_FIELD, RESULT_CONFIGURATION_FIELD,
            STATISTICS_FIELD, RESULT_FIELD, ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String membershipId;

    private final String membershipArn;

    private final Instant createTime;

    private final ProtectedQuerySQLParameters sqlParameters;

    private final String status;

    private final ProtectedQueryResultConfiguration resultConfiguration;

    private final ProtectedQueryStatistics statistics;

    private final ProtectedQueryResult result;

    private final ProtectedQueryError error;

    private ProtectedQuery(BuilderImpl builder) {
        this.id = builder.id;
        this.membershipId = builder.membershipId;
        this.membershipArn = builder.membershipArn;
        this.createTime = builder.createTime;
        this.sqlParameters = builder.sqlParameters;
        this.status = builder.status;
        this.resultConfiguration = builder.resultConfiguration;
        this.statistics = builder.statistics;
        this.result = builder.result;
        this.error = builder.error;
    }

    /**
     * <p>
     * The identifier for a protected query instance.
     * </p>
     * 
     * @return The identifier for a protected query instance.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The identifier for the membership.
     * </p>
     * 
     * @return The identifier for the membership.
     */
    public final String membershipId() {
        return membershipId;
    }

    /**
     * <p>
     * The ARN of the membership.
     * </p>
     * 
     * @return The ARN of the membership.
     */
    public final String membershipArn() {
        return membershipArn;
    }

    /**
     * <p>
     * The time at which the protected query was created.
     * </p>
     * 
     * @return The time at which the protected query was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The protected query SQL parameters.
     * </p>
     * 
     * @return The protected query SQL parameters.
     */
    public final ProtectedQuerySQLParameters sqlParameters() {
        return sqlParameters;
    }

    /**
     * <p>
     * The status of the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProtectedQueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the query.
     * @see ProtectedQueryStatus
     */
    public final ProtectedQueryStatus status() {
        return ProtectedQueryStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProtectedQueryStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the query.
     * @see ProtectedQueryStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Contains any details needed to write the query results.
     * </p>
     * 
     * @return Contains any details needed to write the query results.
     */
    public final ProtectedQueryResultConfiguration resultConfiguration() {
        return resultConfiguration;
    }

    /**
     * <p>
     * Statistics about protected query execution.
     * </p>
     * 
     * @return Statistics about protected query execution.
     */
    public final ProtectedQueryStatistics statistics() {
        return statistics;
    }

    /**
     * <p>
     * The result of the protected query.
     * </p>
     * 
     * @return The result of the protected query.
     */
    public final ProtectedQueryResult result() {
        return result;
    }

    /**
     * <p>
     * An error thrown by the protected query.
     * </p>
     * 
     * @return An error thrown by the protected query.
     */
    public final ProtectedQueryError error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipArn());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(sqlParameters());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resultConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statistics());
        hashCode = 31 * hashCode + Objects.hashCode(result());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedQuery)) {
            return false;
        }
        ProtectedQuery other = (ProtectedQuery) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(membershipId(), other.membershipId())
                && Objects.equals(membershipArn(), other.membershipArn()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(sqlParameters(), other.sqlParameters())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(resultConfiguration(), other.resultConfiguration())
                && Objects.equals(statistics(), other.statistics()) && Objects.equals(result(), other.result())
                && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedQuery").add("Id", id()).add("MembershipId", membershipId())
                .add("MembershipArn", membershipArn()).add("CreateTime", createTime())
                .add("SqlParameters", sqlParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).add("ResultConfiguration", resultConfiguration())
                .add("Statistics", statistics()).add("Result", result()).add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "membershipId":
            return Optional.ofNullable(clazz.cast(membershipId()));
        case "membershipArn":
            return Optional.ofNullable(clazz.cast(membershipArn()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "sqlParameters":
            return Optional.ofNullable(clazz.cast(sqlParameters()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "resultConfiguration":
            return Optional.ofNullable(clazz.cast(resultConfiguration()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statistics()));
        case "result":
            return Optional.ofNullable(clazz.cast(result()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProtectedQuery, T> g) {
        return obj -> g.apply((ProtectedQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedQuery> {
        /**
         * <p>
         * The identifier for a protected query instance.
         * </p>
         * 
         * @param id
         *        The identifier for a protected query instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier for the membership.
         * </p>
         * 
         * @param membershipId
         *        The identifier for the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipId(String membershipId);

        /**
         * <p>
         * The ARN of the membership.
         * </p>
         * 
         * @param membershipArn
         *        The ARN of the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipArn(String membershipArn);

        /**
         * <p>
         * The time at which the protected query was created.
         * </p>
         * 
         * @param createTime
         *        The time at which the protected query was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The protected query SQL parameters.
         * </p>
         * 
         * @param sqlParameters
         *        The protected query SQL parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqlParameters(ProtectedQuerySQLParameters sqlParameters);

        /**
         * <p>
         * The protected query SQL parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedQuerySQLParameters.Builder}
         * avoiding the need to create one manually via {@link ProtectedQuerySQLParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedQuerySQLParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #sqlParameters(ProtectedQuerySQLParameters)}.
         * 
         * @param sqlParameters
         *        a consumer that will call methods on {@link ProtectedQuerySQLParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sqlParameters(ProtectedQuerySQLParameters)
         */
        default Builder sqlParameters(Consumer<ProtectedQuerySQLParameters.Builder> sqlParameters) {
            return sqlParameters(ProtectedQuerySQLParameters.builder().applyMutation(sqlParameters).build());
        }

        /**
         * <p>
         * The status of the query.
         * </p>
         * 
         * @param status
         *        The status of the query.
         * @see ProtectedQueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectedQueryStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the query.
         * </p>
         * 
         * @param status
         *        The status of the query.
         * @see ProtectedQueryStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProtectedQueryStatus
         */
        Builder status(ProtectedQueryStatus status);

        /**
         * <p>
         * Contains any details needed to write the query results.
         * </p>
         * 
         * @param resultConfiguration
         *        Contains any details needed to write the query results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultConfiguration(ProtectedQueryResultConfiguration resultConfiguration);

        /**
         * <p>
         * Contains any details needed to write the query results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ProtectedQueryResultConfiguration.Builder} avoiding the need to create one manually via
         * {@link ProtectedQueryResultConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedQueryResultConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #resultConfiguration(ProtectedQueryResultConfiguration)}.
         * 
         * @param resultConfiguration
         *        a consumer that will call methods on {@link ProtectedQueryResultConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultConfiguration(ProtectedQueryResultConfiguration)
         */
        default Builder resultConfiguration(Consumer<ProtectedQueryResultConfiguration.Builder> resultConfiguration) {
            return resultConfiguration(ProtectedQueryResultConfiguration.builder().applyMutation(resultConfiguration).build());
        }

        /**
         * <p>
         * Statistics about protected query execution.
         * </p>
         * 
         * @param statistics
         *        Statistics about protected query execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(ProtectedQueryStatistics statistics);

        /**
         * <p>
         * Statistics about protected query execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedQueryStatistics.Builder}
         * avoiding the need to create one manually via {@link ProtectedQueryStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedQueryStatistics.Builder#build()} is called immediately
         * and its result is passed to {@link #statistics(ProtectedQueryStatistics)}.
         * 
         * @param statistics
         *        a consumer that will call methods on {@link ProtectedQueryStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statistics(ProtectedQueryStatistics)
         */
        default Builder statistics(Consumer<ProtectedQueryStatistics.Builder> statistics) {
            return statistics(ProtectedQueryStatistics.builder().applyMutation(statistics).build());
        }

        /**
         * <p>
         * The result of the protected query.
         * </p>
         * 
         * @param result
         *        The result of the protected query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder result(ProtectedQueryResult result);

        /**
         * <p>
         * The result of the protected query.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedQueryResult.Builder} avoiding
         * the need to create one manually via {@link ProtectedQueryResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedQueryResult.Builder#build()} is called immediately and
         * its result is passed to {@link #result(ProtectedQueryResult)}.
         * 
         * @param result
         *        a consumer that will call methods on {@link ProtectedQueryResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #result(ProtectedQueryResult)
         */
        default Builder result(Consumer<ProtectedQueryResult.Builder> result) {
            return result(ProtectedQueryResult.builder().applyMutation(result).build());
        }

        /**
         * <p>
         * An error thrown by the protected query.
         * </p>
         * 
         * @param error
         *        An error thrown by the protected query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ProtectedQueryError error);

        /**
         * <p>
         * An error thrown by the protected query.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProtectedQueryError.Builder} avoiding the
         * need to create one manually via {@link ProtectedQueryError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProtectedQueryError.Builder#build()} is called immediately and
         * its result is passed to {@link #error(ProtectedQueryError)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ProtectedQueryError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ProtectedQueryError)
         */
        default Builder error(Consumer<ProtectedQueryError.Builder> error) {
            return error(ProtectedQueryError.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String membershipId;

        private String membershipArn;

        private Instant createTime;

        private ProtectedQuerySQLParameters sqlParameters;

        private String status;

        private ProtectedQueryResultConfiguration resultConfiguration;

        private ProtectedQueryStatistics statistics;

        private ProtectedQueryResult result;

        private ProtectedQueryError error;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedQuery model) {
            id(model.id);
            membershipId(model.membershipId);
            membershipArn(model.membershipArn);
            createTime(model.createTime);
            sqlParameters(model.sqlParameters);
            status(model.status);
            resultConfiguration(model.resultConfiguration);
            statistics(model.statistics);
            result(model.result);
            error(model.error);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getMembershipId() {
            return membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipArn() {
            return membershipArn;
        }

        public final void setMembershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
        }

        @Override
        public final Builder membershipArn(String membershipArn) {
            this.membershipArn = membershipArn;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final ProtectedQuerySQLParameters.Builder getSqlParameters() {
            return sqlParameters != null ? sqlParameters.toBuilder() : null;
        }

        public final void setSqlParameters(ProtectedQuerySQLParameters.BuilderImpl sqlParameters) {
            this.sqlParameters = sqlParameters != null ? sqlParameters.build() : null;
        }

        @Override
        public final Builder sqlParameters(ProtectedQuerySQLParameters sqlParameters) {
            this.sqlParameters = sqlParameters;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProtectedQueryStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ProtectedQueryResultConfiguration.Builder getResultConfiguration() {
            return resultConfiguration != null ? resultConfiguration.toBuilder() : null;
        }

        public final void setResultConfiguration(ProtectedQueryResultConfiguration.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public final Builder resultConfiguration(ProtectedQueryResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final ProtectedQueryStatistics.Builder getStatistics() {
            return statistics != null ? statistics.toBuilder() : null;
        }

        public final void setStatistics(ProtectedQueryStatistics.BuilderImpl statistics) {
            this.statistics = statistics != null ? statistics.build() : null;
        }

        @Override
        public final Builder statistics(ProtectedQueryStatistics statistics) {
            this.statistics = statistics;
            return this;
        }

        public final ProtectedQueryResult.Builder getResult() {
            return result != null ? result.toBuilder() : null;
        }

        public final void setResult(ProtectedQueryResult.BuilderImpl result) {
            this.result = result != null ? result.build() : null;
        }

        @Override
        public final Builder result(ProtectedQueryResult result) {
            this.result = result;
            return this;
        }

        public final ProtectedQueryError.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ProtectedQueryError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ProtectedQueryError error) {
            this.error = error;
            return this;
        }

        @Override
        public ProtectedQuery build() {
            return new ProtectedQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
