/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ChangeSetType {
    CREATE("CREATE"),
    UPDATE("UPDATE"),
    IMPORT("IMPORT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ChangeSetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChangeSetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ChangeSetType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChangeSetType> knownValues() {
        return Stream.of(ChangeSetType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

