/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudformation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudformation.model.CloudFormationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTerminationProtectionRequest
extends CloudFormationRequest
implements ToCopyableBuilder<Builder, UpdateTerminationProtectionRequest> {
    private static final SdkField<Boolean> ENABLE_TERMINATION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableTerminationProtection").getter(UpdateTerminationProtectionRequest.getter(UpdateTerminationProtectionRequest::enableTerminationProtection)).setter(UpdateTerminationProtectionRequest.setter(Builder::enableTerminationProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableTerminationProtection").build()}).build();
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackName").getter(UpdateTerminationProtectionRequest.getter(UpdateTerminationProtectionRequest::stackName)).setter(UpdateTerminationProtectionRequest.setter(Builder::stackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_TERMINATION_PROTECTION_FIELD, STACK_NAME_FIELD));
    private final Boolean enableTerminationProtection;
    private final String stackName;

    private UpdateTerminationProtectionRequest(BuilderImpl builder) {
        super(builder);
        this.enableTerminationProtection = builder.enableTerminationProtection;
        this.stackName = builder.stackName;
    }

    public Boolean enableTerminationProtection() {
        return this.enableTerminationProtection;
    }

    public String stackName() {
        return this.stackName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.enableTerminationProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTerminationProtectionRequest)) {
            return false;
        }
        UpdateTerminationProtectionRequest other = (UpdateTerminationProtectionRequest)((Object)obj);
        return Objects.equals(this.enableTerminationProtection(), other.enableTerminationProtection()) && Objects.equals(this.stackName(), other.stackName());
    }

    public String toString() {
        return ToString.builder((String)"UpdateTerminationProtectionRequest").add("EnableTerminationProtection", (Object)this.enableTerminationProtection()).add("StackName", (Object)this.stackName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EnableTerminationProtection": {
                return Optional.ofNullable(clazz.cast(this.enableTerminationProtection()));
            }
            case "StackName": {
                return Optional.ofNullable(clazz.cast(this.stackName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTerminationProtectionRequest, T> g) {
        return obj -> g.apply((UpdateTerminationProtectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudFormationRequest.BuilderImpl
    implements Builder {
        private Boolean enableTerminationProtection;
        private String stackName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTerminationProtectionRequest model) {
            super(model);
            this.enableTerminationProtection(model.enableTerminationProtection);
            this.stackName(model.stackName);
        }

        public final Boolean getEnableTerminationProtection() {
            return this.enableTerminationProtection;
        }

        @Override
        public final Builder enableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
            return this;
        }

        public final void setEnableTerminationProtection(Boolean enableTerminationProtection) {
            this.enableTerminationProtection = enableTerminationProtection;
        }

        public final String getStackName() {
            return this.stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTerminationProtectionRequest build() {
            return new UpdateTerminationProtectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudFormationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTerminationProtectionRequest> {
        public Builder enableTerminationProtection(Boolean var1);

        public Builder stackName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

