/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.Response;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.services.cloudfront.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudfront.model.AssociateAliasRequest;
import software.amazon.awssdk.services.cloudfront.model.AssociateAliasResponse;
import software.amazon.awssdk.services.cloudfront.model.BatchTooLargeException;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CachePolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.CannotChangeImmutablePublicKeyFieldsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontOriginAccessIdentityInUseException;
import software.amazon.awssdk.services.cloudfront.model.CloudFrontRequest;
import software.amazon.awssdk.services.cloudfront.model.CnameAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ContinuousDeploymentPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.CopyDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CopyDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsRequest;
import software.amazon.awssdk.services.cloudfront.model.CreateStreamingDistributionWithTagsResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeletePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.DeleteStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.DescribeFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.DescribeFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.DistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.DistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileInUseException;
import software.amazon.awssdk.services.cloudfront.model.FieldLevelEncryptionProfileSizeExceededException;
import software.amazon.awssdk.services.cloudfront.model.FunctionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.FunctionInUseException;
import software.amazon.awssdk.services.cloudfront.model.FunctionSizeLimitExceededException;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.GetCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFieldLevelEncryptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationRequest;
import software.amazon.awssdk.services.cloudfront.model.GetInvalidationResponse;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.GetKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetMonitoringSubscriptionResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetPublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.GetResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.GetStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.IllegalDeleteException;
import software.amazon.awssdk.services.cloudfront.model.IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException;
import software.amazon.awssdk.services.cloudfront.model.IllegalOriginAccessConfigurationException;
import software.amazon.awssdk.services.cloudfront.model.IllegalUpdateException;
import software.amazon.awssdk.services.cloudfront.model.InconsistentQuantitiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidArgumentException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDefaultRootObjectException;
import software.amazon.awssdk.services.cloudfront.model.InvalidDomainNameForOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.InvalidErrorCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidForwardCookiesException;
import software.amazon.awssdk.services.cloudfront.model.InvalidFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidGeoRestrictionParameterException;
import software.amazon.awssdk.services.cloudfront.model.InvalidHeadersForS3OriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidIfMatchVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLambdaFunctionAssociationException;
import software.amazon.awssdk.services.cloudfront.model.InvalidLocationCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidMinimumProtocolVersionException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginKeepaliveTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidOriginReadTimeoutException;
import software.amazon.awssdk.services.cloudfront.model.InvalidProtocolSettingsException;
import software.amazon.awssdk.services.cloudfront.model.InvalidQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRelativePathException;
import software.amazon.awssdk.services.cloudfront.model.InvalidRequiredProtocolException;
import software.amazon.awssdk.services.cloudfront.model.InvalidResponseCodeException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTaggingException;
import software.amazon.awssdk.services.cloudfront.model.InvalidTtlOrderException;
import software.amazon.awssdk.services.cloudfront.model.InvalidViewerCertificateException;
import software.amazon.awssdk.services.cloudfront.model.InvalidWebAclIdException;
import software.amazon.awssdk.services.cloudfront.model.KeyGroupAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCachePoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListCloudFrontOriginAccessIdentitiesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListConflictingAliasesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListContinuousDeploymentPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByCachePolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByOriginRequestPolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByResponseHeadersPolicyIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsByWebAclIdResponse;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFieldLevelEncryptionProfilesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListFunctionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListFunctionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListInvalidationsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListKeyGroupsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListOriginAccessControlsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListOriginRequestPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudfront.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListRealtimeLogConfigsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesRequest;
import software.amazon.awssdk.services.cloudfront.model.ListResponseHeadersPoliciesResponse;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsRequest;
import software.amazon.awssdk.services.cloudfront.model.ListStreamingDistributionsResponse;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.MissingBodyException;
import software.amazon.awssdk.services.cloudfront.model.MonitoringSubscriptionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchCloudFrontOriginAccessIdentityException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchContinuousDeploymentPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchDistributionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFieldLevelEncryptionProfileException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchFunctionExistsException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchInvalidationException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchMonitoringSubscriptionException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchPublicKeyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchRealtimeLogConfigException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResourceException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.NoSuchStreamingDistributionException;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.OriginAccessControlInUseException;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.OriginRequestPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.PreconditionFailedException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.PublicKeyInUseException;
import software.amazon.awssdk.services.cloudfront.model.PublishFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.PublishFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.QueryArgProfileEmptyException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigInUseException;
import software.amazon.awssdk.services.cloudfront.model.RealtimeLogConfigOwnerMismatchException;
import software.amazon.awssdk.services.cloudfront.model.ResourceInUseException;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.ResponseHeadersPolicyInUseException;
import software.amazon.awssdk.services.cloudfront.model.StagingDistributionInUseException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionAlreadyExistsException;
import software.amazon.awssdk.services.cloudfront.model.StreamingDistributionNotDisabledException;
import software.amazon.awssdk.services.cloudfront.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionFailedException;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.TestFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.TooLongCspInResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCacheBehaviorsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCachePoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCertificatesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCloudFrontOriginAccessIdentitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyContinuousDeploymentPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookieNamesInWhiteListException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookiesInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCookiesInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyCustomHeadersInResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToKeyGroupException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToOriginAccessControlException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsAssociatedToResponseHeadersPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithLambdaAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyDistributionsWithSingleFunctionArnException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionContentTypeProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionEncryptionEntitiesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionFieldPatternsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFieldLevelEncryptionQueryArgProfilesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyFunctionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInForwardedValuesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyHeadersInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyInvalidationsInProgressException;
import software.amazon.awssdk.services.cloudfront.model.TooManyKeyGroupsAssociatedToDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyKeyGroupsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyLambdaFunctionAssociationsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginAccessControlsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginCustomHeadersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginGroupsPerDistributionException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginRequestPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyOriginsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysException;
import software.amazon.awssdk.services.cloudfront.model.TooManyPublicKeysInKeyGroupException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringParametersException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringsInCachePolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyQueryStringsInOriginRequestPolicyException;
import software.amazon.awssdk.services.cloudfront.model.TooManyRealtimeLogConfigsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyResponseHeadersPoliciesException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionCnamEsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyStreamingDistributionsException;
import software.amazon.awssdk.services.cloudfront.model.TooManyTrustedSignersException;
import software.amazon.awssdk.services.cloudfront.model.TrustedKeyGroupDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.TrustedSignerDoesNotExistException;
import software.amazon.awssdk.services.cloudfront.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudfront.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCachePolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateCloudFrontOriginAccessIdentityResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateContinuousDeploymentPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateDistributionWithStagingConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFieldLevelEncryptionProfileResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateKeyGroupResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginAccessControlResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateOriginRequestPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdatePublicKeyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateRealtimeLogConfigResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateResponseHeadersPolicyResponse;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionRequest;
import software.amazon.awssdk.services.cloudfront.model.UpdateStreamingDistributionResponse;
import software.amazon.awssdk.services.cloudfront.transform.AssociateAliasRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CopyDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateContinuousDeploymentPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateMonitoringSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateOriginAccessControlRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateResponseHeadersPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.CreateStreamingDistributionWithTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteContinuousDeploymentPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteMonitoringSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteOriginAccessControlRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeletePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteResponseHeadersPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DeleteStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.DescribeFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCachePolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetContinuousDeploymentPolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetContinuousDeploymentPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFieldLevelEncryptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetInvalidationRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetKeyGroupConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetMonitoringSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginAccessControlConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginAccessControlRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginRequestPolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetResponseHeadersPolicyConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetResponseHeadersPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.GetStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCachePoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListCloudFrontOriginAccessIdentitiesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListConflictingAliasesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListContinuousDeploymentPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByCachePolicyIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByOriginRequestPolicyIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByResponseHeadersPolicyIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsByWebAclIdRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionConfigsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFieldLevelEncryptionProfilesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListInvalidationsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListKeyGroupsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListOriginAccessControlsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListOriginRequestPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListRealtimeLogConfigsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListResponseHeadersPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListStreamingDistributionsRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.PublishFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.TestFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCachePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateCloudFrontOriginAccessIdentityRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateContinuousDeploymentPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateDistributionWithStagingConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFieldLevelEncryptionProfileRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateFunctionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateKeyGroupRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateOriginAccessControlRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateOriginRequestPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdatePublicKeyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateRealtimeLogConfigRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateResponseHeadersPolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.transform.UpdateStreamingDistributionRequestMarshaller;
import software.amazon.awssdk.services.cloudfront.waiters.CloudFrontAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link CloudFrontAsyncClient}.
 *
 * @see CloudFrontAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultCloudFrontAsyncClient implements CloudFrontAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudFrontAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsXmlProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultCloudFrontAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Associates an alias (also known as a CNAME or an alternate domain name) with a CloudFront distribution.
     * </p>
     * <p>
     * With this operation you can move an alias that’s already in use on a CloudFront distribution to a different
     * distribution in one step. This prevents the downtime that could occur if you first remove the alias from one
     * distribution and then separately add the alias to another distribution.
     * </p>
     * <p>
     * To use this operation to associate an alias with a distribution, you provide the alias and the ID of the target
     * distribution for the alias. For more information, including how to set up the target distribution, prerequisites
     * that you must complete, and other restrictions, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move"
     * >Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param associateAliasRequest
     * @return A Java Future containing the result of the AssociateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.AssociateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/AssociateAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateAliasResponse> associateAlias(AssociateAliasRequest associateAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateAlias");

            HttpResponseHandler<Response<AssociateAliasResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(AssociateAliasResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<AssociateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateAliasRequest, AssociateAliasResponse>()
                            .withOperationName("AssociateAlias")
                            .withMarshaller(new AssociateAliasRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(associateAliasRequest));
            CompletableFuture<AssociateAliasResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a staging distribution using the configuration of the provided primary distribution. A staging
     * distribution is a copy of an existing distribution (called the primary distribution) that you can use in a
     * continuous deployment workflow.
     * </p>
     * <p>
     * After you create a staging distribution, you can use <code>UpdateDistribution</code> to modify the staging
     * distribution’s configuration. Then you can use <code>CreateContinuousDeploymentPolicy</code> to incrementally
     * move traffic to the staging distribution.
     * </p>
     *
     * @param copyDistributionRequest
     * @return A Java Future containing the result of the CopyDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>DistributionAlreadyExistsException The caller reference you attempted to create the distribution with
     *         is associated with another distribution.</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>InvalidOriginAccessControlException The origin access control is not valid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InvalidViewerCertificateException A viewer certificate specified is not valid.</li>
     *         <li>InvalidMinimumProtocolVersionException The minimum protocol version specified is not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyDistributionsException Processing your request would cause you to exceed the maximum number of
     *         distributions allowed.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException An invalid error code was specified.</li>
     *         <li>InvalidResponseCodeException A response code is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyOriginGroupsPerDistributionException Processing your request would cause you to exceed the
     *         maximum number of origin groups allowed.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException Your request contains too many headers in forwarded values.</li>
     *         <li>InvalidHeadersForS3OriginException The headers specified are not valid for an Amazon S3 origin.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException The location code specified is not valid.</li>
     *         <li>InvalidGeoRestrictionParameterException The specified geo restriction parameter is not valid.</li>
     *         <li>InvalidProtocolSettingsException You cannot specify SSLv3 as the minimum protocol version if you only
     *         want to support only clients that support Server Name Indication (SNI).</li>
     *         <li>InvalidTtlOrderException The TTL order specified is not valid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>TooManyOriginCustomHeadersException Your request contains too many origin custom headers.</li>
     *         <li>TooManyQueryStringParametersException Your request contains too many query string parameters.</li>
     *         <li>InvalidQueryStringParametersException The query string parameters specified are not valid.</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda@Edge function associations per owner to be exceeded.</li>
     *         <li>TooManyDistributionsWithSingleFunctionArnException The maximum number of distributions have been
     *         associated with the specified Lambda@Edge function.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda@Edge function
     *         associations than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda@Edge function association is invalid.</li>
     *         <li>TooManyDistributionsWithFunctionAssociationsException You have reached the maximum number of
     *         distributions that are associated with a CloudFront function. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyFunctionAssociationsException You have reached the maximum number of CloudFront function
     *         associations for this distribution. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidFunctionAssociationException A CloudFront function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException The read timeout specified for the origin is not valid.</li>
     *         <li>InvalidOriginKeepaliveTimeoutException The keep alive timeout specified for the origin is not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException The specified configuration
     *         for field-level encryption can't be associated with the specified cache behavior.</li>
     *         <li>TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException The maximum number of
     *         distributions have been associated with the specified configuration for field-level encryption.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToCachePolicyException The maximum number of distributions have been
     *         associated with the specified cache policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchResponseHeadersPolicyException The response headers policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToResponseHeadersPolicyException The maximum number of distributions
     *         have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToOriginRequestPolicyException The maximum number of distributions have
     *         been associated with the specified origin request policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyDistributionsAssociatedToKeyGroupException The number of distributions that reference this key
     *         group is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyKeyGroupsAssociatedToDistributionException The number of key groups referenced by this
     *         distribution is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TrustedKeyGroupDoesNotExistException The specified key group does not exist.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigOwnerMismatchException The specified real-time log configuration belongs to a
     *         different Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CopyDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CopyDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CopyDistributionResponse> copyDistribution(CopyDistributionRequest copyDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, copyDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CopyDistribution");

            HttpResponseHandler<Response<CopyDistributionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CopyDistributionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CopyDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CopyDistributionRequest, CopyDistributionResponse>()
                            .withOperationName("CopyDistribution")
                            .withMarshaller(new CopyDistributionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(copyDistributionRequest));
            CompletableFuture<CopyDistributionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a cache policy.
     * </p>
     * <p>
     * After you create a cache policy, you can attach it to one or more cache behaviors. When it’s attached to a cache
     * behavior, the cache policy determines the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The values that CloudFront includes in the <i>cache key</i>. These values can include HTTP headers, cookies, and
     * URL query strings. CloudFront uses the cache key to find an object in its cache that it can return to the viewer.
     * </p>
     * </li>
     * <li>
     * <p>
     * The default, minimum, and maximum time to live (TTL) values that you want objects to stay in the CloudFront
     * cache.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The headers, cookies, and query strings that are included in the cache key are automatically included in requests
     * that CloudFront sends to the origin. CloudFront sends a request when it can’t find an object in its cache that
     * matches the request’s cache key. If you want to send values to the origin but <i>not</i> include them in the
     * cache key, use <code>OriginRequestPolicy</code>.
     * </p>
     * <p>
     * For more information about cache policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html"
     * >Controlling the cache key</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createCachePolicyRequest
     * @return A Java Future containing the result of the CreateCachePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>CachePolicyAlreadyExistsException A cache policy with this name already exists. You must provide a
     *         unique name. To modify an existing cache policy, use <code>UpdateCachePolicy</code>.</li>
     *         <li>TooManyCachePoliciesException You have reached the maximum number of cache policies for this Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyHeadersInCachePolicyException The number of headers in the cache policy exceeds the maximum.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCookiesInCachePolicyException The number of cookies in the cache policy exceeds the maximum.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyQueryStringsInCachePolicyException The number of query strings in the cache policy exceeds the
     *         maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCachePolicyResponse> createCachePolicy(CreateCachePolicyRequest createCachePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCachePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCachePolicy");

            HttpResponseHandler<Response<CreateCachePolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateCachePolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateCachePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCachePolicyRequest, CreateCachePolicyResponse>()
                            .withOperationName("CreateCachePolicy")
                            .withMarshaller(new CreateCachePolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCachePolicyRequest));
            CompletableFuture<CreateCachePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new origin access identity. If you're using Amazon S3 for your origin, you can use an origin access
     * identity to require users to access your content using a CloudFront URL instead of the Amazon S3 URL. For more
     * information about how to use origin access identities, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving Private
     * Content through CloudFront</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createCloudFrontOriginAccessIdentityRequest
     *        The request to create a new origin access identity (OAI). An origin access identity is a special
     *        CloudFront user that you can associate with Amazon S3 origins, so that you can secure all or just some of
     *        your Amazon S3 content. For more information, see <a href=
     *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     *        > Restricting Access to Amazon S3 Content by Using an Origin Access Identity</a> in the <i>Amazon
     *        CloudFront Developer Guide</i>.
     * @return A Java Future containing the result of the CreateCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CloudFrontOriginAccessIdentityAlreadyExistsException If the <code>CallerReference</code> is a value
     *         you already sent in a previous request to create an identity but the content of the
     *         <code>CloudFrontOriginAccessIdentityConfig</code> is different from the original request, CloudFront
     *         returns a <code>CloudFrontOriginAccessIdentityAlreadyExists</code> error.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyCloudFrontOriginAccessIdentitiesException Processing your request would cause you to exceed
     *         the maximum number of origin access identities allowed.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCloudFrontOriginAccessIdentityResponse> createCloudFrontOriginAccessIdentity(
            CreateCloudFrontOriginAccessIdentityRequest createCloudFrontOriginAccessIdentityRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCloudFrontOriginAccessIdentity");

            HttpResponseHandler<Response<CreateCloudFrontOriginAccessIdentityResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateCloudFrontOriginAccessIdentityResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateCloudFrontOriginAccessIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCloudFrontOriginAccessIdentityRequest, CreateCloudFrontOriginAccessIdentityResponse>()
                            .withOperationName("CreateCloudFrontOriginAccessIdentity")
                            .withMarshaller(new CreateCloudFrontOriginAccessIdentityRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCloudFrontOriginAccessIdentityRequest));
            CompletableFuture<CreateCloudFrontOriginAccessIdentityResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a continuous deployment policy that distributes traffic for a custom domain name to two different
     * CloudFront distributions.
     * </p>
     * <p>
     * To use a continuous deployment policy, first use <code>CopyDistribution</code> to create a staging distribution,
     * then use <code>UpdateDistribution</code> to modify the staging distribution’s configuration.
     * </p>
     * <p>
     * After you create and update a staging distribution, you can use a continuous deployment policy to incrementally
     * move traffic to the staging distribution. This workflow enables you to test changes to a distribution’s
     * configuration before moving all of your domain’s production traffic to the new configuration.
     * </p>
     *
     * @param createContinuousDeploymentPolicyRequest
     * @return A Java Future containing the result of the CreateContinuousDeploymentPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>ContinuousDeploymentPolicyAlreadyExistsException A continuous deployment policy with this
     *         configuration already exists.</li>
     *         <li>TooManyContinuousDeploymentPoliciesException You have reached the maximum number of continuous
     *         deployment policies for this Amazon Web Services account.</li>
     *         <li>StagingDistributionInUseException A continuous deployment policy for this staging distribution
     *         already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateContinuousDeploymentPolicyResponse> createContinuousDeploymentPolicy(
            CreateContinuousDeploymentPolicyRequest createContinuousDeploymentPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createContinuousDeploymentPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateContinuousDeploymentPolicy");

            HttpResponseHandler<Response<CreateContinuousDeploymentPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateContinuousDeploymentPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateContinuousDeploymentPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateContinuousDeploymentPolicyRequest, CreateContinuousDeploymentPolicyResponse>()
                            .withOperationName("CreateContinuousDeploymentPolicy")
                            .withMarshaller(new CreateContinuousDeploymentPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createContinuousDeploymentPolicyRequest));
            CompletableFuture<CreateContinuousDeploymentPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a CloudFront distribution.
     * </p>
     *
     * @param createDistributionRequest
     *        The request to create a new distribution.
     * @return A Java Future containing the result of the CreateDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>DistributionAlreadyExistsException The caller reference you attempted to create the distribution with
     *         is associated with another distribution.</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>InvalidOriginAccessControlException The origin access control is not valid.</li>
     *         <li>IllegalOriginAccessConfigurationException An origin cannot contain both an origin access control
     *         (OAC) and an origin access identity (OAI).</li>
     *         <li>TooManyDistributionsAssociatedToOriginAccessControlException The maximum number of distributions have
     *         been associated with the specified origin access control.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InvalidViewerCertificateException A viewer certificate specified is not valid.</li>
     *         <li>InvalidMinimumProtocolVersionException The minimum protocol version specified is not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyDistributionsException Processing your request would cause you to exceed the maximum number of
     *         distributions allowed.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException An invalid error code was specified.</li>
     *         <li>InvalidResponseCodeException A response code is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyOriginGroupsPerDistributionException Processing your request would cause you to exceed the
     *         maximum number of origin groups allowed.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException Your request contains too many headers in forwarded values.</li>
     *         <li>InvalidHeadersForS3OriginException The headers specified are not valid for an Amazon S3 origin.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException The location code specified is not valid.</li>
     *         <li>InvalidGeoRestrictionParameterException The specified geo restriction parameter is not valid.</li>
     *         <li>InvalidProtocolSettingsException You cannot specify SSLv3 as the minimum protocol version if you only
     *         want to support only clients that support Server Name Indication (SNI).</li>
     *         <li>InvalidTtlOrderException The TTL order specified is not valid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>TooManyOriginCustomHeadersException Your request contains too many origin custom headers.</li>
     *         <li>TooManyQueryStringParametersException Your request contains too many query string parameters.</li>
     *         <li>InvalidQueryStringParametersException The query string parameters specified are not valid.</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda@Edge function associations per owner to be exceeded.</li>
     *         <li>TooManyDistributionsWithSingleFunctionArnException The maximum number of distributions have been
     *         associated with the specified Lambda@Edge function.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda@Edge function
     *         associations than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda@Edge function association is invalid.</li>
     *         <li>TooManyDistributionsWithFunctionAssociationsException You have reached the maximum number of
     *         distributions that are associated with a CloudFront function. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyFunctionAssociationsException You have reached the maximum number of CloudFront function
     *         associations for this distribution. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidFunctionAssociationException A CloudFront function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException The read timeout specified for the origin is not valid.</li>
     *         <li>InvalidOriginKeepaliveTimeoutException The keep alive timeout specified for the origin is not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException The specified configuration
     *         for field-level encryption can't be associated with the specified cache behavior.</li>
     *         <li>TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException The maximum number of
     *         distributions have been associated with the specified configuration for field-level encryption.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToCachePolicyException The maximum number of distributions have been
     *         associated with the specified cache policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchResponseHeadersPolicyException The response headers policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToResponseHeadersPolicyException The maximum number of distributions
     *         have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToOriginRequestPolicyException The maximum number of distributions have
     *         been associated with the specified origin request policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyDistributionsAssociatedToKeyGroupException The number of distributions that reference this key
     *         group is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyKeyGroupsAssociatedToDistributionException The number of key groups referenced by this
     *         distribution is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TrustedKeyGroupDoesNotExistException The specified key group does not exist.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigOwnerMismatchException The specified real-time log configuration belongs to a
     *         different Amazon Web Services account.</li>
     *         <li>ContinuousDeploymentPolicyInUseException You cannot delete a continuous deployment policy that is
     *         associated with a primary distribution.</li>
     *         <li>NoSuchContinuousDeploymentPolicyException The continuous deployment policy doesn’t exist.</li>
     *         <li>InvalidDomainNameForOriginAccessControlException An origin access control is associated with an
     *         origin whose domain name is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDistributionResponse> createDistribution(CreateDistributionRequest createDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDistribution");

            HttpResponseHandler<Response<CreateDistributionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateDistributionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDistributionRequest, CreateDistributionResponse>()
                            .withOperationName("CreateDistribution")
                            .withMarshaller(new CreateDistributionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDistributionRequest));
            CompletableFuture<CreateDistributionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a new distribution with tags.
     * </p>
     *
     * @param createDistributionWithTagsRequest
     *        The request to create a new distribution with tags.
     * @return A Java Future containing the result of the CreateDistributionWithTags operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>DistributionAlreadyExistsException The caller reference you attempted to create the distribution with
     *         is associated with another distribution.</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>InvalidOriginAccessControlException The origin access control is not valid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InvalidViewerCertificateException A viewer certificate specified is not valid.</li>
     *         <li>InvalidMinimumProtocolVersionException The minimum protocol version specified is not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyDistributionsException Processing your request would cause you to exceed the maximum number of
     *         distributions allowed.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException An invalid error code was specified.</li>
     *         <li>InvalidResponseCodeException A response code is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyOriginGroupsPerDistributionException Processing your request would cause you to exceed the
     *         maximum number of origin groups allowed.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException Your request contains too many headers in forwarded values.</li>
     *         <li>InvalidHeadersForS3OriginException The headers specified are not valid for an Amazon S3 origin.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException The location code specified is not valid.</li>
     *         <li>InvalidGeoRestrictionParameterException The specified geo restriction parameter is not valid.</li>
     *         <li>InvalidProtocolSettingsException You cannot specify SSLv3 as the minimum protocol version if you only
     *         want to support only clients that support Server Name Indication (SNI).</li>
     *         <li>InvalidTtlOrderException The TTL order specified is not valid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>TooManyOriginCustomHeadersException Your request contains too many origin custom headers.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>TooManyQueryStringParametersException Your request contains too many query string parameters.</li>
     *         <li>InvalidQueryStringParametersException The query string parameters specified are not valid.</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda@Edge function associations per owner to be exceeded.</li>
     *         <li>TooManyDistributionsWithSingleFunctionArnException The maximum number of distributions have been
     *         associated with the specified Lambda@Edge function.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda@Edge function
     *         associations than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda@Edge function association is invalid.</li>
     *         <li>TooManyDistributionsWithFunctionAssociationsException You have reached the maximum number of
     *         distributions that are associated with a CloudFront function. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyFunctionAssociationsException You have reached the maximum number of CloudFront function
     *         associations for this distribution. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidFunctionAssociationException A CloudFront function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException The read timeout specified for the origin is not valid.</li>
     *         <li>InvalidOriginKeepaliveTimeoutException The keep alive timeout specified for the origin is not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException The specified configuration
     *         for field-level encryption can't be associated with the specified cache behavior.</li>
     *         <li>TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException The maximum number of
     *         distributions have been associated with the specified configuration for field-level encryption.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToCachePolicyException The maximum number of distributions have been
     *         associated with the specified cache policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchResponseHeadersPolicyException The response headers policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToResponseHeadersPolicyException The maximum number of distributions
     *         have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToOriginRequestPolicyException The maximum number of distributions have
     *         been associated with the specified origin request policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyDistributionsAssociatedToKeyGroupException The number of distributions that reference this key
     *         group is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyKeyGroupsAssociatedToDistributionException The number of key groups referenced by this
     *         distribution is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TrustedKeyGroupDoesNotExistException The specified key group does not exist.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigOwnerMismatchException The specified real-time log configuration belongs to a
     *         different Amazon Web Services account.</li>
     *         <li>ContinuousDeploymentPolicyInUseException You cannot delete a continuous deployment policy that is
     *         associated with a primary distribution.</li>
     *         <li>NoSuchContinuousDeploymentPolicyException The continuous deployment policy doesn’t exist.</li>
     *         <li>InvalidDomainNameForOriginAccessControlException An origin access control is associated with an
     *         origin whose domain name is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateDistributionWithTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDistributionWithTagsResponse> createDistributionWithTags(
            CreateDistributionWithTagsRequest createDistributionWithTagsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDistributionWithTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDistributionWithTags");

            HttpResponseHandler<Response<CreateDistributionWithTagsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateDistributionWithTagsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateDistributionWithTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDistributionWithTagsRequest, CreateDistributionWithTagsResponse>()
                            .withOperationName("CreateDistributionWithTags")
                            .withMarshaller(new CreateDistributionWithTagsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createDistributionWithTagsRequest));
            CompletableFuture<CreateDistributionWithTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a new field-level encryption configuration.
     * </p>
     *
     * @param createFieldLevelEncryptionConfigRequest
     * @return A Java Future containing the result of the CreateFieldLevelEncryptionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>FieldLevelEncryptionConfigAlreadyExistsException The specified configuration for field-level
     *         encryption already exists.</li>
     *         <li>TooManyFieldLevelEncryptionConfigsException The maximum number of configurations for field-level
     *         encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionQueryArgProfilesException The maximum number of query arg profiles for
     *         field-level encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionContentTypeProfilesException The maximum number of content type profiles
     *         for field-level encryption have been created.</li>
     *         <li>QueryArgProfileEmptyException No profile specified for the field-level encryption query argument.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFieldLevelEncryptionConfigResponse> createFieldLevelEncryptionConfig(
            CreateFieldLevelEncryptionConfigRequest createFieldLevelEncryptionConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFieldLevelEncryptionConfig");

            HttpResponseHandler<Response<CreateFieldLevelEncryptionConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateFieldLevelEncryptionConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateFieldLevelEncryptionConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFieldLevelEncryptionConfigRequest, CreateFieldLevelEncryptionConfigResponse>()
                            .withOperationName("CreateFieldLevelEncryptionConfig")
                            .withMarshaller(new CreateFieldLevelEncryptionConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFieldLevelEncryptionConfigRequest));
            CompletableFuture<CreateFieldLevelEncryptionConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a field-level encryption profile.
     * </p>
     *
     * @param createFieldLevelEncryptionProfileRequest
     * @return A Java Future containing the result of the CreateFieldLevelEncryptionProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>FieldLevelEncryptionProfileAlreadyExistsException The specified profile for field-level encryption
     *         already exists.</li>
     *         <li>FieldLevelEncryptionProfileSizeExceededException The maximum size of a profile for field-level
     *         encryption was exceeded.</li>
     *         <li>TooManyFieldLevelEncryptionProfilesException The maximum number of profiles for field-level
     *         encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionEncryptionEntitiesException The maximum number of encryption entities for
     *         field-level encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionFieldPatternsException The maximum number of field patterns for
     *         field-level encryption have been created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFieldLevelEncryptionProfileResponse> createFieldLevelEncryptionProfile(
            CreateFieldLevelEncryptionProfileRequest createFieldLevelEncryptionProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFieldLevelEncryptionProfile");

            HttpResponseHandler<Response<CreateFieldLevelEncryptionProfileResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateFieldLevelEncryptionProfileResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateFieldLevelEncryptionProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFieldLevelEncryptionProfileRequest, CreateFieldLevelEncryptionProfileResponse>()
                            .withOperationName("CreateFieldLevelEncryptionProfile")
                            .withMarshaller(new CreateFieldLevelEncryptionProfileRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFieldLevelEncryptionProfileRequest));
            CompletableFuture<CreateFieldLevelEncryptionProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a CloudFront function.
     * </p>
     * <p>
     * To create a function, you provide the function code and some configuration information about the function. The
     * response contains an Amazon Resource Name (ARN) that uniquely identifies the function.
     * </p>
     * <p>
     * When you create a function, it’s in the <code>DEVELOPMENT</code> stage. In this stage, you can test the function
     * with <code>TestFunction</code>, and update it with <code>UpdateFunction</code>.
     * </p>
     * <p>
     * When you’re ready to use your function with a CloudFront distribution, use <code>PublishFunction</code> to copy
     * the function from the <code>DEVELOPMENT</code> stage to <code>LIVE</code>. When it’s live, you can attach the
     * function to a distribution’s cache behavior, using the function’s ARN.
     * </p>
     *
     * @param createFunctionRequest
     * @return A Java Future containing the result of the CreateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>TooManyFunctionsException You have reached the maximum number of CloudFront functions for this Amazon
     *         Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>FunctionAlreadyExistsException A function with the same name already exists in this Amazon Web
     *         Services account. To create a function, you must provide a unique name. To update an existing function,
     *         use <code>UpdateFunction</code>.</li>
     *         <li>FunctionSizeLimitExceededException The function is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFunctionResponse> createFunction(CreateFunctionRequest createFunctionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFunction");

            HttpResponseHandler<Response<CreateFunctionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateFunctionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateFunctionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFunctionRequest, CreateFunctionResponse>()
                            .withOperationName("CreateFunction")
                            .withMarshaller(new CreateFunctionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createFunctionRequest));
            CompletableFuture<CreateFunctionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Create a new invalidation.
     * </p>
     *
     * @param createInvalidationRequest
     *        The request to create an invalidation.
     * @return A Java Future containing the result of the CreateInvalidation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>BatchTooLargeException Invalidation batch specified is too large.</li>
     *         <li>TooManyInvalidationsInProgressException You have exceeded the maximum number of allowable InProgress
     *         invalidation batch requests, or invalidation objects.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateInvalidation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateInvalidationResponse> createInvalidation(CreateInvalidationRequest createInvalidationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInvalidationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInvalidation");

            HttpResponseHandler<Response<CreateInvalidationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateInvalidationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateInvalidationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateInvalidationRequest, CreateInvalidationResponse>()
                            .withOperationName("CreateInvalidation")
                            .withMarshaller(new CreateInvalidationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createInvalidationRequest));
            CompletableFuture<CreateInvalidationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a key group that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">CloudFront signed
     * URLs and signed cookies</a>.
     * </p>
     * <p>
     * To create a key group, you must specify at least one public key for the key group. After you create a key group,
     * you can reference it from one or more cache behaviors. When you reference a key group in a cache behavior,
     * CloudFront requires signed URLs or signed cookies for all requests that match the cache behavior. The URLs or
     * cookies must be signed with a private key whose corresponding public key is in the key group. The signed URL or
     * cookie contains information about which public key CloudFront should use to verify the signature. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">Serving private
     * content</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createKeyGroupRequest
     * @return A Java Future containing the result of the CreateKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>KeyGroupAlreadyExistsException A key group with this name already exists. You must provide a unique
     *         name. To modify an existing key group, use <code>UpdateKeyGroup</code>.</li>
     *         <li>TooManyKeyGroupsException You have reached the maximum number of key groups for this Amazon Web
     *         Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyPublicKeysInKeyGroupException The number of public keys in this key group is more than the
     *         maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateKeyGroupResponse> createKeyGroup(CreateKeyGroupRequest createKeyGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createKeyGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateKeyGroup");

            HttpResponseHandler<Response<CreateKeyGroupResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateKeyGroupResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateKeyGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateKeyGroupRequest, CreateKeyGroupResponse>()
                            .withOperationName("CreateKeyGroup")
                            .withMarshaller(new CreateKeyGroupRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createKeyGroupRequest));
            CompletableFuture<CreateKeyGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Enables additional CloudWatch metrics for the specified CloudFront distribution. The additional metrics incur an
     * additional cost.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional"
     * >Viewing additional CloudFront distribution metrics</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createMonitoringSubscriptionRequest
     * @return A Java Future containing the result of the CreateMonitoringSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>MonitoringSubscriptionAlreadyExistsException A monitoring subscription already exists for the
     *         specified distribution.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMonitoringSubscriptionResponse> createMonitoringSubscription(
            CreateMonitoringSubscriptionRequest createMonitoringSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMonitoringSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMonitoringSubscription");

            HttpResponseHandler<Response<CreateMonitoringSubscriptionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateMonitoringSubscriptionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateMonitoringSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMonitoringSubscriptionRequest, CreateMonitoringSubscriptionResponse>()
                            .withOperationName("CreateMonitoringSubscription")
                            .withMarshaller(new CreateMonitoringSubscriptionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMonitoringSubscriptionRequest));
            CompletableFuture<CreateMonitoringSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new origin access control in CloudFront. After you create an origin access control, you can add it to
     * an origin in a CloudFront distribution so that CloudFront sends authenticated (signed) requests to the origin.
     * </p>
     * <p>
     * For an Amazon S3 origin, this makes it possible to block public access to the Amazon S3 bucket so that viewers
     * (users) can access the content in the bucket only through CloudFront.
     * </p>
     * <p>
     * For more information about using a CloudFront origin access control, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/private-content-restricting-access-to-s3.html"
     * >Restricting access to an Amazon S3 origin</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createOriginAccessControlRequest
     * @return A Java Future containing the result of the CreateOriginAccessControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OriginAccessControlAlreadyExistsException An origin access control with the specified parameters
     *         already exists.</li>
     *         <li>TooManyOriginAccessControlsException The number of origin access controls in your Amazon Web Services
     *         account exceeds the maximum allowed.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOriginAccessControlResponse> createOriginAccessControl(
            CreateOriginAccessControlRequest createOriginAccessControlRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOriginAccessControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOriginAccessControl");

            HttpResponseHandler<Response<CreateOriginAccessControlResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateOriginAccessControlResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateOriginAccessControlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOriginAccessControlRequest, CreateOriginAccessControlResponse>()
                            .withOperationName("CreateOriginAccessControl")
                            .withMarshaller(new CreateOriginAccessControlRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createOriginAccessControlRequest));
            CompletableFuture<CreateOriginAccessControlResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an origin request policy.
     * </p>
     * <p>
     * After you create an origin request policy, you can attach it to one or more cache behaviors. When it’s attached
     * to a cache behavior, the origin request policy determines the values that CloudFront includes in requests that it
     * sends to the origin. Each request that CloudFront sends to the origin includes the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The request body and the URL path (without the domain name) from the viewer request.
     * </p>
     * </li>
     * <li>
     * <p>
     * The headers that CloudFront automatically includes in every origin request, including <code>Host</code>,
     * <code>User-Agent</code>, and <code>X-Amz-Cf-Id</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * All HTTP headers, cookies, and URL query strings that are specified in the cache policy or the origin request
     * policy. These can include items from the viewer request and, in the case of headers, additional ones that are
     * added by CloudFront.
     * </p>
     * </li>
     * </ul>
     * <p>
     * CloudFront sends a request when it can’t find a valid object in its cache that matches the request. If you want
     * to send values to the origin and also include them in the cache key, use <code>CachePolicy</code>.
     * </p>
     * <p>
     * For more information about origin request policies, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-origin-requests.html"
     * >Controlling origin requests</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createOriginRequestPolicyRequest
     * @return A Java Future containing the result of the CreateOriginRequestPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>OriginRequestPolicyAlreadyExistsException An origin request policy with this name already exists. You
     *         must provide a unique name. To modify an existing origin request policy, use
     *         <code>UpdateOriginRequestPolicy</code>.</li>
     *         <li>TooManyOriginRequestPoliciesException You have reached the maximum number of origin request policies
     *         for this Amazon Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyHeadersInOriginRequestPolicyException The number of headers in the origin request policy
     *         exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCookiesInOriginRequestPolicyException The number of cookies in the origin request policy
     *         exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyQueryStringsInOriginRequestPolicyException The number of query strings in the origin request
     *         policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateOriginRequestPolicyResponse> createOriginRequestPolicy(
            CreateOriginRequestPolicyRequest createOriginRequestPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOriginRequestPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOriginRequestPolicy");

            HttpResponseHandler<Response<CreateOriginRequestPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateOriginRequestPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateOriginRequestPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateOriginRequestPolicyRequest, CreateOriginRequestPolicyResponse>()
                            .withOperationName("CreateOriginRequestPolicy")
                            .withMarshaller(new CreateOriginRequestPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createOriginRequestPolicyRequest));
            CompletableFuture<CreateOriginRequestPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Uploads a public key to CloudFront that you can use with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">signed URLs and
     * signed cookies</a>, or with <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/field-level-encryption.html">field-level
     * encryption</a>.
     * </p>
     *
     * @param createPublicKeyRequest
     * @return A Java Future containing the result of the CreatePublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>PublicKeyAlreadyExistsException The specified public key already exists.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>TooManyPublicKeysException The maximum number of public keys for field-level encryption have been
     *         created. To create a new public key, delete one of the existing keys.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreatePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreatePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePublicKeyResponse> createPublicKey(CreatePublicKeyRequest createPublicKeyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePublicKey");

            HttpResponseHandler<Response<CreatePublicKeyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreatePublicKeyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreatePublicKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePublicKeyRequest, CreatePublicKeyResponse>()
                            .withOperationName("CreatePublicKey")
                            .withMarshaller(new CreatePublicKeyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createPublicKeyRequest));
            CompletableFuture<CreatePublicKeyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a real-time log configuration.
     * </p>
     * <p>
     * After you create a real-time log configuration, you can attach it to one or more cache behaviors to send
     * real-time log data to the specified Amazon Kinesis data stream.
     * </p>
     * <p>
     * For more information about real-time log configurations, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/real-time-logs.html">Real-time logs</a>
     * in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param createRealtimeLogConfigRequest
     * @return A Java Future containing the result of the CreateRealtimeLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>RealtimeLogConfigAlreadyExistsException A real-time log configuration with this name already exists.
     *         You must provide a unique name. To modify an existing real-time log configuration, use
     *         <code>UpdateRealtimeLogConfig</code>.</li>
     *         <li>TooManyRealtimeLogConfigsException You have reached the maximum number of real-time log
     *         configurations for this Amazon Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRealtimeLogConfigResponse> createRealtimeLogConfig(
            CreateRealtimeLogConfigRequest createRealtimeLogConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRealtimeLogConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRealtimeLogConfig");

            HttpResponseHandler<Response<CreateRealtimeLogConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateRealtimeLogConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateRealtimeLogConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRealtimeLogConfigRequest, CreateRealtimeLogConfigResponse>()
                            .withOperationName("CreateRealtimeLogConfig")
                            .withMarshaller(new CreateRealtimeLogConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createRealtimeLogConfigRequest));
            CompletableFuture<CreateRealtimeLogConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a response headers policy.
     * </p>
     * <p>
     * A response headers policy contains information about a set of HTTP response headers and their values. To create a
     * response headers policy, you provide some metadata about the policy, and a set of configurations that specify the
     * response headers.
     * </p>
     * <p>
     * After you create a response headers policy, you can use its ID to attach it to one or more cache behaviors in a
     * CloudFront distribution. When it’s attached to a cache behavior, CloudFront adds the headers in the policy to
     * HTTP responses that it sends for requests that match the cache behavior.
     * </p>
     *
     * @param createResponseHeadersPolicyRequest
     * @return A Java Future containing the result of the CreateResponseHeadersPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>ResponseHeadersPolicyAlreadyExistsException A response headers policy with this name already exists.
     *         You must provide a unique name. To modify an existing response headers policy, use
     *         <code>UpdateResponseHeadersPolicy</code>.</li>
     *         <li>TooManyResponseHeadersPoliciesException You have reached the maximum number of response headers
     *         policies for this Amazon Web Services account.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCustomHeadersInResponseHeadersPolicyException The number of custom headers in the response
     *         headers policy exceeds the maximum.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooLongCspInResponseHeadersPolicyException The length of the <code>Content-Security-Policy</code>
     *         header value in the response headers policy exceeds the maximum.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateResponseHeadersPolicyResponse> createResponseHeadersPolicy(
            CreateResponseHeadersPolicyRequest createResponseHeadersPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResponseHeadersPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResponseHeadersPolicy");

            HttpResponseHandler<Response<CreateResponseHeadersPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateResponseHeadersPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateResponseHeadersPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateResponseHeadersPolicyRequest, CreateResponseHeadersPolicyResponse>()
                            .withOperationName("CreateResponseHeadersPolicy")
                            .withMarshaller(new CreateResponseHeadersPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createResponseHeadersPolicyRequest));
            CompletableFuture<CreateResponseHeadersPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on
     * December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the
     * announcement</a> on the Amazon CloudFront discussion forum.
     * </p>
     *
     * @param createStreamingDistributionRequest
     *        The request to create a new streaming distribution.
     * @return A Java Future containing the result of the CreateStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>StreamingDistributionAlreadyExistsException The caller reference you attempted to create the
     *         streaming distribution with is associated with another distribution</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>InvalidOriginAccessControlException The origin access control is not valid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyStreamingDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyStreamingDistributionsException Processing your request would cause you to exceed the maximum
     *         number of streaming distributions allowed.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStreamingDistributionResponse> createStreamingDistribution(
            CreateStreamingDistributionRequest createStreamingDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createStreamingDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStreamingDistribution");

            HttpResponseHandler<Response<CreateStreamingDistributionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateStreamingDistributionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateStreamingDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStreamingDistributionRequest, CreateStreamingDistributionResponse>()
                            .withOperationName("CreateStreamingDistribution")
                            .withMarshaller(new CreateStreamingDistributionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createStreamingDistributionRequest));
            CompletableFuture<CreateStreamingDistributionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * This API is deprecated. Amazon CloudFront is deprecating real-time messaging protocol (RTMP) distributions on
     * December 31, 2020. For more information, <a href="http://forums.aws.amazon.com/ann.jspa?annID=7356">read the
     * announcement</a> on the Amazon CloudFront discussion forum.
     * </p>
     *
     * @param createStreamingDistributionWithTagsRequest
     *        The request to create a new streaming distribution with tags.
     * @return A Java Future containing the result of the CreateStreamingDistributionWithTags operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>StreamingDistributionAlreadyExistsException The caller reference you attempted to create the
     *         streaming distribution with is associated with another distribution</li>
     *         <li>InvalidOriginException The Amazon S3 origin server specified does not refer to a valid Amazon S3
     *         bucket.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>InvalidOriginAccessControlException The origin access control is not valid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>TooManyStreamingDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>TooManyStreamingDistributionsException Processing your request would cause you to exceed the maximum
     *         number of streaming distributions allowed.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.CreateStreamingDistributionWithTags
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/CreateStreamingDistributionWithTags"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateStreamingDistributionWithTagsResponse> createStreamingDistributionWithTags(
            CreateStreamingDistributionWithTagsRequest createStreamingDistributionWithTagsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createStreamingDistributionWithTagsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateStreamingDistributionWithTags");

            HttpResponseHandler<Response<CreateStreamingDistributionWithTagsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(CreateStreamingDistributionWithTagsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<CreateStreamingDistributionWithTagsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateStreamingDistributionWithTagsRequest, CreateStreamingDistributionWithTagsResponse>()
                            .withOperationName("CreateStreamingDistributionWithTags")
                            .withMarshaller(new CreateStreamingDistributionWithTagsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(createStreamingDistributionWithTagsRequest));
            CompletableFuture<CreateStreamingDistributionWithTagsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a cache policy.
     * </p>
     * <p>
     * You cannot delete a cache policy if it’s attached to a cache behavior. First update your distributions to remove
     * the cache policy from all cache behaviors, then delete the cache policy.
     * </p>
     * <p>
     * To delete a cache policy, you must provide the policy’s identifier and version. To get these values, you can use
     * <code>ListCachePolicies</code> or <code>GetCachePolicy</code>.
     * </p>
     *
     * @param deleteCachePolicyRequest
     * @return A Java Future containing the result of the DeleteCachePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>IllegalDeleteException You cannot delete a managed policy.</li>
     *         <li>CachePolicyInUseException Cannot delete the cache policy because it is attached to one or more cache
     *         behaviors.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCachePolicyResponse> deleteCachePolicy(DeleteCachePolicyRequest deleteCachePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteCachePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCachePolicy");

            HttpResponseHandler<Response<DeleteCachePolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteCachePolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteCachePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCachePolicyRequest, DeleteCachePolicyResponse>()
                            .withOperationName("DeleteCachePolicy")
                            .withMarshaller(new DeleteCachePolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCachePolicyRequest));
            CompletableFuture<DeleteCachePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete an origin access identity.
     * </p>
     *
     * @param deleteCloudFrontOriginAccessIdentityRequest
     *        Deletes a origin access identity.
     * @return A Java Future containing the result of the DeleteCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>CloudFrontOriginAccessIdentityInUseException The Origin Access Identity specified is already in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteCloudFrontOriginAccessIdentityResponse> deleteCloudFrontOriginAccessIdentity(
            DeleteCloudFrontOriginAccessIdentityRequest deleteCloudFrontOriginAccessIdentityRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteCloudFrontOriginAccessIdentity");

            HttpResponseHandler<Response<DeleteCloudFrontOriginAccessIdentityResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteCloudFrontOriginAccessIdentityResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteCloudFrontOriginAccessIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteCloudFrontOriginAccessIdentityRequest, DeleteCloudFrontOriginAccessIdentityResponse>()
                            .withOperationName("DeleteCloudFrontOriginAccessIdentity")
                            .withMarshaller(new DeleteCloudFrontOriginAccessIdentityRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteCloudFrontOriginAccessIdentityRequest));
            CompletableFuture<DeleteCloudFrontOriginAccessIdentityResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a continuous deployment policy.
     * </p>
     * <p>
     * You cannot delete a continuous deployment policy that’s attached to a primary distribution. First update your
     * distribution to remove the continuous deployment policy, then you can delete the policy.
     * </p>
     *
     * @param deleteContinuousDeploymentPolicyRequest
     * @return A Java Future containing the result of the DeleteContinuousDeploymentPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>ContinuousDeploymentPolicyInUseException You cannot delete a continuous deployment policy that is
     *         associated with a primary distribution.</li>
     *         <li>NoSuchContinuousDeploymentPolicyException The continuous deployment policy doesn’t exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteContinuousDeploymentPolicyResponse> deleteContinuousDeploymentPolicy(
            DeleteContinuousDeploymentPolicyRequest deleteContinuousDeploymentPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteContinuousDeploymentPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteContinuousDeploymentPolicy");

            HttpResponseHandler<Response<DeleteContinuousDeploymentPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteContinuousDeploymentPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteContinuousDeploymentPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteContinuousDeploymentPolicyRequest, DeleteContinuousDeploymentPolicyResponse>()
                            .withOperationName("DeleteContinuousDeploymentPolicy")
                            .withMarshaller(new DeleteContinuousDeploymentPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteContinuousDeploymentPolicyRequest));
            CompletableFuture<DeleteContinuousDeploymentPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a distribution.
     * </p>
     *
     * @param deleteDistributionRequest
     *        This action deletes a web distribution. To delete a web distribution using the CloudFront API, perform the
     *        following steps.</p>
     *        <p>
     *        <b>To delete a web distribution using the CloudFront API:</b>
     *        </p>
     *        <ol>
     *        <li>
     *        <p>
     *        Disable the web distribution
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution Config</code> request to get the current configuration and the
     *        <code>Etag</code> header for the distribution.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Update the XML document that was returned in the response to your <code>GET Distribution Config</code>
     *        request to change the value of <code>Enabled</code> to <code>false</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>PUT Distribution Config</code> request to update the configuration for your distribution.
     *        In the request body, include the XML document that you updated in Step 3. Set the value of the HTTP
     *        <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when
     *        you submitted the <code>GET Distribution Config</code> request in Step 2.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to the <code>PUT Distribution Config</code> request to confirm that the distribution
     *        was successfully disabled.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>GET Distribution</code> request to confirm that your changes have propagated. When
     *        propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Submit a <code>DELETE Distribution</code> request. Set the value of the HTTP <code>If-Match</code> header
     *        to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     *        <code>GET Distribution Config</code> request in Step 6.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Review the response to your <code>DELETE Distribution</code> request to confirm that the distribution was
     *        successfully deleted.
     *        </p>
     *        </li>
     *        </ol>
     *        <p>
     *        For information about deleting a distribution using the CloudFront console, see <a
     *        href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html"
     *        >Deleting a Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * @return A Java Future containing the result of the DeleteDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li> <li>DistributionNotDisabledException The specified
     *         CloudFront distribution is not disabled. You must disable the distribution before you can delete it.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li> <li>
     *         NoSuchDistributionException The specified distribution does not exist.</li> <li>
     *         PreconditionFailedException The precondition in one or more of the request fields evaluated to <code>
     *         false</code>.</li> <li>SdkException Base class for all exceptions that can be thrown by the SDK (both
     *         service and client). Can be used for catch all scenarios.</li> <li>SdkClientException If any client side
     *         error occurs such as an IO related failure, failure to get credentials, etc.</li> <li>CloudFrontException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     *         </li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDistributionResponse> deleteDistribution(DeleteDistributionRequest deleteDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDistribution");

            HttpResponseHandler<Response<DeleteDistributionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteDistributionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDistributionRequest, DeleteDistributionResponse>()
                            .withOperationName("DeleteDistribution")
                            .withMarshaller(new DeleteDistributionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteDistributionRequest));
            CompletableFuture<DeleteDistributionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove a field-level encryption configuration.
     * </p>
     *
     * @param deleteFieldLevelEncryptionConfigRequest
     * @return A Java Future containing the result of the DeleteFieldLevelEncryptionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>FieldLevelEncryptionConfigInUseException The specified configuration for field-level encryption is in
     *         use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFieldLevelEncryptionConfigResponse> deleteFieldLevelEncryptionConfig(
            DeleteFieldLevelEncryptionConfigRequest deleteFieldLevelEncryptionConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFieldLevelEncryptionConfig");

            HttpResponseHandler<Response<DeleteFieldLevelEncryptionConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteFieldLevelEncryptionConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteFieldLevelEncryptionConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFieldLevelEncryptionConfigRequest, DeleteFieldLevelEncryptionConfigResponse>()
                            .withOperationName("DeleteFieldLevelEncryptionConfig")
                            .withMarshaller(new DeleteFieldLevelEncryptionConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFieldLevelEncryptionConfigRequest));
            CompletableFuture<DeleteFieldLevelEncryptionConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove a field-level encryption profile.
     * </p>
     *
     * @param deleteFieldLevelEncryptionProfileRequest
     * @return A Java Future containing the result of the DeleteFieldLevelEncryptionProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>FieldLevelEncryptionProfileInUseException The specified profile for field-level encryption is in use.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFieldLevelEncryptionProfileResponse> deleteFieldLevelEncryptionProfile(
            DeleteFieldLevelEncryptionProfileRequest deleteFieldLevelEncryptionProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFieldLevelEncryptionProfile");

            HttpResponseHandler<Response<DeleteFieldLevelEncryptionProfileResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteFieldLevelEncryptionProfileResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteFieldLevelEncryptionProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFieldLevelEncryptionProfileRequest, DeleteFieldLevelEncryptionProfileResponse>()
                            .withOperationName("DeleteFieldLevelEncryptionProfile")
                            .withMarshaller(new DeleteFieldLevelEncryptionProfileRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFieldLevelEncryptionProfileRequest));
            CompletableFuture<DeleteFieldLevelEncryptionProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a CloudFront function.
     * </p>
     * <p>
     * You cannot delete a function if it’s associated with a cache behavior. First, update your distributions to remove
     * the function association from all cache behaviors, then delete the function.
     * </p>
     * <p>
     * To delete a function, you must provide the function’s name and version (<code>ETag</code> value). To get these
     * values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return A Java Future containing the result of the DeleteFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>FunctionInUseException Cannot delete the function because it’s attached to one or more cache
     *         behaviors.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFunctionResponse> deleteFunction(DeleteFunctionRequest deleteFunctionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFunction");

            HttpResponseHandler<Response<DeleteFunctionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteFunctionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteFunctionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFunctionRequest, DeleteFunctionResponse>()
                            .withOperationName("DeleteFunction")
                            .withMarshaller(new DeleteFunctionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteFunctionRequest));
            CompletableFuture<DeleteFunctionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a key group.
     * </p>
     * <p>
     * You cannot delete a key group that is referenced in a cache behavior. First update your distributions to remove
     * the key group from all cache behaviors, then delete the key group.
     * </p>
     * <p>
     * To delete a key group, you must provide the key group’s identifier and version. To get these values, use
     * <code>ListKeyGroups</code> followed by <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.
     * </p>
     *
     * @param deleteKeyGroupRequest
     * @return A Java Future containing the result of the DeleteKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>ResourceInUseException Cannot delete this resource because it is in use.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteKeyGroupResponse> deleteKeyGroup(DeleteKeyGroupRequest deleteKeyGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteKeyGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteKeyGroup");

            HttpResponseHandler<Response<DeleteKeyGroupResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteKeyGroupResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteKeyGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteKeyGroupRequest, DeleteKeyGroupResponse>()
                            .withOperationName("DeleteKeyGroup")
                            .withMarshaller(new DeleteKeyGroupRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteKeyGroupRequest));
            CompletableFuture<DeleteKeyGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disables additional CloudWatch metrics for the specified CloudFront distribution.
     * </p>
     *
     * @param deleteMonitoringSubscriptionRequest
     * @return A Java Future containing the result of the DeleteMonitoringSubscription operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>NoSuchMonitoringSubscriptionException A monitoring subscription does not exist for the specified
     *         distribution.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteMonitoringSubscriptionResponse> deleteMonitoringSubscription(
            DeleteMonitoringSubscriptionRequest deleteMonitoringSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMonitoringSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMonitoringSubscription");

            HttpResponseHandler<Response<DeleteMonitoringSubscriptionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteMonitoringSubscriptionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteMonitoringSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteMonitoringSubscriptionRequest, DeleteMonitoringSubscriptionResponse>()
                            .withOperationName("DeleteMonitoringSubscription")
                            .withMarshaller(new DeleteMonitoringSubscriptionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteMonitoringSubscriptionRequest));
            CompletableFuture<DeleteMonitoringSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a CloudFront origin access control.
     * </p>
     * <p>
     * You cannot delete an origin access control if it's in use. First, update all distributions to remove the origin
     * access control from all origins, then delete the origin access control.
     * </p>
     *
     * @param deleteOriginAccessControlRequest
     * @return A Java Future containing the result of the DeleteOriginAccessControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchOriginAccessControlException The origin access control does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>OriginAccessControlInUseException Cannot delete the origin access control because it's in use by one
     *         or more distributions.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOriginAccessControlResponse> deleteOriginAccessControl(
            DeleteOriginAccessControlRequest deleteOriginAccessControlRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOriginAccessControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOriginAccessControl");

            HttpResponseHandler<Response<DeleteOriginAccessControlResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteOriginAccessControlResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteOriginAccessControlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOriginAccessControlRequest, DeleteOriginAccessControlResponse>()
                            .withOperationName("DeleteOriginAccessControl")
                            .withMarshaller(new DeleteOriginAccessControlRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOriginAccessControlRequest));
            CompletableFuture<DeleteOriginAccessControlResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an origin request policy.
     * </p>
     * <p>
     * You cannot delete an origin request policy if it’s attached to any cache behaviors. First update your
     * distributions to remove the origin request policy from all cache behaviors, then delete the origin request
     * policy.
     * </p>
     * <p>
     * To delete an origin request policy, you must provide the policy’s identifier and version. To get the identifier,
     * you can use <code>ListOriginRequestPolicies</code> or <code>GetOriginRequestPolicy</code>.
     * </p>
     *
     * @param deleteOriginRequestPolicyRequest
     * @return A Java Future containing the result of the DeleteOriginRequestPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>IllegalDeleteException You cannot delete a managed policy.</li>
     *         <li>OriginRequestPolicyInUseException Cannot delete the origin request policy because it is attached to
     *         one or more cache behaviors.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteOriginRequestPolicyResponse> deleteOriginRequestPolicy(
            DeleteOriginRequestPolicyRequest deleteOriginRequestPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOriginRequestPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOriginRequestPolicy");

            HttpResponseHandler<Response<DeleteOriginRequestPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteOriginRequestPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteOriginRequestPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteOriginRequestPolicyRequest, DeleteOriginRequestPolicyResponse>()
                            .withOperationName("DeleteOriginRequestPolicy")
                            .withMarshaller(new DeleteOriginRequestPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteOriginRequestPolicyRequest));
            CompletableFuture<DeleteOriginRequestPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove a public key you previously added to CloudFront.
     * </p>
     *
     * @param deletePublicKeyRequest
     * @return A Java Future containing the result of the DeletePublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>PublicKeyInUseException The specified public key is in use.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeletePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeletePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePublicKeyResponse> deletePublicKey(DeletePublicKeyRequest deletePublicKeyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePublicKey");

            HttpResponseHandler<Response<DeletePublicKeyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeletePublicKeyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeletePublicKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePublicKeyRequest, DeletePublicKeyResponse>()
                            .withOperationName("DeletePublicKey")
                            .withMarshaller(new DeletePublicKeyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deletePublicKeyRequest));
            CompletableFuture<DeletePublicKeyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a real-time log configuration.
     * </p>
     * <p>
     * You cannot delete a real-time log configuration if it’s attached to a cache behavior. First update your
     * distributions to remove the real-time log configuration from all cache behaviors, then delete the real-time log
     * configuration.
     * </p>
     * <p>
     * To delete a real-time log configuration, you can provide the configuration’s name or its Amazon Resource Name
     * (ARN). You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log
     * configuration to delete.
     * </p>
     *
     * @param deleteRealtimeLogConfigRequest
     * @return A Java Future containing the result of the DeleteRealtimeLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigInUseException Cannot delete the real-time log configuration because it is attached
     *         to one or more cache behaviors.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRealtimeLogConfigResponse> deleteRealtimeLogConfig(
            DeleteRealtimeLogConfigRequest deleteRealtimeLogConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRealtimeLogConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRealtimeLogConfig");

            HttpResponseHandler<Response<DeleteRealtimeLogConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteRealtimeLogConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteRealtimeLogConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRealtimeLogConfigRequest, DeleteRealtimeLogConfigResponse>()
                            .withOperationName("DeleteRealtimeLogConfig")
                            .withMarshaller(new DeleteRealtimeLogConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteRealtimeLogConfigRequest));
            CompletableFuture<DeleteRealtimeLogConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a response headers policy.
     * </p>
     * <p>
     * You cannot delete a response headers policy if it’s attached to a cache behavior. First update your distributions
     * to remove the response headers policy from all cache behaviors, then delete the response headers policy.
     * </p>
     * <p>
     * To delete a response headers policy, you must provide the policy’s identifier and version. To get these values,
     * you can use <code>ListResponseHeadersPolicies</code> or <code>GetResponseHeadersPolicy</code>.
     * </p>
     *
     * @param deleteResponseHeadersPolicyRequest
     * @return A Java Future containing the result of the DeleteResponseHeadersPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchResponseHeadersPolicyException The response headers policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>IllegalDeleteException You cannot delete a managed policy.</li>
     *         <li>ResponseHeadersPolicyInUseException Cannot delete the response headers policy because it is attached
     *         to one or more cache behaviors in a CloudFront distribution.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteResponseHeadersPolicyResponse> deleteResponseHeadersPolicy(
            DeleteResponseHeadersPolicyRequest deleteResponseHeadersPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResponseHeadersPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResponseHeadersPolicy");

            HttpResponseHandler<Response<DeleteResponseHeadersPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteResponseHeadersPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteResponseHeadersPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteResponseHeadersPolicyRequest, DeleteResponseHeadersPolicyResponse>()
                            .withOperationName("DeleteResponseHeadersPolicy")
                            .withMarshaller(new DeleteResponseHeadersPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteResponseHeadersPolicyRequest));
            CompletableFuture<DeleteResponseHeadersPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Delete a streaming distribution. To delete an RTMP distribution using the CloudFront API, perform the following
     * steps.
     * </p>
     * <p>
     * <b>To delete an RTMP distribution using the CloudFront API</b>:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Disable the RTMP distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to get the current configuration and the
     * <code>Etag</code> header for the distribution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the XML document that was returned in the response to your <code>GET Streaming Distribution Config</code>
     * request to change the value of <code>Enabled</code> to <code>false</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>PUT Streaming Distribution Config</code> request to update the configuration for your
     * distribution. In the request body, include the XML document that you updated in Step 3. Then set the value of the
     * HTTP <code>If-Match</code> header to the value of the <code>ETag</code> header that CloudFront returned when you
     * submitted the <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to the <code>PUT Streaming Distribution Config</code> request to confirm that the
     * distribution was successfully disabled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>GET Streaming Distribution Config</code> request to confirm that your changes have propagated.
     * When propagation is complete, the value of <code>Status</code> is <code>Deployed</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Submit a <code>DELETE Streaming Distribution</code> request. Set the value of the HTTP <code>If-Match</code>
     * header to the value of the <code>ETag</code> header that CloudFront returned when you submitted the
     * <code>GET Streaming Distribution Config</code> request in Step 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * Review the response to your <code>DELETE Streaming Distribution</code> request to confirm that the distribution
     * was successfully deleted.
     * </p>
     * </li>
     * </ol>
     * <p>
     * For information about deleting a distribution using the CloudFront console, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html">Deleting a
     * Distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     *
     * @param deleteStreamingDistributionRequest
     *        The request to delete a streaming distribution.
     * @return A Java Future containing the result of the DeleteStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>StreamingDistributionNotDisabledException The specified CloudFront distribution is not disabled. You
     *         must disable the distribution before you can delete it.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DeleteStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DeleteStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteStreamingDistributionResponse> deleteStreamingDistribution(
            DeleteStreamingDistributionRequest deleteStreamingDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteStreamingDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteStreamingDistribution");

            HttpResponseHandler<Response<DeleteStreamingDistributionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DeleteStreamingDistributionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DeleteStreamingDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteStreamingDistributionRequest, DeleteStreamingDistributionResponse>()
                            .withOperationName("DeleteStreamingDistribution")
                            .withMarshaller(new DeleteStreamingDistributionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(deleteStreamingDistributionRequest));
            CompletableFuture<DeleteStreamingDistributionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets configuration information and metadata about a CloudFront function, but not the function’s code. To get a
     * function’s code, use <code>GetFunction</code>.
     * </p>
     * <p>
     * To get configuration information and metadata about a function, you must provide the function’s name and stage.
     * To get these values, you can use <code>ListFunctions</code>.
     * </p>
     *
     * @param describeFunctionRequest
     * @return A Java Future containing the result of the DescribeFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.DescribeFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/DescribeFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFunctionResponse> describeFunction(DescribeFunctionRequest describeFunctionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFunction");

            HttpResponseHandler<Response<DescribeFunctionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(DescribeFunctionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<DescribeFunctionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFunctionRequest, DescribeFunctionResponse>()
                            .withOperationName("DescribeFunction")
                            .withMarshaller(new DescribeFunctionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(describeFunctionRequest));
            CompletableFuture<DescribeFunctionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a cache policy, including the following metadata:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The policy’s identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The date and time when the policy was last modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get a cache policy, you must provide the policy’s identifier. If the cache policy is attached to a
     * distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier
     * using <code>ListCachePolicies</code>.
     * </p>
     *
     * @param getCachePolicyRequest
     * @return A Java Future containing the result of the GetCachePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCachePolicyResponse> getCachePolicy(GetCachePolicyRequest getCachePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCachePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCachePolicy");

            HttpResponseHandler<Response<GetCachePolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetCachePolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetCachePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCachePolicyRequest, GetCachePolicyResponse>()
                            .withOperationName("GetCachePolicy")
                            .withMarshaller(new GetCachePolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCachePolicyRequest));
            CompletableFuture<GetCachePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a cache policy configuration.
     * </p>
     * <p>
     * To get a cache policy configuration, you must provide the policy’s identifier. If the cache policy is attached to
     * a distribution’s cache behavior, you can get the policy’s identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the cache policy is not attached to a cache behavior, you can get the identifier
     * using <code>ListCachePolicies</code>.
     * </p>
     *
     * @param getCachePolicyConfigRequest
     * @return A Java Future containing the result of the GetCachePolicyConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCachePolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCachePolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCachePolicyConfigResponse> getCachePolicyConfig(
            GetCachePolicyConfigRequest getCachePolicyConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCachePolicyConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCachePolicyConfig");

            HttpResponseHandler<Response<GetCachePolicyConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetCachePolicyConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetCachePolicyConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCachePolicyConfigRequest, GetCachePolicyConfigResponse>()
                            .withOperationName("GetCachePolicyConfig")
                            .withMarshaller(new GetCachePolicyConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCachePolicyConfigRequest));
            CompletableFuture<GetCachePolicyConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityRequest
     *        The request to get an origin access identity's information.
     * @return A Java Future containing the result of the GetCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCloudFrontOriginAccessIdentityResponse> getCloudFrontOriginAccessIdentity(
            GetCloudFrontOriginAccessIdentityRequest getCloudFrontOriginAccessIdentityRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudFrontOriginAccessIdentity");

            HttpResponseHandler<Response<GetCloudFrontOriginAccessIdentityResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetCloudFrontOriginAccessIdentityResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetCloudFrontOriginAccessIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCloudFrontOriginAccessIdentityRequest, GetCloudFrontOriginAccessIdentityResponse>()
                            .withOperationName("GetCloudFrontOriginAccessIdentity")
                            .withMarshaller(new GetCloudFrontOriginAccessIdentityRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCloudFrontOriginAccessIdentityRequest));
            CompletableFuture<GetCloudFrontOriginAccessIdentityResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the configuration information about an origin access identity.
     * </p>
     *
     * @param getCloudFrontOriginAccessIdentityConfigRequest
     *        The origin access identity's configuration information. For more information, see <a href=
     *        "https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_CloudFrontOriginAccessIdentityConfig.html"
     *        >CloudFrontOriginAccessIdentityConfig</a>.
     * @return A Java Future containing the result of the GetCloudFrontOriginAccessIdentityConfig operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetCloudFrontOriginAccessIdentityConfig
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetCloudFrontOriginAccessIdentityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCloudFrontOriginAccessIdentityConfigResponse> getCloudFrontOriginAccessIdentityConfig(
            GetCloudFrontOriginAccessIdentityConfigRequest getCloudFrontOriginAccessIdentityConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getCloudFrontOriginAccessIdentityConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCloudFrontOriginAccessIdentityConfig");

            HttpResponseHandler<Response<GetCloudFrontOriginAccessIdentityConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetCloudFrontOriginAccessIdentityConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetCloudFrontOriginAccessIdentityConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCloudFrontOriginAccessIdentityConfigRequest, GetCloudFrontOriginAccessIdentityConfigResponse>()
                            .withOperationName("GetCloudFrontOriginAccessIdentityConfig")
                            .withMarshaller(new GetCloudFrontOriginAccessIdentityConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCloudFrontOriginAccessIdentityConfigRequest));
            CompletableFuture<GetCloudFrontOriginAccessIdentityConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a continuous deployment policy, including metadata (the policy’s identifier and the date and time when the
     * policy was last modified).
     * </p>
     *
     * @param getContinuousDeploymentPolicyRequest
     * @return A Java Future containing the result of the GetContinuousDeploymentPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchContinuousDeploymentPolicyException The continuous deployment policy doesn’t exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContinuousDeploymentPolicyResponse> getContinuousDeploymentPolicy(
            GetContinuousDeploymentPolicyRequest getContinuousDeploymentPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getContinuousDeploymentPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContinuousDeploymentPolicy");

            HttpResponseHandler<Response<GetContinuousDeploymentPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetContinuousDeploymentPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetContinuousDeploymentPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContinuousDeploymentPolicyRequest, GetContinuousDeploymentPolicyResponse>()
                            .withOperationName("GetContinuousDeploymentPolicy")
                            .withMarshaller(new GetContinuousDeploymentPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getContinuousDeploymentPolicyRequest));
            CompletableFuture<GetContinuousDeploymentPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets configuration information about a continuous deployment policy.
     * </p>
     *
     * @param getContinuousDeploymentPolicyConfigRequest
     * @return A Java Future containing the result of the GetContinuousDeploymentPolicyConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchContinuousDeploymentPolicyException The continuous deployment policy doesn’t exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetContinuousDeploymentPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetContinuousDeploymentPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetContinuousDeploymentPolicyConfigResponse> getContinuousDeploymentPolicyConfig(
            GetContinuousDeploymentPolicyConfigRequest getContinuousDeploymentPolicyConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getContinuousDeploymentPolicyConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContinuousDeploymentPolicyConfig");

            HttpResponseHandler<Response<GetContinuousDeploymentPolicyConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetContinuousDeploymentPolicyConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetContinuousDeploymentPolicyConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetContinuousDeploymentPolicyConfigRequest, GetContinuousDeploymentPolicyConfigResponse>()
                            .withOperationName("GetContinuousDeploymentPolicyConfig")
                            .withMarshaller(new GetContinuousDeploymentPolicyConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getContinuousDeploymentPolicyConfigRequest));
            CompletableFuture<GetContinuousDeploymentPolicyConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the information about a distribution.
     * </p>
     *
     * @param getDistributionRequest
     *        The request to get a distribution's information.
     * @return A Java Future containing the result of the GetDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDistributionResponse> getDistribution(GetDistributionRequest getDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDistribution");

            HttpResponseHandler<Response<GetDistributionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetDistributionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDistributionRequest, GetDistributionResponse>()
                            .withOperationName("GetDistribution")
                            .withMarshaller(new GetDistributionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDistributionRequest));
            CompletableFuture<GetDistributionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the configuration information about a distribution.
     * </p>
     *
     * @param getDistributionConfigRequest
     *        The request to get a distribution configuration.
     * @return A Java Future containing the result of the GetDistributionConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetDistributionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDistributionConfigResponse> getDistributionConfig(
            GetDistributionConfigRequest getDistributionConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDistributionConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDistributionConfig");

            HttpResponseHandler<Response<GetDistributionConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetDistributionConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetDistributionConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDistributionConfigRequest, GetDistributionConfigResponse>()
                            .withOperationName("GetDistributionConfig")
                            .withMarshaller(new GetDistributionConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getDistributionConfigRequest));
            CompletableFuture<GetDistributionConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionRequest
     * @return A Java Future containing the result of the GetFieldLevelEncryption operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFieldLevelEncryption
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryption"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFieldLevelEncryptionResponse> getFieldLevelEncryption(
            GetFieldLevelEncryptionRequest getFieldLevelEncryptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFieldLevelEncryptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFieldLevelEncryption");

            HttpResponseHandler<Response<GetFieldLevelEncryptionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetFieldLevelEncryptionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetFieldLevelEncryptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFieldLevelEncryptionRequest, GetFieldLevelEncryptionResponse>()
                            .withOperationName("GetFieldLevelEncryption")
                            .withMarshaller(new GetFieldLevelEncryptionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFieldLevelEncryptionRequest));
            CompletableFuture<GetFieldLevelEncryptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the field-level encryption configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionConfigRequest
     * @return A Java Future containing the result of the GetFieldLevelEncryptionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFieldLevelEncryptionConfigResponse> getFieldLevelEncryptionConfig(
            GetFieldLevelEncryptionConfigRequest getFieldLevelEncryptionConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFieldLevelEncryptionConfig");

            HttpResponseHandler<Response<GetFieldLevelEncryptionConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetFieldLevelEncryptionConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetFieldLevelEncryptionConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFieldLevelEncryptionConfigRequest, GetFieldLevelEncryptionConfigResponse>()
                            .withOperationName("GetFieldLevelEncryptionConfig")
                            .withMarshaller(new GetFieldLevelEncryptionConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFieldLevelEncryptionConfigRequest));
            CompletableFuture<GetFieldLevelEncryptionConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the field-level encryption profile information.
     * </p>
     *
     * @param getFieldLevelEncryptionProfileRequest
     * @return A Java Future containing the result of the GetFieldLevelEncryptionProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFieldLevelEncryptionProfileResponse> getFieldLevelEncryptionProfile(
            GetFieldLevelEncryptionProfileRequest getFieldLevelEncryptionProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFieldLevelEncryptionProfile");

            HttpResponseHandler<Response<GetFieldLevelEncryptionProfileResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetFieldLevelEncryptionProfileResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetFieldLevelEncryptionProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFieldLevelEncryptionProfileRequest, GetFieldLevelEncryptionProfileResponse>()
                            .withOperationName("GetFieldLevelEncryptionProfile")
                            .withMarshaller(new GetFieldLevelEncryptionProfileRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFieldLevelEncryptionProfileRequest));
            CompletableFuture<GetFieldLevelEncryptionProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the field-level encryption profile configuration information.
     * </p>
     *
     * @param getFieldLevelEncryptionProfileConfigRequest
     * @return A Java Future containing the result of the GetFieldLevelEncryptionProfileConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFieldLevelEncryptionProfileConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFieldLevelEncryptionProfileConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFieldLevelEncryptionProfileConfigResponse> getFieldLevelEncryptionProfileConfig(
            GetFieldLevelEncryptionProfileConfigRequest getFieldLevelEncryptionProfileConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getFieldLevelEncryptionProfileConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFieldLevelEncryptionProfileConfig");

            HttpResponseHandler<Response<GetFieldLevelEncryptionProfileConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetFieldLevelEncryptionProfileConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetFieldLevelEncryptionProfileConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFieldLevelEncryptionProfileConfigRequest, GetFieldLevelEncryptionProfileConfigResponse>()
                            .withOperationName("GetFieldLevelEncryptionProfileConfig")
                            .withMarshaller(new GetFieldLevelEncryptionProfileConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFieldLevelEncryptionProfileConfigRequest));
            CompletableFuture<GetFieldLevelEncryptionProfileConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the code of a CloudFront function. To get configuration information and metadata about a function, use
     * <code>DescribeFunction</code>.
     * </p>
     * <p>
     * To get a function’s code, you must provide the function’s name and stage. To get these values, you can use
     * <code>ListFunctions</code>.
     * </p>
     *
     * @param getFunctionRequest
     * @return A Java Future containing the result of the GetFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetFunctionResponse> getFunction(GetFunctionRequest getFunctionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFunction");

            HttpResponseHandler<Response<GetFunctionResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    GetFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetFunctionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFunctionRequest, GetFunctionResponse>()
                            .withOperationName("GetFunction").withMarshaller(new GetFunctionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getFunctionRequest));
            CompletableFuture<GetFunctionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the information about an invalidation.
     * </p>
     *
     * @param getInvalidationRequest
     *        The request to get an invalidation's information.
     * @return A Java Future containing the result of the GetInvalidation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchInvalidationException The specified invalidation does not exist.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetInvalidation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetInvalidation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetInvalidationResponse> getInvalidation(GetInvalidationRequest getInvalidationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInvalidationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInvalidation");

            HttpResponseHandler<Response<GetInvalidationResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetInvalidationResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetInvalidationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetInvalidationRequest, GetInvalidationResponse>()
                            .withOperationName("GetInvalidation")
                            .withMarshaller(new GetInvalidationRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getInvalidationRequest));
            CompletableFuture<GetInvalidationResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a key group, including the date and time when the key group was last modified.
     * </p>
     * <p>
     * To get a key group, you must provide the key group’s identifier. If the key group is referenced in a
     * distribution’s cache behavior, you can get the key group’s identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier
     * using <code>ListKeyGroups</code>.
     * </p>
     *
     * @param getKeyGroupRequest
     * @return A Java Future containing the result of the GetKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetKeyGroupResponse> getKeyGroup(GetKeyGroupRequest getKeyGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getKeyGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetKeyGroup");

            HttpResponseHandler<Response<GetKeyGroupResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    GetKeyGroupResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetKeyGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetKeyGroupRequest, GetKeyGroupResponse>()
                            .withOperationName("GetKeyGroup").withMarshaller(new GetKeyGroupRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getKeyGroupRequest));
            CompletableFuture<GetKeyGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a key group configuration.
     * </p>
     * <p>
     * To get a key group configuration, you must provide the key group’s identifier. If the key group is referenced in
     * a distribution’s cache behavior, you can get the key group’s identifier using <code>ListDistributions</code> or
     * <code>GetDistribution</code>. If the key group is not referenced in a cache behavior, you can get the identifier
     * using <code>ListKeyGroups</code>.
     * </p>
     *
     * @param getKeyGroupConfigRequest
     * @return A Java Future containing the result of the GetKeyGroupConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetKeyGroupConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetKeyGroupConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetKeyGroupConfigResponse> getKeyGroupConfig(GetKeyGroupConfigRequest getKeyGroupConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getKeyGroupConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetKeyGroupConfig");

            HttpResponseHandler<Response<GetKeyGroupConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetKeyGroupConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetKeyGroupConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetKeyGroupConfigRequest, GetKeyGroupConfigResponse>()
                            .withOperationName("GetKeyGroupConfig")
                            .withMarshaller(new GetKeyGroupConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getKeyGroupConfigRequest));
            CompletableFuture<GetKeyGroupConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about whether additional CloudWatch metrics are enabled for the specified CloudFront
     * distribution.
     * </p>
     *
     * @param getMonitoringSubscriptionRequest
     * @return A Java Future containing the result of the GetMonitoringSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>NoSuchMonitoringSubscriptionException A monitoring subscription does not exist for the specified
     *         distribution.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetMonitoringSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetMonitoringSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetMonitoringSubscriptionResponse> getMonitoringSubscription(
            GetMonitoringSubscriptionRequest getMonitoringSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMonitoringSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMonitoringSubscription");

            HttpResponseHandler<Response<GetMonitoringSubscriptionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetMonitoringSubscriptionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetMonitoringSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMonitoringSubscriptionRequest, GetMonitoringSubscriptionResponse>()
                            .withOperationName("GetMonitoringSubscription")
                            .withMarshaller(new GetMonitoringSubscriptionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMonitoringSubscriptionRequest));
            CompletableFuture<GetMonitoringSubscriptionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a CloudFront origin access control, including its unique identifier.
     * </p>
     *
     * @param getOriginAccessControlRequest
     * @return A Java Future containing the result of the GetOriginAccessControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOriginAccessControlException The origin access control does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOriginAccessControlResponse> getOriginAccessControl(
            GetOriginAccessControlRequest getOriginAccessControlRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOriginAccessControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOriginAccessControl");

            HttpResponseHandler<Response<GetOriginAccessControlResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetOriginAccessControlResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetOriginAccessControlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOriginAccessControlRequest, GetOriginAccessControlResponse>()
                            .withOperationName("GetOriginAccessControl")
                            .withMarshaller(new GetOriginAccessControlRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOriginAccessControlRequest));
            CompletableFuture<GetOriginAccessControlResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a CloudFront origin access control configuration.
     * </p>
     *
     * @param getOriginAccessControlConfigRequest
     * @return A Java Future containing the result of the GetOriginAccessControlConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOriginAccessControlException The origin access control does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetOriginAccessControlConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginAccessControlConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOriginAccessControlConfigResponse> getOriginAccessControlConfig(
            GetOriginAccessControlConfigRequest getOriginAccessControlConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOriginAccessControlConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOriginAccessControlConfig");

            HttpResponseHandler<Response<GetOriginAccessControlConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetOriginAccessControlConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetOriginAccessControlConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOriginAccessControlConfigRequest, GetOriginAccessControlConfigResponse>()
                            .withOperationName("GetOriginAccessControlConfig")
                            .withMarshaller(new GetOriginAccessControlConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOriginAccessControlConfigRequest));
            CompletableFuture<GetOriginAccessControlConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an origin request policy, including the following metadata:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The policy’s identifier.
     * </p>
     * </li>
     * <li>
     * <p>
     * The date and time when the policy was last modified.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get an origin request policy, you must provide the policy’s identifier. If the origin request policy is
     * attached to a distribution’s cache behavior, you can get the policy’s identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a
     * cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.
     * </p>
     *
     * @param getOriginRequestPolicyRequest
     * @return A Java Future containing the result of the GetOriginRequestPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOriginRequestPolicyResponse> getOriginRequestPolicy(
            GetOriginRequestPolicyRequest getOriginRequestPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOriginRequestPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOriginRequestPolicy");

            HttpResponseHandler<Response<GetOriginRequestPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetOriginRequestPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetOriginRequestPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOriginRequestPolicyRequest, GetOriginRequestPolicyResponse>()
                            .withOperationName("GetOriginRequestPolicy")
                            .withMarshaller(new GetOriginRequestPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOriginRequestPolicyRequest));
            CompletableFuture<GetOriginRequestPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets an origin request policy configuration.
     * </p>
     * <p>
     * To get an origin request policy configuration, you must provide the policy’s identifier. If the origin request
     * policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the origin request policy is not attached to a
     * cache behavior, you can get the identifier using <code>ListOriginRequestPolicies</code>.
     * </p>
     *
     * @param getOriginRequestPolicyConfigRequest
     * @return A Java Future containing the result of the GetOriginRequestPolicyConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetOriginRequestPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetOriginRequestPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetOriginRequestPolicyConfigResponse> getOriginRequestPolicyConfig(
            GetOriginRequestPolicyConfigRequest getOriginRequestPolicyConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOriginRequestPolicyConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOriginRequestPolicyConfig");

            HttpResponseHandler<Response<GetOriginRequestPolicyConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetOriginRequestPolicyConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetOriginRequestPolicyConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetOriginRequestPolicyConfigRequest, GetOriginRequestPolicyConfigResponse>()
                            .withOperationName("GetOriginRequestPolicyConfig")
                            .withMarshaller(new GetOriginRequestPolicyConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getOriginRequestPolicyConfigRequest));
            CompletableFuture<GetOriginRequestPolicyConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a public key.
     * </p>
     *
     * @param getPublicKeyRequest
     * @return A Java Future containing the result of the GetPublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetPublicKeyResponse> getPublicKey(GetPublicKeyRequest getPublicKeyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPublicKey");

            HttpResponseHandler<Response<GetPublicKeyResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    GetPublicKeyResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetPublicKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPublicKeyRequest, GetPublicKeyResponse>()
                            .withOperationName("GetPublicKey").withMarshaller(new GetPublicKeyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPublicKeyRequest));
            CompletableFuture<GetPublicKeyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a public key configuration.
     * </p>
     *
     * @param getPublicKeyConfigRequest
     * @return A Java Future containing the result of the GetPublicKeyConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetPublicKeyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetPublicKeyConfig" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPublicKeyConfigResponse> getPublicKeyConfig(GetPublicKeyConfigRequest getPublicKeyConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPublicKeyConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPublicKeyConfig");

            HttpResponseHandler<Response<GetPublicKeyConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetPublicKeyConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetPublicKeyConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPublicKeyConfigRequest, GetPublicKeyConfigResponse>()
                            .withOperationName("GetPublicKeyConfig")
                            .withMarshaller(new GetPublicKeyConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPublicKeyConfigRequest));
            CompletableFuture<GetPublicKeyConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a real-time log configuration.
     * </p>
     * <p>
     * To get a real-time log configuration, you can provide the configuration’s name or its Amazon Resource Name (ARN).
     * You must provide at least one. If you provide both, CloudFront uses the name to identify the real-time log
     * configuration to get.
     * </p>
     *
     * @param getRealtimeLogConfigRequest
     * @return A Java Future containing the result of the GetRealtimeLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetRealtimeLogConfigResponse> getRealtimeLogConfig(
            GetRealtimeLogConfigRequest getRealtimeLogConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRealtimeLogConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRealtimeLogConfig");

            HttpResponseHandler<Response<GetRealtimeLogConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetRealtimeLogConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetRealtimeLogConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRealtimeLogConfigRequest, GetRealtimeLogConfigResponse>()
                            .withOperationName("GetRealtimeLogConfig")
                            .withMarshaller(new GetRealtimeLogConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getRealtimeLogConfigRequest));
            CompletableFuture<GetRealtimeLogConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a response headers policy, including metadata (the policy’s identifier and the date and time when the policy
     * was last modified).
     * </p>
     * <p>
     * To get a response headers policy, you must provide the policy’s identifier. If the response headers policy is
     * attached to a distribution’s cache behavior, you can get the policy’s identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to
     * a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.
     * </p>
     *
     * @param getResponseHeadersPolicyRequest
     * @return A Java Future containing the result of the GetResponseHeadersPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchResponseHeadersPolicyException The response headers policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResponseHeadersPolicyResponse> getResponseHeadersPolicy(
            GetResponseHeadersPolicyRequest getResponseHeadersPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResponseHeadersPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResponseHeadersPolicy");

            HttpResponseHandler<Response<GetResponseHeadersPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetResponseHeadersPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetResponseHeadersPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResponseHeadersPolicyRequest, GetResponseHeadersPolicyResponse>()
                            .withOperationName("GetResponseHeadersPolicy")
                            .withMarshaller(new GetResponseHeadersPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResponseHeadersPolicyRequest));
            CompletableFuture<GetResponseHeadersPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a response headers policy configuration.
     * </p>
     * <p>
     * To get a response headers policy configuration, you must provide the policy’s identifier. If the response headers
     * policy is attached to a distribution’s cache behavior, you can get the policy’s identifier using
     * <code>ListDistributions</code> or <code>GetDistribution</code>. If the response headers policy is not attached to
     * a cache behavior, you can get the identifier using <code>ListResponseHeadersPolicies</code>.
     * </p>
     *
     * @param getResponseHeadersPolicyConfigRequest
     * @return A Java Future containing the result of the GetResponseHeadersPolicyConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchResponseHeadersPolicyException The response headers policy does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetResponseHeadersPolicyConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetResponseHeadersPolicyConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetResponseHeadersPolicyConfigResponse> getResponseHeadersPolicyConfig(
            GetResponseHeadersPolicyConfigRequest getResponseHeadersPolicyConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getResponseHeadersPolicyConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResponseHeadersPolicyConfig");

            HttpResponseHandler<Response<GetResponseHeadersPolicyConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetResponseHeadersPolicyConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetResponseHeadersPolicyConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetResponseHeadersPolicyConfigRequest, GetResponseHeadersPolicyConfigResponse>()
                            .withOperationName("GetResponseHeadersPolicyConfig")
                            .withMarshaller(new GetResponseHeadersPolicyConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getResponseHeadersPolicyConfigRequest));
            CompletableFuture<GetResponseHeadersPolicyConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a specified RTMP distribution, including the distribution configuration.
     * </p>
     *
     * @param getStreamingDistributionRequest
     *        The request to get a streaming distribution's information.
     * @return A Java Future containing the result of the GetStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetStreamingDistributionResponse> getStreamingDistribution(
            GetStreamingDistributionRequest getStreamingDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getStreamingDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStreamingDistribution");

            HttpResponseHandler<Response<GetStreamingDistributionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetStreamingDistributionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetStreamingDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStreamingDistributionRequest, GetStreamingDistributionResponse>()
                            .withOperationName("GetStreamingDistribution")
                            .withMarshaller(new GetStreamingDistributionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getStreamingDistributionRequest));
            CompletableFuture<GetStreamingDistributionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Get the configuration information about a streaming distribution.
     * </p>
     *
     * @param getStreamingDistributionConfigRequest
     *        To request to get a streaming distribution configuration.
     * @return A Java Future containing the result of the GetStreamingDistributionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.GetStreamingDistributionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/GetStreamingDistributionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetStreamingDistributionConfigResponse> getStreamingDistributionConfig(
            GetStreamingDistributionConfigRequest getStreamingDistributionConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getStreamingDistributionConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetStreamingDistributionConfig");

            HttpResponseHandler<Response<GetStreamingDistributionConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(GetStreamingDistributionConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<GetStreamingDistributionConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetStreamingDistributionConfigRequest, GetStreamingDistributionConfigResponse>()
                            .withOperationName("GetStreamingDistributionConfig")
                            .withMarshaller(new GetStreamingDistributionConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getStreamingDistributionConfigRequest));
            CompletableFuture<GetStreamingDistributionConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of cache policies.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listCachePoliciesRequest
     * @return A Java Future containing the result of the ListCachePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListCachePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCachePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCachePoliciesResponse> listCachePolicies(ListCachePoliciesRequest listCachePoliciesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCachePoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCachePolicies");

            HttpResponseHandler<Response<ListCachePoliciesResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListCachePoliciesResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListCachePoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCachePoliciesRequest, ListCachePoliciesResponse>()
                            .withOperationName("ListCachePolicies")
                            .withMarshaller(new ListCachePoliciesRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCachePoliciesRequest));
            CompletableFuture<ListCachePoliciesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists origin access identities.
     * </p>
     *
     * @param listCloudFrontOriginAccessIdentitiesRequest
     *        The request to list origin access identities.
     * @return A Java Future containing the result of the ListCloudFrontOriginAccessIdentities operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListCloudFrontOriginAccessIdentities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListCloudFrontOriginAccessIdentities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListCloudFrontOriginAccessIdentitiesResponse> listCloudFrontOriginAccessIdentities(
            ListCloudFrontOriginAccessIdentitiesRequest listCloudFrontOriginAccessIdentitiesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listCloudFrontOriginAccessIdentitiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCloudFrontOriginAccessIdentities");

            HttpResponseHandler<Response<ListCloudFrontOriginAccessIdentitiesResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListCloudFrontOriginAccessIdentitiesResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListCloudFrontOriginAccessIdentitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCloudFrontOriginAccessIdentitiesRequest, ListCloudFrontOriginAccessIdentitiesResponse>()
                            .withOperationName("ListCloudFrontOriginAccessIdentities")
                            .withMarshaller(new ListCloudFrontOriginAccessIdentitiesRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCloudFrontOriginAccessIdentitiesRequest));
            CompletableFuture<ListCloudFrontOriginAccessIdentitiesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of aliases (also called CNAMEs or alternate domain names) that conflict or overlap with the provided
     * alias, and the associated CloudFront distributions and Amazon Web Services accounts for each conflicting alias.
     * In the returned list, the distribution and account IDs are partially hidden, which allows you to identify the
     * distributions and accounts that you own, but helps to protect the information of ones that you don’t own.
     * </p>
     * <p>
     * Use this operation to find aliases that are in use in CloudFront that conflict or overlap with the provided
     * alias. For example, if you provide <code>www.example.com</code> as input, the returned list can include
     * <code>www.example.com</code> and the overlapping wildcard alternate domain name (<code>*.example.com</code>), if
     * they exist. If you provide <code>*.example.com</code> as input, the returned list can include
     * <code>*.example.com</code> and any alternate domain names covered by that wildcard (for example,
     * <code>www.example.com</code>, <code>test.example.com</code>, <code>dev.example.com</code>, and so on), if they
     * exist.
     * </p>
     * <p>
     * To list conflicting aliases, you provide the alias to search and the ID of a distribution in your account that
     * has an attached SSL/TLS certificate that includes the provided alias. For more information, including how to set
     * up the distribution and certificate, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/CNAMEs.html#alternate-domain-names-move"
     * >Moving an alternate domain name to a different distribution</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listConflictingAliasesRequest
     * @return A Java Future containing the result of the ListConflictingAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListConflictingAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListConflictingAliases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListConflictingAliasesResponse> listConflictingAliases(
            ListConflictingAliasesRequest listConflictingAliasesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listConflictingAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListConflictingAliases");

            HttpResponseHandler<Response<ListConflictingAliasesResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListConflictingAliasesResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListConflictingAliasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListConflictingAliasesRequest, ListConflictingAliasesResponse>()
                            .withOperationName("ListConflictingAliases")
                            .withMarshaller(new ListConflictingAliasesRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listConflictingAliasesRequest));
            CompletableFuture<ListConflictingAliasesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of the continuous deployment policies in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listContinuousDeploymentPoliciesRequest
     * @return A Java Future containing the result of the ListContinuousDeploymentPolicies operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchContinuousDeploymentPolicyException The continuous deployment policy doesn’t exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListContinuousDeploymentPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListContinuousDeploymentPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListContinuousDeploymentPoliciesResponse> listContinuousDeploymentPolicies(
            ListContinuousDeploymentPoliciesRequest listContinuousDeploymentPoliciesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listContinuousDeploymentPoliciesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListContinuousDeploymentPolicies");

            HttpResponseHandler<Response<ListContinuousDeploymentPoliciesResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListContinuousDeploymentPoliciesResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListContinuousDeploymentPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListContinuousDeploymentPoliciesRequest, ListContinuousDeploymentPoliciesResponse>()
                            .withOperationName("ListContinuousDeploymentPolicies")
                            .withMarshaller(new ListContinuousDeploymentPoliciesRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listContinuousDeploymentPoliciesRequest));
            CompletableFuture<ListContinuousDeploymentPoliciesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List CloudFront distributions.
     * </p>
     *
     * @param listDistributionsRequest
     *        The request to list your distributions.
     * @return A Java Future containing the result of the ListDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDistributionsResponse> listDistributions(ListDistributionsRequest listDistributionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDistributionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributions");

            HttpResponseHandler<Response<ListDistributionsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListDistributionsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListDistributionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsRequest, ListDistributionsResponse>()
                            .withOperationName("ListDistributions")
                            .withMarshaller(new ListDistributionsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDistributionsRequest));
            CompletableFuture<ListDistributionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified
     * cache policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByCachePolicyIdRequest
     * @return A Java Future containing the result of the ListDistributionsByCachePolicyId operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByCachePolicyId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByCachePolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDistributionsByCachePolicyIdResponse> listDistributionsByCachePolicyId(
            ListDistributionsByCachePolicyIdRequest listDistributionsByCachePolicyIdRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDistributionsByCachePolicyIdRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionsByCachePolicyId");

            HttpResponseHandler<Response<ListDistributionsByCachePolicyIdResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListDistributionsByCachePolicyIdResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListDistributionsByCachePolicyIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsByCachePolicyIdRequest, ListDistributionsByCachePolicyIdResponse>()
                            .withOperationName("ListDistributionsByCachePolicyId")
                            .withMarshaller(new ListDistributionsByCachePolicyIdRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDistributionsByCachePolicyIdRequest));
            CompletableFuture<ListDistributionsByCachePolicyIdResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that references the specified key
     * group.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByKeyGroupRequest
     * @return A Java Future containing the result of the ListDistributionsByKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByKeyGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDistributionsByKeyGroupResponse> listDistributionsByKeyGroup(
            ListDistributionsByKeyGroupRequest listDistributionsByKeyGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDistributionsByKeyGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionsByKeyGroup");

            HttpResponseHandler<Response<ListDistributionsByKeyGroupResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListDistributionsByKeyGroupResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListDistributionsByKeyGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsByKeyGroupRequest, ListDistributionsByKeyGroupResponse>()
                            .withOperationName("ListDistributionsByKeyGroup")
                            .withMarshaller(new ListDistributionsByKeyGroupRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDistributionsByKeyGroupRequest));
            CompletableFuture<ListDistributionsByKeyGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified
     * origin request policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByOriginRequestPolicyIdRequest
     * @return A Java Future containing the result of the ListDistributionsByOriginRequestPolicyId operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByOriginRequestPolicyId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByOriginRequestPolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDistributionsByOriginRequestPolicyIdResponse> listDistributionsByOriginRequestPolicyId(
            ListDistributionsByOriginRequestPolicyIdRequest listDistributionsByOriginRequestPolicyIdRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDistributionsByOriginRequestPolicyIdRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionsByOriginRequestPolicyId");

            HttpResponseHandler<Response<ListDistributionsByOriginRequestPolicyIdResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListDistributionsByOriginRequestPolicyIdResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListDistributionsByOriginRequestPolicyIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsByOriginRequestPolicyIdRequest, ListDistributionsByOriginRequestPolicyIdResponse>()
                            .withOperationName("ListDistributionsByOriginRequestPolicyId")
                            .withMarshaller(new ListDistributionsByOriginRequestPolicyIdRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDistributionsByOriginRequestPolicyIdRequest));
            CompletableFuture<ListDistributionsByOriginRequestPolicyIdResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of distributions that have a cache behavior that’s associated with the specified real-time log
     * configuration.
     * </p>
     * <p>
     * You can specify the real-time log configuration by its name or its Amazon Resource Name (ARN). You must provide
     * at least one. If you provide both, CloudFront uses the name to identify the real-time log configuration to list
     * distributions for.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByRealtimeLogConfigRequest
     * @return A Java Future containing the result of the ListDistributionsByRealtimeLogConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDistributionsByRealtimeLogConfigResponse> listDistributionsByRealtimeLogConfig(
            ListDistributionsByRealtimeLogConfigRequest listDistributionsByRealtimeLogConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDistributionsByRealtimeLogConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionsByRealtimeLogConfig");

            HttpResponseHandler<Response<ListDistributionsByRealtimeLogConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListDistributionsByRealtimeLogConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListDistributionsByRealtimeLogConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsByRealtimeLogConfigRequest, ListDistributionsByRealtimeLogConfigResponse>()
                            .withOperationName("ListDistributionsByRealtimeLogConfig")
                            .withMarshaller(new ListDistributionsByRealtimeLogConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDistributionsByRealtimeLogConfigRequest));
            CompletableFuture<ListDistributionsByRealtimeLogConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of distribution IDs for distributions that have a cache behavior that’s associated with the specified
     * response headers policy.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listDistributionsByResponseHeadersPolicyIdRequest
     * @return A Java Future containing the result of the ListDistributionsByResponseHeadersPolicyId operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchResponseHeadersPolicyException The response headers policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByResponseHeadersPolicyId
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByResponseHeadersPolicyId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDistributionsByResponseHeadersPolicyIdResponse> listDistributionsByResponseHeadersPolicyId(
            ListDistributionsByResponseHeadersPolicyIdRequest listDistributionsByResponseHeadersPolicyIdRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listDistributionsByResponseHeadersPolicyIdRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionsByResponseHeadersPolicyId");

            HttpResponseHandler<Response<ListDistributionsByResponseHeadersPolicyIdResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListDistributionsByResponseHeadersPolicyIdResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListDistributionsByResponseHeadersPolicyIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsByResponseHeadersPolicyIdRequest, ListDistributionsByResponseHeadersPolicyIdResponse>()
                            .withOperationName("ListDistributionsByResponseHeadersPolicyId")
                            .withMarshaller(new ListDistributionsByResponseHeadersPolicyIdRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDistributionsByResponseHeadersPolicyIdRequest));
            CompletableFuture<ListDistributionsByResponseHeadersPolicyIdResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List the distributions that are associated with a specified WAF web ACL.
     * </p>
     *
     * @param listDistributionsByWebAclIdRequest
     *        The request to list distributions that are associated with a specified WAF web ACL.
     * @return A Java Future containing the result of the ListDistributionsByWebACLId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListDistributionsByWebACLId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListDistributionsByWebACLId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDistributionsByWebAclIdResponse> listDistributionsByWebACLId(
            ListDistributionsByWebAclIdRequest listDistributionsByWebAclIdRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDistributionsByWebAclIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDistributionsByWebACLId");

            HttpResponseHandler<Response<ListDistributionsByWebAclIdResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListDistributionsByWebAclIdResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListDistributionsByWebAclIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDistributionsByWebAclIdRequest, ListDistributionsByWebAclIdResponse>()
                            .withOperationName("ListDistributionsByWebACLId")
                            .withMarshaller(new ListDistributionsByWebAclIdRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listDistributionsByWebAclIdRequest));
            CompletableFuture<ListDistributionsByWebAclIdResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all field-level encryption configurations that have been created in CloudFront for this account.
     * </p>
     *
     * @param listFieldLevelEncryptionConfigsRequest
     * @return A Java Future containing the result of the ListFieldLevelEncryptionConfigs operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListFieldLevelEncryptionConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFieldLevelEncryptionConfigsResponse> listFieldLevelEncryptionConfigs(
            ListFieldLevelEncryptionConfigsRequest listFieldLevelEncryptionConfigsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listFieldLevelEncryptionConfigsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFieldLevelEncryptionConfigs");

            HttpResponseHandler<Response<ListFieldLevelEncryptionConfigsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListFieldLevelEncryptionConfigsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListFieldLevelEncryptionConfigsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFieldLevelEncryptionConfigsRequest, ListFieldLevelEncryptionConfigsResponse>()
                            .withOperationName("ListFieldLevelEncryptionConfigs")
                            .withMarshaller(new ListFieldLevelEncryptionConfigsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFieldLevelEncryptionConfigsRequest));
            CompletableFuture<ListFieldLevelEncryptionConfigsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Request a list of field-level encryption profiles that have been created in CloudFront for this account.
     * </p>
     *
     * @param listFieldLevelEncryptionProfilesRequest
     * @return A Java Future containing the result of the ListFieldLevelEncryptionProfiles operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListFieldLevelEncryptionProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFieldLevelEncryptionProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFieldLevelEncryptionProfilesResponse> listFieldLevelEncryptionProfiles(
            ListFieldLevelEncryptionProfilesRequest listFieldLevelEncryptionProfilesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listFieldLevelEncryptionProfilesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFieldLevelEncryptionProfiles");

            HttpResponseHandler<Response<ListFieldLevelEncryptionProfilesResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListFieldLevelEncryptionProfilesResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListFieldLevelEncryptionProfilesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFieldLevelEncryptionProfilesRequest, ListFieldLevelEncryptionProfilesResponse>()
                            .withOperationName("ListFieldLevelEncryptionProfiles")
                            .withMarshaller(new ListFieldLevelEncryptionProfilesRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFieldLevelEncryptionProfilesRequest));
            CompletableFuture<ListFieldLevelEncryptionProfilesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of all CloudFront functions in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the functions that are in the specified stage, either
     * <code>DEVELOPMENT</code> or <code>LIVE</code>.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listFunctionsRequest
     * @return A Java Future containing the result of the ListFunctions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFunctionsResponse> listFunctions(ListFunctionsRequest listFunctionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFunctionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFunctions");

            HttpResponseHandler<Response<ListFunctionsResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    ListFunctionsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListFunctionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFunctionsRequest, ListFunctionsResponse>()
                            .withOperationName("ListFunctions")
                            .withMarshaller(new ListFunctionsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listFunctionsRequest));
            CompletableFuture<ListFunctionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists invalidation batches.
     * </p>
     *
     * @param listInvalidationsRequest
     *        The request to list invalidations.
     * @return A Java Future containing the result of the ListInvalidations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListInvalidations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListInvalidations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListInvalidationsResponse> listInvalidations(ListInvalidationsRequest listInvalidationsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInvalidationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInvalidations");

            HttpResponseHandler<Response<ListInvalidationsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListInvalidationsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListInvalidationsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListInvalidationsRequest, ListInvalidationsResponse>()
                            .withOperationName("ListInvalidations")
                            .withMarshaller(new ListInvalidationsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listInvalidationsRequest));
            CompletableFuture<ListInvalidationsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of key groups.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listKeyGroupsRequest
     * @return A Java Future containing the result of the ListKeyGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListKeyGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListKeyGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListKeyGroupsResponse> listKeyGroups(ListKeyGroupsRequest listKeyGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listKeyGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListKeyGroups");

            HttpResponseHandler<Response<ListKeyGroupsResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    ListKeyGroupsResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListKeyGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListKeyGroupsRequest, ListKeyGroupsResponse>()
                            .withOperationName("ListKeyGroups")
                            .withMarshaller(new ListKeyGroupsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listKeyGroupsRequest));
            CompletableFuture<ListKeyGroupsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the list of CloudFront origin access controls in this Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send another request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the next request.
     * </p>
     *
     * @param listOriginAccessControlsRequest
     * @return A Java Future containing the result of the ListOriginAccessControls operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListOriginAccessControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginAccessControls"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOriginAccessControlsResponse> listOriginAccessControls(
            ListOriginAccessControlsRequest listOriginAccessControlsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOriginAccessControlsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOriginAccessControls");

            HttpResponseHandler<Response<ListOriginAccessControlsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListOriginAccessControlsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListOriginAccessControlsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOriginAccessControlsRequest, ListOriginAccessControlsResponse>()
                            .withOperationName("ListOriginAccessControls")
                            .withMarshaller(new ListOriginAccessControlsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOriginAccessControlsRequest));
            CompletableFuture<ListOriginAccessControlsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of origin request policies.
     * </p>
     * <p>
     * You can optionally apply a filter to return only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listOriginRequestPoliciesRequest
     * @return A Java Future containing the result of the ListOriginRequestPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListOriginRequestPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListOriginRequestPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListOriginRequestPoliciesResponse> listOriginRequestPolicies(
            ListOriginRequestPoliciesRequest listOriginRequestPoliciesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOriginRequestPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOriginRequestPolicies");

            HttpResponseHandler<Response<ListOriginRequestPoliciesResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListOriginRequestPoliciesResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListOriginRequestPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListOriginRequestPoliciesRequest, ListOriginRequestPoliciesResponse>()
                            .withOperationName("ListOriginRequestPolicies")
                            .withMarshaller(new ListOriginRequestPoliciesRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listOriginRequestPoliciesRequest));
            CompletableFuture<ListOriginRequestPoliciesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List all public keys that have been added to CloudFront for this account.
     * </p>
     *
     * @param listPublicKeysRequest
     * @return A Java Future containing the result of the ListPublicKeys operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListPublicKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListPublicKeysResponse> listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPublicKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPublicKeys");

            HttpResponseHandler<Response<ListPublicKeysResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListPublicKeysResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListPublicKeysResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPublicKeysRequest, ListPublicKeysResponse>()
                            .withOperationName("ListPublicKeys")
                            .withMarshaller(new ListPublicKeysRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listPublicKeysRequest));
            CompletableFuture<ListPublicKeysResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of real-time log configurations.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listRealtimeLogConfigsRequest
     * @return A Java Future containing the result of the ListRealtimeLogConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListRealtimeLogConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListRealtimeLogConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListRealtimeLogConfigsResponse> listRealtimeLogConfigs(
            ListRealtimeLogConfigsRequest listRealtimeLogConfigsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRealtimeLogConfigsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRealtimeLogConfigs");

            HttpResponseHandler<Response<ListRealtimeLogConfigsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListRealtimeLogConfigsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListRealtimeLogConfigsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRealtimeLogConfigsRequest, ListRealtimeLogConfigsResponse>()
                            .withOperationName("ListRealtimeLogConfigs")
                            .withMarshaller(new ListRealtimeLogConfigsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listRealtimeLogConfigsRequest));
            CompletableFuture<ListRealtimeLogConfigsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a list of response headers policies.
     * </p>
     * <p>
     * You can optionally apply a filter to get only the managed policies created by Amazon Web Services, or only the
     * custom policies created in your Amazon Web Services account.
     * </p>
     * <p>
     * You can optionally specify the maximum number of items to receive in the response. If the total number of items
     * in the list exceeds the maximum that you specify, or the default maximum, the response is paginated. To get the
     * next page of items, send a subsequent request that specifies the <code>NextMarker</code> value from the current
     * response as the <code>Marker</code> value in the subsequent request.
     * </p>
     *
     * @param listResponseHeadersPoliciesRequest
     * @return A Java Future containing the result of the ListResponseHeadersPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>NoSuchResponseHeadersPolicyException The response headers policy does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListResponseHeadersPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListResponseHeadersPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListResponseHeadersPoliciesResponse> listResponseHeadersPolicies(
            ListResponseHeadersPoliciesRequest listResponseHeadersPoliciesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResponseHeadersPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResponseHeadersPolicies");

            HttpResponseHandler<Response<ListResponseHeadersPoliciesResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListResponseHeadersPoliciesResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListResponseHeadersPoliciesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListResponseHeadersPoliciesRequest, ListResponseHeadersPoliciesResponse>()
                            .withOperationName("ListResponseHeadersPolicies")
                            .withMarshaller(new ListResponseHeadersPoliciesRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listResponseHeadersPoliciesRequest));
            CompletableFuture<ListResponseHeadersPoliciesResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List streaming distributions.
     * </p>
     *
     * @param listStreamingDistributionsRequest
     *        The request to list your streaming distributions.
     * @return A Java Future containing the result of the ListStreamingDistributions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListStreamingDistributions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListStreamingDistributions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListStreamingDistributionsResponse> listStreamingDistributions(
            ListStreamingDistributionsRequest listStreamingDistributionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listStreamingDistributionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListStreamingDistributions");

            HttpResponseHandler<Response<ListStreamingDistributionsResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListStreamingDistributionsResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListStreamingDistributionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListStreamingDistributionsRequest, ListStreamingDistributionsResponse>()
                            .withOperationName("ListStreamingDistributions")
                            .withMarshaller(new ListStreamingDistributionsRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listStreamingDistributionsRequest));
            CompletableFuture<ListStreamingDistributionsResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * List tags for a CloudFront resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        The request to list tags for a CloudFront resource.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            HttpResponseHandler<Response<ListTagsForResourceResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(ListTagsForResourceResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Publishes a CloudFront function by copying the function code from the <code>DEVELOPMENT</code> stage to
     * <code>LIVE</code>. This automatically updates all cache behaviors that are using this function to use the newly
     * published copy in the <code>LIVE</code> stage.
     * </p>
     * <p>
     * When a function is published to the <code>LIVE</code> stage, you can attach the function to a distribution’s
     * cache behavior, using the function’s Amazon Resource Name (ARN).
     * </p>
     * <p>
     * To publish a function, you must provide the function’s name and version (<code>ETag</code> value). To get these
     * values, you can use <code>ListFunctions</code> and <code>DescribeFunction</code>.
     * </p>
     *
     * @param publishFunctionRequest
     * @return A Java Future containing the result of the PublishFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.PublishFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/PublishFunction" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<PublishFunctionResponse> publishFunction(PublishFunctionRequest publishFunctionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, publishFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PublishFunction");

            HttpResponseHandler<Response<PublishFunctionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(PublishFunctionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<PublishFunctionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PublishFunctionRequest, PublishFunctionResponse>()
                            .withOperationName("PublishFunction")
                            .withMarshaller(new PublishFunctionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(publishFunctionRequest));
            CompletableFuture<PublishFunctionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Add tags to a CloudFront resource.
     * </p>
     *
     * @param tagResourceRequest
     *        The request to add tags to a CloudFront resource.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            HttpResponseHandler<Response<TagResourceResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    TagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tests a CloudFront function.
     * </p>
     * <p>
     * To test a function, you provide an <i>event object</i> that represents an HTTP request or response that your
     * CloudFront distribution could receive in production. CloudFront runs the function, passing it the event object
     * that you provided, and returns the function’s result (the modified event object) in the response. The response
     * also contains function logs and error messages, if any exist. For more information about testing functions, see
     * <a
     * href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/managing-functions.html#test-function"
     * >Testing functions</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * <p>
     * To test a function, you provide the function’s name and version (<code>ETag</code> value) along with the event
     * object. To get the function’s name and version, you can use <code>ListFunctions</code> and
     * <code>DescribeFunction</code>.
     * </p>
     *
     * @param testFunctionRequest
     * @return A Java Future containing the result of the TestFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>TestFunctionFailedException The CloudFront function failed.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.TestFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/TestFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TestFunctionResponse> testFunction(TestFunctionRequest testFunctionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, testFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TestFunction");

            HttpResponseHandler<Response<TestFunctionResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    TestFunctionResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<TestFunctionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TestFunctionRequest, TestFunctionResponse>()
                            .withOperationName("TestFunction").withMarshaller(new TestFunctionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(testFunctionRequest));
            CompletableFuture<TestFunctionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Remove tags from a CloudFront resource.
     * </p>
     *
     * @param untagResourceRequest
     *        The request to remove tags from a CloudFront resource.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidTaggingException The tagging specified is not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            HttpResponseHandler<Response<UntagResourceResponse>> responseHandler = protocolFactory.createCombinedResponseHandler(
                    UntagResourceResponse::builder, new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a cache policy configuration.
     * </p>
     * <p>
     * When you update a cache policy configuration, all the fields are updated with the values provided in the request.
     * You cannot update some fields independent of others. To update a cache policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetCachePolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the cache policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateCachePolicy</code> by providing the entire cache policy configuration, including the fields that
     * you modified and those that you didn’t.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateCachePolicyRequest
     * @return A Java Future containing the result of the UpdateCachePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>CachePolicyAlreadyExistsException A cache policy with this name already exists. You must provide a
     *         unique name. To modify an existing cache policy, use <code>UpdateCachePolicy</code>.</li>
     *         <li>TooManyHeadersInCachePolicyException The number of headers in the cache policy exceeds the maximum.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCookiesInCachePolicyException The number of cookies in the cache policy exceeds the maximum.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyQueryStringsInCachePolicyException The number of query strings in the cache policy exceeds the
     *         maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateCachePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCachePolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCachePolicyResponse> updateCachePolicy(UpdateCachePolicyRequest updateCachePolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCachePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCachePolicy");

            HttpResponseHandler<Response<UpdateCachePolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateCachePolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateCachePolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCachePolicyRequest, UpdateCachePolicyResponse>()
                            .withOperationName("UpdateCachePolicy")
                            .withMarshaller(new UpdateCachePolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCachePolicyRequest));
            CompletableFuture<UpdateCachePolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update an origin access identity.
     * </p>
     *
     * @param updateCloudFrontOriginAccessIdentityRequest
     *        The request to update an origin access identity.
     * @return A Java Future containing the result of the UpdateCloudFrontOriginAccessIdentity operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>NoSuchCloudFrontOriginAccessIdentityException The specified origin access identity does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateCloudFrontOriginAccessIdentity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateCloudFrontOriginAccessIdentity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCloudFrontOriginAccessIdentityResponse> updateCloudFrontOriginAccessIdentity(
            UpdateCloudFrontOriginAccessIdentityRequest updateCloudFrontOriginAccessIdentityRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateCloudFrontOriginAccessIdentityRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCloudFrontOriginAccessIdentity");

            HttpResponseHandler<Response<UpdateCloudFrontOriginAccessIdentityResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateCloudFrontOriginAccessIdentityResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateCloudFrontOriginAccessIdentityResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCloudFrontOriginAccessIdentityRequest, UpdateCloudFrontOriginAccessIdentityResponse>()
                            .withOperationName("UpdateCloudFrontOriginAccessIdentity")
                            .withMarshaller(new UpdateCloudFrontOriginAccessIdentityRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCloudFrontOriginAccessIdentityRequest));
            CompletableFuture<UpdateCloudFrontOriginAccessIdentityResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a continuous deployment policy. You can update a continuous deployment policy to enable or disable it, to
     * change the percentage of traffic that it sends to the staging distribution, or to change the staging distribution
     * that it sends traffic to.
     * </p>
     * <p>
     * When you update a continuous deployment policy configuration, all the fields are updated with the values that are
     * provided in the request. You cannot update some fields independent of others. To update a continuous deployment
     * policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetContinuousDeploymentPolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the continuous deployment policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>UpdateContinuousDeploymentPolicy</code>, providing the entire continuous deployment policy
     * configuration, including the fields that you modified and those that you didn’t.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateContinuousDeploymentPolicyRequest
     * @return A Java Future containing the result of the UpdateContinuousDeploymentPolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>StagingDistributionInUseException A continuous deployment policy for this staging distribution
     *         already exists.</li>
     *         <li>NoSuchContinuousDeploymentPolicyException The continuous deployment policy doesn’t exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateContinuousDeploymentPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateContinuousDeploymentPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateContinuousDeploymentPolicyResponse> updateContinuousDeploymentPolicy(
            UpdateContinuousDeploymentPolicyRequest updateContinuousDeploymentPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateContinuousDeploymentPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateContinuousDeploymentPolicy");

            HttpResponseHandler<Response<UpdateContinuousDeploymentPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateContinuousDeploymentPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateContinuousDeploymentPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateContinuousDeploymentPolicyRequest, UpdateContinuousDeploymentPolicyResponse>()
                            .withOperationName("UpdateContinuousDeploymentPolicy")
                            .withMarshaller(new UpdateContinuousDeploymentPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateContinuousDeploymentPolicyRequest));
            CompletableFuture<UpdateContinuousDeploymentPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the configuration for a CloudFront distribution.
     * </p>
     * <p>
     * The update process includes getting the current distribution configuration, updating it to make your changes, and
     * then submitting an <code>UpdateDistribution</code> request to make the updates.
     * </p>
     * <p>
     * <b>To update a web distribution using the CloudFront API</b>
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetDistributionConfig</code> to get the current configuration, including the version identifier (
     * <code>ETag</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * Update the distribution configuration that was returned in the response. Note the following important
     * requirements and restrictions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You must rename the <code>ETag</code> field to <code>IfMatch</code>, leaving the value unchanged. (Set the value
     * of <code>IfMatch</code> to the value of <code>ETag</code>, then remove the <code>ETag</code> field.)
     * </p>
     * </li>
     * <li>
     * <p>
     * You can’t change the value of <code>CallerReference</code>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Submit an <code>UpdateDistribution</code> request, providing the distribution configuration. The new
     * configuration replaces the existing configuration. The values that you specify in an
     * <code>UpdateDistribution</code> request are not merged into your existing configuration. Make sure to include all
     * fields: the ones that you modified and also the ones that you didn’t.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateDistributionRequest
     *        The request to update a distribution.
     * @return A Java Future containing the result of the UpdateDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException An invalid error code was specified.</li>
     *         <li>InvalidResponseCodeException A response code is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>InvalidOriginAccessControlException The origin access control is not valid.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InvalidViewerCertificateException A viewer certificate specified is not valid.</li>
     *         <li>InvalidMinimumProtocolVersionException The minimum protocol version specified is not valid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyOriginGroupsPerDistributionException Processing your request would cause you to exceed the
     *         maximum number of origin groups allowed.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException Your request contains too many headers in forwarded values.</li>
     *         <li>InvalidHeadersForS3OriginException The headers specified are not valid for an Amazon S3 origin.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException The location code specified is not valid.</li>
     *         <li>InvalidGeoRestrictionParameterException The specified geo restriction parameter is not valid.</li>
     *         <li>InvalidTtlOrderException The TTL order specified is not valid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>TooManyOriginCustomHeadersException Your request contains too many origin custom headers.</li>
     *         <li>TooManyQueryStringParametersException Your request contains too many query string parameters.</li>
     *         <li>InvalidQueryStringParametersException The query string parameters specified are not valid.</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda@Edge function associations per owner to be exceeded.</li>
     *         <li>TooManyDistributionsWithSingleFunctionArnException The maximum number of distributions have been
     *         associated with the specified Lambda@Edge function.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda@Edge function
     *         associations than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda@Edge function association is invalid.</li>
     *         <li>TooManyDistributionsWithFunctionAssociationsException You have reached the maximum number of
     *         distributions that are associated with a CloudFront function. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyFunctionAssociationsException You have reached the maximum number of CloudFront function
     *         associations for this distribution. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidFunctionAssociationException A CloudFront function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException The read timeout specified for the origin is not valid.</li>
     *         <li>InvalidOriginKeepaliveTimeoutException The keep alive timeout specified for the origin is not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException The specified configuration
     *         for field-level encryption can't be associated with the specified cache behavior.</li>
     *         <li>TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException The maximum number of
     *         distributions have been associated with the specified configuration for field-level encryption.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToCachePolicyException The maximum number of distributions have been
     *         associated with the specified cache policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchResponseHeadersPolicyException The response headers policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToResponseHeadersPolicyException The maximum number of distributions
     *         have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToOriginRequestPolicyException The maximum number of distributions have
     *         been associated with the specified origin request policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyDistributionsAssociatedToKeyGroupException The number of distributions that reference this key
     *         group is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyKeyGroupsAssociatedToDistributionException The number of key groups referenced by this
     *         distribution is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TrustedKeyGroupDoesNotExistException The specified key group does not exist.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigOwnerMismatchException The specified real-time log configuration belongs to a
     *         different Amazon Web Services account.</li>
     *         <li>ContinuousDeploymentPolicyInUseException You cannot delete a continuous deployment policy that is
     *         associated with a primary distribution.</li>
     *         <li>NoSuchContinuousDeploymentPolicyException The continuous deployment policy doesn’t exist.</li>
     *         <li>StagingDistributionInUseException A continuous deployment policy for this staging distribution
     *         already exists.</li>
     *         <li>IllegalOriginAccessConfigurationException An origin cannot contain both an origin access control
     *         (OAC) and an origin access identity (OAI).</li>
     *         <li>InvalidDomainNameForOriginAccessControlException An origin access control is associated with an
     *         origin whose domain name is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateDistribution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDistributionResponse> updateDistribution(UpdateDistributionRequest updateDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDistribution");

            HttpResponseHandler<Response<UpdateDistributionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateDistributionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDistributionRequest, UpdateDistributionResponse>()
                            .withOperationName("UpdateDistribution")
                            .withMarshaller(new UpdateDistributionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDistributionRequest));
            CompletableFuture<UpdateDistributionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Copies the staging distribution's configuration to its corresponding primary distribution. The primary
     * distribution retains its <code>Aliases</code> (also known as alternate domain names or CNAMEs) and
     * <code>ContinuousDeploymentPolicyId</code> value, but otherwise its configuration is overwritten to match the
     * staging distribution.
     * </p>
     * <p>
     * You can use this operation in a continuous deployment workflow after you have tested configuration changes on the
     * staging distribution. After using a continuous deployment policy to move a portion of your domain name’s traffic
     * to the staging distribution and verifying that it works as intended, you can use this operation to copy the
     * staging distribution’s configuration to the primary distribution. This action will disable the continuous
     * deployment policy and move your domain’s traffic back to the primary distribution.
     * </p>
     *
     * @param updateDistributionWithStagingConfigRequest
     * @return A Java Future containing the result of the UpdateDistributionWithStagingConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>NoSuchDistributionException The specified distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>TooManyDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>InvalidDefaultRootObjectException The default root object file name is too big or contains an invalid
     *         character.</li>
     *         <li>InvalidRelativePathException The relative path is too big, is not URL-encoded, or does not begin with
     *         a slash (/).</li>
     *         <li>InvalidErrorCodeException An invalid error code was specified.</li>
     *         <li>InvalidResponseCodeException A response code is not valid.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>InvalidOriginAccessControlException The origin access control is not valid.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InvalidViewerCertificateException A viewer certificate specified is not valid.</li>
     *         <li>InvalidMinimumProtocolVersionException The minimum protocol version specified is not valid.</li>
     *         <li>InvalidRequiredProtocolException This operation requires the HTTPS protocol. Ensure that you specify
     *         the HTTPS protocol in your request, or omit the <code>RequiredProtocols</code> element from your
     *         distribution configuration.</li>
     *         <li>NoSuchOriginException No origin exists with the specified <code>Origin Id</code>.</li>
     *         <li>TooManyOriginsException You cannot create more origins for the distribution.</li>
     *         <li>TooManyOriginGroupsPerDistributionException Processing your request would cause you to exceed the
     *         maximum number of origin groups allowed.</li>
     *         <li>TooManyCacheBehaviorsException You cannot create more cache behaviors for the distribution.</li>
     *         <li>TooManyCookieNamesInWhiteListException Your request contains more cookie names in the whitelist than
     *         are allowed per cache behavior.</li>
     *         <li>InvalidForwardCookiesException Your request contains forward cookies option which doesn't match with
     *         the expectation for the <code>whitelisted</code> list of cookie names. Either list of cookie names has
     *         been specified when not allowed or list of cookie names is missing when expected.</li>
     *         <li>TooManyHeadersInForwardedValuesException Your request contains too many headers in forwarded values.</li>
     *         <li>InvalidHeadersForS3OriginException The headers specified are not valid for an Amazon S3 origin.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>TooManyCertificatesException You cannot create anymore custom SSL/TLS certificates.</li>
     *         <li>InvalidLocationCodeException The location code specified is not valid.</li>
     *         <li>InvalidGeoRestrictionParameterException The specified geo restriction parameter is not valid.</li>
     *         <li>InvalidTtlOrderException The TTL order specified is not valid.</li>
     *         <li>InvalidWebAclIdException A web ACL ID specified is not valid. To specify a web ACL created using the
     *         latest version of WAF, use the ACL ARN, for example
     *         <code>arn:aws:wafv2:us-east-1:123456789012:global/webacl/ExampleWebACL/473e64fd-f30b-4765-81a0-62ad96dd167a</code>
     *         . To specify a web ACL created using WAF Classic, use the ACL ID, for example
     *         <code>473e64fd-f30b-4765-81a0-62ad96dd167a</code>.</li>
     *         <li>TooManyOriginCustomHeadersException Your request contains too many origin custom headers.</li>
     *         <li>TooManyQueryStringParametersException Your request contains too many query string parameters.</li>
     *         <li>InvalidQueryStringParametersException The query string parameters specified are not valid.</li>
     *         <li>TooManyDistributionsWithLambdaAssociationsException Processing your request would cause the maximum
     *         number of distributions with Lambda@Edge function associations per owner to be exceeded.</li>
     *         <li>TooManyDistributionsWithSingleFunctionArnException The maximum number of distributions have been
     *         associated with the specified Lambda@Edge function.</li>
     *         <li>TooManyLambdaFunctionAssociationsException Your request contains more Lambda@Edge function
     *         associations than are allowed per distribution.</li>
     *         <li>InvalidLambdaFunctionAssociationException The specified Lambda@Edge function association is invalid.</li>
     *         <li>TooManyDistributionsWithFunctionAssociationsException You have reached the maximum number of
     *         distributions that are associated with a CloudFront function. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyFunctionAssociationsException You have reached the maximum number of CloudFront function
     *         associations for this distribution. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>InvalidFunctionAssociationException A CloudFront function association is invalid.</li>
     *         <li>InvalidOriginReadTimeoutException The read timeout specified for the origin is not valid.</li>
     *         <li>InvalidOriginKeepaliveTimeoutException The keep alive timeout specified for the origin is not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException The specified configuration
     *         for field-level encryption can't be associated with the specified cache behavior.</li>
     *         <li>TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException The maximum number of
     *         distributions have been associated with the specified configuration for field-level encryption.</li>
     *         <li>NoSuchCachePolicyException The cache policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToCachePolicyException The maximum number of distributions have been
     *         associated with the specified cache policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchResponseHeadersPolicyException The response headers policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToResponseHeadersPolicyException The maximum number of distributions
     *         have been associated with the specified response headers policy.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>TooManyDistributionsAssociatedToOriginRequestPolicyException The maximum number of distributions have
     *         been associated with the specified origin request policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyDistributionsAssociatedToKeyGroupException The number of distributions that reference this key
     *         group is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyKeyGroupsAssociatedToDistributionException The number of key groups referenced by this
     *         distribution is more than the maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TrustedKeyGroupDoesNotExistException The specified key group does not exist.</li>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>RealtimeLogConfigOwnerMismatchException The specified real-time log configuration belongs to a
     *         different Amazon Web Services account.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateDistributionWithStagingConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateDistributionWithStagingConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDistributionWithStagingConfigResponse> updateDistributionWithStagingConfig(
            UpdateDistributionWithStagingConfigRequest updateDistributionWithStagingConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateDistributionWithStagingConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDistributionWithStagingConfig");

            HttpResponseHandler<Response<UpdateDistributionWithStagingConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateDistributionWithStagingConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateDistributionWithStagingConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDistributionWithStagingConfigRequest, UpdateDistributionWithStagingConfigResponse>()
                            .withOperationName("UpdateDistributionWithStagingConfig")
                            .withMarshaller(new UpdateDistributionWithStagingConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateDistributionWithStagingConfigRequest));
            CompletableFuture<UpdateDistributionWithStagingConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a field-level encryption configuration.
     * </p>
     *
     * @param updateFieldLevelEncryptionConfigRequest
     * @return A Java Future containing the result of the UpdateFieldLevelEncryptionConfig operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>NoSuchFieldLevelEncryptionConfigException The specified configuration for field-level encryption
     *         doesn't exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>TooManyFieldLevelEncryptionQueryArgProfilesException The maximum number of query arg profiles for
     *         field-level encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionContentTypeProfilesException The maximum number of content type profiles
     *         for field-level encryption have been created.</li>
     *         <li>QueryArgProfileEmptyException No profile specified for the field-level encryption query argument.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateFieldLevelEncryptionConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFieldLevelEncryptionConfigResponse> updateFieldLevelEncryptionConfig(
            UpdateFieldLevelEncryptionConfigRequest updateFieldLevelEncryptionConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFieldLevelEncryptionConfigRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFieldLevelEncryptionConfig");

            HttpResponseHandler<Response<UpdateFieldLevelEncryptionConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateFieldLevelEncryptionConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateFieldLevelEncryptionConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFieldLevelEncryptionConfigRequest, UpdateFieldLevelEncryptionConfigResponse>()
                            .withOperationName("UpdateFieldLevelEncryptionConfig")
                            .withMarshaller(new UpdateFieldLevelEncryptionConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFieldLevelEncryptionConfigRequest));
            CompletableFuture<UpdateFieldLevelEncryptionConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a field-level encryption profile.
     * </p>
     *
     * @param updateFieldLevelEncryptionProfileRequest
     * @return A Java Future containing the result of the UpdateFieldLevelEncryptionProfile operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>FieldLevelEncryptionProfileAlreadyExistsException The specified profile for field-level encryption
     *         already exists.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>NoSuchFieldLevelEncryptionProfileException The specified profile for field-level encryption doesn't
     *         exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>FieldLevelEncryptionProfileSizeExceededException The maximum size of a profile for field-level
     *         encryption was exceeded.</li>
     *         <li>TooManyFieldLevelEncryptionEncryptionEntitiesException The maximum number of encryption entities for
     *         field-level encryption have been created.</li>
     *         <li>TooManyFieldLevelEncryptionFieldPatternsException The maximum number of field patterns for
     *         field-level encryption have been created.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateFieldLevelEncryptionProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFieldLevelEncryptionProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFieldLevelEncryptionProfileResponse> updateFieldLevelEncryptionProfile(
            UpdateFieldLevelEncryptionProfileRequest updateFieldLevelEncryptionProfileRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateFieldLevelEncryptionProfileRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFieldLevelEncryptionProfile");

            HttpResponseHandler<Response<UpdateFieldLevelEncryptionProfileResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateFieldLevelEncryptionProfileResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateFieldLevelEncryptionProfileResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFieldLevelEncryptionProfileRequest, UpdateFieldLevelEncryptionProfileResponse>()
                            .withOperationName("UpdateFieldLevelEncryptionProfile")
                            .withMarshaller(new UpdateFieldLevelEncryptionProfileRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFieldLevelEncryptionProfileRequest));
            CompletableFuture<UpdateFieldLevelEncryptionProfileResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a CloudFront function.
     * </p>
     * <p>
     * You can update a function’s code or the comment that describes the function. You cannot update a function’s name.
     * </p>
     * <p>
     * To update a function, you provide the function’s name and version (<code>ETag</code> value) along with the
     * updated function code. To get the name and version, you can use <code>ListFunctions</code> and
     * <code>DescribeFunction</code>.
     * </p>
     *
     * @param updateFunctionRequest
     * @return A Java Future containing the result of the UpdateFunction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchFunctionExistsException The function does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>FunctionSizeLimitExceededException The function is too large. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>UnsupportedOperationException This operation is not supported in this region.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFunctionResponse> updateFunction(UpdateFunctionRequest updateFunctionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFunction");

            HttpResponseHandler<Response<UpdateFunctionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateFunctionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateFunctionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFunctionRequest, UpdateFunctionResponse>()
                            .withOperationName("UpdateFunction")
                            .withMarshaller(new UpdateFunctionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateFunctionRequest));
            CompletableFuture<UpdateFunctionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a key group.
     * </p>
     * <p>
     * When you update a key group, all the fields are updated with the values provided in the request. You cannot
     * update some fields independent of others. To update a key group:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Get the current key group with <code>GetKeyGroup</code> or <code>GetKeyGroupConfig</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the key group that you want to update. For example, add or remove public key IDs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateKeyGroup</code> with the entire key group object, including the fields that you modified and
     * those that you didn’t.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateKeyGroupRequest
     * @return A Java Future containing the result of the UpdateKeyGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchResourceException A resource that was specified is not valid.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>KeyGroupAlreadyExistsException A key group with this name already exists. You must provide a unique
     *         name. To modify an existing key group, use <code>UpdateKeyGroup</code>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>TooManyPublicKeysInKeyGroupException The number of public keys in this key group is more than the
     *         maximum allowed. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateKeyGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateKeyGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateKeyGroupResponse> updateKeyGroup(UpdateKeyGroupRequest updateKeyGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateKeyGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateKeyGroup");

            HttpResponseHandler<Response<UpdateKeyGroupResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateKeyGroupResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateKeyGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateKeyGroupRequest, UpdateKeyGroupResponse>()
                            .withOperationName("UpdateKeyGroup")
                            .withMarshaller(new UpdateKeyGroupRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateKeyGroupRequest));
            CompletableFuture<UpdateKeyGroupResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a CloudFront origin access control.
     * </p>
     *
     * @param updateOriginAccessControlRequest
     * @return A Java Future containing the result of the UpdateOriginAccessControl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>OriginAccessControlAlreadyExistsException An origin access control with the specified parameters
     *         already exists.</li>
     *         <li>NoSuchOriginAccessControlException The origin access control does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateOriginAccessControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginAccessControl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOriginAccessControlResponse> updateOriginAccessControl(
            UpdateOriginAccessControlRequest updateOriginAccessControlRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOriginAccessControlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOriginAccessControl");

            HttpResponseHandler<Response<UpdateOriginAccessControlResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateOriginAccessControlResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateOriginAccessControlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOriginAccessControlRequest, UpdateOriginAccessControlResponse>()
                            .withOperationName("UpdateOriginAccessControl")
                            .withMarshaller(new UpdateOriginAccessControlRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateOriginAccessControlRequest));
            CompletableFuture<UpdateOriginAccessControlResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an origin request policy configuration.
     * </p>
     * <p>
     * When you update an origin request policy configuration, all the fields are updated with the values provided in
     * the request. You cannot update some fields independent of others. To update an origin request policy
     * configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetOriginRequestPolicyConfig</code> to get the current configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the fields in the origin request policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateOriginRequestPolicy</code> by providing the entire origin request policy configuration,
     * including the fields that you modified and those that you didn’t.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateOriginRequestPolicyRequest
     * @return A Java Future containing the result of the UpdateOriginRequestPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchOriginRequestPolicyException The origin request policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>OriginRequestPolicyAlreadyExistsException An origin request policy with this name already exists. You
     *         must provide a unique name. To modify an existing origin request policy, use
     *         <code>UpdateOriginRequestPolicy</code>.</li>
     *         <li>TooManyHeadersInOriginRequestPolicyException The number of headers in the origin request policy
     *         exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyCookiesInOriginRequestPolicyException The number of cookies in the origin request policy
     *         exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooManyQueryStringsInOriginRequestPolicyException The number of query strings in the origin request
     *         policy exceeds the maximum. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateOriginRequestPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateOriginRequestPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateOriginRequestPolicyResponse> updateOriginRequestPolicy(
            UpdateOriginRequestPolicyRequest updateOriginRequestPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOriginRequestPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOriginRequestPolicy");

            HttpResponseHandler<Response<UpdateOriginRequestPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateOriginRequestPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateOriginRequestPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateOriginRequestPolicyRequest, UpdateOriginRequestPolicyResponse>()
                            .withOperationName("UpdateOriginRequestPolicy")
                            .withMarshaller(new UpdateOriginRequestPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateOriginRequestPolicyRequest));
            CompletableFuture<UpdateOriginRequestPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update public key information. Note that the only value you can change is the comment.
     * </p>
     *
     * @param updatePublicKeyRequest
     * @return A Java Future containing the result of the UpdatePublicKey operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>CannotChangeImmutablePublicKeyFieldsException You can't change the value of a public key.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>NoSuchPublicKeyException The specified public key doesn't exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdatePublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdatePublicKey" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePublicKeyResponse> updatePublicKey(UpdatePublicKeyRequest updatePublicKeyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePublicKey");

            HttpResponseHandler<Response<UpdatePublicKeyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdatePublicKeyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdatePublicKeyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePublicKeyRequest, UpdatePublicKeyResponse>()
                            .withOperationName("UpdatePublicKey")
                            .withMarshaller(new UpdatePublicKeyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updatePublicKeyRequest));
            CompletableFuture<UpdatePublicKeyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a real-time log configuration.
     * </p>
     * <p>
     * When you update a real-time log configuration, all the parameters are updated with the values provided in the
     * request. You cannot update some parameters independent of others. To update a real-time log configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Call <code>GetRealtimeLogConfig</code> to get the current real-time log configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Locally modify the parameters in the real-time log configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call this API (<code>UpdateRealtimeLogConfig</code>) by providing the entire real-time log configuration,
     * including the parameters that you modified and those that you didn’t.
     * </p>
     * </li>
     * </ol>
     * <p>
     * You cannot update a real-time log configuration’s <code>Name</code> or <code>ARN</code>.
     * </p>
     *
     * @param updateRealtimeLogConfigRequest
     * @return A Java Future containing the result of the UpdateRealtimeLogConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>NoSuchRealtimeLogConfigException The real-time log configuration does not exist.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateRealtimeLogConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateRealtimeLogConfig"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRealtimeLogConfigResponse> updateRealtimeLogConfig(
            UpdateRealtimeLogConfigRequest updateRealtimeLogConfigRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRealtimeLogConfigRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRealtimeLogConfig");

            HttpResponseHandler<Response<UpdateRealtimeLogConfigResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateRealtimeLogConfigResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateRealtimeLogConfigResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRealtimeLogConfigRequest, UpdateRealtimeLogConfigResponse>()
                            .withOperationName("UpdateRealtimeLogConfig")
                            .withMarshaller(new UpdateRealtimeLogConfigRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateRealtimeLogConfigRequest));
            CompletableFuture<UpdateRealtimeLogConfigResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a response headers policy.
     * </p>
     * <p>
     * When you update a response headers policy, the entire policy is replaced. You cannot update some policy fields
     * independent of others. To update a response headers policy configuration:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Use <code>GetResponseHeadersPolicyConfig</code> to get the current policy’s configuration.
     * </p>
     * </li>
     * <li>
     * <p>
     * Modify the fields in the response headers policy configuration that you want to update.
     * </p>
     * </li>
     * <li>
     * <p>
     * Call <code>UpdateResponseHeadersPolicy</code>, providing the entire response headers policy configuration,
     * including the fields that you modified and those that you didn’t.
     * </p>
     * </li>
     * </ol>
     *
     * @param updateResponseHeadersPolicyRequest
     * @return A Java Future containing the result of the UpdateResponseHeadersPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>NoSuchResponseHeadersPolicyException The response headers policy does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>ResponseHeadersPolicyAlreadyExistsException A response headers policy with this name already exists.
     *         You must provide a unique name. To modify an existing response headers policy, use
     *         <code>UpdateResponseHeadersPolicy</code>.</li>
     *         <li>TooManyCustomHeadersInResponseHeadersPolicyException The number of custom headers in the response
     *         headers policy exceeds the maximum.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>TooLongCspInResponseHeadersPolicyException The length of the <code>Content-Security-Policy</code>
     *         header value in the response headers policy exceeds the maximum.</p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html"
     *         >Quotas</a> (formerly known as limits) in the <i>Amazon CloudFront Developer Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateResponseHeadersPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateResponseHeadersPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResponseHeadersPolicyResponse> updateResponseHeadersPolicy(
            UpdateResponseHeadersPolicyRequest updateResponseHeadersPolicyRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResponseHeadersPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResponseHeadersPolicy");

            HttpResponseHandler<Response<UpdateResponseHeadersPolicyResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateResponseHeadersPolicyResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateResponseHeadersPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResponseHeadersPolicyRequest, UpdateResponseHeadersPolicyResponse>()
                            .withOperationName("UpdateResponseHeadersPolicy")
                            .withMarshaller(new UpdateResponseHeadersPolicyRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateResponseHeadersPolicyRequest));
            CompletableFuture<UpdateResponseHeadersPolicyResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update a streaming distribution.
     * </p>
     *
     * @param updateStreamingDistributionRequest
     *        The request to update a streaming distribution.
     * @return A Java Future containing the result of the UpdateStreamingDistribution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException Access denied.</li>
     *         <li>CnameAlreadyExistsException The CNAME specified is already defined for CloudFront.</li>
     *         <li>IllegalUpdateException The update contains modifications that are not allowed.</li>
     *         <li>InvalidIfMatchVersionException The <code>If-Match</code> version is missing or not valid.</li>
     *         <li>MissingBodyException This operation requires a body. Ensure that the body is present and the
     *         <code>Content-Type</code> header is set.</li>
     *         <li>NoSuchStreamingDistributionException The specified streaming distribution does not exist.</li>
     *         <li>PreconditionFailedException The precondition in one or more of the request fields evaluated to
     *         <code>false</code>.</li>
     *         <li>TooManyStreamingDistributionCnamEsException Your request contains more CNAMEs than are allowed per
     *         distribution.</li>
     *         <li>InvalidArgumentException An argument is invalid.</li>
     *         <li>InvalidOriginAccessIdentityException The origin access identity is not valid or doesn't exist.</li>
     *         <li>InvalidOriginAccessControlException The origin access control is not valid.</li>
     *         <li>TooManyTrustedSignersException Your request contains more trusted signers than are allowed per
     *         distribution.</li>
     *         <li>TrustedSignerDoesNotExistException One or more of your trusted signers don't exist.</li>
     *         <li>InconsistentQuantitiesException The value of <code>Quantity</code> and the size of <code>Items</code>
     *         don't match.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CloudFrontException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample CloudFrontAsyncClient.UpdateStreamingDistribution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/cloudfront-2020-05-31/UpdateStreamingDistribution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateStreamingDistributionResponse> updateStreamingDistribution(
            UpdateStreamingDistributionRequest updateStreamingDistributionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateStreamingDistributionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "CloudFront");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateStreamingDistribution");

            HttpResponseHandler<Response<UpdateStreamingDistributionResponse>> responseHandler = protocolFactory
                    .createCombinedResponseHandler(UpdateStreamingDistributionResponse::builder,
                            new XmlOperationMetadata().withHasStreamingSuccessResponse(false));

            CompletableFuture<UpdateStreamingDistributionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateStreamingDistributionRequest, UpdateStreamingDistributionResponse>()
                            .withOperationName("UpdateStreamingDistribution")
                            .withMarshaller(new UpdateStreamingDistributionRequestMarshaller(protocolFactory))
                            .withCombinedResponseHandler(responseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateStreamingDistributionRequest));
            CompletableFuture<UpdateStreamingDistributionResponse> whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            CompletableFutureUtils.forwardExceptionTo(whenCompleteFuture, executeFuture);
            return whenCompleteFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private AwsXmlProtocolFactory init() {
        return AwsXmlProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StreamingDistributionAlreadyExists")
                                .exceptionBuilderSupplier(StreamingDistributionAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchInvalidation")
                                .exceptionBuilderSupplier(NoSuchInvalidationException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooLongCSPInResponseHeadersPolicy")
                                .exceptionBuilderSupplier(TooLongCspInResponseHeadersPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionConfig")
                                .exceptionBuilderSupplier(NoSuchFieldLevelEncryptionConfigException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OriginRequestPolicyAlreadyExists")
                                .exceptionBuilderSupplier(OriginRequestPolicyAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyKeyGroupsAssociatedToDistribution")
                                .exceptionBuilderSupplier(TooManyKeyGroupsAssociatedToDistributionException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidMinimumProtocolVersion")
                                .exceptionBuilderSupplier(InvalidMinimumProtocolVersionException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyInvalidationsInProgress")
                                .exceptionBuilderSupplier(TooManyInvalidationsInProgressException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionConfigs")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionConfigsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyPublicKeys")
                                .exceptionBuilderSupplier(TooManyPublicKeysException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCacheBehaviors")
                                .exceptionBuilderSupplier(TooManyCacheBehaviorsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityInUse")
                                .exceptionBuilderSupplier(CloudFrontOriginAccessIdentityInUseException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileAlreadyExists")
                                .exceptionBuilderSupplier(FieldLevelEncryptionProfileAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOriginAccessControl")
                                .exceptionBuilderSupplier(InvalidOriginAccessControlException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MissingBody")
                                .exceptionBuilderSupplier(MissingBodyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyResponseHeadersPolicies")
                                .exceptionBuilderSupplier(TooManyResponseHeadersPoliciesException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOrigins")
                                .exceptionBuilderSupplier(TooManyOriginsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FunctionSizeLimitExceeded")
                                .exceptionBuilderSupplier(FunctionSizeLimitExceededException::builder).httpStatusCode(413)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperation")
                                .exceptionBuilderSupplier(UnsupportedOperationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BatchTooLarge")
                                .exceptionBuilderSupplier(BatchTooLargeException::builder).httpStatusCode(413).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RealtimeLogConfigInUse")
                                .exceptionBuilderSupplier(RealtimeLogConfigInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResponseCode")
                                .exceptionBuilderSupplier(InvalidResponseCodeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigAlreadyExists")
                                .exceptionBuilderSupplier(FieldLevelEncryptionConfigAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOriginKeepaliveTimeout")
                                .exceptionBuilderSupplier(InvalidOriginKeepaliveTimeoutException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyStreamingDistributionCNAMEs")
                                .exceptionBuilderSupplier(TooManyStreamingDistributionCnamEsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OriginAccessControlAlreadyExists")
                                .exceptionBuilderSupplier(OriginAccessControlAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StreamingDistributionNotDisabled")
                                .exceptionBuilderSupplier(StreamingDistributionNotDisabledException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionCNAMEs")
                                .exceptionBuilderSupplier(TooManyDistributionCnamEsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyQueryStringParameters")
                                .exceptionBuilderSupplier(TooManyQueryStringParametersException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionEncryptionEntities")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionEncryptionEntitiesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionConfigInUse")
                                .exceptionBuilderSupplier(FieldLevelEncryptionConfigInUseException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CloudFrontOriginAccessIdentityAlreadyExists")
                                .exceptionBuilderSupplier(CloudFrontOriginAccessIdentityAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchOriginAccessControl")
                                .exceptionBuilderSupplier(NoSuchOriginAccessControlException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchRealtimeLogConfig")
                                .exceptionBuilderSupplier(NoSuchRealtimeLogConfigException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidProtocolSettings")
                                .exceptionBuilderSupplier(InvalidProtocolSettingsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionProfiles")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionProfilesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUse")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidForwardCookies")
                                .exceptionBuilderSupplier(InvalidForwardCookiesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyPublicKeysInKeyGroup")
                                .exceptionBuilderSupplier(TooManyPublicKeysInKeyGroupException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOriginAccessIdentity")
                                .exceptionBuilderSupplier(InvalidOriginAccessIdentityException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IllegalUpdate")
                                .exceptionBuilderSupplier(IllegalUpdateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCookieNamesInWhiteList")
                                .exceptionBuilderSupplier(TooManyCookieNamesInWhiteListException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrustedKeyGroupDoesNotExist")
                                .exceptionBuilderSupplier(TrustedKeyGroupDoesNotExistException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata
                                .builder()
                                .errorCode("TooManyDistributionsAssociatedToResponseHeadersPolicy")
                                .exceptionBuilderSupplier(TooManyDistributionsAssociatedToResponseHeadersPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchDistribution")
                                .exceptionBuilderSupplier(NoSuchDistributionException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchResponseHeadersPolicy")
                                .exceptionBuilderSupplier(NoSuchResponseHeadersPolicyException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CNAMEAlreadyExists")
                                .exceptionBuilderSupplier(CnameAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTTLOrder")
                                .exceptionBuilderSupplier(InvalidTtlOrderException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FunctionInUse")
                                .exceptionBuilderSupplier(FunctionInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidViewerCertificate")
                                .exceptionBuilderSupplier(InvalidViewerCertificateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCachePolicies")
                                .exceptionBuilderSupplier(TooManyCachePoliciesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyQueryStringsInCachePolicy")
                                .exceptionBuilderSupplier(TooManyQueryStringsInCachePolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FunctionAlreadyExists")
                                .exceptionBuilderSupplier(FunctionAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CachePolicyInUse")
                                .exceptionBuilderSupplier(CachePolicyInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDefaultRootObject")
                                .exceptionBuilderSupplier(InvalidDefaultRootObjectException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StagingDistributionInUse")
                                .exceptionBuilderSupplier(StagingDistributionInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCloudFrontOriginAccessIdentities")
                                .exceptionBuilderSupplier(TooManyCloudFrontOriginAccessIdentitiesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionContentTypeProfiles")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionContentTypeProfilesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRelativePath")
                                .exceptionBuilderSupplier(InvalidRelativePathException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsWithLambdaAssociations")
                                .exceptionBuilderSupplier(TooManyDistributionsWithLambdaAssociationsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidHeadersForS3Origin")
                                .exceptionBuilderSupplier(InvalidHeadersForS3OriginException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RealtimeLogConfigAlreadyExists")
                                .exceptionBuilderSupplier(RealtimeLogConfigAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributions")
                                .exceptionBuilderSupplier(TooManyDistributionsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToOriginRequestPolicy")
                                .exceptionBuilderSupplier(TooManyDistributionsAssociatedToOriginRequestPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CannotChangeImmutablePublicKeyFields")
                                .exceptionBuilderSupplier(CannotChangeImmutablePublicKeyFieldsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionQueryArgProfiles")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionQueryArgProfilesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCookiesInOriginRequestPolicy")
                                .exceptionBuilderSupplier(TooManyCookiesInOriginRequestPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IllegalDelete")
                                .exceptionBuilderSupplier(IllegalDeleteException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOrigin")
                                .exceptionBuilderSupplier(InvalidOriginException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TestFunctionFailed")
                                .exceptionBuilderSupplier(TestFunctionFailedException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidGeoRestrictionParameter")
                                .exceptionBuilderSupplier(InvalidGeoRestrictionParameterException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCustomHeadersInResponseHeadersPolicy")
                                .exceptionBuilderSupplier(TooManyCustomHeadersInResponseHeadersPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TrustedSignerDoesNotExist")
                                .exceptionBuilderSupplier(TrustedSignerDoesNotExistException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResponseHeadersPolicyInUse")
                                .exceptionBuilderSupplier(ResponseHeadersPolicyInUseException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyHeadersInForwardedValues")
                                .exceptionBuilderSupplier(TooManyHeadersInForwardedValuesException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOriginReadTimeout")
                                .exceptionBuilderSupplier(InvalidOriginReadTimeoutException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OriginAccessControlInUse")
                                .exceptionBuilderSupplier(OriginAccessControlInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OriginRequestPolicyInUse")
                                .exceptionBuilderSupplier(OriginRequestPolicyInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToKeyGroup")
                                .exceptionBuilderSupplier(TooManyDistributionsAssociatedToKeyGroupException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidErrorCode")
                                .exceptionBuilderSupplier(InvalidErrorCodeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ContinuousDeploymentPolicyAlreadyExists")
                                .exceptionBuilderSupplier(ContinuousDeploymentPolicyAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFieldLevelEncryptionFieldPatterns")
                                .exceptionBuilderSupplier(TooManyFieldLevelEncryptionFieldPatternsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata
                                .builder()
                                .errorCode("IllegalFieldLevelEncryptionConfigAssociationWithCacheBehavior")
                                .exceptionBuilderSupplier(
                                        IllegalFieldLevelEncryptionConfigAssociationWithCacheBehaviorException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequiredProtocol")
                                .exceptionBuilderSupplier(InvalidRequiredProtocolException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchOriginRequestPolicy")
                                .exceptionBuilderSupplier(NoSuchOriginRequestPolicyException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchOrigin")
                                .exceptionBuilderSupplier(NoSuchOriginException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyQueryStringsInOriginRequestPolicy")
                                .exceptionBuilderSupplier(TooManyQueryStringsInOriginRequestPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTrustedSigners")
                                .exceptionBuilderSupplier(TooManyTrustedSignersException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFunctions")
                                .exceptionBuilderSupplier(TooManyFunctionsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsWithFunctionAssociations")
                                .exceptionBuilderSupplier(TooManyDistributionsWithFunctionAssociationsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyStreamingDistributions")
                                .exceptionBuilderSupplier(TooManyStreamingDistributionsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsWithSingleFunctionARN")
                                .exceptionBuilderSupplier(TooManyDistributionsWithSingleFunctionArnException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PublicKeyInUse")
                                .exceptionBuilderSupplier(PublicKeyInUseException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchContinuousDeploymentPolicy")
                                .exceptionBuilderSupplier(NoSuchContinuousDeploymentPolicyException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionFailed")
                                .exceptionBuilderSupplier(PreconditionFailedException::builder).httpStatusCode(412).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyKeyGroups")
                                .exceptionBuilderSupplier(TooManyKeyGroupsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DistributionAlreadyExists")
                                .exceptionBuilderSupplier(DistributionAlreadyExistsException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CachePolicyAlreadyExists")
                                .exceptionBuilderSupplier(CachePolicyAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ContinuousDeploymentPolicyInUse")
                                .exceptionBuilderSupplier(ContinuousDeploymentPolicyInUseException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDomainNameForOriginAccessControl")
                                .exceptionBuilderSupplier(InvalidDomainNameForOriginAccessControlException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOriginCustomHeaders")
                                .exceptionBuilderSupplier(TooManyOriginCustomHeadersException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLocationCode")
                                .exceptionBuilderSupplier(InvalidLocationCodeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyContinuousDeploymentPolicies")
                                .exceptionBuilderSupplier(TooManyContinuousDeploymentPoliciesException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyFunctionAssociations")
                                .exceptionBuilderSupplier(TooManyFunctionAssociationsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileSizeExceeded")
                                .exceptionBuilderSupplier(FieldLevelEncryptionProfileSizeExceededException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCertificates")
                                .exceptionBuilderSupplier(TooManyCertificatesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QueryArgProfileEmpty")
                                .exceptionBuilderSupplier(QueryArgProfileEmptyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MonitoringSubscriptionAlreadyExists")
                                .exceptionBuilderSupplier(MonitoringSubscriptionAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyRealtimeLogConfigs")
                                .exceptionBuilderSupplier(TooManyRealtimeLogConfigsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidQueryStringParameters")
                                .exceptionBuilderSupplier(InvalidQueryStringParametersException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchFunctionExists")
                                .exceptionBuilderSupplier(NoSuchFunctionExistsException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyHeadersInCachePolicy")
                                .exceptionBuilderSupplier(TooManyHeadersInCachePolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("RealtimeLogConfigOwnerMismatch")
                                .exceptionBuilderSupplier(RealtimeLogConfigOwnerMismatchException::builder).httpStatusCode(401)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchFieldLevelEncryptionProfile")
                                .exceptionBuilderSupplier(NoSuchFieldLevelEncryptionProfileException::builder)
                                .httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchResource")
                                .exceptionBuilderSupplier(NoSuchResourceException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InconsistentQuantities")
                                .exceptionBuilderSupplier(InconsistentQuantitiesException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFunctionAssociation")
                                .exceptionBuilderSupplier(InvalidFunctionAssociationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchMonitoringSubscription")
                                .exceptionBuilderSupplier(NoSuchMonitoringSubscriptionException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidLambdaFunctionAssociation")
                                .exceptionBuilderSupplier(InvalidLambdaFunctionAssociationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyLambdaFunctionAssociations")
                                .exceptionBuilderSupplier(TooManyLambdaFunctionAssociationsException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DistributionNotDisabled")
                                .exceptionBuilderSupplier(DistributionNotDisabledException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResponseHeadersPolicyAlreadyExists")
                                .exceptionBuilderSupplier(ResponseHeadersPolicyAlreadyExistsException::builder)
                                .httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOriginGroupsPerDistribution")
                                .exceptionBuilderSupplier(TooManyOriginGroupsPerDistributionException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDenied")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToOriginAccessControl")
                                .exceptionBuilderSupplier(TooManyDistributionsAssociatedToOriginAccessControlException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IllegalOriginAccessConfiguration")
                                .exceptionBuilderSupplier(IllegalOriginAccessConfigurationException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyCookiesInCachePolicy")
                                .exceptionBuilderSupplier(TooManyCookiesInCachePolicyException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOriginAccessControls")
                                .exceptionBuilderSupplier(TooManyOriginAccessControlsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidArgument")
                                .exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyOriginRequestPolicies")
                                .exceptionBuilderSupplier(TooManyOriginRequestPoliciesException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchCachePolicy")
                                .exceptionBuilderSupplier(NoSuchCachePolicyException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KeyGroupAlreadyExists")
                                .exceptionBuilderSupplier(KeyGroupAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchStreamingDistribution")
                                .exceptionBuilderSupplier(NoSuchStreamingDistributionException::builder).httpStatusCode(404)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchPublicKey")
                                .exceptionBuilderSupplier(NoSuchPublicKeyException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidWebACLId")
                                .exceptionBuilderSupplier(InvalidWebAclIdException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata
                                .builder()
                                .errorCode("TooManyDistributionsAssociatedToFieldLevelEncryptionConfig")
                                .exceptionBuilderSupplier(
                                        TooManyDistributionsAssociatedToFieldLevelEncryptionConfigException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyDistributionsAssociatedToCachePolicy")
                                .exceptionBuilderSupplier(TooManyDistributionsAssociatedToCachePolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PublicKeyAlreadyExists")
                                .exceptionBuilderSupplier(PublicKeyAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FieldLevelEncryptionProfileInUse")
                                .exceptionBuilderSupplier(FieldLevelEncryptionProfileInUseException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidIfMatchVersion")
                                .exceptionBuilderSupplier(InvalidIfMatchVersionException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTagging")
                                .exceptionBuilderSupplier(InvalidTaggingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyHeadersInOriginRequestPolicy")
                                .exceptionBuilderSupplier(TooManyHeadersInOriginRequestPolicyException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchCloudFrontOriginAccessIdentity")
                                .exceptionBuilderSupplier(NoSuchCloudFrontOriginAccessIdentityException::builder)
                                .httpStatusCode(404).build()).clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(CloudFrontException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends CloudFrontRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    @Override
    public CloudFrontUtilities utilities() {
        return CloudFrontUtilities.create();
    }

    @Override
    public CloudFrontAsyncWaiter waiter() {
        return CloudFrontAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }
}
