/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a key group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyGroupSummary implements SdkPojo, Serializable, ToCopyableBuilder<KeyGroupSummary.Builder, KeyGroupSummary> {
    private static final SdkField<KeyGroup> KEY_GROUP_FIELD = SdkField
            .<KeyGroup> builder(MarshallingType.SDK_POJO)
            .memberName("KeyGroup")
            .getter(getter(KeyGroupSummary::keyGroup))
            .setter(setter(Builder::keyGroup))
            .constructor(KeyGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyGroup")
                    .unmarshallLocationName("KeyGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final KeyGroup keyGroup;

    private KeyGroupSummary(BuilderImpl builder) {
        this.keyGroup = builder.keyGroup;
    }

    /**
     * <p>
     * A key group.
     * </p>
     * 
     * @return A key group.
     */
    public final KeyGroup keyGroup() {
        return keyGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyGroup());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyGroupSummary)) {
            return false;
        }
        KeyGroupSummary other = (KeyGroupSummary) obj;
        return Objects.equals(keyGroup(), other.keyGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyGroupSummary").add("KeyGroup", keyGroup()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyGroup":
            return Optional.ofNullable(clazz.cast(keyGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KeyGroupSummary, T> g) {
        return obj -> g.apply((KeyGroupSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyGroupSummary> {
        /**
         * <p>
         * A key group.
         * </p>
         * 
         * @param keyGroup
         *        A key group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyGroup(KeyGroup keyGroup);

        /**
         * <p>
         * A key group.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyGroup.Builder} avoiding the need to
         * create one manually via {@link KeyGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyGroup.Builder#build()} is called immediately and its result is
         * passed to {@link #keyGroup(KeyGroup)}.
         * 
         * @param keyGroup
         *        a consumer that will call methods on {@link KeyGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyGroup(KeyGroup)
         */
        default Builder keyGroup(Consumer<KeyGroup.Builder> keyGroup) {
            return keyGroup(KeyGroup.builder().applyMutation(keyGroup).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private KeyGroup keyGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyGroupSummary model) {
            keyGroup(model.keyGroup);
        }

        public final KeyGroup.Builder getKeyGroup() {
            return keyGroup != null ? keyGroup.toBuilder() : null;
        }

        public final void setKeyGroup(KeyGroup.BuilderImpl keyGroup) {
            this.keyGroup = keyGroup != null ? keyGroup.build() : null;
        }

        @Override
        public final Builder keyGroup(KeyGroup keyGroup) {
            this.keyGroup = keyGroup;
            return this;
        }

        @Override
        public KeyGroupSummary build() {
            return new KeyGroupSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
