/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A CloudFront origin access control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OriginAccessControlSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OriginAccessControlSummary.Builder, OriginAccessControlSummary> {
    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(OriginAccessControlSummary::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Description")
            .getter(getter(OriginAccessControlSummary::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description")
                    .unmarshallLocationName("Description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(OriginAccessControlSummary::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<String> SIGNING_PROTOCOL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SigningProtocol")
            .getter(getter(OriginAccessControlSummary::signingProtocolAsString))
            .setter(setter(Builder::signingProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningProtocol")
                    .unmarshallLocationName("SigningProtocol").build()).build();

    private static final SdkField<String> SIGNING_BEHAVIOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SigningBehavior")
            .getter(getter(OriginAccessControlSummary::signingBehaviorAsString))
            .setter(setter(Builder::signingBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SigningBehavior")
                    .unmarshallLocationName("SigningBehavior").build()).build();

    private static final SdkField<String> ORIGIN_ACCESS_CONTROL_ORIGIN_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OriginAccessControlOriginType")
            .getter(getter(OriginAccessControlSummary::originAccessControlOriginTypeAsString))
            .setter(setter(Builder::originAccessControlOriginType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginAccessControlOriginType")
                    .unmarshallLocationName("OriginAccessControlOriginType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD,
            NAME_FIELD, SIGNING_PROTOCOL_FIELD, SIGNING_BEHAVIOR_FIELD, ORIGIN_ACCESS_CONTROL_ORIGIN_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String description;

    private final String name;

    private final String signingProtocol;

    private final String signingBehavior;

    private final String originAccessControlOriginType;

    private OriginAccessControlSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.name = builder.name;
        this.signingProtocol = builder.signingProtocol;
        this.signingBehavior = builder.signingBehavior;
        this.originAccessControlOriginType = builder.originAccessControlOriginType;
    }

    /**
     * <p>
     * The unique identifier of the origin access control.
     * </p>
     * 
     * @return The unique identifier of the origin access control.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A description of the origin access control.
     * </p>
     * 
     * @return A description of the origin access control.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique name that identifies the origin access control.
     * </p>
     * 
     * @return A unique name that identifies the origin access control.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The signing protocol of the origin access control. The signing protocol determines how CloudFront signs
     * (authenticates) requests. The only valid value is <code>sigv4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingProtocol}
     * will return {@link OriginAccessControlSigningProtocols#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #signingProtocolAsString}.
     * </p>
     * 
     * @return The signing protocol of the origin access control. The signing protocol determines how CloudFront signs
     *         (authenticates) requests. The only valid value is <code>sigv4</code>.
     * @see OriginAccessControlSigningProtocols
     */
    public final OriginAccessControlSigningProtocols signingProtocol() {
        return OriginAccessControlSigningProtocols.fromValue(signingProtocol);
    }

    /**
     * <p>
     * The signing protocol of the origin access control. The signing protocol determines how CloudFront signs
     * (authenticates) requests. The only valid value is <code>sigv4</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingProtocol}
     * will return {@link OriginAccessControlSigningProtocols#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #signingProtocolAsString}.
     * </p>
     * 
     * @return The signing protocol of the origin access control. The signing protocol determines how CloudFront signs
     *         (authenticates) requests. The only valid value is <code>sigv4</code>.
     * @see OriginAccessControlSigningProtocols
     */
    public final String signingProtocolAsString() {
        return signingProtocol;
    }

    /**
     * <p>
     * A value that specifies which requests CloudFront signs (adds authentication information to). This field can have
     * one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>never</code> – CloudFront doesn't sign any origin requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code> header
     * from the viewer request if necessary.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header,
     * CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code> header,
     * CloudFront doesn't sign the origin request, but instead passes along the <code>Authorization</code> header that
     * it received in the viewer request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingBehavior}
     * will return {@link OriginAccessControlSigningBehaviors#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #signingBehaviorAsString}.
     * </p>
     * 
     * @return A value that specifies which requests CloudFront signs (adds authentication information to). This field
     *         can have one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>never</code> – CloudFront doesn't sign any origin requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code>
     *         header from the viewer request if necessary.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header,
     *         CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code>
     *         header, CloudFront doesn't sign the origin request, but instead passes along the
     *         <code>Authorization</code> header that it received in the viewer request.
     *         </p>
     *         </li>
     * @see OriginAccessControlSigningBehaviors
     */
    public final OriginAccessControlSigningBehaviors signingBehavior() {
        return OriginAccessControlSigningBehaviors.fromValue(signingBehavior);
    }

    /**
     * <p>
     * A value that specifies which requests CloudFront signs (adds authentication information to). This field can have
     * one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>never</code> – CloudFront doesn't sign any origin requests.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code> header
     * from the viewer request if necessary.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header,
     * CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code> header,
     * CloudFront doesn't sign the origin request, but instead passes along the <code>Authorization</code> header that
     * it received in the viewer request.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #signingBehavior}
     * will return {@link OriginAccessControlSigningBehaviors#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #signingBehaviorAsString}.
     * </p>
     * 
     * @return A value that specifies which requests CloudFront signs (adds authentication information to). This field
     *         can have one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>never</code> – CloudFront doesn't sign any origin requests.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code>
     *         header from the viewer request if necessary.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header,
     *         CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code>
     *         header, CloudFront doesn't sign the origin request, but instead passes along the
     *         <code>Authorization</code> header that it received in the viewer request.
     *         </p>
     *         </li>
     * @see OriginAccessControlSigningBehaviors
     */
    public final String signingBehaviorAsString() {
        return signingBehavior;
    }

    /**
     * <p>
     * The type of origin that this origin access control is for. The only valid value is <code>s3</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originAccessControlOriginType} will return {@link OriginAccessControlOriginTypes#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #originAccessControlOriginTypeAsString}.
     * </p>
     * 
     * @return The type of origin that this origin access control is for. The only valid value is <code>s3</code>.
     * @see OriginAccessControlOriginTypes
     */
    public final OriginAccessControlOriginTypes originAccessControlOriginType() {
        return OriginAccessControlOriginTypes.fromValue(originAccessControlOriginType);
    }

    /**
     * <p>
     * The type of origin that this origin access control is for. The only valid value is <code>s3</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #originAccessControlOriginType} will return {@link OriginAccessControlOriginTypes#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #originAccessControlOriginTypeAsString}.
     * </p>
     * 
     * @return The type of origin that this origin access control is for. The only valid value is <code>s3</code>.
     * @see OriginAccessControlOriginTypes
     */
    public final String originAccessControlOriginTypeAsString() {
        return originAccessControlOriginType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(signingProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(signingBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(originAccessControlOriginTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OriginAccessControlSummary)) {
            return false;
        }
        OriginAccessControlSummary other = (OriginAccessControlSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name())
                && Objects.equals(signingProtocolAsString(), other.signingProtocolAsString())
                && Objects.equals(signingBehaviorAsString(), other.signingBehaviorAsString())
                && Objects.equals(originAccessControlOriginTypeAsString(), other.originAccessControlOriginTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OriginAccessControlSummary").add("Id", id()).add("Description", description())
                .add("Name", name()).add("SigningProtocol", signingProtocolAsString())
                .add("SigningBehavior", signingBehaviorAsString())
                .add("OriginAccessControlOriginType", originAccessControlOriginTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SigningProtocol":
            return Optional.ofNullable(clazz.cast(signingProtocolAsString()));
        case "SigningBehavior":
            return Optional.ofNullable(clazz.cast(signingBehaviorAsString()));
        case "OriginAccessControlOriginType":
            return Optional.ofNullable(clazz.cast(originAccessControlOriginTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OriginAccessControlSummary, T> g) {
        return obj -> g.apply((OriginAccessControlSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OriginAccessControlSummary> {
        /**
         * <p>
         * The unique identifier of the origin access control.
         * </p>
         * 
         * @param id
         *        The unique identifier of the origin access control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A description of the origin access control.
         * </p>
         * 
         * @param description
         *        A description of the origin access control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique name that identifies the origin access control.
         * </p>
         * 
         * @param name
         *        A unique name that identifies the origin access control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The signing protocol of the origin access control. The signing protocol determines how CloudFront signs
         * (authenticates) requests. The only valid value is <code>sigv4</code>.
         * </p>
         * 
         * @param signingProtocol
         *        The signing protocol of the origin access control. The signing protocol determines how CloudFront
         *        signs (authenticates) requests. The only valid value is <code>sigv4</code>.
         * @see OriginAccessControlSigningProtocols
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginAccessControlSigningProtocols
         */
        Builder signingProtocol(String signingProtocol);

        /**
         * <p>
         * The signing protocol of the origin access control. The signing protocol determines how CloudFront signs
         * (authenticates) requests. The only valid value is <code>sigv4</code>.
         * </p>
         * 
         * @param signingProtocol
         *        The signing protocol of the origin access control. The signing protocol determines how CloudFront
         *        signs (authenticates) requests. The only valid value is <code>sigv4</code>.
         * @see OriginAccessControlSigningProtocols
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginAccessControlSigningProtocols
         */
        Builder signingProtocol(OriginAccessControlSigningProtocols signingProtocol);

        /**
         * <p>
         * A value that specifies which requests CloudFront signs (adds authentication information to). This field can
         * have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>never</code> – CloudFront doesn't sign any origin requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code> header
         * from the viewer request if necessary.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header,
         * CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code> header,
         * CloudFront doesn't sign the origin request, but instead passes along the <code>Authorization</code> header
         * that it received in the viewer request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param signingBehavior
         *        A value that specifies which requests CloudFront signs (adds authentication information to). This
         *        field can have one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>never</code> – CloudFront doesn't sign any origin requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code>
         *        header from the viewer request if necessary.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code>
         *        header, CloudFront signs the origin request. If the viewer request contains the
         *        <code>Authorization</code> header, CloudFront doesn't sign the origin request, but instead passes
         *        along the <code>Authorization</code> header that it received in the viewer request.
         *        </p>
         *        </li>
         * @see OriginAccessControlSigningBehaviors
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginAccessControlSigningBehaviors
         */
        Builder signingBehavior(String signingBehavior);

        /**
         * <p>
         * A value that specifies which requests CloudFront signs (adds authentication information to). This field can
         * have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>never</code> – CloudFront doesn't sign any origin requests.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code> header
         * from the viewer request if necessary.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code> header,
         * CloudFront signs the origin request. If the viewer request contains the <code>Authorization</code> header,
         * CloudFront doesn't sign the origin request, but instead passes along the <code>Authorization</code> header
         * that it received in the viewer request.
         * </p>
         * </li>
         * </ul>
         * 
         * @param signingBehavior
         *        A value that specifies which requests CloudFront signs (adds authentication information to). This
         *        field can have one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>never</code> – CloudFront doesn't sign any origin requests.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>always</code> – CloudFront signs all origin requests, overwriting the <code>Authorization</code>
         *        header from the viewer request if necessary.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>no-override</code> – If the viewer request doesn't contain the <code>Authorization</code>
         *        header, CloudFront signs the origin request. If the viewer request contains the
         *        <code>Authorization</code> header, CloudFront doesn't sign the origin request, but instead passes
         *        along the <code>Authorization</code> header that it received in the viewer request.
         *        </p>
         *        </li>
         * @see OriginAccessControlSigningBehaviors
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginAccessControlSigningBehaviors
         */
        Builder signingBehavior(OriginAccessControlSigningBehaviors signingBehavior);

        /**
         * <p>
         * The type of origin that this origin access control is for. The only valid value is <code>s3</code>.
         * </p>
         * 
         * @param originAccessControlOriginType
         *        The type of origin that this origin access control is for. The only valid value is <code>s3</code>.
         * @see OriginAccessControlOriginTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginAccessControlOriginTypes
         */
        Builder originAccessControlOriginType(String originAccessControlOriginType);

        /**
         * <p>
         * The type of origin that this origin access control is for. The only valid value is <code>s3</code>.
         * </p>
         * 
         * @param originAccessControlOriginType
         *        The type of origin that this origin access control is for. The only valid value is <code>s3</code>.
         * @see OriginAccessControlOriginTypes
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OriginAccessControlOriginTypes
         */
        Builder originAccessControlOriginType(OriginAccessControlOriginTypes originAccessControlOriginType);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String description;

        private String name;

        private String signingProtocol;

        private String signingBehavior;

        private String originAccessControlOriginType;

        private BuilderImpl() {
        }

        private BuilderImpl(OriginAccessControlSummary model) {
            id(model.id);
            description(model.description);
            name(model.name);
            signingProtocol(model.signingProtocol);
            signingBehavior(model.signingBehavior);
            originAccessControlOriginType(model.originAccessControlOriginType);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSigningProtocol() {
            return signingProtocol;
        }

        public final void setSigningProtocol(String signingProtocol) {
            this.signingProtocol = signingProtocol;
        }

        @Override
        public final Builder signingProtocol(String signingProtocol) {
            this.signingProtocol = signingProtocol;
            return this;
        }

        @Override
        public final Builder signingProtocol(OriginAccessControlSigningProtocols signingProtocol) {
            this.signingProtocol(signingProtocol == null ? null : signingProtocol.toString());
            return this;
        }

        public final String getSigningBehavior() {
            return signingBehavior;
        }

        public final void setSigningBehavior(String signingBehavior) {
            this.signingBehavior = signingBehavior;
        }

        @Override
        public final Builder signingBehavior(String signingBehavior) {
            this.signingBehavior = signingBehavior;
            return this;
        }

        @Override
        public final Builder signingBehavior(OriginAccessControlSigningBehaviors signingBehavior) {
            this.signingBehavior(signingBehavior == null ? null : signingBehavior.toString());
            return this;
        }

        public final String getOriginAccessControlOriginType() {
            return originAccessControlOriginType;
        }

        public final void setOriginAccessControlOriginType(String originAccessControlOriginType) {
            this.originAccessControlOriginType = originAccessControlOriginType;
        }

        @Override
        public final Builder originAccessControlOriginType(String originAccessControlOriginType) {
            this.originAccessControlOriginType = originAccessControlOriginType;
            return this;
        }

        @Override
        public final Builder originAccessControlOriginType(OriginAccessControlOriginTypes originAccessControlOriginType) {
            this.originAccessControlOriginType(originAccessControlOriginType == null ? null : originAccessControlOriginType
                    .toString());
            return this;
        }

        @Override
        public OriginAccessControlSummary build() {
            return new OriginAccessControlSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
