/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A response headers policy configuration.
 * </p>
 * <p>
 * A response headers policy configuration contains metadata about the response headers policy, and configurations for
 * sets of HTTP response headers and their values. CloudFront adds the headers in the policy to HTTP responses that it
 * sends for requests that match a cache behavior associated with the policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseHeadersPolicyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponseHeadersPolicyConfig.Builder, ResponseHeadersPolicyConfig> {
    private static final SdkField<String> COMMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Comment")
            .getter(getter(ResponseHeadersPolicyConfig::comment))
            .setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment")
                    .unmarshallLocationName("Comment").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(ResponseHeadersPolicyConfig::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<ResponseHeadersPolicyCorsConfig> CORS_CONFIG_FIELD = SdkField
            .<ResponseHeadersPolicyCorsConfig> builder(MarshallingType.SDK_POJO)
            .memberName("CorsConfig")
            .getter(getter(ResponseHeadersPolicyConfig::corsConfig))
            .setter(setter(Builder::corsConfig))
            .constructor(ResponseHeadersPolicyCorsConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CorsConfig")
                    .unmarshallLocationName("CorsConfig").build()).build();

    private static final SdkField<ResponseHeadersPolicySecurityHeadersConfig> SECURITY_HEADERS_CONFIG_FIELD = SdkField
            .<ResponseHeadersPolicySecurityHeadersConfig> builder(MarshallingType.SDK_POJO)
            .memberName("SecurityHeadersConfig")
            .getter(getter(ResponseHeadersPolicyConfig::securityHeadersConfig))
            .setter(setter(Builder::securityHeadersConfig))
            .constructor(ResponseHeadersPolicySecurityHeadersConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityHeadersConfig")
                    .unmarshallLocationName("SecurityHeadersConfig").build()).build();

    private static final SdkField<ResponseHeadersPolicyServerTimingHeadersConfig> SERVER_TIMING_HEADERS_CONFIG_FIELD = SdkField
            .<ResponseHeadersPolicyServerTimingHeadersConfig> builder(MarshallingType.SDK_POJO)
            .memberName("ServerTimingHeadersConfig")
            .getter(getter(ResponseHeadersPolicyConfig::serverTimingHeadersConfig))
            .setter(setter(Builder::serverTimingHeadersConfig))
            .constructor(ResponseHeadersPolicyServerTimingHeadersConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerTimingHeadersConfig")
                    .unmarshallLocationName("ServerTimingHeadersConfig").build()).build();

    private static final SdkField<ResponseHeadersPolicyCustomHeadersConfig> CUSTOM_HEADERS_CONFIG_FIELD = SdkField
            .<ResponseHeadersPolicyCustomHeadersConfig> builder(MarshallingType.SDK_POJO)
            .memberName("CustomHeadersConfig")
            .getter(getter(ResponseHeadersPolicyConfig::customHeadersConfig))
            .setter(setter(Builder::customHeadersConfig))
            .constructor(ResponseHeadersPolicyCustomHeadersConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomHeadersConfig")
                    .unmarshallLocationName("CustomHeadersConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, NAME_FIELD,
            CORS_CONFIG_FIELD, SECURITY_HEADERS_CONFIG_FIELD, SERVER_TIMING_HEADERS_CONFIG_FIELD, CUSTOM_HEADERS_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String comment;

    private final String name;

    private final ResponseHeadersPolicyCorsConfig corsConfig;

    private final ResponseHeadersPolicySecurityHeadersConfig securityHeadersConfig;

    private final ResponseHeadersPolicyServerTimingHeadersConfig serverTimingHeadersConfig;

    private final ResponseHeadersPolicyCustomHeadersConfig customHeadersConfig;

    private ResponseHeadersPolicyConfig(BuilderImpl builder) {
        this.comment = builder.comment;
        this.name = builder.name;
        this.corsConfig = builder.corsConfig;
        this.securityHeadersConfig = builder.securityHeadersConfig;
        this.serverTimingHeadersConfig = builder.serverTimingHeadersConfig;
        this.customHeadersConfig = builder.customHeadersConfig;
    }

    /**
     * <p>
     * A comment to describe the response headers policy.
     * </p>
     * <p>
     * The comment cannot be longer than 128 characters.
     * </p>
     * 
     * @return A comment to describe the response headers policy.</p>
     *         <p>
     *         The comment cannot be longer than 128 characters.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * A name to identify the response headers policy.
     * </p>
     * <p>
     * The name must be unique for response headers policies in this Amazon Web Services account.
     * </p>
     * 
     * @return A name to identify the response headers policy.</p>
     *         <p>
     *         The name must be unique for response headers policies in this Amazon Web Services account.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
     * </p>
     * 
     * @return A configuration for a set of HTTP response headers that are used for cross-origin resource sharing
     *         (CORS).
     */
    public final ResponseHeadersPolicyCorsConfig corsConfig() {
        return corsConfig;
    }

    /**
     * <p>
     * A configuration for a set of security-related HTTP response headers.
     * </p>
     * 
     * @return A configuration for a set of security-related HTTP response headers.
     */
    public final ResponseHeadersPolicySecurityHeadersConfig securityHeadersConfig() {
        return securityHeadersConfig;
    }

    /**
     * <p>
     * A configuration for enabling the <code>Server-Timing</code> header in HTTP responses sent from CloudFront.
     * </p>
     * 
     * @return A configuration for enabling the <code>Server-Timing</code> header in HTTP responses sent from
     *         CloudFront.
     */
    public final ResponseHeadersPolicyServerTimingHeadersConfig serverTimingHeadersConfig() {
        return serverTimingHeadersConfig;
    }

    /**
     * <p>
     * A configuration for a set of custom HTTP response headers.
     * </p>
     * 
     * @return A configuration for a set of custom HTTP response headers.
     */
    public final ResponseHeadersPolicyCustomHeadersConfig customHeadersConfig() {
        return customHeadersConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(corsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(securityHeadersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(serverTimingHeadersConfig());
        hashCode = 31 * hashCode + Objects.hashCode(customHeadersConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseHeadersPolicyConfig)) {
            return false;
        }
        ResponseHeadersPolicyConfig other = (ResponseHeadersPolicyConfig) obj;
        return Objects.equals(comment(), other.comment()) && Objects.equals(name(), other.name())
                && Objects.equals(corsConfig(), other.corsConfig())
                && Objects.equals(securityHeadersConfig(), other.securityHeadersConfig())
                && Objects.equals(serverTimingHeadersConfig(), other.serverTimingHeadersConfig())
                && Objects.equals(customHeadersConfig(), other.customHeadersConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseHeadersPolicyConfig").add("Comment", comment()).add("Name", name())
                .add("CorsConfig", corsConfig()).add("SecurityHeadersConfig", securityHeadersConfig())
                .add("ServerTimingHeadersConfig", serverTimingHeadersConfig()).add("CustomHeadersConfig", customHeadersConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CorsConfig":
            return Optional.ofNullable(clazz.cast(corsConfig()));
        case "SecurityHeadersConfig":
            return Optional.ofNullable(clazz.cast(securityHeadersConfig()));
        case "ServerTimingHeadersConfig":
            return Optional.ofNullable(clazz.cast(serverTimingHeadersConfig()));
        case "CustomHeadersConfig":
            return Optional.ofNullable(clazz.cast(customHeadersConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResponseHeadersPolicyConfig, T> g) {
        return obj -> g.apply((ResponseHeadersPolicyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseHeadersPolicyConfig> {
        /**
         * <p>
         * A comment to describe the response headers policy.
         * </p>
         * <p>
         * The comment cannot be longer than 128 characters.
         * </p>
         * 
         * @param comment
         *        A comment to describe the response headers policy.</p>
         *        <p>
         *        The comment cannot be longer than 128 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A name to identify the response headers policy.
         * </p>
         * <p>
         * The name must be unique for response headers policies in this Amazon Web Services account.
         * </p>
         * 
         * @param name
         *        A name to identify the response headers policy.</p>
         *        <p>
         *        The name must be unique for response headers policies in this Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
         * </p>
         * 
         * @param corsConfig
         *        A configuration for a set of HTTP response headers that are used for cross-origin resource sharing
         *        (CORS).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder corsConfig(ResponseHeadersPolicyCorsConfig corsConfig);

        /**
         * <p>
         * A configuration for a set of HTTP response headers that are used for cross-origin resource sharing (CORS).
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseHeadersPolicyCorsConfig.Builder}
         * avoiding the need to create one manually via {@link ResponseHeadersPolicyCorsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseHeadersPolicyCorsConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #corsConfig(ResponseHeadersPolicyCorsConfig)}.
         * 
         * @param corsConfig
         *        a consumer that will call methods on {@link ResponseHeadersPolicyCorsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #corsConfig(ResponseHeadersPolicyCorsConfig)
         */
        default Builder corsConfig(Consumer<ResponseHeadersPolicyCorsConfig.Builder> corsConfig) {
            return corsConfig(ResponseHeadersPolicyCorsConfig.builder().applyMutation(corsConfig).build());
        }

        /**
         * <p>
         * A configuration for a set of security-related HTTP response headers.
         * </p>
         * 
         * @param securityHeadersConfig
         *        A configuration for a set of security-related HTTP response headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityHeadersConfig(ResponseHeadersPolicySecurityHeadersConfig securityHeadersConfig);

        /**
         * <p>
         * A configuration for a set of security-related HTTP response headers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResponseHeadersPolicySecurityHeadersConfig.Builder} avoiding the need to create one manually via
         * {@link ResponseHeadersPolicySecurityHeadersConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseHeadersPolicySecurityHeadersConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #securityHeadersConfig(ResponseHeadersPolicySecurityHeadersConfig)}.
         * 
         * @param securityHeadersConfig
         *        a consumer that will call methods on {@link ResponseHeadersPolicySecurityHeadersConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityHeadersConfig(ResponseHeadersPolicySecurityHeadersConfig)
         */
        default Builder securityHeadersConfig(Consumer<ResponseHeadersPolicySecurityHeadersConfig.Builder> securityHeadersConfig) {
            return securityHeadersConfig(ResponseHeadersPolicySecurityHeadersConfig.builder()
                    .applyMutation(securityHeadersConfig).build());
        }

        /**
         * <p>
         * A configuration for enabling the <code>Server-Timing</code> header in HTTP responses sent from CloudFront.
         * </p>
         * 
         * @param serverTimingHeadersConfig
         *        A configuration for enabling the <code>Server-Timing</code> header in HTTP responses sent from
         *        CloudFront.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverTimingHeadersConfig(ResponseHeadersPolicyServerTimingHeadersConfig serverTimingHeadersConfig);

        /**
         * <p>
         * A configuration for enabling the <code>Server-Timing</code> header in HTTP responses sent from CloudFront.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResponseHeadersPolicyServerTimingHeadersConfig.Builder} avoiding the need to create one manually via
         * {@link ResponseHeadersPolicyServerTimingHeadersConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseHeadersPolicyServerTimingHeadersConfig.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #serverTimingHeadersConfig(ResponseHeadersPolicyServerTimingHeadersConfig)}.
         * 
         * @param serverTimingHeadersConfig
         *        a consumer that will call methods on {@link ResponseHeadersPolicyServerTimingHeadersConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverTimingHeadersConfig(ResponseHeadersPolicyServerTimingHeadersConfig)
         */
        default Builder serverTimingHeadersConfig(
                Consumer<ResponseHeadersPolicyServerTimingHeadersConfig.Builder> serverTimingHeadersConfig) {
            return serverTimingHeadersConfig(ResponseHeadersPolicyServerTimingHeadersConfig.builder()
                    .applyMutation(serverTimingHeadersConfig).build());
        }

        /**
         * <p>
         * A configuration for a set of custom HTTP response headers.
         * </p>
         * 
         * @param customHeadersConfig
         *        A configuration for a set of custom HTTP response headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customHeadersConfig(ResponseHeadersPolicyCustomHeadersConfig customHeadersConfig);

        /**
         * <p>
         * A configuration for a set of custom HTTP response headers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ResponseHeadersPolicyCustomHeadersConfig.Builder} avoiding the need to create one manually via
         * {@link ResponseHeadersPolicyCustomHeadersConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseHeadersPolicyCustomHeadersConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #customHeadersConfig(ResponseHeadersPolicyCustomHeadersConfig)}.
         * 
         * @param customHeadersConfig
         *        a consumer that will call methods on {@link ResponseHeadersPolicyCustomHeadersConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customHeadersConfig(ResponseHeadersPolicyCustomHeadersConfig)
         */
        default Builder customHeadersConfig(Consumer<ResponseHeadersPolicyCustomHeadersConfig.Builder> customHeadersConfig) {
            return customHeadersConfig(ResponseHeadersPolicyCustomHeadersConfig.builder().applyMutation(customHeadersConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String comment;

        private String name;

        private ResponseHeadersPolicyCorsConfig corsConfig;

        private ResponseHeadersPolicySecurityHeadersConfig securityHeadersConfig;

        private ResponseHeadersPolicyServerTimingHeadersConfig serverTimingHeadersConfig;

        private ResponseHeadersPolicyCustomHeadersConfig customHeadersConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseHeadersPolicyConfig model) {
            comment(model.comment);
            name(model.name);
            corsConfig(model.corsConfig);
            securityHeadersConfig(model.securityHeadersConfig);
            serverTimingHeadersConfig(model.serverTimingHeadersConfig);
            customHeadersConfig(model.customHeadersConfig);
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ResponseHeadersPolicyCorsConfig.Builder getCorsConfig() {
            return corsConfig != null ? corsConfig.toBuilder() : null;
        }

        public final void setCorsConfig(ResponseHeadersPolicyCorsConfig.BuilderImpl corsConfig) {
            this.corsConfig = corsConfig != null ? corsConfig.build() : null;
        }

        @Override
        public final Builder corsConfig(ResponseHeadersPolicyCorsConfig corsConfig) {
            this.corsConfig = corsConfig;
            return this;
        }

        public final ResponseHeadersPolicySecurityHeadersConfig.Builder getSecurityHeadersConfig() {
            return securityHeadersConfig != null ? securityHeadersConfig.toBuilder() : null;
        }

        public final void setSecurityHeadersConfig(ResponseHeadersPolicySecurityHeadersConfig.BuilderImpl securityHeadersConfig) {
            this.securityHeadersConfig = securityHeadersConfig != null ? securityHeadersConfig.build() : null;
        }

        @Override
        public final Builder securityHeadersConfig(ResponseHeadersPolicySecurityHeadersConfig securityHeadersConfig) {
            this.securityHeadersConfig = securityHeadersConfig;
            return this;
        }

        public final ResponseHeadersPolicyServerTimingHeadersConfig.Builder getServerTimingHeadersConfig() {
            return serverTimingHeadersConfig != null ? serverTimingHeadersConfig.toBuilder() : null;
        }

        public final void setServerTimingHeadersConfig(
                ResponseHeadersPolicyServerTimingHeadersConfig.BuilderImpl serverTimingHeadersConfig) {
            this.serverTimingHeadersConfig = serverTimingHeadersConfig != null ? serverTimingHeadersConfig.build() : null;
        }

        @Override
        public final Builder serverTimingHeadersConfig(ResponseHeadersPolicyServerTimingHeadersConfig serverTimingHeadersConfig) {
            this.serverTimingHeadersConfig = serverTimingHeadersConfig;
            return this;
        }

        public final ResponseHeadersPolicyCustomHeadersConfig.Builder getCustomHeadersConfig() {
            return customHeadersConfig != null ? customHeadersConfig.toBuilder() : null;
        }

        public final void setCustomHeadersConfig(ResponseHeadersPolicyCustomHeadersConfig.BuilderImpl customHeadersConfig) {
            this.customHeadersConfig = customHeadersConfig != null ? customHeadersConfig.build() : null;
        }

        @Override
        public final Builder customHeadersConfig(ResponseHeadersPolicyCustomHeadersConfig customHeadersConfig) {
            this.customHeadersConfig = customHeadersConfig;
            return this;
        }

        @Override
        public ResponseHeadersPolicyConfig build() {
            return new ResponseHeadersPolicyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
