/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateKeyGroupRequest extends CloudFrontRequest implements
        ToCopyableBuilder<UpdateKeyGroupRequest.Builder, UpdateKeyGroupRequest> {
    private static final SdkField<KeyGroupConfig> KEY_GROUP_CONFIG_FIELD = SdkField
            .<KeyGroupConfig> builder(MarshallingType.SDK_POJO)
            .memberName("KeyGroupConfig")
            .getter(getter(UpdateKeyGroupRequest::keyGroupConfig))
            .setter(setter(Builder::keyGroupConfig))
            .constructor(KeyGroupConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyGroupConfig")
                    .unmarshallLocationName("KeyGroupConfig").build(), PayloadTrait.create()).build();

    private static final SdkField<String> ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Id")
            .getter(getter(UpdateKeyGroupRequest::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Id").unmarshallLocationName("Id")
                    .build()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IfMatch")
            .getter(getter(UpdateKeyGroupRequest::ifMatch))
            .setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match")
                    .unmarshallLocationName("If-Match").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_GROUP_CONFIG_FIELD,
            ID_FIELD, IF_MATCH_FIELD));

    private final KeyGroupConfig keyGroupConfig;

    private final String id;

    private final String ifMatch;

    private UpdateKeyGroupRequest(BuilderImpl builder) {
        super(builder);
        this.keyGroupConfig = builder.keyGroupConfig;
        this.id = builder.id;
        this.ifMatch = builder.ifMatch;
    }

    /**
     * <p>
     * The key group configuration.
     * </p>
     * 
     * @return The key group configuration.
     */
    public final KeyGroupConfig keyGroupConfig() {
        return keyGroupConfig;
    }

    /**
     * <p>
     * The identifier of the key group that you are updating.
     * </p>
     * 
     * @return The identifier of the key group that you are updating.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The version of the key group that you are updating. The version is the key group’s <code>ETag</code> value.
     * </p>
     * 
     * @return The version of the key group that you are updating. The version is the key group’s <code>ETag</code>
     *         value.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(keyGroupConfig());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateKeyGroupRequest)) {
            return false;
        }
        UpdateKeyGroupRequest other = (UpdateKeyGroupRequest) obj;
        return Objects.equals(keyGroupConfig(), other.keyGroupConfig()) && Objects.equals(id(), other.id())
                && Objects.equals(ifMatch(), other.ifMatch());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateKeyGroupRequest").add("KeyGroupConfig", keyGroupConfig()).add("Id", id())
                .add("IfMatch", ifMatch()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyGroupConfig":
            return Optional.ofNullable(clazz.cast(keyGroupConfig()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "IfMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateKeyGroupRequest, T> g) {
        return obj -> g.apply((UpdateKeyGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateKeyGroupRequest> {
        /**
         * <p>
         * The key group configuration.
         * </p>
         * 
         * @param keyGroupConfig
         *        The key group configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyGroupConfig(KeyGroupConfig keyGroupConfig);

        /**
         * <p>
         * The key group configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link KeyGroupConfig.Builder} avoiding the need
         * to create one manually via {@link KeyGroupConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KeyGroupConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #keyGroupConfig(KeyGroupConfig)}.
         * 
         * @param keyGroupConfig
         *        a consumer that will call methods on {@link KeyGroupConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #keyGroupConfig(KeyGroupConfig)
         */
        default Builder keyGroupConfig(Consumer<KeyGroupConfig.Builder> keyGroupConfig) {
            return keyGroupConfig(KeyGroupConfig.builder().applyMutation(keyGroupConfig).build());
        }

        /**
         * <p>
         * The identifier of the key group that you are updating.
         * </p>
         * 
         * @param id
         *        The identifier of the key group that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The version of the key group that you are updating. The version is the key group’s <code>ETag</code> value.
         * </p>
         * 
         * @param ifMatch
         *        The version of the key group that you are updating. The version is the key group’s <code>ETag</code>
         *        value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private KeyGroupConfig keyGroupConfig;

        private String id;

        private String ifMatch;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateKeyGroupRequest model) {
            super(model);
            keyGroupConfig(model.keyGroupConfig);
            id(model.id);
            ifMatch(model.ifMatch);
        }

        public final KeyGroupConfig.Builder getKeyGroupConfig() {
            return keyGroupConfig != null ? keyGroupConfig.toBuilder() : null;
        }

        public final void setKeyGroupConfig(KeyGroupConfig.BuilderImpl keyGroupConfig) {
            this.keyGroupConfig = keyGroupConfig != null ? keyGroupConfig.build() : null;
        }

        @Override
        public final Builder keyGroupConfig(KeyGroupConfig keyGroupConfig) {
            this.keyGroupConfig = keyGroupConfig;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateKeyGroupRequest build() {
            return new UpdateKeyGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
