/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnycastIpListRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateAnycastIpListRequest.Builder, CreateAnycastIpListRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(CreateAnycastIpListRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<Integer> IP_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("IpCount")
            .getter(getter(CreateAnycastIpListRequest::ipCount))
            .setter(setter(Builder::ipCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpCount")
                    .unmarshallLocationName("IpCount").build()).build();

    private static final SdkField<Tags> TAGS_FIELD = SdkField
            .<Tags> builder(MarshallingType.SDK_POJO)
            .memberName("Tags")
            .getter(getter(CreateAnycastIpListRequest::tags))
            .setter(setter(Builder::tags))
            .constructor(Tags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags")
                    .unmarshallLocationName("Tags").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IP_COUNT_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final Integer ipCount;

    private final Tags tags;

    private CreateAnycastIpListRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ipCount = builder.ipCount;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Name of the Anycast static IP list.
     * </p>
     * 
     * @return Name of the Anycast static IP list.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The number of static IP addresses that are allocated to the Anycast static IP list. Valid values: 21 or 3.
     * </p>
     * 
     * @return The number of static IP addresses that are allocated to the Anycast static IP list. Valid values: 21 or
     *         3.
     */
    public final Integer ipCount() {
        return ipCount;
    }

    /**
     * Returns the value of the Tags property for this object.
     * 
     * @return The value of the Tags property for this object.
     */
    public final Tags tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ipCount());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnycastIpListRequest)) {
            return false;
        }
        CreateAnycastIpListRequest other = (CreateAnycastIpListRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ipCount(), other.ipCount())
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnycastIpListRequest").add("Name", name()).add("IpCount", ipCount()).add("Tags", tags())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "IpCount":
            return Optional.ofNullable(clazz.cast(ipCount()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("IpCount", IP_COUNT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnycastIpListRequest, T> g) {
        return obj -> g.apply((CreateAnycastIpListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAnycastIpListRequest> {
        /**
         * <p>
         * Name of the Anycast static IP list.
         * </p>
         * 
         * @param name
         *        Name of the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The number of static IP addresses that are allocated to the Anycast static IP list. Valid values: 21 or 3.
         * </p>
         * 
         * @param ipCount
         *        The number of static IP addresses that are allocated to the Anycast static IP list. Valid values: 21
         *        or 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipCount(Integer ipCount);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tags tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Tags.Builder} avoiding the need to create
         * one manually via {@link Tags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Tags.Builder#build()} is called immediately and its result is
         * passed to {@link #tags(Tags)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link Tags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(Tags)
         */
        default Builder tags(Consumer<Tags.Builder> tags) {
            return tags(Tags.builder().applyMutation(tags).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String name;

        private Integer ipCount;

        private Tags tags;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnycastIpListRequest model) {
            super(model);
            name(model.name);
            ipCount(model.ipCount);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getIpCount() {
            return ipCount;
        }

        public final void setIpCount(Integer ipCount) {
            this.ipCount = ipCount;
        }

        @Override
        public final Builder ipCount(Integer ipCount) {
            this.ipCount = ipCount;
            return this;
        }

        public final Tags.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnycastIpListRequest build() {
            return new CreateAnycastIpListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
