/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectionGroupRequest extends CloudFrontRequest implements
        ToCopyableBuilder<CreateConnectionGroupRequest.Builder, CreateConnectionGroupRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(CreateConnectionGroupRequest::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("Name").build()).build();

    private static final SdkField<Boolean> IPV6_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Ipv6Enabled")
            .getter(getter(CreateConnectionGroupRequest::ipv6Enabled))
            .setter(setter(Builder::ipv6Enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Enabled")
                    .unmarshallLocationName("Ipv6Enabled").build()).build();

    private static final SdkField<Tags> TAGS_FIELD = SdkField
            .<Tags> builder(MarshallingType.SDK_POJO)
            .memberName("Tags")
            .getter(getter(CreateConnectionGroupRequest::tags))
            .setter(setter(Builder::tags))
            .constructor(Tags::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags")
                    .unmarshallLocationName("Tags").build()).build();

    private static final SdkField<String> ANYCAST_IP_LIST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnycastIpListId")
            .getter(getter(CreateConnectionGroupRequest::anycastIpListId))
            .setter(setter(Builder::anycastIpListId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnycastIpListId")
                    .unmarshallLocationName("AnycastIpListId").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled")
            .getter(getter(CreateConnectionGroupRequest::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled")
                    .unmarshallLocationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            IPV6_ENABLED_FIELD, TAGS_FIELD, ANYCAST_IP_LIST_ID_FIELD, ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final Boolean ipv6Enabled;

    private final Tags tags;

    private final String anycastIpListId;

    private final Boolean enabled;

    private CreateConnectionGroupRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ipv6Enabled = builder.ipv6Enabled;
        this.tags = builder.tags;
        this.anycastIpListId = builder.anycastIpListId;
        this.enabled = builder.enabled;
    }

    /**
     * <p>
     * The name of the connection group. Enter a friendly identifier that is unique within your Amazon Web Services
     * account. This name can't be updated after you create the connection group.
     * </p>
     * 
     * @return The name of the connection group. Enter a friendly identifier that is unique within your Amazon Web
     *         Services account. This name can't be updated after you create the connection group.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Enable IPv6 for the connection group. The default is <code>true</code>. For more information, see <a href=
     * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesEnableIPv6"
     * >Enable IPv6</a> in the <i>Amazon CloudFront Developer Guide</i>.
     * </p>
     * 
     * @return Enable IPv6 for the connection group. The default is <code>true</code>. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesEnableIPv6"
     *         >Enable IPv6</a> in the <i>Amazon CloudFront Developer Guide</i>.
     */
    public final Boolean ipv6Enabled() {
        return ipv6Enabled;
    }

    /**
     * Returns the value of the Tags property for this object.
     * 
     * @return The value of the Tags property for this object.
     */
    public final Tags tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the Anycast static IP list.
     * </p>
     * 
     * @return The ID of the Anycast static IP list.
     */
    public final String anycastIpListId() {
        return anycastIpListId;
    }

    /**
     * <p>
     * Enable the connection group.
     * </p>
     * 
     * @return Enable the connection group.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ipv6Enabled());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(anycastIpListId());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectionGroupRequest)) {
            return false;
        }
        CreateConnectionGroupRequest other = (CreateConnectionGroupRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ipv6Enabled(), other.ipv6Enabled())
                && Objects.equals(tags(), other.tags()) && Objects.equals(anycastIpListId(), other.anycastIpListId())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectionGroupRequest").add("Name", name()).add("Ipv6Enabled", ipv6Enabled())
                .add("Tags", tags()).add("AnycastIpListId", anycastIpListId()).add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Ipv6Enabled":
            return Optional.ofNullable(clazz.cast(ipv6Enabled()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "AnycastIpListId":
            return Optional.ofNullable(clazz.cast(anycastIpListId()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Ipv6Enabled", IPV6_ENABLED_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("AnycastIpListId", ANYCAST_IP_LIST_ID_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectionGroupRequest, T> g) {
        return obj -> g.apply((CreateConnectionGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CloudFrontRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectionGroupRequest> {
        /**
         * <p>
         * The name of the connection group. Enter a friendly identifier that is unique within your Amazon Web Services
         * account. This name can't be updated after you create the connection group.
         * </p>
         * 
         * @param name
         *        The name of the connection group. Enter a friendly identifier that is unique within your Amazon Web
         *        Services account. This name can't be updated after you create the connection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Enable IPv6 for the connection group. The default is <code>true</code>. For more information, see <a href=
         * "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesEnableIPv6"
         * >Enable IPv6</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * </p>
         * 
         * @param ipv6Enabled
         *        Enable IPv6 for the connection group. The default is <code>true</code>. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesEnableIPv6"
         *        >Enable IPv6</a> in the <i>Amazon CloudFront Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Enabled(Boolean ipv6Enabled);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tags tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Tags.Builder} avoiding the need to create
         * one manually via {@link Tags#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Tags.Builder#build()} is called immediately and its result is
         * passed to {@link #tags(Tags)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link Tags.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(Tags)
         */
        default Builder tags(Consumer<Tags.Builder> tags) {
            return tags(Tags.builder().applyMutation(tags).build());
        }

        /**
         * <p>
         * The ID of the Anycast static IP list.
         * </p>
         * 
         * @param anycastIpListId
         *        The ID of the Anycast static IP list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anycastIpListId(String anycastIpListId);

        /**
         * <p>
         * Enable the connection group.
         * </p>
         * 
         * @param enabled
         *        Enable the connection group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudFrontRequest.BuilderImpl implements Builder {
        private String name;

        private Boolean ipv6Enabled;

        private Tags tags;

        private String anycastIpListId;

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectionGroupRequest model) {
            super(model);
            name(model.name);
            ipv6Enabled(model.ipv6Enabled);
            tags(model.tags);
            anycastIpListId(model.anycastIpListId);
            enabled(model.enabled);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Boolean getIpv6Enabled() {
            return ipv6Enabled;
        }

        public final void setIpv6Enabled(Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
        }

        @Override
        public final Builder ipv6Enabled(Boolean ipv6Enabled) {
            this.ipv6Enabled = ipv6Enabled;
            return this;
        }

        public final Tags.Builder getTags() {
            return tags != null ? tags.toBuilder() : null;
        }

        public final void setTags(Tags.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(Tags tags) {
            this.tags = tags;
            return this;
        }

        public final String getAnycastIpListId() {
            return anycastIpListId;
        }

        public final void setAnycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
        }

        @Override
        public final Builder anycastIpListId(String anycastIpListId) {
            this.anycastIpListId = anycastIpListId;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectionGroupRequest build() {
            return new CreateConnectionGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
