/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A subscription configuration for additional CloudWatch metrics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RealtimeMetricsSubscriptionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RealtimeMetricsSubscriptionConfig.Builder, RealtimeMetricsSubscriptionConfig> {
    private static final SdkField<String> REALTIME_METRICS_SUBSCRIPTION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RealtimeMetricsSubscriptionStatus")
            .getter(getter(RealtimeMetricsSubscriptionConfig::realtimeMetricsSubscriptionStatusAsString))
            .setter(setter(Builder::realtimeMetricsSubscriptionStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealtimeMetricsSubscriptionStatus")
                    .unmarshallLocationName("RealtimeMetricsSubscriptionStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REALTIME_METRICS_SUBSCRIPTION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String realtimeMetricsSubscriptionStatus;

    private RealtimeMetricsSubscriptionConfig(BuilderImpl builder) {
        this.realtimeMetricsSubscriptionStatus = builder.realtimeMetricsSubscriptionStatus;
    }

    /**
     * <p>
     * A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #realtimeMetricsSubscriptionStatus} will return
     * {@link RealtimeMetricsSubscriptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #realtimeMetricsSubscriptionStatusAsString}.
     * </p>
     * 
     * @return A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront
     *         distribution.
     * @see RealtimeMetricsSubscriptionStatus
     */
    public final RealtimeMetricsSubscriptionStatus realtimeMetricsSubscriptionStatus() {
        return RealtimeMetricsSubscriptionStatus.fromValue(realtimeMetricsSubscriptionStatus);
    }

    /**
     * <p>
     * A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #realtimeMetricsSubscriptionStatus} will return
     * {@link RealtimeMetricsSubscriptionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #realtimeMetricsSubscriptionStatusAsString}.
     * </p>
     * 
     * @return A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront
     *         distribution.
     * @see RealtimeMetricsSubscriptionStatus
     */
    public final String realtimeMetricsSubscriptionStatusAsString() {
        return realtimeMetricsSubscriptionStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(realtimeMetricsSubscriptionStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RealtimeMetricsSubscriptionConfig)) {
            return false;
        }
        RealtimeMetricsSubscriptionConfig other = (RealtimeMetricsSubscriptionConfig) obj;
        return Objects.equals(realtimeMetricsSubscriptionStatusAsString(), other.realtimeMetricsSubscriptionStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RealtimeMetricsSubscriptionConfig")
                .add("RealtimeMetricsSubscriptionStatus", realtimeMetricsSubscriptionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RealtimeMetricsSubscriptionStatus":
            return Optional.ofNullable(clazz.cast(realtimeMetricsSubscriptionStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RealtimeMetricsSubscriptionStatus", REALTIME_METRICS_SUBSCRIPTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RealtimeMetricsSubscriptionConfig, T> g) {
        return obj -> g.apply((RealtimeMetricsSubscriptionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RealtimeMetricsSubscriptionConfig> {
        /**
         * <p>
         * A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
         * </p>
         * 
         * @param realtimeMetricsSubscriptionStatus
         *        A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront
         *        distribution.
         * @see RealtimeMetricsSubscriptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealtimeMetricsSubscriptionStatus
         */
        Builder realtimeMetricsSubscriptionStatus(String realtimeMetricsSubscriptionStatus);

        /**
         * <p>
         * A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront distribution.
         * </p>
         * 
         * @param realtimeMetricsSubscriptionStatus
         *        A flag that indicates whether additional CloudWatch metrics are enabled for a given CloudFront
         *        distribution.
         * @see RealtimeMetricsSubscriptionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RealtimeMetricsSubscriptionStatus
         */
        Builder realtimeMetricsSubscriptionStatus(RealtimeMetricsSubscriptionStatus realtimeMetricsSubscriptionStatus);
    }

    static final class BuilderImpl implements Builder {
        private String realtimeMetricsSubscriptionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(RealtimeMetricsSubscriptionConfig model) {
            realtimeMetricsSubscriptionStatus(model.realtimeMetricsSubscriptionStatus);
        }

        public final String getRealtimeMetricsSubscriptionStatus() {
            return realtimeMetricsSubscriptionStatus;
        }

        public final void setRealtimeMetricsSubscriptionStatus(String realtimeMetricsSubscriptionStatus) {
            this.realtimeMetricsSubscriptionStatus = realtimeMetricsSubscriptionStatus;
        }

        @Override
        public final Builder realtimeMetricsSubscriptionStatus(String realtimeMetricsSubscriptionStatus) {
            this.realtimeMetricsSubscriptionStatus = realtimeMetricsSubscriptionStatus;
            return this;
        }

        @Override
        public final Builder realtimeMetricsSubscriptionStatus(RealtimeMetricsSubscriptionStatus realtimeMetricsSubscriptionStatus) {
            this.realtimeMetricsSubscriptionStatus(realtimeMetricsSubscriptionStatus == null ? null
                    : realtimeMetricsSubscriptionStatus.toString());
            return this;
        }

        @Override
        public RealtimeMetricsSubscriptionConfig build() {
            return new RealtimeMetricsSubscriptionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
