/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudfront.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a response headers policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResponseHeadersPolicySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ResponseHeadersPolicySummary.Builder, ResponseHeadersPolicySummary> {
    private static final SdkField<String> TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Type")
            .getter(getter(ResponseHeadersPolicySummary::typeAsString))
            .setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type")
                    .unmarshallLocationName("Type").build()).build();

    private static final SdkField<ResponseHeadersPolicy> RESPONSE_HEADERS_POLICY_FIELD = SdkField
            .<ResponseHeadersPolicy> builder(MarshallingType.SDK_POJO)
            .memberName("ResponseHeadersPolicy")
            .getter(getter(ResponseHeadersPolicySummary::responseHeadersPolicy))
            .setter(setter(Builder::responseHeadersPolicy))
            .constructor(ResponseHeadersPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseHeadersPolicy")
                    .unmarshallLocationName("ResponseHeadersPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            RESPONSE_HEADERS_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final ResponseHeadersPolicy responseHeadersPolicy;

    private ResponseHeadersPolicySummary(BuilderImpl builder) {
        this.type = builder.type;
        this.responseHeadersPolicy = builder.responseHeadersPolicy;
    }

    /**
     * <p>
     * The type of response headers policy, either <code>managed</code> (created by Amazon Web Services) or
     * <code>custom</code> (created in this Amazon Web Services account).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResponseHeadersPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of response headers policy, either <code>managed</code> (created by Amazon Web Services) or
     *         <code>custom</code> (created in this Amazon Web Services account).
     * @see ResponseHeadersPolicyType
     */
    public final ResponseHeadersPolicyType type() {
        return ResponseHeadersPolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of response headers policy, either <code>managed</code> (created by Amazon Web Services) or
     * <code>custom</code> (created in this Amazon Web Services account).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResponseHeadersPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of response headers policy, either <code>managed</code> (created by Amazon Web Services) or
     *         <code>custom</code> (created in this Amazon Web Services account).
     * @see ResponseHeadersPolicyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The response headers policy.
     * </p>
     * 
     * @return The response headers policy.
     */
    public final ResponseHeadersPolicy responseHeadersPolicy() {
        return responseHeadersPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(responseHeadersPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResponseHeadersPolicySummary)) {
            return false;
        }
        ResponseHeadersPolicySummary other = (ResponseHeadersPolicySummary) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(responseHeadersPolicy(), other.responseHeadersPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResponseHeadersPolicySummary").add("Type", typeAsString())
                .add("ResponseHeadersPolicy", responseHeadersPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "ResponseHeadersPolicy":
            return Optional.ofNullable(clazz.cast(responseHeadersPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("ResponseHeadersPolicy", RESPONSE_HEADERS_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResponseHeadersPolicySummary, T> g) {
        return obj -> g.apply((ResponseHeadersPolicySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResponseHeadersPolicySummary> {
        /**
         * <p>
         * The type of response headers policy, either <code>managed</code> (created by Amazon Web Services) or
         * <code>custom</code> (created in this Amazon Web Services account).
         * </p>
         * 
         * @param type
         *        The type of response headers policy, either <code>managed</code> (created by Amazon Web Services) or
         *        <code>custom</code> (created in this Amazon Web Services account).
         * @see ResponseHeadersPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponseHeadersPolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of response headers policy, either <code>managed</code> (created by Amazon Web Services) or
         * <code>custom</code> (created in this Amazon Web Services account).
         * </p>
         * 
         * @param type
         *        The type of response headers policy, either <code>managed</code> (created by Amazon Web Services) or
         *        <code>custom</code> (created in this Amazon Web Services account).
         * @see ResponseHeadersPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResponseHeadersPolicyType
         */
        Builder type(ResponseHeadersPolicyType type);

        /**
         * <p>
         * The response headers policy.
         * </p>
         * 
         * @param responseHeadersPolicy
         *        The response headers policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseHeadersPolicy(ResponseHeadersPolicy responseHeadersPolicy);

        /**
         * <p>
         * The response headers policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResponseHeadersPolicy.Builder} avoiding
         * the need to create one manually via {@link ResponseHeadersPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseHeadersPolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #responseHeadersPolicy(ResponseHeadersPolicy)}.
         * 
         * @param responseHeadersPolicy
         *        a consumer that will call methods on {@link ResponseHeadersPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #responseHeadersPolicy(ResponseHeadersPolicy)
         */
        default Builder responseHeadersPolicy(Consumer<ResponseHeadersPolicy.Builder> responseHeadersPolicy) {
            return responseHeadersPolicy(ResponseHeadersPolicy.builder().applyMutation(responseHeadersPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private ResponseHeadersPolicy responseHeadersPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(ResponseHeadersPolicySummary model) {
            type(model.type);
            responseHeadersPolicy(model.responseHeadersPolicy);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResponseHeadersPolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final ResponseHeadersPolicy.Builder getResponseHeadersPolicy() {
            return responseHeadersPolicy != null ? responseHeadersPolicy.toBuilder() : null;
        }

        public final void setResponseHeadersPolicy(ResponseHeadersPolicy.BuilderImpl responseHeadersPolicy) {
            this.responseHeadersPolicy = responseHeadersPolicy != null ? responseHeadersPolicy.build() : null;
        }

        @Override
        public final Builder responseHeadersPolicy(ResponseHeadersPolicy responseHeadersPolicy) {
            this.responseHeadersPolicy = responseHeadersPolicy;
            return this;
        }

        @Override
        public ResponseHeadersPolicySummary build() {
            return new ResponseHeadersPolicySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
