/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.model.Event;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse;

public class LookupEventsIterable
implements SdkIterable<LookupEventsResponse> {
    private final CloudTrailClient client;
    private final LookupEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public LookupEventsIterable(CloudTrailClient client, LookupEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new LookupEventsResponseFetcher();
    }

    public Iterator<LookupEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Event> events() {
        Function<LookupEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final LookupEventsIterable resume(LookupEventsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new LookupEventsIterable(this.client, (LookupEventsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new LookupEventsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<LookupEventsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class LookupEventsResponseFetcher
    implements SyncPageFetcher<LookupEventsResponse> {
        private LookupEventsResponseFetcher() {
        }

        public boolean hasNextPage(LookupEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public LookupEventsResponse nextPage(LookupEventsResponse previousPage) {
            if (previousPage == null) {
                return LookupEventsIterable.this.client.lookupEvents(LookupEventsIterable.this.firstRequest);
            }
            return LookupEventsIterable.this.client.lookupEvents((LookupEventsRequest)((Object)LookupEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

