/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.model.Event;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse;

public class LookupEventsPublisher
implements SdkPublisher<LookupEventsResponse> {
    private final CloudTrailAsyncClient client;
    private final LookupEventsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public LookupEventsPublisher(CloudTrailAsyncClient client, LookupEventsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private LookupEventsPublisher(CloudTrailAsyncClient client, LookupEventsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new LookupEventsResponseFetcher();
    }

    public void subscribe(Subscriber<? super LookupEventsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Event> events() {
        Function<LookupEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new LookupEventsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class LookupEventsResponseFetcher
    implements AsyncPageFetcher<LookupEventsResponse> {
        private LookupEventsResponseFetcher() {
        }

        public boolean hasNextPage(LookupEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<LookupEventsResponse> nextPage(LookupEventsResponse previousPage) {
            if (previousPage == null) {
                return LookupEventsPublisher.this.client.lookupEvents(LookupEventsPublisher.this.firstRequest);
            }
            return LookupEventsPublisher.this.client.lookupEvents((LookupEventsRequest)((Object)LookupEventsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

