/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.metrics.publishers.cloudwatch.internal;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.metrics.publishers.cloudwatch.internal.CloudWatchMetricLogger;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;

@SdkInternalApi
public class MetricUploader {
    private final CloudWatchAsyncClient cloudWatchClient;

    public MetricUploader(CloudWatchAsyncClient cloudWatchClient) {
        this.cloudWatchClient = cloudWatchClient;
    }

    public CompletableFuture<Void> upload(List<PutMetricDataRequest> requests) {
        CompletableFuture[] publishResults = this.startCalls(requests);
        return CompletableFuture.allOf(publishResults).whenComplete((r, t) -> {
            int numRequests = publishResults.length;
            if (t != null) {
                CloudWatchMetricLogger.METRIC_LOGGER.warn(() -> "Failed while publishing some or all AWS SDK client-side metrics to CloudWatch.", t);
            } else {
                CloudWatchMetricLogger.METRIC_LOGGER.debug(() -> "Successfully published " + numRequests + " AWS SDK client-side metric requests to CloudWatch.");
            }
        });
    }

    private CompletableFuture<?>[] startCalls(List<PutMetricDataRequest> requests) {
        return (CompletableFuture[])requests.stream().peek(this::logRequest).map(arg_0 -> ((CloudWatchAsyncClient)this.cloudWatchClient).putMetricData(arg_0)).toArray(CompletableFuture[]::new);
    }

    private void logRequest(PutMetricDataRequest putMetricDataRequest) {
        CloudWatchMetricLogger.METRIC_LOGGER.trace(() -> "Sending request to CloudWatch: " + putMetricDataRequest);
    }

    public void close(boolean closeClient) {
        if (closeClient) {
            this.cloudWatchClient.close();
        }
    }
}

