/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.MessageData;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataResult;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataResultMessagesCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMetricDataResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, GetMetricDataResponse> {
    private static final SdkField<List<MetricDataResult>> METRIC_DATA_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetMetricDataResponse.getter(GetMetricDataResponse::metricDataResults)).setter(GetMetricDataResponse.setter(Builder::metricDataResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDataResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDataResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMetricDataResponse.getter(GetMetricDataResponse::nextToken)).setter(GetMetricDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<MessageData>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetMetricDataResponse.getter(GetMetricDataResponse::messages)).setter(GetMetricDataResponse.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_DATA_RESULTS_FIELD, NEXT_TOKEN_FIELD, MESSAGES_FIELD));
    private final List<MetricDataResult> metricDataResults;
    private final String nextToken;
    private final List<MessageData> messages;

    private GetMetricDataResponse(BuilderImpl builder) {
        super(builder);
        this.metricDataResults = builder.metricDataResults;
        this.nextToken = builder.nextToken;
        this.messages = builder.messages;
    }

    public boolean hasMetricDataResults() {
        return this.metricDataResults != null && !(this.metricDataResults instanceof SdkAutoConstructList);
    }

    public List<MetricDataResult> metricDataResults() {
        return this.metricDataResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasMessages() {
        return this.messages != null && !(this.messages instanceof SdkAutoConstructList);
    }

    public List<MessageData> messages() {
        return this.messages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDataResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.messages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricDataResponse)) {
            return false;
        }
        GetMetricDataResponse other = (GetMetricDataResponse)((Object)obj);
        return Objects.equals(this.metricDataResults(), other.metricDataResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.messages(), other.messages());
    }

    public String toString() {
        return ToString.builder((String)"GetMetricDataResponse").add("MetricDataResults", this.metricDataResults()).add("NextToken", (Object)this.nextToken()).add("Messages", this.messages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricDataResults": {
                return Optional.ofNullable(clazz.cast(this.metricDataResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMetricDataResponse, T> g) {
        return obj -> g.apply((GetMetricDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private List<MetricDataResult> metricDataResults = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private List<MessageData> messages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricDataResponse model) {
            super(model);
            this.metricDataResults(model.metricDataResults);
            this.nextToken(model.nextToken);
            this.messages(model.messages);
        }

        public final Collection<MetricDataResult.Builder> getMetricDataResults() {
            return this.metricDataResults != null ? (Collection)this.metricDataResults.stream().map(MetricDataResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricDataResults(Collection<MetricDataResult> metricDataResults) {
            this.metricDataResults = MetricDataResultsCopier.copy(metricDataResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataResults(MetricDataResult ... metricDataResults) {
            this.metricDataResults(Arrays.asList(metricDataResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDataResults(Consumer<MetricDataResult.Builder> ... metricDataResults) {
            this.metricDataResults(Stream.of(metricDataResults).map(c -> (MetricDataResult)((MetricDataResult.Builder)MetricDataResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricDataResults(Collection<MetricDataResult.BuilderImpl> metricDataResults) {
            this.metricDataResults = MetricDataResultsCopier.copyFromBuilder(metricDataResults);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<MessageData.Builder> getMessages() {
            return this.messages != null ? (Collection)this.messages.stream().map(MessageData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<MessageData> messages) {
            this.messages = MetricDataResultMessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(MessageData ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<MessageData.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (MessageData)((MessageData.Builder)MessageData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMessages(Collection<MessageData.BuilderImpl> messages) {
            this.messages = MetricDataResultMessagesCopier.copyFromBuilder(messages);
        }

        @Override
        public GetMetricDataResponse build() {
            return new GetMetricDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMetricDataResponse> {
        public Builder metricDataResults(Collection<MetricDataResult> var1);

        public Builder metricDataResults(MetricDataResult ... var1);

        public Builder metricDataResults(Consumer<MetricDataResult.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder messages(Collection<MessageData> var1);

        public Builder messages(MessageData ... var1);

        public Builder messages(Consumer<MessageData.Builder> ... var1);
    }
}

