/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatch.model.AlarmType;
import software.amazon.awssdk.services.cloudwatch.model.ContributorAttributesCopier;
import software.amazon.awssdk.services.cloudwatch.model.HistoryItemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AlarmHistoryItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AlarmHistoryItem> {
    private static final SdkField<String> ALARM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmName").getter(AlarmHistoryItem.getter(AlarmHistoryItem::alarmName)).setter(AlarmHistoryItem.setter(Builder::alarmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmName").build()}).build();
    private static final SdkField<String> ALARM_CONTRIBUTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmContributorId").getter(AlarmHistoryItem.getter(AlarmHistoryItem::alarmContributorId)).setter(AlarmHistoryItem.setter(Builder::alarmContributorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmContributorId").build()}).build();
    private static final SdkField<String> ALARM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlarmType").getter(AlarmHistoryItem.getter(AlarmHistoryItem::alarmTypeAsString)).setter(AlarmHistoryItem.setter(Builder::alarmType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmType").build()}).build();
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("Timestamp").getter(AlarmHistoryItem.getter(AlarmHistoryItem::timestamp)).setter(AlarmHistoryItem.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<String> HISTORY_ITEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HistoryItemType").getter(AlarmHistoryItem.getter(AlarmHistoryItem::historyItemTypeAsString)).setter(AlarmHistoryItem.setter(Builder::historyItemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoryItemType").build()}).build();
    private static final SdkField<String> HISTORY_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HistorySummary").getter(AlarmHistoryItem.getter(AlarmHistoryItem::historySummary)).setter(AlarmHistoryItem.setter(Builder::historySummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistorySummary").build()}).build();
    private static final SdkField<String> HISTORY_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HistoryData").getter(AlarmHistoryItem.getter(AlarmHistoryItem::historyData)).setter(AlarmHistoryItem.setter(Builder::historyData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HistoryData").build()}).build();
    private static final SdkField<Map<String, String>> ALARM_CONTRIBUTOR_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AlarmContributorAttributes").getter(AlarmHistoryItem.getter(AlarmHistoryItem::alarmContributorAttributes)).setter(AlarmHistoryItem.setter(Builder::alarmContributorAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlarmContributorAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_NAME_FIELD, ALARM_CONTRIBUTOR_ID_FIELD, ALARM_TYPE_FIELD, TIMESTAMP_FIELD, HISTORY_ITEM_TYPE_FIELD, HISTORY_SUMMARY_FIELD, HISTORY_DATA_FIELD, ALARM_CONTRIBUTOR_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AlarmHistoryItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String alarmName;
    private final String alarmContributorId;
    private final String alarmType;
    private final Instant timestamp;
    private final String historyItemType;
    private final String historySummary;
    private final String historyData;
    private final Map<String, String> alarmContributorAttributes;

    private AlarmHistoryItem(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.alarmContributorId = builder.alarmContributorId;
        this.alarmType = builder.alarmType;
        this.timestamp = builder.timestamp;
        this.historyItemType = builder.historyItemType;
        this.historySummary = builder.historySummary;
        this.historyData = builder.historyData;
        this.alarmContributorAttributes = builder.alarmContributorAttributes;
    }

    public final String alarmName() {
        return this.alarmName;
    }

    public final String alarmContributorId() {
        return this.alarmContributorId;
    }

    public final AlarmType alarmType() {
        return AlarmType.fromValue(this.alarmType);
    }

    public final String alarmTypeAsString() {
        return this.alarmType;
    }

    public final Instant timestamp() {
        return this.timestamp;
    }

    public final HistoryItemType historyItemType() {
        return HistoryItemType.fromValue(this.historyItemType);
    }

    public final String historyItemTypeAsString() {
        return this.historyItemType;
    }

    public final String historySummary() {
        return this.historySummary;
    }

    public final String historyData() {
        return this.historyData;
    }

    public final boolean hasAlarmContributorAttributes() {
        return this.alarmContributorAttributes != null && !(this.alarmContributorAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> alarmContributorAttributes() {
        return this.alarmContributorAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmContributorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.historyItemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.historySummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.historyData());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlarmContributorAttributes() ? this.alarmContributorAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlarmHistoryItem)) {
            return false;
        }
        AlarmHistoryItem other = (AlarmHistoryItem)obj;
        return Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.alarmContributorId(), other.alarmContributorId()) && Objects.equals(this.alarmTypeAsString(), other.alarmTypeAsString()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.historyItemTypeAsString(), other.historyItemTypeAsString()) && Objects.equals(this.historySummary(), other.historySummary()) && Objects.equals(this.historyData(), other.historyData()) && this.hasAlarmContributorAttributes() == other.hasAlarmContributorAttributes() && Objects.equals(this.alarmContributorAttributes(), other.alarmContributorAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"AlarmHistoryItem").add("AlarmName", (Object)this.alarmName()).add("AlarmContributorId", (Object)this.alarmContributorId()).add("AlarmType", (Object)this.alarmTypeAsString()).add("Timestamp", (Object)this.timestamp()).add("HistoryItemType", (Object)this.historyItemTypeAsString()).add("HistorySummary", (Object)this.historySummary()).add("HistoryData", (Object)this.historyData()).add("AlarmContributorAttributes", this.hasAlarmContributorAttributes() ? this.alarmContributorAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "AlarmContributorId": {
                return Optional.ofNullable(clazz.cast(this.alarmContributorId()));
            }
            case "AlarmType": {
                return Optional.ofNullable(clazz.cast(this.alarmTypeAsString()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "HistoryItemType": {
                return Optional.ofNullable(clazz.cast(this.historyItemTypeAsString()));
            }
            case "HistorySummary": {
                return Optional.ofNullable(clazz.cast(this.historySummary()));
            }
            case "HistoryData": {
                return Optional.ofNullable(clazz.cast(this.historyData()));
            }
            case "AlarmContributorAttributes": {
                return Optional.ofNullable(clazz.cast(this.alarmContributorAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AlarmName", ALARM_NAME_FIELD);
        map.put("AlarmContributorId", ALARM_CONTRIBUTOR_ID_FIELD);
        map.put("AlarmType", ALARM_TYPE_FIELD);
        map.put("Timestamp", TIMESTAMP_FIELD);
        map.put("HistoryItemType", HISTORY_ITEM_TYPE_FIELD);
        map.put("HistorySummary", HISTORY_SUMMARY_FIELD);
        map.put("HistoryData", HISTORY_DATA_FIELD);
        map.put("AlarmContributorAttributes", ALARM_CONTRIBUTOR_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AlarmHistoryItem, T> g) {
        return obj -> g.apply((AlarmHistoryItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alarmName;
        private String alarmContributorId;
        private String alarmType;
        private Instant timestamp;
        private String historyItemType;
        private String historySummary;
        private String historyData;
        private Map<String, String> alarmContributorAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AlarmHistoryItem model) {
            this.alarmName(model.alarmName);
            this.alarmContributorId(model.alarmContributorId);
            this.alarmType(model.alarmType);
            this.timestamp(model.timestamp);
            this.historyItemType(model.historyItemType);
            this.historySummary(model.historySummary);
            this.historyData(model.historyData);
            this.alarmContributorAttributes(model.alarmContributorAttributes);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final String getAlarmContributorId() {
            return this.alarmContributorId;
        }

        public final void setAlarmContributorId(String alarmContributorId) {
            this.alarmContributorId = alarmContributorId;
        }

        @Override
        public final Builder alarmContributorId(String alarmContributorId) {
            this.alarmContributorId = alarmContributorId;
            return this;
        }

        public final String getAlarmType() {
            return this.alarmType;
        }

        public final void setAlarmType(String alarmType) {
            this.alarmType = alarmType;
        }

        @Override
        public final Builder alarmType(String alarmType) {
            this.alarmType = alarmType;
            return this;
        }

        @Override
        public final Builder alarmType(AlarmType alarmType) {
            this.alarmType(alarmType == null ? null : alarmType.toString());
            return this;
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getHistoryItemType() {
            return this.historyItemType;
        }

        public final void setHistoryItemType(String historyItemType) {
            this.historyItemType = historyItemType;
        }

        @Override
        public final Builder historyItemType(String historyItemType) {
            this.historyItemType = historyItemType;
            return this;
        }

        @Override
        public final Builder historyItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType == null ? null : historyItemType.toString());
            return this;
        }

        public final String getHistorySummary() {
            return this.historySummary;
        }

        public final void setHistorySummary(String historySummary) {
            this.historySummary = historySummary;
        }

        @Override
        public final Builder historySummary(String historySummary) {
            this.historySummary = historySummary;
            return this;
        }

        public final String getHistoryData() {
            return this.historyData;
        }

        public final void setHistoryData(String historyData) {
            this.historyData = historyData;
        }

        @Override
        public final Builder historyData(String historyData) {
            this.historyData = historyData;
            return this;
        }

        public final Map<String, String> getAlarmContributorAttributes() {
            if (this.alarmContributorAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.alarmContributorAttributes;
        }

        public final void setAlarmContributorAttributes(Map<String, String> alarmContributorAttributes) {
            this.alarmContributorAttributes = ContributorAttributesCopier.copy(alarmContributorAttributes);
        }

        @Override
        public final Builder alarmContributorAttributes(Map<String, String> alarmContributorAttributes) {
            this.alarmContributorAttributes = ContributorAttributesCopier.copy(alarmContributorAttributes);
            return this;
        }

        public AlarmHistoryItem build() {
            return new AlarmHistoryItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AlarmHistoryItem> {
        public Builder alarmName(String var1);

        public Builder alarmContributorId(String var1);

        public Builder alarmType(String var1);

        public Builder alarmType(AlarmType var1);

        public Builder timestamp(Instant var1);

        public Builder historyItemType(String var1);

        public Builder historyItemType(HistoryItemType var1);

        public Builder historySummary(String var1);

        public Builder historyData(String var1);

        public Builder alarmContributorAttributes(Map<String, String> var1);
    }
}

