/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterLogEventsResponse extends CloudWatchLogsResponse implements
        ToCopyableBuilder<FilterLogEventsResponse.Builder, FilterLogEventsResponse> {
    private static final SdkField<List<FilteredLogEvent>> EVENTS_FIELD = SdkField
            .<List<FilteredLogEvent>> builder(MarshallingType.LIST)
            .memberName("events")
            .getter(getter(FilterLogEventsResponse::events))
            .setter(setter(Builder::events))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("events").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FilteredLogEvent> builder(MarshallingType.SDK_POJO)
                                            .constructor(FilteredLogEvent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SearchedLogStream>> SEARCHED_LOG_STREAMS_FIELD = SdkField
            .<List<SearchedLogStream>> builder(MarshallingType.LIST)
            .memberName("searchedLogStreams")
            .getter(getter(FilterLogEventsResponse::searchedLogStreams))
            .setter(setter(Builder::searchedLogStreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchedLogStreams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchedLogStream> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchedLogStream::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(FilterLogEventsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD,
            SEARCHED_LOG_STREAMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<FilteredLogEvent> events;

    private final List<SearchedLogStream> searchedLogStreams;

    private final String nextToken;

    private FilterLogEventsResponse(BuilderImpl builder) {
        super(builder);
        this.events = builder.events;
        this.searchedLogStreams = builder.searchedLogStreams;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Events property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEvents() {
        return events != null && !(events instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The matched events.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEvents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The matched events.
     */
    public final List<FilteredLogEvent> events() {
        return events;
    }

    /**
     * Returns true if the SearchedLogStreams property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSearchedLogStreams() {
        return searchedLogStreams != null && !(searchedLogStreams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <b>IMPORTANT</b> Starting on May 15, 2020, this parameter will be deprecated. This parameter will be an empty
     * list after the deprecation occurs.
     * </p>
     * <p>
     * Indicates which log streams have been searched and whether each has been searched completely.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSearchedLogStreams()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <b>IMPORTANT</b> Starting on May 15, 2020, this parameter will be deprecated. This parameter will be an
     *         empty list after the deprecation occurs.</p>
     *         <p>
     *         Indicates which log streams have been searched and whether each has been searched completely.
     */
    public final List<SearchedLogStream> searchedLogStreams() {
        return searchedLogStreams;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. The token expires after 24 hours.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. The token expires after 24 hours.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEvents() ? events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSearchedLogStreams() ? searchedLogStreams() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterLogEventsResponse)) {
            return false;
        }
        FilterLogEventsResponse other = (FilterLogEventsResponse) obj;
        return hasEvents() == other.hasEvents() && Objects.equals(events(), other.events())
                && hasSearchedLogStreams() == other.hasSearchedLogStreams()
                && Objects.equals(searchedLogStreams(), other.searchedLogStreams())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterLogEventsResponse").add("Events", hasEvents() ? events() : null)
                .add("SearchedLogStreams", hasSearchedLogStreams() ? searchedLogStreams() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "events":
            return Optional.ofNullable(clazz.cast(events()));
        case "searchedLogStreams":
            return Optional.ofNullable(clazz.cast(searchedLogStreams()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterLogEventsResponse, T> g) {
        return obj -> g.apply((FilterLogEventsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudWatchLogsResponse.Builder, SdkPojo, CopyableBuilder<Builder, FilterLogEventsResponse> {
        /**
         * <p>
         * The matched events.
         * </p>
         * 
         * @param events
         *        The matched events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(Collection<FilteredLogEvent> events);

        /**
         * <p>
         * The matched events.
         * </p>
         * 
         * @param events
         *        The matched events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder events(FilteredLogEvent... events);

        /**
         * <p>
         * The matched events.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FilteredLogEvent>.Builder} avoiding the
         * need to create one manually via {@link List<FilteredLogEvent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FilteredLogEvent>.Builder#build()} is called immediately and
         * its result is passed to {@link #events(List<FilteredLogEvent>)}.
         * 
         * @param events
         *        a consumer that will call methods on {@link List<FilteredLogEvent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #events(List<FilteredLogEvent>)
         */
        Builder events(Consumer<FilteredLogEvent.Builder>... events);

        /**
         * <p>
         * <b>IMPORTANT</b> Starting on May 15, 2020, this parameter will be deprecated. This parameter will be an empty
         * list after the deprecation occurs.
         * </p>
         * <p>
         * Indicates which log streams have been searched and whether each has been searched completely.
         * </p>
         * 
         * @param searchedLogStreams
         *        <b>IMPORTANT</b> Starting on May 15, 2020, this parameter will be deprecated. This parameter will be
         *        an empty list after the deprecation occurs.</p>
         *        <p>
         *        Indicates which log streams have been searched and whether each has been searched completely.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedLogStreams(Collection<SearchedLogStream> searchedLogStreams);

        /**
         * <p>
         * <b>IMPORTANT</b> Starting on May 15, 2020, this parameter will be deprecated. This parameter will be an empty
         * list after the deprecation occurs.
         * </p>
         * <p>
         * Indicates which log streams have been searched and whether each has been searched completely.
         * </p>
         * 
         * @param searchedLogStreams
         *        <b>IMPORTANT</b> Starting on May 15, 2020, this parameter will be deprecated. This parameter will be
         *        an empty list after the deprecation occurs.</p>
         *        <p>
         *        Indicates which log streams have been searched and whether each has been searched completely.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchedLogStreams(SearchedLogStream... searchedLogStreams);

        /**
         * <p>
         * <b>IMPORTANT</b> Starting on May 15, 2020, this parameter will be deprecated. This parameter will be an empty
         * list after the deprecation occurs.
         * </p>
         * <p>
         * Indicates which log streams have been searched and whether each has been searched completely.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SearchedLogStream>.Builder} avoiding the
         * need to create one manually via {@link List<SearchedLogStream>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SearchedLogStream>.Builder#build()} is called immediately
         * and its result is passed to {@link #searchedLogStreams(List<SearchedLogStream>)}.
         * 
         * @param searchedLogStreams
         *        a consumer that will call methods on {@link List<SearchedLogStream>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #searchedLogStreams(List<SearchedLogStream>)
         */
        Builder searchedLogStreams(Consumer<SearchedLogStream.Builder>... searchedLogStreams);

        /**
         * <p>
         * The token to use when requesting the next set of items. The token expires after 24 hours.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. The token expires after 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudWatchLogsResponse.BuilderImpl implements Builder {
        private List<FilteredLogEvent> events = DefaultSdkAutoConstructList.getInstance();

        private List<SearchedLogStream> searchedLogStreams = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterLogEventsResponse model) {
            super(model);
            events(model.events);
            searchedLogStreams(model.searchedLogStreams);
            nextToken(model.nextToken);
        }

        public final Collection<FilteredLogEvent.Builder> getEvents() {
            if (events instanceof SdkAutoConstructList) {
                return null;
            }
            return events != null ? events.stream().map(FilteredLogEvent::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder events(Collection<FilteredLogEvent> events) {
            this.events = FilteredLogEventsCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(FilteredLogEvent... events) {
            events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<FilteredLogEvent.Builder>... events) {
            events(Stream.of(events).map(c -> FilteredLogEvent.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEvents(Collection<FilteredLogEvent.BuilderImpl> events) {
            this.events = FilteredLogEventsCopier.copyFromBuilder(events);
        }

        public final Collection<SearchedLogStream.Builder> getSearchedLogStreams() {
            if (searchedLogStreams instanceof SdkAutoConstructList) {
                return null;
            }
            return searchedLogStreams != null ? searchedLogStreams.stream().map(SearchedLogStream::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder searchedLogStreams(Collection<SearchedLogStream> searchedLogStreams) {
            this.searchedLogStreams = SearchedLogStreamsCopier.copy(searchedLogStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchedLogStreams(SearchedLogStream... searchedLogStreams) {
            searchedLogStreams(Arrays.asList(searchedLogStreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchedLogStreams(Consumer<SearchedLogStream.Builder>... searchedLogStreams) {
            searchedLogStreams(Stream.of(searchedLogStreams).map(c -> SearchedLogStream.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSearchedLogStreams(Collection<SearchedLogStream.BuilderImpl> searchedLogStreams) {
            this.searchedLogStreams = SearchedLogStreamsCopier.copyFromBuilder(searchedLogStreams);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public FilterLogEventsResponse build() {
            return new FilterLogEventsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
