/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchlogs.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudwatchlogs.model.CloudWatchLogsRequest;
import software.amazon.awssdk.services.cloudwatchlogs.model.EvaluationFrequency;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateLogAnomalyDetectorRequest
extends CloudWatchLogsRequest
implements ToCopyableBuilder<Builder, UpdateLogAnomalyDetectorRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("anomalyDetectorArn").getter(UpdateLogAnomalyDetectorRequest.getter(UpdateLogAnomalyDetectorRequest::anomalyDetectorArn)).setter(UpdateLogAnomalyDetectorRequest.setter(Builder::anomalyDetectorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyDetectorArn").build()}).build();
    private static final SdkField<String> EVALUATION_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluationFrequency").getter(UpdateLogAnomalyDetectorRequest.getter(UpdateLogAnomalyDetectorRequest::evaluationFrequencyAsString)).setter(UpdateLogAnomalyDetectorRequest.setter(Builder::evaluationFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationFrequency").build()}).build();
    private static final SdkField<String> FILTER_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterPattern").getter(UpdateLogAnomalyDetectorRequest.getter(UpdateLogAnomalyDetectorRequest::filterPattern)).setter(UpdateLogAnomalyDetectorRequest.setter(Builder::filterPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterPattern").build()}).build();
    private static final SdkField<Long> ANOMALY_VISIBILITY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("anomalyVisibilityTime").getter(UpdateLogAnomalyDetectorRequest.getter(UpdateLogAnomalyDetectorRequest::anomalyVisibilityTime)).setter(UpdateLogAnomalyDetectorRequest.setter(Builder::anomalyVisibilityTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("anomalyVisibilityTime").build()}).build();
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enabled").getter(UpdateLogAnomalyDetectorRequest.getter(UpdateLogAnomalyDetectorRequest::enabled)).setter(UpdateLogAnomalyDetectorRequest.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD, EVALUATION_FREQUENCY_FIELD, FILTER_PATTERN_FIELD, ANOMALY_VISIBILITY_TIME_FIELD, ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateLogAnomalyDetectorRequest.memberNameToFieldInitializer();
    private final String anomalyDetectorArn;
    private final String evaluationFrequency;
    private final String filterPattern;
    private final Long anomalyVisibilityTime;
    private final Boolean enabled;

    private UpdateLogAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.evaluationFrequency = builder.evaluationFrequency;
        this.filterPattern = builder.filterPattern;
        this.anomalyVisibilityTime = builder.anomalyVisibilityTime;
        this.enabled = builder.enabled;
    }

    public final String anomalyDetectorArn() {
        return this.anomalyDetectorArn;
    }

    public final EvaluationFrequency evaluationFrequency() {
        return EvaluationFrequency.fromValue(this.evaluationFrequency);
    }

    public final String evaluationFrequencyAsString() {
        return this.evaluationFrequency;
    }

    public final String filterPattern() {
        return this.filterPattern;
    }

    public final Long anomalyVisibilityTime() {
        return this.anomalyVisibilityTime;
    }

    public final Boolean enabled() {
        return this.enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyVisibilityTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLogAnomalyDetectorRequest)) {
            return false;
        }
        UpdateLogAnomalyDetectorRequest other = (UpdateLogAnomalyDetectorRequest)((Object)obj);
        return Objects.equals(this.anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(this.evaluationFrequencyAsString(), other.evaluationFrequencyAsString()) && Objects.equals(this.filterPattern(), other.filterPattern()) && Objects.equals(this.anomalyVisibilityTime(), other.anomalyVisibilityTime()) && Objects.equals(this.enabled(), other.enabled());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateLogAnomalyDetectorRequest").add("AnomalyDetectorArn", (Object)this.anomalyDetectorArn()).add("EvaluationFrequency", (Object)this.evaluationFrequencyAsString()).add("FilterPattern", (Object)this.filterPattern()).add("AnomalyVisibilityTime", (Object)this.anomalyVisibilityTime()).add("Enabled", (Object)this.enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "anomalyDetectorArn": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorArn()));
            }
            case "evaluationFrequency": {
                return Optional.ofNullable(clazz.cast(this.evaluationFrequencyAsString()));
            }
            case "filterPattern": {
                return Optional.ofNullable(clazz.cast(this.filterPattern()));
            }
            case "anomalyVisibilityTime": {
                return Optional.ofNullable(clazz.cast(this.anomalyVisibilityTime()));
            }
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("anomalyDetectorArn", ANOMALY_DETECTOR_ARN_FIELD);
        map.put("evaluationFrequency", EVALUATION_FREQUENCY_FIELD);
        map.put("filterPattern", FILTER_PATTERN_FIELD);
        map.put("anomalyVisibilityTime", ANOMALY_VISIBILITY_TIME_FIELD);
        map.put("enabled", ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateLogAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((UpdateLogAnomalyDetectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchLogsRequest.BuilderImpl
    implements Builder {
        private String anomalyDetectorArn;
        private String evaluationFrequency;
        private String filterPattern;
        private Long anomalyVisibilityTime;
        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLogAnomalyDetectorRequest model) {
            super(model);
            this.anomalyDetectorArn(model.anomalyDetectorArn);
            this.evaluationFrequency(model.evaluationFrequency);
            this.filterPattern(model.filterPattern);
            this.anomalyVisibilityTime(model.anomalyVisibilityTime);
            this.enabled(model.enabled);
        }

        public final String getAnomalyDetectorArn() {
            return this.anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getEvaluationFrequency() {
            return this.evaluationFrequency;
        }

        public final void setEvaluationFrequency(String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
        }

        @Override
        public final Builder evaluationFrequency(String evaluationFrequency) {
            this.evaluationFrequency = evaluationFrequency;
            return this;
        }

        @Override
        public final Builder evaluationFrequency(EvaluationFrequency evaluationFrequency) {
            this.evaluationFrequency(evaluationFrequency == null ? null : evaluationFrequency.toString());
            return this;
        }

        public final String getFilterPattern() {
            return this.filterPattern;
        }

        public final void setFilterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
        }

        @Override
        public final Builder filterPattern(String filterPattern) {
            this.filterPattern = filterPattern;
            return this;
        }

        public final Long getAnomalyVisibilityTime() {
            return this.anomalyVisibilityTime;
        }

        public final void setAnomalyVisibilityTime(Long anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
        }

        @Override
        public final Builder anomalyVisibilityTime(Long anomalyVisibilityTime) {
            this.anomalyVisibilityTime = anomalyVisibilityTime;
            return this;
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLogAnomalyDetectorRequest build() {
            return new UpdateLogAnomalyDetectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudWatchLogsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateLogAnomalyDetectorRequest> {
        public Builder anomalyDetectorArn(String var1);

        public Builder evaluationFrequency(String var1);

        public Builder evaluationFrequency(EvaluationFrequency var1);

        public Builder filterPattern(String var1);

        public Builder anomalyVisibilityTime(Long var1);

        public Builder enabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

