/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetProjectsResponse extends CodeBuildResponse implements
        ToCopyableBuilder<BatchGetProjectsResponse.Builder, BatchGetProjectsResponse> {
    private static final SdkField<List<Project>> PROJECTS_FIELD = SdkField
            .<List<Project>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetProjectsResponse::projects))
            .setter(setter(Builder::projects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Project> builder(MarshallingType.SDK_POJO)
                                            .constructor(Project::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PROJECTS_NOT_FOUND_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(BatchGetProjectsResponse::projectsNotFound))
            .setter(setter(Builder::projectsNotFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectsNotFound").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECTS_FIELD,
            PROJECTS_NOT_FOUND_FIELD));

    private final List<Project> projects;

    private final List<String> projectsNotFound;

    private BatchGetProjectsResponse(BuilderImpl builder) {
        super(builder);
        this.projects = builder.projects;
        this.projectsNotFound = builder.projectsNotFound;
    }

    /**
     * Returns true if the Projects property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasProjects() {
        return projects != null && !(projects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the requested build projects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProjects()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the requested build projects.
     */
    public List<Project> projects() {
        return projects;
    }

    /**
     * Returns true if the ProjectsNotFound property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasProjectsNotFound() {
        return projectsNotFound != null && !(projectsNotFound instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names of build projects for which information could not be found.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProjectsNotFound()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of build projects for which information could not be found.
     */
    public List<String> projectsNotFound() {
        return projectsNotFound;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projects());
        hashCode = 31 * hashCode + Objects.hashCode(projectsNotFound());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetProjectsResponse)) {
            return false;
        }
        BatchGetProjectsResponse other = (BatchGetProjectsResponse) obj;
        return Objects.equals(projects(), other.projects()) && Objects.equals(projectsNotFound(), other.projectsNotFound());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchGetProjectsResponse").add("Projects", projects())
                .add("ProjectsNotFound", projectsNotFound()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projects":
            return Optional.ofNullable(clazz.cast(projects()));
        case "projectsNotFound":
            return Optional.ofNullable(clazz.cast(projectsNotFound()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetProjectsResponse, T> g) {
        return obj -> g.apply((BatchGetProjectsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, BatchGetProjectsResponse> {
        /**
         * <p>
         * Information about the requested build projects.
         * </p>
         * 
         * @param projects
         *        Information about the requested build projects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projects(Collection<Project> projects);

        /**
         * <p>
         * Information about the requested build projects.
         * </p>
         * 
         * @param projects
         *        Information about the requested build projects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projects(Project... projects);

        /**
         * <p>
         * Information about the requested build projects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Project>.Builder} avoiding the need to
         * create one manually via {@link List<Project>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Project>.Builder#build()} is called immediately and its
         * result is passed to {@link #projects(List<Project>)}.
         * 
         * @param projects
         *        a consumer that will call methods on {@link List<Project>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projects(List<Project>)
         */
        Builder projects(Consumer<Project.Builder>... projects);

        /**
         * <p>
         * The names of build projects for which information could not be found.
         * </p>
         * 
         * @param projectsNotFound
         *        The names of build projects for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectsNotFound(Collection<String> projectsNotFound);

        /**
         * <p>
         * The names of build projects for which information could not be found.
         * </p>
         * 
         * @param projectsNotFound
         *        The names of build projects for which information could not be found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectsNotFound(String... projectsNotFound);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private List<Project> projects = DefaultSdkAutoConstructList.getInstance();

        private List<String> projectsNotFound = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetProjectsResponse model) {
            super(model);
            projects(model.projects);
            projectsNotFound(model.projectsNotFound);
        }

        public final Collection<Project.Builder> getProjects() {
            return projects != null ? projects.stream().map(Project::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder projects(Collection<Project> projects) {
            this.projects = ProjectsCopier.copy(projects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Project... projects) {
            projects(Arrays.asList(projects));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projects(Consumer<Project.Builder>... projects) {
            projects(Stream.of(projects).map(c -> Project.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProjects(Collection<Project.BuilderImpl> projects) {
            this.projects = ProjectsCopier.copyFromBuilder(projects);
        }

        public final Collection<String> getProjectsNotFound() {
            return projectsNotFound;
        }

        @Override
        public final Builder projectsNotFound(Collection<String> projectsNotFound) {
            this.projectsNotFound = ProjectNamesCopier.copy(projectsNotFound);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectsNotFound(String... projectsNotFound) {
            projectsNotFound(Arrays.asList(projectsNotFound));
            return this;
        }

        public final void setProjectsNotFound(Collection<String> projectsNotFound) {
            this.projectsNotFound = ProjectNamesCopier.copy(projectsNotFound);
        }

        @Override
        public BatchGetProjectsResponse build() {
            return new BatchGetProjectsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
