/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about Amazon CloudWatch Logs for a build project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLogsConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLogsConfig.Builder, CloudWatchLogsConfig> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsConfig::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsConfig::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloudWatchLogsConfig::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            GROUP_NAME_FIELD, STREAM_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String groupName;

    private final String streamName;

    private CloudWatchLogsConfig(BuilderImpl builder) {
        this.status = builder.status;
        this.groupName = builder.groupName;
        this.streamName = builder.streamName;
    }

    /**
     * <p>
     * The current status of the logs in Amazon CloudWatch Logs for a build project. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>: Amazon CloudWatch Logs are enabled for this build project.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>: Amazon CloudWatch Logs are not enabled for this build project.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LogsConfigStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the logs in Amazon CloudWatch Logs for a build project. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code>: Amazon CloudWatch Logs are enabled for this build project.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code>: Amazon CloudWatch Logs are not enabled for this build project.
     *         </p>
     *         </li>
     * @see LogsConfigStatusType
     */
    public LogsConfigStatusType status() {
        return LogsConfigStatusType.fromValue(status);
    }

    /**
     * <p>
     * The current status of the logs in Amazon CloudWatch Logs for a build project. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code>: Amazon CloudWatch Logs are enabled for this build project.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code>: Amazon CloudWatch Logs are not enabled for this build project.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LogsConfigStatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the logs in Amazon CloudWatch Logs for a build project. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code>: Amazon CloudWatch Logs are enabled for this build project.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code>: Amazon CloudWatch Logs are not enabled for this build project.
     *         </p>
     *         </li>
     * @see LogsConfigStatusType
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The group name of the logs in Amazon CloudWatch Logs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working
     * with Log Groups and Log Streams</a>.
     * </p>
     * 
     * @return The group name of the logs in Amazon CloudWatch Logs. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html"
     *         >Working with Log Groups and Log Streams</a>.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The prefix of the stream name of the Amazon CloudWatch Logs. For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html">Working
     * with Log Groups and Log Streams</a>.
     * </p>
     * 
     * @return The prefix of the stream name of the Amazon CloudWatch Logs. For more information, see <a
     *         href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html"
     *         >Working with Log Groups and Log Streams</a>.
     */
    public String streamName() {
        return streamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsConfig)) {
            return false;
        }
        CloudWatchLogsConfig other = (CloudWatchLogsConfig) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(groupName(), other.groupName())
                && Objects.equals(streamName(), other.streamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CloudWatchLogsConfig").add("Status", statusAsString()).add("GroupName", groupName())
                .add("StreamName", streamName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "groupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "streamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogsConfig, T> g) {
        return obj -> g.apply((CloudWatchLogsConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLogsConfig> {
        /**
         * <p>
         * The current status of the logs in Amazon CloudWatch Logs for a build project. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code>: Amazon CloudWatch Logs are enabled for this build project.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code>: Amazon CloudWatch Logs are not enabled for this build project.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the logs in Amazon CloudWatch Logs for a build project. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code>: Amazon CloudWatch Logs are enabled for this build project.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code>: Amazon CloudWatch Logs are not enabled for this build project.
         *        </p>
         *        </li>
         * @see LogsConfigStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogsConfigStatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the logs in Amazon CloudWatch Logs for a build project. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code>: Amazon CloudWatch Logs are enabled for this build project.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code>: Amazon CloudWatch Logs are not enabled for this build project.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the logs in Amazon CloudWatch Logs for a build project. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code>: Amazon CloudWatch Logs are enabled for this build project.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code>: Amazon CloudWatch Logs are not enabled for this build project.
         *        </p>
         *        </li>
         * @see LogsConfigStatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LogsConfigStatusType
         */
        Builder status(LogsConfigStatusType status);

        /**
         * <p>
         * The group name of the logs in Amazon CloudWatch Logs. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html"
         * >Working with Log Groups and Log Streams</a>.
         * </p>
         * 
         * @param groupName
         *        The group name of the logs in Amazon CloudWatch Logs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html"
         *        >Working with Log Groups and Log Streams</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The prefix of the stream name of the Amazon CloudWatch Logs. For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html"
         * >Working with Log Groups and Log Streams</a>.
         * </p>
         * 
         * @param streamName
         *        The prefix of the stream name of the Amazon CloudWatch Logs. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html"
         *        >Working with Log Groups and Log Streams</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String groupName;

        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsConfig model) {
            status(model.status);
            groupName(model.groupName);
            streamName(model.streamName);
        }

        public final String getStatusAsString() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LogsConfigStatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public CloudWatchLogsConfig build() {
            return new CloudWatchLogsConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
