/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWebhookRequest extends CodeBuildRequest implements
        ToCopyableBuilder<CreateWebhookRequest.Builder, CreateWebhookRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateWebhookRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectName").build()).build();

    private static final SdkField<String> BRANCH_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateWebhookRequest::branchFilter)).setter(setter(Builder::branchFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("branchFilter").build()).build();

    private static final SdkField<List<List<WebhookFilter>>> FILTER_GROUPS_FIELD = SdkField
            .<List<List<WebhookFilter>>> builder(MarshallingType.LIST)
            .getter(getter(CreateWebhookRequest::filterGroups))
            .setter(setter(Builder::filterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<WebhookFilter>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<WebhookFilter> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(WebhookFilter::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            BRANCH_FILTER_FIELD, FILTER_GROUPS_FIELD));

    private final String projectName;

    private final String branchFilter;

    private final List<List<WebhookFilter>> filterGroups;

    private CreateWebhookRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.branchFilter = builder.branchFilter;
        this.filterGroups = builder.filterGroups;
    }

    /**
     * <p>
     * The name of the AWS CodeBuild project.
     * </p>
     * 
     * @return The name of the AWS CodeBuild project.
     */
    public String projectName() {
        return projectName;
    }

    /**
     * <p>
     * A regular expression used to determine which repository branches are built when a webhook is triggered. If the
     * name of a branch matches the regular expression, then it is built. If <code>branchFilter</code> is empty, then
     * all branches are built.
     * </p>
     * <note>
     * <p>
     * It is recommended that you use <code>filterGroups</code> instead of <code>branchFilter</code>.
     * </p>
     * </note>
     * 
     * @return A regular expression used to determine which repository branches are built when a webhook is triggered.
     *         If the name of a branch matches the regular expression, then it is built. If <code>branchFilter</code> is
     *         empty, then all branches are built.</p> <note>
     *         <p>
     *         It is recommended that you use <code>filterGroups</code> instead of <code>branchFilter</code>.
     *         </p>
     */
    public String branchFilter() {
        return branchFilter;
    }

    /**
     * Returns true if the FilterGroups property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilterGroups() {
        return filterGroups != null && !(filterGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of arrays of <code>WebhookFilter</code> objects used to determine which webhooks are triggered. At least
     * one <code>WebhookFilter</code> in the array must specify <code>EVENT</code> as its <code>type</code>.
     * </p>
     * <p>
     * For a build to be triggered, at least one filter group in the <code>filterGroups</code> array must pass. For a
     * filter group to pass, each of its filters must pass.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilterGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of arrays of <code>WebhookFilter</code> objects used to determine which webhooks are triggered.
     *         At least one <code>WebhookFilter</code> in the array must specify <code>EVENT</code> as its
     *         <code>type</code>. </p>
     *         <p>
     *         For a build to be triggered, at least one filter group in the <code>filterGroups</code> array must pass.
     *         For a filter group to pass, each of its filters must pass.
     */
    public List<List<WebhookFilter>> filterGroups() {
        return filterGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(branchFilter());
        hashCode = 31 * hashCode + Objects.hashCode(filterGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebhookRequest)) {
            return false;
        }
        CreateWebhookRequest other = (CreateWebhookRequest) obj;
        return Objects.equals(projectName(), other.projectName()) && Objects.equals(branchFilter(), other.branchFilter())
                && Objects.equals(filterGroups(), other.filterGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateWebhookRequest").add("ProjectName", projectName()).add("BranchFilter", branchFilter())
                .add("FilterGroups", filterGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "projectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "branchFilter":
            return Optional.ofNullable(clazz.cast(branchFilter()));
        case "filterGroups":
            return Optional.ofNullable(clazz.cast(filterGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateWebhookRequest, T> g) {
        return obj -> g.apply((CreateWebhookRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWebhookRequest> {
        /**
         * <p>
         * The name of the AWS CodeBuild project.
         * </p>
         * 
         * @param projectName
         *        The name of the AWS CodeBuild project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * A regular expression used to determine which repository branches are built when a webhook is triggered. If
         * the name of a branch matches the regular expression, then it is built. If <code>branchFilter</code> is empty,
         * then all branches are built.
         * </p>
         * <note>
         * <p>
         * It is recommended that you use <code>filterGroups</code> instead of <code>branchFilter</code>.
         * </p>
         * </note>
         * 
         * @param branchFilter
         *        A regular expression used to determine which repository branches are built when a webhook is
         *        triggered. If the name of a branch matches the regular expression, then it is built. If
         *        <code>branchFilter</code> is empty, then all branches are built.</p> <note>
         *        <p>
         *        It is recommended that you use <code>filterGroups</code> instead of <code>branchFilter</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder branchFilter(String branchFilter);

        /**
         * <p>
         * An array of arrays of <code>WebhookFilter</code> objects used to determine which webhooks are triggered. At
         * least one <code>WebhookFilter</code> in the array must specify <code>EVENT</code> as its <code>type</code>.
         * </p>
         * <p>
         * For a build to be triggered, at least one filter group in the <code>filterGroups</code> array must pass. For
         * a filter group to pass, each of its filters must pass.
         * </p>
         * 
         * @param filterGroups
         *        An array of arrays of <code>WebhookFilter</code> objects used to determine which webhooks are
         *        triggered. At least one <code>WebhookFilter</code> in the array must specify <code>EVENT</code> as its
         *        <code>type</code>. </p>
         *        <p>
         *        For a build to be triggered, at least one filter group in the <code>filterGroups</code> array must
         *        pass. For a filter group to pass, each of its filters must pass.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterGroups(Collection<? extends Collection<WebhookFilter>> filterGroups);

        /**
         * <p>
         * An array of arrays of <code>WebhookFilter</code> objects used to determine which webhooks are triggered. At
         * least one <code>WebhookFilter</code> in the array must specify <code>EVENT</code> as its <code>type</code>.
         * </p>
         * <p>
         * For a build to be triggered, at least one filter group in the <code>filterGroups</code> array must pass. For
         * a filter group to pass, each of its filters must pass.
         * </p>
         * 
         * @param filterGroups
         *        An array of arrays of <code>WebhookFilter</code> objects used to determine which webhooks are
         *        triggered. At least one <code>WebhookFilter</code> in the array must specify <code>EVENT</code> as its
         *        <code>type</code>. </p>
         *        <p>
         *        For a build to be triggered, at least one filter group in the <code>filterGroups</code> array must
         *        pass. For a filter group to pass, each of its filters must pass.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterGroups(Collection<WebhookFilter>... filterGroups);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeBuildRequest.BuilderImpl implements Builder {
        private String projectName;

        private String branchFilter;

        private List<List<WebhookFilter>> filterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebhookRequest model) {
            super(model);
            projectName(model.projectName);
            branchFilter(model.branchFilter);
            filterGroups(model.filterGroups);
        }

        public final String getProjectName() {
            return projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        public final String getBranchFilter() {
            return branchFilter;
        }

        @Override
        public final Builder branchFilter(String branchFilter) {
            this.branchFilter = branchFilter;
            return this;
        }

        public final void setBranchFilter(String branchFilter) {
            this.branchFilter = branchFilter;
        }

        public final Collection<? extends Collection<WebhookFilter>> getFilterGroups() {
            return filterGroups;
        }

        @Override
        public final Builder filterGroups(Collection<? extends Collection<WebhookFilter>> filterGroups) {
            this.filterGroups = FilterGroupsCopier.copy(filterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filterGroups(Collection<WebhookFilter>... filterGroups) {
            filterGroups(Arrays.asList(filterGroups));
            return this;
        }

        public final void setFilterGroups(Collection<? extends Collection<WebhookFilter>> filterGroups) {
            this.filterGroups = FilterGroupsCopier.copy(filterGroups);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWebhookRequest build() {
            return new CreateWebhookRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
