/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTestCasesResponse extends CodeBuildResponse implements
        ToCopyableBuilder<DescribeTestCasesResponse.Builder, DescribeTestCasesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeTestCasesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<TestCase>> TEST_CASES_FIELD = SdkField
            .<List<TestCase>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTestCasesResponse::testCases))
            .setter(setter(Builder::testCases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TestCase> builder(MarshallingType.SDK_POJO)
                                            .constructor(TestCase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TEST_CASES_FIELD));

    private final String nextToken;

    private final List<TestCase> testCases;

    private DescribeTestCasesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.testCases = builder.testCases;
    }

    /**
     * <p>
     * During a previous call, the maximum number of items that can be returned is the value specified in
     * <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is
     * returned. To get the next batch of items in the list, call this operation again, adding the next token to the
     * call. To get all of the items in the list, keep calling this operation with each subsequent next token that is
     * returned, until no more next tokens are returned.
     * </p>
     * 
     * @return During a previous call, the maximum number of items that can be returned is the value specified in
     *         <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i>
     *         is returned. To get the next batch of items in the list, call this operation again, adding the next token
     *         to the call. To get all of the items in the list, keep calling this operation with each subsequent next
     *         token that is returned, until no more next tokens are returned.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the TestCases property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTestCases() {
        return testCases != null && !(testCases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The returned list of test cases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTestCases()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The returned list of test cases.
     */
    public List<TestCase> testCases() {
        return testCases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(testCases());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTestCasesResponse)) {
            return false;
        }
        DescribeTestCasesResponse other = (DescribeTestCasesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(testCases(), other.testCases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTestCasesResponse").add("NextToken", nextToken()).add("TestCases", testCases()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "testCases":
            return Optional.ofNullable(clazz.cast(testCases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTestCasesResponse, T> g) {
        return obj -> g.apply((DescribeTestCasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeBuildResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTestCasesResponse> {
        /**
         * <p>
         * During a previous call, the maximum number of items that can be returned is the value specified in
         * <code>maxResults</code>. If there more items in the list, then a unique string called a <i>nextToken</i> is
         * returned. To get the next batch of items in the list, call this operation again, adding the next token to the
         * call. To get all of the items in the list, keep calling this operation with each subsequent next token that
         * is returned, until no more next tokens are returned.
         * </p>
         * 
         * @param nextToken
         *        During a previous call, the maximum number of items that can be returned is the value specified in
         *        <code>maxResults</code>. If there more items in the list, then a unique string called a
         *        <i>nextToken</i> is returned. To get the next batch of items in the list, call this operation again,
         *        adding the next token to the call. To get all of the items in the list, keep calling this operation
         *        with each subsequent next token that is returned, until no more next tokens are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The returned list of test cases.
         * </p>
         * 
         * @param testCases
         *        The returned list of test cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCases(Collection<TestCase> testCases);

        /**
         * <p>
         * The returned list of test cases.
         * </p>
         * 
         * @param testCases
         *        The returned list of test cases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCases(TestCase... testCases);

        /**
         * <p>
         * The returned list of test cases.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TestCase>.Builder} avoiding the need to
         * create one manually via {@link List<TestCase>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TestCase>.Builder#build()} is called immediately and its
         * result is passed to {@link #testCases(List<TestCase>)}.
         * 
         * @param testCases
         *        a consumer that will call methods on {@link List<TestCase>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testCases(List<TestCase>)
         */
        Builder testCases(Consumer<TestCase.Builder>... testCases);
    }

    static final class BuilderImpl extends CodeBuildResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<TestCase> testCases = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTestCasesResponse model) {
            super(model);
            nextToken(model.nextToken);
            testCases(model.testCases);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<TestCase.Builder> getTestCases() {
            return testCases != null ? testCases.stream().map(TestCase::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder testCases(Collection<TestCase> testCases) {
            this.testCases = TestCasesCopier.copy(testCases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testCases(TestCase... testCases) {
            testCases(Arrays.asList(testCases));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testCases(Consumer<TestCase.Builder>... testCases) {
            testCases(Stream.of(testCases).map(c -> TestCase.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTestCases(Collection<TestCase.BuilderImpl> testCases) {
            this.testCases = TestCasesCopier.copyFromBuilder(testCases);
        }

        @Override
        public DescribeTestCasesResponse build() {
            return new DescribeTestCasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
