/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the location where the run of a report is exported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportExportConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ReportExportConfig.Builder, ReportExportConfig> {
    private static final SdkField<String> EXPORT_CONFIG_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReportExportConfig::exportConfigTypeAsString)).setter(setter(Builder::exportConfigType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportConfigType").build()).build();

    private static final SdkField<S3ReportExportConfig> S3_DESTINATION_FIELD = SdkField
            .<S3ReportExportConfig> builder(MarshallingType.SDK_POJO).getter(getter(ReportExportConfig::s3Destination))
            .setter(setter(Builder::s3Destination)).constructor(S3ReportExportConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Destination").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_CONFIG_TYPE_FIELD,
            S3_DESTINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String exportConfigType;

    private final S3ReportExportConfig s3Destination;

    private ReportExportConfig(BuilderImpl builder) {
        this.exportConfigType = builder.exportConfigType;
        this.s3Destination = builder.s3Destination;
    }

    /**
     * <p>
     * The export configuration type. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>S3</code>: The report results are exported to an S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_EXPORT</code>: The report results are not exported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportConfigType}
     * will return {@link ReportExportConfigType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #exportConfigTypeAsString}.
     * </p>
     * 
     * @return The export configuration type. Valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>S3</code>: The report results are exported to an S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_EXPORT</code>: The report results are not exported.
     *         </p>
     *         </li>
     * @see ReportExportConfigType
     */
    public ReportExportConfigType exportConfigType() {
        return ReportExportConfigType.fromValue(exportConfigType);
    }

    /**
     * <p>
     * The export configuration type. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>S3</code>: The report results are exported to an S3 bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_EXPORT</code>: The report results are not exported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #exportConfigType}
     * will return {@link ReportExportConfigType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #exportConfigTypeAsString}.
     * </p>
     * 
     * @return The export configuration type. Valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>S3</code>: The report results are exported to an S3 bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_EXPORT</code>: The report results are not exported.
     *         </p>
     *         </li>
     * @see ReportExportConfigType
     */
    public String exportConfigTypeAsString() {
        return exportConfigType;
    }

    /**
     * <p>
     * A <code>S3ReportExportConfig</code> object that contains information about the S3 bucket where the run of a
     * report is exported.
     * </p>
     * 
     * @return A <code>S3ReportExportConfig</code> object that contains information about the S3 bucket where the run of
     *         a report is exported.
     */
    public S3ReportExportConfig s3Destination() {
        return s3Destination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportConfigTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Destination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportExportConfig)) {
            return false;
        }
        ReportExportConfig other = (ReportExportConfig) obj;
        return Objects.equals(exportConfigTypeAsString(), other.exportConfigTypeAsString())
                && Objects.equals(s3Destination(), other.s3Destination());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReportExportConfig").add("ExportConfigType", exportConfigTypeAsString())
                .add("S3Destination", s3Destination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportConfigType":
            return Optional.ofNullable(clazz.cast(exportConfigTypeAsString()));
        case "s3Destination":
            return Optional.ofNullable(clazz.cast(s3Destination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportExportConfig, T> g) {
        return obj -> g.apply((ReportExportConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportExportConfig> {
        /**
         * <p>
         * The export configuration type. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>S3</code>: The report results are exported to an S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_EXPORT</code>: The report results are not exported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exportConfigType
         *        The export configuration type. Valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>S3</code>: The report results are exported to an S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_EXPORT</code>: The report results are not exported.
         *        </p>
         *        </li>
         * @see ReportExportConfigType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportExportConfigType
         */
        Builder exportConfigType(String exportConfigType);

        /**
         * <p>
         * The export configuration type. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>S3</code>: The report results are exported to an S3 bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_EXPORT</code>: The report results are not exported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param exportConfigType
         *        The export configuration type. Valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>S3</code>: The report results are exported to an S3 bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_EXPORT</code>: The report results are not exported.
         *        </p>
         *        </li>
         * @see ReportExportConfigType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReportExportConfigType
         */
        Builder exportConfigType(ReportExportConfigType exportConfigType);

        /**
         * <p>
         * A <code>S3ReportExportConfig</code> object that contains information about the S3 bucket where the run of a
         * report is exported.
         * </p>
         * 
         * @param s3Destination
         *        A <code>S3ReportExportConfig</code> object that contains information about the S3 bucket where the run
         *        of a report is exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Destination(S3ReportExportConfig s3Destination);

        /**
         * <p>
         * A <code>S3ReportExportConfig</code> object that contains information about the S3 bucket where the run of a
         * report is exported.
         * </p>
         * This is a convenience that creates an instance of the {@link S3ReportExportConfig.Builder} avoiding the need
         * to create one manually via {@link S3ReportExportConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3ReportExportConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Destination(S3ReportExportConfig)}.
         * 
         * @param s3Destination
         *        a consumer that will call methods on {@link S3ReportExportConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Destination(S3ReportExportConfig)
         */
        default Builder s3Destination(Consumer<S3ReportExportConfig.Builder> s3Destination) {
            return s3Destination(S3ReportExportConfig.builder().applyMutation(s3Destination).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String exportConfigType;

        private S3ReportExportConfig s3Destination;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportExportConfig model) {
            exportConfigType(model.exportConfigType);
            s3Destination(model.s3Destination);
        }

        public final String getExportConfigTypeAsString() {
            return exportConfigType;
        }

        @Override
        public final Builder exportConfigType(String exportConfigType) {
            this.exportConfigType = exportConfigType;
            return this;
        }

        @Override
        public final Builder exportConfigType(ReportExportConfigType exportConfigType) {
            this.exportConfigType(exportConfigType == null ? null : exportConfigType.toString());
            return this;
        }

        public final void setExportConfigType(String exportConfigType) {
            this.exportConfigType = exportConfigType;
        }

        public final S3ReportExportConfig.Builder getS3Destination() {
            return s3Destination != null ? s3Destination.toBuilder() : null;
        }

        @Override
        public final Builder s3Destination(S3ReportExportConfig s3Destination) {
            this.s3Destination = s3Destination;
            return this;
        }

        public final void setS3Destination(S3ReportExportConfig.BuilderImpl s3Destination) {
            this.s3Destination = s3Destination != null ? s3Destination.build() : null;
        }

        @Override
        public ReportExportConfig build() {
            return new ReportExportConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
