/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ArtifactsType {
    CODEPIPELINE("CODEPIPELINE"),
    S3("S3"),
    NO_ARTIFACTS("NO_ARTIFACTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ArtifactsType> VALUE_MAP;
    private final String value;

    private ArtifactsType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ArtifactsType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ArtifactsType> knownValues() {
        EnumSet<ArtifactsType> knownValues = EnumSet.allOf(ArtifactsType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ArtifactsType.class, ArtifactsType::toString);
    }
}

