/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codebuild.model.CodeBuildRequest;
import software.amazon.awssdk.services.codebuild.model.LogsConfig;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifacts;
import software.amazon.awssdk.services.codebuild.model.ProjectArtifactsListCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectBuildBatchConfig;
import software.amazon.awssdk.services.codebuild.model.ProjectCache;
import software.amazon.awssdk.services.codebuild.model.ProjectEnvironment;
import software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocation;
import software.amazon.awssdk.services.codebuild.model.ProjectFileSystemLocationsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSecondarySourceVersionsCopier;
import software.amazon.awssdk.services.codebuild.model.ProjectSource;
import software.amazon.awssdk.services.codebuild.model.ProjectSourceVersion;
import software.amazon.awssdk.services.codebuild.model.ProjectSourcesCopier;
import software.amazon.awssdk.services.codebuild.model.Tag;
import software.amazon.awssdk.services.codebuild.model.TagListCopier;
import software.amazon.awssdk.services.codebuild.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateProjectRequest
extends CodeBuildRequest
implements ToCopyableBuilder<Builder, CreateProjectRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateProjectRequest.getter(CreateProjectRequest::name)).setter(CreateProjectRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateProjectRequest.getter(CreateProjectRequest::description)).setter(CreateProjectRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<ProjectSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("source").getter(CreateProjectRequest.getter(CreateProjectRequest::source)).setter(CreateProjectRequest.setter(Builder::source)).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()}).build();
    private static final SdkField<List<ProjectSource>> SECONDARY_SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondarySources").getter(CreateProjectRequest.getter(CreateProjectRequest::secondarySources)).setter(CreateProjectRequest.setter(Builder::secondarySources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceVersion").getter(CreateProjectRequest.getter(CreateProjectRequest::sourceVersion)).setter(CreateProjectRequest.setter(Builder::sourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVersion").build()}).build();
    private static final SdkField<List<ProjectSourceVersion>> SECONDARY_SOURCE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondarySourceVersions").getter(CreateProjectRequest.getter(CreateProjectRequest::secondarySourceVersions)).setter(CreateProjectRequest.setter(Builder::secondarySourceVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondarySourceVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectSourceVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectArtifacts> ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("artifacts").getter(CreateProjectRequest.getter(CreateProjectRequest::artifacts)).setter(CreateProjectRequest.setter(Builder::artifacts)).constructor(ProjectArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifacts").build()}).build();
    private static final SdkField<List<ProjectArtifacts>> SECONDARY_ARTIFACTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secondaryArtifacts").getter(CreateProjectRequest.getter(CreateProjectRequest::secondaryArtifacts)).setter(CreateProjectRequest.setter(Builder::secondaryArtifacts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secondaryArtifacts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectArtifacts::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectCache> CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cache").getter(CreateProjectRequest.getter(CreateProjectRequest::cache)).setter(CreateProjectRequest.setter(Builder::cache)).constructor(ProjectCache::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cache").build()}).build();
    private static final SdkField<ProjectEnvironment> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environment").getter(CreateProjectRequest.getter(CreateProjectRequest::environment)).setter(CreateProjectRequest.setter(Builder::environment)).constructor(ProjectEnvironment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()}).build();
    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRole").getter(CreateProjectRequest.getter(CreateProjectRequest::serviceRole)).setter(CreateProjectRequest.setter(Builder::serviceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRole").build()}).build();
    private static final SdkField<Integer> TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutInMinutes").getter(CreateProjectRequest.getter(CreateProjectRequest::timeoutInMinutes)).setter(CreateProjectRequest.setter(Builder::timeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInMinutes").build()}).build();
    private static final SdkField<Integer> QUEUED_TIMEOUT_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("queuedTimeoutInMinutes").getter(CreateProjectRequest.getter(CreateProjectRequest::queuedTimeoutInMinutes)).setter(CreateProjectRequest.setter(Builder::queuedTimeoutInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queuedTimeoutInMinutes").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encryptionKey").getter(CreateProjectRequest.getter(CreateProjectRequest::encryptionKey)).setter(CreateProjectRequest.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionKey").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateProjectRequest.getter(CreateProjectRequest::tags)).setter(CreateProjectRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vpcConfig").getter(CreateProjectRequest.getter(CreateProjectRequest::vpcConfig)).setter(CreateProjectRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfig").build()}).build();
    private static final SdkField<Boolean> BADGE_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("badgeEnabled").getter(CreateProjectRequest.getter(CreateProjectRequest::badgeEnabled)).setter(CreateProjectRequest.setter(Builder::badgeEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("badgeEnabled").build()}).build();
    private static final SdkField<LogsConfig> LOGS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logsConfig").getter(CreateProjectRequest.getter(CreateProjectRequest::logsConfig)).setter(CreateProjectRequest.setter(Builder::logsConfig)).constructor(LogsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logsConfig").build()}).build();
    private static final SdkField<List<ProjectFileSystemLocation>> FILE_SYSTEM_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("fileSystemLocations").getter(CreateProjectRequest.getter(CreateProjectRequest::fileSystemLocations)).setter(CreateProjectRequest.setter(Builder::fileSystemLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProjectFileSystemLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ProjectBuildBatchConfig> BUILD_BATCH_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("buildBatchConfig").getter(CreateProjectRequest.getter(CreateProjectRequest::buildBatchConfig)).setter(CreateProjectRequest.setter(Builder::buildBatchConfig)).constructor(ProjectBuildBatchConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildBatchConfig").build()}).build();
    private static final SdkField<Integer> CONCURRENT_BUILD_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("concurrentBuildLimit").getter(CreateProjectRequest.getter(CreateProjectRequest::concurrentBuildLimit)).setter(CreateProjectRequest.setter(Builder::concurrentBuildLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrentBuildLimit").build()}).build();
    private static final SdkField<Integer> AUTO_RETRY_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("autoRetryLimit").getter(CreateProjectRequest.getter(CreateProjectRequest::autoRetryLimit)).setter(CreateProjectRequest.setter(Builder::autoRetryLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRetryLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SOURCE_FIELD, SECONDARY_SOURCES_FIELD, SOURCE_VERSION_FIELD, SECONDARY_SOURCE_VERSIONS_FIELD, ARTIFACTS_FIELD, SECONDARY_ARTIFACTS_FIELD, CACHE_FIELD, ENVIRONMENT_FIELD, SERVICE_ROLE_FIELD, TIMEOUT_IN_MINUTES_FIELD, QUEUED_TIMEOUT_IN_MINUTES_FIELD, ENCRYPTION_KEY_FIELD, TAGS_FIELD, VPC_CONFIG_FIELD, BADGE_ENABLED_FIELD, LOGS_CONFIG_FIELD, FILE_SYSTEM_LOCATIONS_FIELD, BUILD_BATCH_CONFIG_FIELD, CONCURRENT_BUILD_LIMIT_FIELD, AUTO_RETRY_LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateProjectRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final ProjectSource source;
    private final List<ProjectSource> secondarySources;
    private final String sourceVersion;
    private final List<ProjectSourceVersion> secondarySourceVersions;
    private final ProjectArtifacts artifacts;
    private final List<ProjectArtifacts> secondaryArtifacts;
    private final ProjectCache cache;
    private final ProjectEnvironment environment;
    private final String serviceRole;
    private final Integer timeoutInMinutes;
    private final Integer queuedTimeoutInMinutes;
    private final String encryptionKey;
    private final List<Tag> tags;
    private final VpcConfig vpcConfig;
    private final Boolean badgeEnabled;
    private final LogsConfig logsConfig;
    private final List<ProjectFileSystemLocation> fileSystemLocations;
    private final ProjectBuildBatchConfig buildBatchConfig;
    private final Integer concurrentBuildLimit;
    private final Integer autoRetryLimit;

    private CreateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.source = builder.source;
        this.secondarySources = builder.secondarySources;
        this.sourceVersion = builder.sourceVersion;
        this.secondarySourceVersions = builder.secondarySourceVersions;
        this.artifacts = builder.artifacts;
        this.secondaryArtifacts = builder.secondaryArtifacts;
        this.cache = builder.cache;
        this.environment = builder.environment;
        this.serviceRole = builder.serviceRole;
        this.timeoutInMinutes = builder.timeoutInMinutes;
        this.queuedTimeoutInMinutes = builder.queuedTimeoutInMinutes;
        this.encryptionKey = builder.encryptionKey;
        this.tags = builder.tags;
        this.vpcConfig = builder.vpcConfig;
        this.badgeEnabled = builder.badgeEnabled;
        this.logsConfig = builder.logsConfig;
        this.fileSystemLocations = builder.fileSystemLocations;
        this.buildBatchConfig = builder.buildBatchConfig;
        this.concurrentBuildLimit = builder.concurrentBuildLimit;
        this.autoRetryLimit = builder.autoRetryLimit;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ProjectSource source() {
        return this.source;
    }

    public final boolean hasSecondarySources() {
        return this.secondarySources != null && !(this.secondarySources instanceof SdkAutoConstructList);
    }

    public final List<ProjectSource> secondarySources() {
        return this.secondarySources;
    }

    public final String sourceVersion() {
        return this.sourceVersion;
    }

    public final boolean hasSecondarySourceVersions() {
        return this.secondarySourceVersions != null && !(this.secondarySourceVersions instanceof SdkAutoConstructList);
    }

    public final List<ProjectSourceVersion> secondarySourceVersions() {
        return this.secondarySourceVersions;
    }

    public final ProjectArtifacts artifacts() {
        return this.artifacts;
    }

    public final boolean hasSecondaryArtifacts() {
        return this.secondaryArtifacts != null && !(this.secondaryArtifacts instanceof SdkAutoConstructList);
    }

    public final List<ProjectArtifacts> secondaryArtifacts() {
        return this.secondaryArtifacts;
    }

    public final ProjectCache cache() {
        return this.cache;
    }

    public final ProjectEnvironment environment() {
        return this.environment;
    }

    public final String serviceRole() {
        return this.serviceRole;
    }

    public final Integer timeoutInMinutes() {
        return this.timeoutInMinutes;
    }

    public final Integer queuedTimeoutInMinutes() {
        return this.queuedTimeoutInMinutes;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final Boolean badgeEnabled() {
        return this.badgeEnabled;
    }

    public final LogsConfig logsConfig() {
        return this.logsConfig;
    }

    public final boolean hasFileSystemLocations() {
        return this.fileSystemLocations != null && !(this.fileSystemLocations instanceof SdkAutoConstructList);
    }

    public final List<ProjectFileSystemLocation> fileSystemLocations() {
        return this.fileSystemLocations;
    }

    public final ProjectBuildBatchConfig buildBatchConfig() {
        return this.buildBatchConfig;
    }

    public final Integer concurrentBuildLimit() {
        return this.concurrentBuildLimit;
    }

    public final Integer autoRetryLimit() {
        return this.autoRetryLimit;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySources() ? this.secondarySources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondarySourceVersions() ? this.secondarySourceVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.artifacts());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecondaryArtifacts() ? this.secondaryArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cache());
        hashCode = 31 * hashCode + Objects.hashCode(this.environment());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.queuedTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.badgeEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.logsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFileSystemLocations() ? this.fileSystemLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.buildBatchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrentBuildLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRetryLimit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.source(), other.source()) && this.hasSecondarySources() == other.hasSecondarySources() && Objects.equals(this.secondarySources(), other.secondarySources()) && Objects.equals(this.sourceVersion(), other.sourceVersion()) && this.hasSecondarySourceVersions() == other.hasSecondarySourceVersions() && Objects.equals(this.secondarySourceVersions(), other.secondarySourceVersions()) && Objects.equals(this.artifacts(), other.artifacts()) && this.hasSecondaryArtifacts() == other.hasSecondaryArtifacts() && Objects.equals(this.secondaryArtifacts(), other.secondaryArtifacts()) && Objects.equals(this.cache(), other.cache()) && Objects.equals(this.environment(), other.environment()) && Objects.equals(this.serviceRole(), other.serviceRole()) && Objects.equals(this.timeoutInMinutes(), other.timeoutInMinutes()) && Objects.equals(this.queuedTimeoutInMinutes(), other.queuedTimeoutInMinutes()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.badgeEnabled(), other.badgeEnabled()) && Objects.equals(this.logsConfig(), other.logsConfig()) && this.hasFileSystemLocations() == other.hasFileSystemLocations() && Objects.equals(this.fileSystemLocations(), other.fileSystemLocations()) && Objects.equals(this.buildBatchConfig(), other.buildBatchConfig()) && Objects.equals(this.concurrentBuildLimit(), other.concurrentBuildLimit()) && Objects.equals(this.autoRetryLimit(), other.autoRetryLimit());
    }

    public final String toString() {
        return ToString.builder((String)"CreateProjectRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Source", (Object)this.source()).add("SecondarySources", this.hasSecondarySources() ? this.secondarySources() : null).add("SourceVersion", (Object)this.sourceVersion()).add("SecondarySourceVersions", this.hasSecondarySourceVersions() ? this.secondarySourceVersions() : null).add("Artifacts", (Object)this.artifacts()).add("SecondaryArtifacts", this.hasSecondaryArtifacts() ? this.secondaryArtifacts() : null).add("Cache", (Object)this.cache()).add("Environment", (Object)this.environment()).add("ServiceRole", (Object)this.serviceRole()).add("TimeoutInMinutes", (Object)this.timeoutInMinutes()).add("QueuedTimeoutInMinutes", (Object)this.queuedTimeoutInMinutes()).add("EncryptionKey", (Object)this.encryptionKey()).add("Tags", this.hasTags() ? this.tags() : null).add("VpcConfig", (Object)this.vpcConfig()).add("BadgeEnabled", (Object)this.badgeEnabled()).add("LogsConfig", (Object)this.logsConfig()).add("FileSystemLocations", this.hasFileSystemLocations() ? this.fileSystemLocations() : null).add("BuildBatchConfig", (Object)this.buildBatchConfig()).add("ConcurrentBuildLimit", (Object)this.concurrentBuildLimit()).add("AutoRetryLimit", (Object)this.autoRetryLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "secondarySources": {
                return Optional.ofNullable(clazz.cast(this.secondarySources()));
            }
            case "sourceVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceVersion()));
            }
            case "secondarySourceVersions": {
                return Optional.ofNullable(clazz.cast(this.secondarySourceVersions()));
            }
            case "artifacts": {
                return Optional.ofNullable(clazz.cast(this.artifacts()));
            }
            case "secondaryArtifacts": {
                return Optional.ofNullable(clazz.cast(this.secondaryArtifacts()));
            }
            case "cache": {
                return Optional.ofNullable(clazz.cast(this.cache()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "serviceRole": {
                return Optional.ofNullable(clazz.cast(this.serviceRole()));
            }
            case "timeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutInMinutes()));
            }
            case "queuedTimeoutInMinutes": {
                return Optional.ofNullable(clazz.cast(this.queuedTimeoutInMinutes()));
            }
            case "encryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "vpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "badgeEnabled": {
                return Optional.ofNullable(clazz.cast(this.badgeEnabled()));
            }
            case "logsConfig": {
                return Optional.ofNullable(clazz.cast(this.logsConfig()));
            }
            case "fileSystemLocations": {
                return Optional.ofNullable(clazz.cast(this.fileSystemLocations()));
            }
            case "buildBatchConfig": {
                return Optional.ofNullable(clazz.cast(this.buildBatchConfig()));
            }
            case "concurrentBuildLimit": {
                return Optional.ofNullable(clazz.cast(this.concurrentBuildLimit()));
            }
            case "autoRetryLimit": {
                return Optional.ofNullable(clazz.cast(this.autoRetryLimit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("secondarySources", SECONDARY_SOURCES_FIELD);
        map.put("sourceVersion", SOURCE_VERSION_FIELD);
        map.put("secondarySourceVersions", SECONDARY_SOURCE_VERSIONS_FIELD);
        map.put("artifacts", ARTIFACTS_FIELD);
        map.put("secondaryArtifacts", SECONDARY_ARTIFACTS_FIELD);
        map.put("cache", CACHE_FIELD);
        map.put("environment", ENVIRONMENT_FIELD);
        map.put("serviceRole", SERVICE_ROLE_FIELD);
        map.put("timeoutInMinutes", TIMEOUT_IN_MINUTES_FIELD);
        map.put("queuedTimeoutInMinutes", QUEUED_TIMEOUT_IN_MINUTES_FIELD);
        map.put("encryptionKey", ENCRYPTION_KEY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("vpcConfig", VPC_CONFIG_FIELD);
        map.put("badgeEnabled", BADGE_ENABLED_FIELD);
        map.put("logsConfig", LOGS_CONFIG_FIELD);
        map.put("fileSystemLocations", FILE_SYSTEM_LOCATIONS_FIELD);
        map.put("buildBatchConfig", BUILD_BATCH_CONFIG_FIELD);
        map.put("concurrentBuildLimit", CONCURRENT_BUILD_LIMIT_FIELD);
        map.put("autoRetryLimit", AUTO_RETRY_LIMIT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectRequest, T> g) {
        return obj -> g.apply((CreateProjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeBuildRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private ProjectSource source;
        private List<ProjectSource> secondarySources = DefaultSdkAutoConstructList.getInstance();
        private String sourceVersion;
        private List<ProjectSourceVersion> secondarySourceVersions = DefaultSdkAutoConstructList.getInstance();
        private ProjectArtifacts artifacts;
        private List<ProjectArtifacts> secondaryArtifacts = DefaultSdkAutoConstructList.getInstance();
        private ProjectCache cache;
        private ProjectEnvironment environment;
        private String serviceRole;
        private Integer timeoutInMinutes;
        private Integer queuedTimeoutInMinutes;
        private String encryptionKey;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private VpcConfig vpcConfig;
        private Boolean badgeEnabled;
        private LogsConfig logsConfig;
        private List<ProjectFileSystemLocation> fileSystemLocations = DefaultSdkAutoConstructList.getInstance();
        private ProjectBuildBatchConfig buildBatchConfig;
        private Integer concurrentBuildLimit;
        private Integer autoRetryLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.source(model.source);
            this.secondarySources(model.secondarySources);
            this.sourceVersion(model.sourceVersion);
            this.secondarySourceVersions(model.secondarySourceVersions);
            this.artifacts(model.artifacts);
            this.secondaryArtifacts(model.secondaryArtifacts);
            this.cache(model.cache);
            this.environment(model.environment);
            this.serviceRole(model.serviceRole);
            this.timeoutInMinutes(model.timeoutInMinutes);
            this.queuedTimeoutInMinutes(model.queuedTimeoutInMinutes);
            this.encryptionKey(model.encryptionKey);
            this.tags(model.tags);
            this.vpcConfig(model.vpcConfig);
            this.badgeEnabled(model.badgeEnabled);
            this.logsConfig(model.logsConfig);
            this.fileSystemLocations(model.fileSystemLocations);
            this.buildBatchConfig(model.buildBatchConfig);
            this.concurrentBuildLimit(model.concurrentBuildLimit);
            this.autoRetryLimit(model.autoRetryLimit);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ProjectSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        public final void setSource(ProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(ProjectSource source) {
            this.source = source;
            return this;
        }

        public final List<ProjectSource.Builder> getSecondarySources() {
            List<ProjectSource.Builder> result = ProjectSourcesCopier.copyToBuilder(this.secondarySources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySources(Collection<ProjectSource.BuilderImpl> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copyFromBuilder(secondarySources);
        }

        @Override
        public final Builder secondarySources(Collection<ProjectSource> secondarySources) {
            this.secondarySources = ProjectSourcesCopier.copy(secondarySources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(ProjectSource ... secondarySources) {
            this.secondarySources(Arrays.asList(secondarySources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySources(Consumer<ProjectSource.Builder> ... secondarySources) {
            this.secondarySources(Stream.of(secondarySources).map(c -> (ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceVersion() {
            return this.sourceVersion;
        }

        public final void setSourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
        }

        @Override
        public final Builder sourceVersion(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            return this;
        }

        public final List<ProjectSourceVersion.Builder> getSecondarySourceVersions() {
            List<ProjectSourceVersion.Builder> result = ProjectSecondarySourceVersionsCopier.copyToBuilder(this.secondarySourceVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondarySourceVersions(Collection<ProjectSourceVersion.BuilderImpl> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copyFromBuilder(secondarySourceVersions);
        }

        @Override
        public final Builder secondarySourceVersions(Collection<ProjectSourceVersion> secondarySourceVersions) {
            this.secondarySourceVersions = ProjectSecondarySourceVersionsCopier.copy(secondarySourceVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(ProjectSourceVersion ... secondarySourceVersions) {
            this.secondarySourceVersions(Arrays.asList(secondarySourceVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder> ... secondarySourceVersions) {
            this.secondarySourceVersions(Stream.of(secondarySourceVersions).map(c -> (ProjectSourceVersion)((ProjectSourceVersion.Builder)ProjectSourceVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectArtifacts.Builder getArtifacts() {
            return this.artifacts != null ? this.artifacts.toBuilder() : null;
        }

        public final void setArtifacts(ProjectArtifacts.BuilderImpl artifacts) {
            this.artifacts = artifacts != null ? artifacts.build() : null;
        }

        @Override
        public final Builder artifacts(ProjectArtifacts artifacts) {
            this.artifacts = artifacts;
            return this;
        }

        public final List<ProjectArtifacts.Builder> getSecondaryArtifacts() {
            List<ProjectArtifacts.Builder> result = ProjectArtifactsListCopier.copyToBuilder(this.secondaryArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryArtifacts(Collection<ProjectArtifacts.BuilderImpl> secondaryArtifacts) {
            this.secondaryArtifacts = ProjectArtifactsListCopier.copyFromBuilder(secondaryArtifacts);
        }

        @Override
        public final Builder secondaryArtifacts(Collection<ProjectArtifacts> secondaryArtifacts) {
            this.secondaryArtifacts = ProjectArtifactsListCopier.copy(secondaryArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(ProjectArtifacts ... secondaryArtifacts) {
            this.secondaryArtifacts(Arrays.asList(secondaryArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(Consumer<ProjectArtifacts.Builder> ... secondaryArtifacts) {
            this.secondaryArtifacts(Stream.of(secondaryArtifacts).map(c -> (ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectCache.Builder getCache() {
            return this.cache != null ? this.cache.toBuilder() : null;
        }

        public final void setCache(ProjectCache.BuilderImpl cache) {
            this.cache = cache != null ? cache.build() : null;
        }

        @Override
        public final Builder cache(ProjectCache cache) {
            this.cache = cache;
            return this;
        }

        public final ProjectEnvironment.Builder getEnvironment() {
            return this.environment != null ? this.environment.toBuilder() : null;
        }

        public final void setEnvironment(ProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(ProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final Integer getTimeoutInMinutes() {
            return this.timeoutInMinutes;
        }

        public final void setTimeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
        }

        @Override
        public final Builder timeoutInMinutes(Integer timeoutInMinutes) {
            this.timeoutInMinutes = timeoutInMinutes;
            return this;
        }

        public final Integer getQueuedTimeoutInMinutes() {
            return this.queuedTimeoutInMinutes;
        }

        public final void setQueuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
        }

        @Override
        public final Builder queuedTimeoutInMinutes(Integer queuedTimeoutInMinutes) {
            this.queuedTimeoutInMinutes = queuedTimeoutInMinutes;
            return this;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Boolean getBadgeEnabled() {
            return this.badgeEnabled;
        }

        public final void setBadgeEnabled(Boolean badgeEnabled) {
            this.badgeEnabled = badgeEnabled;
        }

        @Override
        public final Builder badgeEnabled(Boolean badgeEnabled) {
            this.badgeEnabled = badgeEnabled;
            return this;
        }

        public final LogsConfig.Builder getLogsConfig() {
            return this.logsConfig != null ? this.logsConfig.toBuilder() : null;
        }

        public final void setLogsConfig(LogsConfig.BuilderImpl logsConfig) {
            this.logsConfig = logsConfig != null ? logsConfig.build() : null;
        }

        @Override
        public final Builder logsConfig(LogsConfig logsConfig) {
            this.logsConfig = logsConfig;
            return this;
        }

        public final List<ProjectFileSystemLocation.Builder> getFileSystemLocations() {
            List<ProjectFileSystemLocation.Builder> result = ProjectFileSystemLocationsCopier.copyToBuilder(this.fileSystemLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFileSystemLocations(Collection<ProjectFileSystemLocation.BuilderImpl> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copyFromBuilder(fileSystemLocations);
        }

        @Override
        public final Builder fileSystemLocations(Collection<ProjectFileSystemLocation> fileSystemLocations) {
            this.fileSystemLocations = ProjectFileSystemLocationsCopier.copy(fileSystemLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(ProjectFileSystemLocation ... fileSystemLocations) {
            this.fileSystemLocations(Arrays.asList(fileSystemLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder> ... fileSystemLocations) {
            this.fileSystemLocations(Stream.of(fileSystemLocations).map(c -> (ProjectFileSystemLocation)((ProjectFileSystemLocation.Builder)ProjectFileSystemLocation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ProjectBuildBatchConfig.Builder getBuildBatchConfig() {
            return this.buildBatchConfig != null ? this.buildBatchConfig.toBuilder() : null;
        }

        public final void setBuildBatchConfig(ProjectBuildBatchConfig.BuilderImpl buildBatchConfig) {
            this.buildBatchConfig = buildBatchConfig != null ? buildBatchConfig.build() : null;
        }

        @Override
        public final Builder buildBatchConfig(ProjectBuildBatchConfig buildBatchConfig) {
            this.buildBatchConfig = buildBatchConfig;
            return this;
        }

        public final Integer getConcurrentBuildLimit() {
            return this.concurrentBuildLimit;
        }

        public final void setConcurrentBuildLimit(Integer concurrentBuildLimit) {
            this.concurrentBuildLimit = concurrentBuildLimit;
        }

        @Override
        public final Builder concurrentBuildLimit(Integer concurrentBuildLimit) {
            this.concurrentBuildLimit = concurrentBuildLimit;
            return this;
        }

        public final Integer getAutoRetryLimit() {
            return this.autoRetryLimit;
        }

        public final void setAutoRetryLimit(Integer autoRetryLimit) {
            this.autoRetryLimit = autoRetryLimit;
        }

        @Override
        public final Builder autoRetryLimit(Integer autoRetryLimit) {
            this.autoRetryLimit = autoRetryLimit;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectRequest build() {
            return new CreateProjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeBuildRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateProjectRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder source(ProjectSource var1);

        default public Builder source(Consumer<ProjectSource.Builder> source) {
            return this.source((ProjectSource)((ProjectSource.Builder)ProjectSource.builder().applyMutation(source)).build());
        }

        public Builder secondarySources(Collection<ProjectSource> var1);

        public Builder secondarySources(ProjectSource ... var1);

        public Builder secondarySources(Consumer<ProjectSource.Builder> ... var1);

        public Builder sourceVersion(String var1);

        public Builder secondarySourceVersions(Collection<ProjectSourceVersion> var1);

        public Builder secondarySourceVersions(ProjectSourceVersion ... var1);

        public Builder secondarySourceVersions(Consumer<ProjectSourceVersion.Builder> ... var1);

        public Builder artifacts(ProjectArtifacts var1);

        default public Builder artifacts(Consumer<ProjectArtifacts.Builder> artifacts) {
            return this.artifacts((ProjectArtifacts)((ProjectArtifacts.Builder)ProjectArtifacts.builder().applyMutation(artifacts)).build());
        }

        public Builder secondaryArtifacts(Collection<ProjectArtifacts> var1);

        public Builder secondaryArtifacts(ProjectArtifacts ... var1);

        public Builder secondaryArtifacts(Consumer<ProjectArtifacts.Builder> ... var1);

        public Builder cache(ProjectCache var1);

        default public Builder cache(Consumer<ProjectCache.Builder> cache) {
            return this.cache((ProjectCache)((ProjectCache.Builder)ProjectCache.builder().applyMutation(cache)).build());
        }

        public Builder environment(ProjectEnvironment var1);

        default public Builder environment(Consumer<ProjectEnvironment.Builder> environment) {
            return this.environment((ProjectEnvironment)((ProjectEnvironment.Builder)ProjectEnvironment.builder().applyMutation(environment)).build());
        }

        public Builder serviceRole(String var1);

        public Builder timeoutInMinutes(Integer var1);

        public Builder queuedTimeoutInMinutes(Integer var1);

        public Builder encryptionKey(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder badgeEnabled(Boolean var1);

        public Builder logsConfig(LogsConfig var1);

        default public Builder logsConfig(Consumer<LogsConfig.Builder> logsConfig) {
            return this.logsConfig((LogsConfig)((LogsConfig.Builder)LogsConfig.builder().applyMutation(logsConfig)).build());
        }

        public Builder fileSystemLocations(Collection<ProjectFileSystemLocation> var1);

        public Builder fileSystemLocations(ProjectFileSystemLocation ... var1);

        public Builder fileSystemLocations(Consumer<ProjectFileSystemLocation.Builder> ... var1);

        public Builder buildBatchConfig(ProjectBuildBatchConfig var1);

        default public Builder buildBatchConfig(Consumer<ProjectBuildBatchConfig.Builder> buildBatchConfig) {
            return this.buildBatchConfig((ProjectBuildBatchConfig)((ProjectBuildBatchConfig.Builder)ProjectBuildBatchConfig.builder().applyMutation(buildBatchConfig)).build());
        }

        public Builder concurrentBuildLimit(Integer var1);

        public Builder autoRetryLimit(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

