/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.jmespath.component;

import software.amazon.awssdk.codegen.jmespath.component.FunctionExpression;
import software.amazon.awssdk.codegen.jmespath.component.MultiSelectHash;
import software.amazon.awssdk.codegen.jmespath.component.MultiSelectList;
import software.amazon.awssdk.codegen.jmespath.component.WildcardExpression;
import software.amazon.awssdk.codegen.jmespath.parser.JmesPathVisitor;
import software.amazon.awssdk.utils.Validate;

public class SubExpressionRight {
    private String identifier;
    private MultiSelectList multiSelectList;
    private MultiSelectHash multiSelectHash;
    private FunctionExpression functionExpression;
    private WildcardExpression wildcardExpression;

    public static SubExpressionRight identifier(String identifier) {
        Validate.notNull((Object)identifier, (String)"identifier", (Object[])new Object[0]);
        SubExpressionRight result = new SubExpressionRight();
        result.identifier = identifier;
        return result;
    }

    public static SubExpressionRight multiSelectList(MultiSelectList multiSelectList) {
        Validate.notNull((Object)multiSelectList, (String)"multiSelectList", (Object[])new Object[0]);
        SubExpressionRight result = new SubExpressionRight();
        result.multiSelectList = multiSelectList;
        return result;
    }

    public static SubExpressionRight multiSelectHash(MultiSelectHash multiSelectHash) {
        Validate.notNull((Object)multiSelectHash, (String)"multiSelectHash", (Object[])new Object[0]);
        SubExpressionRight result = new SubExpressionRight();
        result.multiSelectHash = multiSelectHash;
        return result;
    }

    public static SubExpressionRight functionExpression(FunctionExpression functionExpression) {
        Validate.notNull((Object)functionExpression, (String)"functionExpression", (Object[])new Object[0]);
        SubExpressionRight result = new SubExpressionRight();
        result.functionExpression = functionExpression;
        return result;
    }

    public static SubExpressionRight wildcardExpression(WildcardExpression wildcardExpression) {
        Validate.notNull((Object)wildcardExpression, (String)"wildcardExpression", (Object[])new Object[0]);
        SubExpressionRight result = new SubExpressionRight();
        result.wildcardExpression = wildcardExpression;
        return result;
    }

    public boolean isIdentifier() {
        return this.identifier != null;
    }

    public boolean isMultiSelectList() {
        return this.multiSelectList != null;
    }

    public boolean isMultiSelectHash() {
        return this.multiSelectHash != null;
    }

    public boolean isFunctionExpression() {
        return this.functionExpression != null;
    }

    public boolean isWildcardExpression() {
        return this.wildcardExpression != null;
    }

    public String asIdentifier() {
        Validate.validState((boolean)this.isIdentifier(), (String)"Not an Identifier", (Object[])new Object[0]);
        return this.identifier;
    }

    public MultiSelectList asMultiSelectList() {
        Validate.validState((boolean)this.isMultiSelectList(), (String)"Not a MultiSelectList", (Object[])new Object[0]);
        return this.multiSelectList;
    }

    public MultiSelectHash asMultiSelectHash() {
        Validate.validState((boolean)this.isMultiSelectHash(), (String)"Not a MultiSelectHash", (Object[])new Object[0]);
        return this.multiSelectHash;
    }

    public FunctionExpression asFunctionExpression() {
        Validate.validState((boolean)this.isFunctionExpression(), (String)"Not a FunctionExpression", (Object[])new Object[0]);
        return this.functionExpression;
    }

    public WildcardExpression asWildcardExpression() {
        Validate.validState((boolean)this.isWildcardExpression(), (String)"Not a WildcardExpression", (Object[])new Object[0]);
        return this.wildcardExpression;
    }

    public void visit(JmesPathVisitor visitor) {
        if (this.isIdentifier()) {
            visitor.visitIdentifier(this.asIdentifier());
        } else if (this.isMultiSelectList()) {
            visitor.visitMultiSelectList(this.asMultiSelectList());
        } else if (this.isMultiSelectHash()) {
            visitor.visitMultiSelectHash(this.asMultiSelectHash());
        } else if (this.isFunctionExpression()) {
            visitor.visitFunctionExpression(this.asFunctionExpression());
        } else if (this.isWildcardExpression()) {
            visitor.visitWildcardExpression(this.asWildcardExpression());
        } else {
            throw new IllegalStateException();
        }
    }
}

