/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.service;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.Validate;

public class PaginatorDefinition {
    private static final String VALID_REGEX = "[a-zA-Z.]+";
    private List<String> inputToken;
    private List<String> outputToken;
    private List<String> resultKey;
    private String moreResults;
    private String limitKey;

    public List<String> getInputToken() {
        return this.inputToken;
    }

    public void setInputToken(List<String> inputToken) {
        this.inputToken = inputToken;
    }

    public List<String> getOutputToken() {
        return this.outputToken;
    }

    public void setOutputToken(List<String> outputToken) {
        this.outputToken = outputToken;
    }

    public List<String> getResultKey() {
        return this.resultKey;
    }

    public void setResultKey(List<String> resultKey) {
        this.resultKey = resultKey;
    }

    public String getMoreResults() {
        return this.moreResults;
    }

    public void setMoreResults(String moreResults) {
        this.moreResults = moreResults;
    }

    public String getLimitKey() {
        return this.limitKey;
    }

    public void setLimitKey(String limitKey) {
        this.limitKey = limitKey;
    }

    public boolean isValid() {
        Pattern p = Pattern.compile(VALID_REGEX);
        return !CollectionUtils.isNullOrEmpty(this.inputToken) && !CollectionUtils.isNullOrEmpty(this.outputToken) && this.outputToken.stream().allMatch(t -> p.matcher((CharSequence)t).matches());
    }

    private List<String> asList(JrsValue node) {
        if (node.isArray()) {
            ArrayList<String> output = new ArrayList<String>();
            Iterator elements = ((JrsArray)node).elements();
            elements.forEachRemaining(v -> output.add(this.asString((JrsValue)v)));
            return output;
        }
        return Collections.singletonList(this.asString(node));
    }

    private String asString(JrsValue value) {
        Validate.isTrue((value.asToken() == JsonToken.VALUE_STRING ? 1 : 0) != 0, (String)("Expected a string node: " + value), (Object[])new Object[0]);
        return value.asText();
    }

    public void setLimit_key(String limitKey) {
        this.limitKey = limitKey;
    }

    public void setInput_token(JrsValue inputToken) {
        this.inputToken = this.asList(inputToken);
    }

    public void setOutput_token(JrsValue outputToken) {
        this.outputToken = this.asList(outputToken);
    }

    public void setResult_key(JrsValue resultKey) {
        this.resultKey = this.asList(resultKey);
    }

    public void setMore_results(String moreResults) {
        this.moreResults = moreResults;
    }
}

