/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

public final class BeanGetterHelper {
    private final PoetExtensions poetExtensions;
    private final ServiceModelCopiers copiers;
    private final TypeProvider typeProvider;

    public BeanGetterHelper(PoetExtensions poetExtensions, ServiceModelCopiers copiers, TypeProvider typeProvider) {
        this.poetExtensions = poetExtensions;
        this.copiers = copiers;
        this.typeProvider = typeProvider;
    }

    public MethodSpec beanStyleGetter(MemberModel memberModel) {
        if (memberModel.hasBuilder()) {
            return this.builderGetter(memberModel);
        }
        if (memberModel.containsBuildable()) {
            return this.buildableContainerGetter(memberModel);
        }
        if (memberModel.isSdkBytesType()) {
            return this.byteBufferGetter(memberModel);
        }
        if (memberModel.isList() && memberModel.getListModel().getListMemberModel().isSdkBytesType()) {
            return this.listByteBufferGetter(memberModel);
        }
        if (memberModel.isMap() && memberModel.getMapModel().getValueModel().isSdkBytesType()) {
            return this.mapByteBufferGetter(memberModel);
        }
        return this.regularGetter(memberModel);
    }

    private MethodSpec buildableContainerGetter(MemberModel memberModel) {
        TypeName returnType = this.typeProvider.typeName(memberModel, new TypeProvider.TypeNameOptions().shapeTransformation(TypeProvider.ShapeTransformation.USE_BUILDER).useByteBufferTypes(true));
        ClassName copierClass = this.copiers.copierClassFor(memberModel).orElseThrow(() -> new IllegalStateException("Copier class not found for " + memberModel));
        String variableName = memberModel.getVariable().getVariableName();
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("$T result = $T.$N(this.$N);", new Object[]{returnType, copierClass, this.copiers.copyToBuilderMethodName(), variableName});
        if (memberModel.isList()) {
            code.add("if (result instanceof $T) {", new Object[]{SdkAutoConstructList.class}).add("return null;", new Object[0]).add("}", new Object[0]);
        }
        if (memberModel.isMap()) {
            code.add("if (result instanceof $T) {", new Object[]{SdkAutoConstructMap.class}).add("return null;", new Object[0]).add("}", new Object[0]);
        }
        code.add("return result;", new Object[0]);
        return MethodSpec.methodBuilder((String)memberModel.getBeanStyleGetterMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(returnType).addCode(code.build()).build();
    }

    private MethodSpec byteBufferGetter(MemberModel memberModel) {
        return this.basicGetter(memberModel, (TypeName)ClassName.get(ByteBuffer.class), CodeBlock.of((String)"return $1N == null ? null : $1N.asByteBuffer();", (Object[])new Object[]{memberModel.getVariable().getVariableName()}));
    }

    private MethodSpec listByteBufferGetter(MemberModel memberModel) {
        return this.basicGetter(memberModel, (TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{ByteBuffer.class}), CodeBlock.of((String)"return $1N == null ? null : $1N.stream().map($2T::asByteBuffer).collect($3T.toList());", (Object[])new Object[]{memberModel.getVariable().getVariableName(), SdkBytes.class, Collectors.class}));
    }

    private MethodSpec mapByteBufferGetter(MemberModel memberModel) {
        String body = "return $1N == null ? null : $1N.entrySet().stream().collect($2T.toMap(e -> e.getKey(), e -> e.getValue().asByteBuffer()));";
        String keyType = memberModel.getMapModel().getKeyModel().getVariable().getVariableType();
        return this.basicGetter(memberModel, (TypeName)PoetUtils.createParameterizedTypeName(Map.class, keyType, ByteBuffer.class.getSimpleName()), CodeBlock.of((String)body, (Object[])new Object[]{memberModel.getVariable().getVariableName(), Collectors.class}));
    }

    private MethodSpec regularGetter(MemberModel memberModel) {
        return this.basicGetter(memberModel, this.typeProvider.parameterType(memberModel), CodeBlock.of((String)"return $N;", (Object[])new Object[]{memberModel.getVariable().getVariableName()}));
    }

    private MethodSpec builderGetter(MemberModel memberModel) {
        return this.basicGetter(memberModel, (TypeName)this.poetExtensions.getModelClass(memberModel.getC2jShape()).nestedClass("Builder"), CodeBlock.of((String)"return $1N != null ? $1N.toBuilder() : null;", (Object[])new Object[]{memberModel.getVariable().getVariableName()}));
    }

    private MethodSpec basicGetter(MemberModel memberModel, TypeName returnType, CodeBlock body) {
        CodeBlock.Builder getterBody = CodeBlock.builder();
        memberModel.getAutoConstructClassIfExists().ifPresent(autoConstructClass -> getterBody.add("if ($N instanceof $T) {", new Object[]{memberModel.getVariable().getVariableName(), autoConstructClass}).add("return null;", new Object[0]).add("}", new Object[0]));
        getterBody.add(body);
        return MethodSpec.methodBuilder((String)memberModel.getBeanStyleGetterMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns(returnType).addCode(getterBody.build()).build();
    }
}

