/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ConfigureAgentResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.CreateProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.DeleteProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.DeleteProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.DescribeProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.GetProfileRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.GetProfileResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.PostAgentProfileResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.UpdateProfilingGroupRequest;
import software.amazon.awssdk.services.codeguruprofiler.model.UpdateProfilingGroupResponse;
import software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesPublisher;
import software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsPublisher;

/**
 * Service client for accessing Amazon CodeGuru Profiler asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Example service documentation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface CodeGuruProfilerAsyncClient extends SdkClient {
    String SERVICE_NAME = "codeguru-profiler";

    /**
     * Create a {@link CodeGuruProfilerAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CodeGuruProfilerAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CodeGuruProfilerAsyncClient}.
     */
    static CodeGuruProfilerAsyncClientBuilder builder() {
        return new DefaultCodeGuruProfilerAsyncClientBuilder();
    }

    /**
     * <p>
     * Provides the configuration to use for an agent of the profiling group.
     * </p>
     *
     * @param configureAgentRequest
     *        Request for ConfigureAgent operation.
     * @return A Java Future containing the result of the ConfigureAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.ConfigureAgent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ConfigureAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConfigureAgentResponse> configureAgent(ConfigureAgentRequest configureAgentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the configuration to use for an agent of the profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ConfigureAgentRequest.Builder} avoiding the need to
     * create one manually via {@link ConfigureAgentRequest#builder()}
     * </p>
     *
     * @param configureAgentRequest
     *        A {@link Consumer} that will call methods on {@link ConfigureAgentRequest.Builder} to create a request.
     *        Request for ConfigureAgent operation.
     * @return A Java Future containing the result of the ConfigureAgent operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.ConfigureAgent
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ConfigureAgent"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ConfigureAgentResponse> configureAgent(Consumer<ConfigureAgentRequest.Builder> configureAgentRequest) {
        return configureAgent(ConfigureAgentRequest.builder().applyMutation(configureAgentRequest).build());
    }

    /**
     * <p>
     * Create a profiling group.
     * </p>
     *
     * @param createProfilingGroupRequest
     *        Request for CreateProfilingGroup operation.
     * @return A Java Future containing the result of the CreateProfilingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Request can can cause an inconsistent state for the resource.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.CreateProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/CreateProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProfilingGroupResponse> createProfilingGroup(
            CreateProfilingGroupRequest createProfilingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfilingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link CreateProfilingGroupRequest#builder()}
     * </p>
     *
     * @param createProfilingGroupRequest
     *        A {@link Consumer} that will call methods on {@link CreateProfilingGroupRequest.Builder} to create a
     *        request. Request for CreateProfilingGroup operation.
     * @return A Java Future containing the result of the CreateProfilingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException Request would cause a service quota to be exceeded.</li>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Request can can cause an inconsistent state for the resource.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.CreateProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/CreateProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateProfilingGroupResponse> createProfilingGroup(
            Consumer<CreateProfilingGroupRequest.Builder> createProfilingGroupRequest) {
        return createProfilingGroup(CreateProfilingGroupRequest.builder().applyMutation(createProfilingGroupRequest).build());
    }

    /**
     * <p>
     * Delete a profiling group.
     * </p>
     *
     * @param deleteProfilingGroupRequest
     *        Request for DeleteProfilingGroup operation.
     * @return A Java Future containing the result of the DeleteProfilingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.DeleteProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DeleteProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProfilingGroupResponse> deleteProfilingGroup(
            DeleteProfilingGroupRequest deleteProfilingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfilingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProfilingGroupRequest#builder()}
     * </p>
     *
     * @param deleteProfilingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProfilingGroupRequest.Builder} to create a
     *        request. Request for DeleteProfilingGroup operation.
     * @return A Java Future containing the result of the DeleteProfilingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.DeleteProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DeleteProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteProfilingGroupResponse> deleteProfilingGroup(
            Consumer<DeleteProfilingGroupRequest.Builder> deleteProfilingGroupRequest) {
        return deleteProfilingGroup(DeleteProfilingGroupRequest.builder().applyMutation(deleteProfilingGroupRequest).build());
    }

    /**
     * <p>
     * Describe a profiling group.
     * </p>
     *
     * @param describeProfilingGroupRequest
     *        Request for DescribeProfilingGroup operation.
     * @return A Java Future containing the result of the DescribeProfilingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.DescribeProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DescribeProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProfilingGroupResponse> describeProfilingGroup(
            DescribeProfilingGroupRequest describeProfilingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describe a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProfilingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeProfilingGroupRequest#builder()}
     * </p>
     *
     * @param describeProfilingGroupRequest
     *        A {@link Consumer} that will call methods on {@link DescribeProfilingGroupRequest.Builder} to create a
     *        request. Request for DescribeProfilingGroup operation.
     * @return A Java Future containing the result of the DescribeProfilingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.DescribeProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/DescribeProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeProfilingGroupResponse> describeProfilingGroup(
            Consumer<DescribeProfilingGroupRequest.Builder> describeProfilingGroupRequest) {
        return describeProfilingGroup(DescribeProfilingGroupRequest.builder().applyMutation(describeProfilingGroupRequest)
                .build());
    }

    /**
     * <p>
     * Get the aggregated profile of a profiling group for the specified time range. If the requested time range does
     * not align with the available aggregated profiles, it will be expanded to attain alignment. If aggregated profiles
     * are available only for part of the period requested, the profile is returned from the earliest available to the
     * latest within the requested time range. For instance, if the requested time range is from 00:00 to 00:20 and the
     * available profiles are from 00:15 to 00:25, then the returned profile will be from 00:15 to 00:20.
     * </p>
     *
     * @param getProfileRequest
     *        Request for GetProfile operation.
     * @return A Java Future containing the result of the GetProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.GetProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetProfileResponse> getProfile(GetProfileRequest getProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the aggregated profile of a profiling group for the specified time range. If the requested time range does
     * not align with the available aggregated profiles, it will be expanded to attain alignment. If aggregated profiles
     * are available only for part of the period requested, the profile is returned from the earliest available to the
     * latest within the requested time range. For instance, if the requested time range is from 00:00 to 00:20 and the
     * available profiles are from 00:15 to 00:25, then the returned profile will be from 00:15 to 00:20.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileRequest.Builder} avoiding the need to
     * create one manually via {@link GetProfileRequest#builder()}
     * </p>
     *
     * @param getProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetProfileRequest.Builder} to create a request.
     *        Request for GetProfile operation.
     * @return A Java Future containing the result of the GetProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.GetProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/GetProfile" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetProfileResponse> getProfile(Consumer<GetProfileRequest.Builder> getProfileRequest) {
        return getProfile(GetProfileRequest.builder().applyMutation(getProfileRequest).build());
    }

    /**
     * <p>
     * List the start times of the available aggregated profiles of a profiling group for an aggregation period within
     * the specified time range.
     * </p>
     *
     * @param listProfileTimesRequest
     *        Request for ListProfileTimes operation.
     * @return A Java Future containing the result of the ListProfileTimes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.ListProfileTimes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProfileTimesResponse> listProfileTimes(ListProfileTimesRequest listProfileTimesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the start times of the available aggregated profiles of a profiling group for an aggregation period within
     * the specified time range.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileTimesRequest.Builder} avoiding the need
     * to create one manually via {@link ListProfileTimesRequest#builder()}
     * </p>
     *
     * @param listProfileTimesRequest
     *        A {@link Consumer} that will call methods on {@link ListProfileTimesRequest.Builder} to create a request.
     *        Request for ListProfileTimes operation.
     * @return A Java Future containing the result of the ListProfileTimes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.ListProfileTimes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProfileTimesResponse> listProfileTimes(
            Consumer<ListProfileTimesRequest.Builder> listProfileTimesRequest) {
        return listProfileTimes(ListProfileTimesRequest.builder().applyMutation(listProfileTimesRequest).build());
    }

    /**
     * <p>
     * List the start times of the available aggregated profiles of a profiling group for an aggregation period within
     * the specified time range.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfileTimes(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesPublisher publisher = client.listProfileTimesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesPublisher publisher = client.listProfileTimesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfileTimes(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProfileTimesRequest
     *        Request for ListProfileTimes operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.ListProfileTimes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileTimesPublisher listProfileTimesPaginator(ListProfileTimesRequest listProfileTimesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the start times of the available aggregated profiles of a profiling group for an aggregation period within
     * the specified time range.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfileTimes(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesPublisher publisher = client.listProfileTimesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfileTimesPublisher publisher = client.listProfileTimesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfileTimes(software.amazon.awssdk.services.codeguruprofiler.model.ListProfileTimesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileTimesRequest.Builder} avoiding the need
     * to create one manually via {@link ListProfileTimesRequest#builder()}
     * </p>
     *
     * @param listProfileTimesRequest
     *        A {@link Consumer} that will call methods on {@link ListProfileTimesRequest.Builder} to create a request.
     *        Request for ListProfileTimes operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.ListProfileTimes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfileTimes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileTimesPublisher listProfileTimesPaginator(Consumer<ListProfileTimesRequest.Builder> listProfileTimesRequest) {
        return listProfileTimesPaginator(ListProfileTimesRequest.builder().applyMutation(listProfileTimesRequest).build());
    }

    /**
     * <p>
     * List profiling groups in the account.
     * </p>
     *
     * @param listProfilingGroupsRequest
     *        Request for ListProfilingGroups operation.
     * @return A Java Future containing the result of the ListProfilingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.ListProfilingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProfilingGroupsResponse> listProfilingGroups(
            ListProfilingGroupsRequest listProfilingGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List profiling groups in the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilingGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProfilingGroupsRequest#builder()}
     * </p>
     *
     * @param listProfilingGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListProfilingGroupsRequest.Builder} to create a
     *        request. Request for ListProfilingGroups operation.
     * @return A Java Future containing the result of the ListProfilingGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.ListProfilingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListProfilingGroupsResponse> listProfilingGroups(
            Consumer<ListProfilingGroupsRequest.Builder> listProfilingGroupsRequest) {
        return listProfilingGroups(ListProfilingGroupsRequest.builder().applyMutation(listProfilingGroupsRequest).build());
    }

    /**
     * <p>
     * List profiling groups in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfilingGroups(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsPublisher publisher = client.listProfilingGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsPublisher publisher = client.listProfilingGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfilingGroups(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listProfilingGroupsRequest
     *        Request for ListProfilingGroups operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.ListProfilingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfilingGroupsPublisher listProfilingGroupsPaginator(ListProfilingGroupsRequest listProfilingGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List profiling groups in the account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listProfilingGroups(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsPublisher publisher = client.listProfilingGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.codeguruprofiler.paginators.ListProfilingGroupsPublisher publisher = client.listProfilingGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listProfilingGroups(software.amazon.awssdk.services.codeguruprofiler.model.ListProfilingGroupsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfilingGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProfilingGroupsRequest#builder()}
     * </p>
     *
     * @param listProfilingGroupsRequest
     *        A {@link Consumer} that will call methods on {@link ListProfilingGroupsRequest.Builder} to create a
     *        request. Request for ListProfilingGroups operation.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.ListProfilingGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/ListProfilingGroups"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfilingGroupsPublisher listProfilingGroupsPaginator(
            Consumer<ListProfilingGroupsRequest.Builder> listProfilingGroupsRequest) {
        return listProfilingGroupsPaginator(ListProfilingGroupsRequest.builder().applyMutation(listProfilingGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Submit profile collected by an agent belonging to a profiling group for aggregation.
     * </p>
     *
     * @param postAgentProfileRequest
     *        Request for PostAgentProfile operation.
     * @return A Java Future containing the result of the PostAgentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.PostAgentProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/PostAgentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PostAgentProfileResponse> postAgentProfile(PostAgentProfileRequest postAgentProfileRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submit profile collected by an agent belonging to a profiling group for aggregation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PostAgentProfileRequest.Builder} avoiding the need
     * to create one manually via {@link PostAgentProfileRequest#builder()}
     * </p>
     *
     * @param postAgentProfileRequest
     *        A {@link Consumer} that will call methods on {@link PostAgentProfileRequest.Builder} to create a request.
     *        Request for PostAgentProfile operation.
     * @return A Java Future containing the result of the PostAgentProfile operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.PostAgentProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/PostAgentProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PostAgentProfileResponse> postAgentProfile(
            Consumer<PostAgentProfileRequest.Builder> postAgentProfileRequest) {
        return postAgentProfile(PostAgentProfileRequest.builder().applyMutation(postAgentProfileRequest).build());
    }

    /**
     * <p>
     * Update a profiling group.
     * </p>
     *
     * @param updateProfilingGroupRequest
     *        Request for UpdateProfilingGroup operation.
     * @return A Java Future containing the result of the UpdateProfilingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Request can can cause an inconsistent state for the resource.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.UpdateProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/UpdateProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProfilingGroupResponse> updateProfilingGroup(
            UpdateProfilingGroupRequest updateProfilingGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update a profiling group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfilingGroupRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateProfilingGroupRequest#builder()}
     * </p>
     *
     * @param updateProfilingGroupRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProfilingGroupRequest.Builder} to create a
     *        request. Request for UpdateProfilingGroup operation.
     * @return A Java Future containing the result of the UpdateProfilingGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException Unexpected error during processing of request.</li>
     *         <li>ConflictException Request can can cause an inconsistent state for the resource.</li>
     *         <li>ValidationException The input fails to satisfy the constraints of the API.</li>
     *         <li>ThrottlingException Request was denied due to request throttling.</li>
     *         <li>ResourceNotFoundException Request references a resource which does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>CodeGuruProfilerException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample CodeGuruProfilerAsyncClient.UpdateProfilingGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/codeguruprofiler-2019-07-18/UpdateProfilingGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateProfilingGroupResponse> updateProfilingGroup(
            Consumer<UpdateProfilingGroupRequest.Builder> updateProfilingGroupRequest) {
        return updateProfilingGroup(UpdateProfilingGroupRequest.builder().applyMutation(updateProfilingGroupRequest).build());
    }
}
