/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.codeguruprofiler.model.AgentParameterField;
import software.amazon.awssdk.services.codeguruprofiler.model.AgentParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AgentConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AgentConfiguration> {
    private static final SdkField<Map<String, String>> AGENT_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("agentParameters").getter(AgentConfiguration.getter(AgentConfiguration::agentParametersAsStrings)).setter(AgentConfiguration.setter(Builder::agentParametersWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> PERIOD_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("periodInSeconds").getter(AgentConfiguration.getter(AgentConfiguration::periodInSeconds)).setter(AgentConfiguration.setter(Builder::periodInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("periodInSeconds").build()}).build();
    private static final SdkField<Boolean> SHOULD_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("shouldProfile").getter(AgentConfiguration.getter(AgentConfiguration::shouldProfile)).setter(AgentConfiguration.setter(Builder::shouldProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shouldProfile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_PARAMETERS_FIELD, PERIOD_IN_SECONDS_FIELD, SHOULD_PROFILE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, String> agentParameters;
    private final Integer periodInSeconds;
    private final Boolean shouldProfile;

    private AgentConfiguration(BuilderImpl builder) {
        this.agentParameters = builder.agentParameters;
        this.periodInSeconds = builder.periodInSeconds;
        this.shouldProfile = builder.shouldProfile;
    }

    public Map<AgentParameterField, String> agentParameters() {
        return AgentParametersCopier.copyStringToEnum(this.agentParameters);
    }

    public boolean hasAgentParameters() {
        return this.agentParameters != null && !(this.agentParameters instanceof SdkAutoConstructMap);
    }

    public Map<String, String> agentParametersAsStrings() {
        return this.agentParameters;
    }

    public Integer periodInSeconds() {
        return this.periodInSeconds;
    }

    public Boolean shouldProfile() {
        return this.shouldProfile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentParameters() ? this.agentParametersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.periodInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.shouldProfile());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AgentConfiguration)) {
            return false;
        }
        AgentConfiguration other = (AgentConfiguration)obj;
        return this.hasAgentParameters() == other.hasAgentParameters() && Objects.equals(this.agentParametersAsStrings(), other.agentParametersAsStrings()) && Objects.equals(this.periodInSeconds(), other.periodInSeconds()) && Objects.equals(this.shouldProfile(), other.shouldProfile());
    }

    public String toString() {
        return ToString.builder((String)"AgentConfiguration").add("AgentParameters", this.hasAgentParameters() ? this.agentParametersAsStrings() : null).add("PeriodInSeconds", (Object)this.periodInSeconds()).add("ShouldProfile", (Object)this.shouldProfile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentParameters": {
                return Optional.ofNullable(clazz.cast(this.agentParametersAsStrings()));
            }
            case "periodInSeconds": {
                return Optional.ofNullable(clazz.cast(this.periodInSeconds()));
            }
            case "shouldProfile": {
                return Optional.ofNullable(clazz.cast(this.shouldProfile()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AgentConfiguration, T> g) {
        return obj -> g.apply((AgentConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> agentParameters = DefaultSdkAutoConstructMap.getInstance();
        private Integer periodInSeconds;
        private Boolean shouldProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(AgentConfiguration model) {
            this.agentParametersWithStrings(model.agentParameters);
            this.periodInSeconds(model.periodInSeconds);
            this.shouldProfile(model.shouldProfile);
        }

        public final Map<String, String> getAgentParameters() {
            if (this.agentParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.agentParameters;
        }

        @Override
        public final Builder agentParametersWithStrings(Map<String, String> agentParameters) {
            this.agentParameters = AgentParametersCopier.copy(agentParameters);
            return this;
        }

        @Override
        public final Builder agentParameters(Map<AgentParameterField, String> agentParameters) {
            this.agentParameters = AgentParametersCopier.copyEnumToString(agentParameters);
            return this;
        }

        public final void setAgentParameters(Map<String, String> agentParameters) {
            this.agentParameters = AgentParametersCopier.copy(agentParameters);
        }

        public final Integer getPeriodInSeconds() {
            return this.periodInSeconds;
        }

        @Override
        public final Builder periodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
            return this;
        }

        public final void setPeriodInSeconds(Integer periodInSeconds) {
            this.periodInSeconds = periodInSeconds;
        }

        public final Boolean getShouldProfile() {
            return this.shouldProfile;
        }

        @Override
        public final Builder shouldProfile(Boolean shouldProfile) {
            this.shouldProfile = shouldProfile;
            return this;
        }

        public final void setShouldProfile(Boolean shouldProfile) {
            this.shouldProfile = shouldProfile;
        }

        public AgentConfiguration build() {
            return new AgentConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AgentConfiguration> {
        public Builder agentParametersWithStrings(Map<String, String> var1);

        public Builder agentParameters(Map<AgentParameterField, String> var1);

        public Builder periodInSeconds(Integer var1);

        public Builder shouldProfile(Boolean var1);
    }
}

