/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescription;
import software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupDescriptionsCopier;
import software.amazon.awssdk.services.codeguruprofiler.model.ProfilingGroupNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProfilingGroupsResponse
extends CodeGuruProfilerResponse
implements ToCopyableBuilder<Builder, ListProfilingGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListProfilingGroupsResponse.getter(ListProfilingGroupsResponse::nextToken)).setter(ListProfilingGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<String>> PROFILING_GROUP_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("profilingGroupNames").getter(ListProfilingGroupsResponse.getter(ListProfilingGroupsResponse::profilingGroupNames)).setter(ListProfilingGroupsResponse.setter(Builder::profilingGroupNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroupNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProfilingGroupDescription>> PROFILING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("profilingGroups").getter(ListProfilingGroupsResponse.getter(ListProfilingGroupsResponse::profilingGroups)).setter(ListProfilingGroupsResponse.setter(Builder::profilingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profilingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfilingGroupDescription::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, PROFILING_GROUP_NAMES_FIELD, PROFILING_GROUPS_FIELD));
    private final String nextToken;
    private final List<String> profilingGroupNames;
    private final List<ProfilingGroupDescription> profilingGroups;

    private ListProfilingGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.profilingGroupNames = builder.profilingGroupNames;
        this.profilingGroups = builder.profilingGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasProfilingGroupNames() {
        return this.profilingGroupNames != null && !(this.profilingGroupNames instanceof SdkAutoConstructList);
    }

    public List<String> profilingGroupNames() {
        return this.profilingGroupNames;
    }

    public boolean hasProfilingGroups() {
        return this.profilingGroups != null && !(this.profilingGroups instanceof SdkAutoConstructList);
    }

    public List<ProfilingGroupDescription> profilingGroups() {
        return this.profilingGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfilingGroupNames() ? this.profilingGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfilingGroups() ? this.profilingGroups() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfilingGroupsResponse)) {
            return false;
        }
        ListProfilingGroupsResponse other = (ListProfilingGroupsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasProfilingGroupNames() == other.hasProfilingGroupNames() && Objects.equals(this.profilingGroupNames(), other.profilingGroupNames()) && this.hasProfilingGroups() == other.hasProfilingGroups() && Objects.equals(this.profilingGroups(), other.profilingGroups());
    }

    public String toString() {
        return ToString.builder((String)"ListProfilingGroupsResponse").add("NextToken", (Object)this.nextToken()).add("ProfilingGroupNames", this.hasProfilingGroupNames() ? this.profilingGroupNames() : null).add("ProfilingGroups", this.hasProfilingGroups() ? this.profilingGroups() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "profilingGroupNames": {
                return Optional.ofNullable(clazz.cast(this.profilingGroupNames()));
            }
            case "profilingGroups": {
                return Optional.ofNullable(clazz.cast(this.profilingGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfilingGroupsResponse, T> g) {
        return obj -> g.apply((ListProfilingGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<String> profilingGroupNames = DefaultSdkAutoConstructList.getInstance();
        private List<ProfilingGroupDescription> profilingGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfilingGroupsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.profilingGroupNames(model.profilingGroupNames);
            this.profilingGroups(model.profilingGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<String> getProfilingGroupNames() {
            if (this.profilingGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.profilingGroupNames;
        }

        @Override
        public final Builder profilingGroupNames(Collection<String> profilingGroupNames) {
            this.profilingGroupNames = ProfilingGroupNamesCopier.copy(profilingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilingGroupNames(String ... profilingGroupNames) {
            this.profilingGroupNames(Arrays.asList(profilingGroupNames));
            return this;
        }

        public final void setProfilingGroupNames(Collection<String> profilingGroupNames) {
            this.profilingGroupNames = ProfilingGroupNamesCopier.copy(profilingGroupNames);
        }

        public final Collection<ProfilingGroupDescription.Builder> getProfilingGroups() {
            if (this.profilingGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.profilingGroups != null ? (Collection)this.profilingGroups.stream().map(ProfilingGroupDescription::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder profilingGroups(Collection<ProfilingGroupDescription> profilingGroups) {
            this.profilingGroups = ProfilingGroupDescriptionsCopier.copy(profilingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilingGroups(ProfilingGroupDescription ... profilingGroups) {
            this.profilingGroups(Arrays.asList(profilingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profilingGroups(Consumer<ProfilingGroupDescription.Builder> ... profilingGroups) {
            this.profilingGroups(Stream.of(profilingGroups).map(c -> (ProfilingGroupDescription)((ProfilingGroupDescription.Builder)ProfilingGroupDescription.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProfilingGroups(Collection<ProfilingGroupDescription.BuilderImpl> profilingGroups) {
            this.profilingGroups = ProfilingGroupDescriptionsCopier.copyFromBuilder(profilingGroups);
        }

        @Override
        public ListProfilingGroupsResponse build() {
            return new ListProfilingGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListProfilingGroupsResponse> {
        public Builder nextToken(String var1);

        public Builder profilingGroupNames(Collection<String> var1);

        public Builder profilingGroupNames(String ... var1);

        public Builder profilingGroups(Collection<ProfilingGroupDescription> var1);

        public Builder profilingGroups(ProfilingGroupDescription ... var1);

        public Builder profilingGroups(Consumer<ProfilingGroupDescription.Builder> ... var1);
    }
}

