/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MetadataField {
    AGENT_ID("AgentId"),
    AWS_REQUEST_ID("AwsRequestId"),
    COMPUTE_PLATFORM("ComputePlatform"),
    EXECUTION_ENVIRONMENT("ExecutionEnvironment"),
    LAMBDA_FUNCTION_ARN("LambdaFunctionArn"),
    LAMBDA_MEMORY_LIMIT_IN_MB("LambdaMemoryLimitInMB"),
    LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS("LambdaPreviousExecutionTimeInMilliseconds"),
    LAMBDA_REMAINING_TIME_IN_MILLISECONDS("LambdaRemainingTimeInMilliseconds"),
    LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS("LambdaTimeGapBetweenInvokesInMilliseconds"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MetadataField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MetadataField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MetadataField.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MetadataField> knownValues() {
        return Stream.of(MetadataField.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

