/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codeguruprofiler.model.AggregatedProfileTime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProfilingStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ProfilingStatus> {
    private static final SdkField<Instant> LATEST_AGENT_ORCHESTRATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("latestAgentOrchestratedAt").getter(ProfilingStatus.getter(ProfilingStatus::latestAgentOrchestratedAt)).setter(ProfilingStatus.setter(Builder::latestAgentOrchestratedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAgentOrchestratedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LATEST_AGENT_PROFILE_REPORTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("latestAgentProfileReportedAt").getter(ProfilingStatus.getter(ProfilingStatus::latestAgentProfileReportedAt)).setter(ProfilingStatus.setter(Builder::latestAgentProfileReportedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAgentProfileReportedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<AggregatedProfileTime> LATEST_AGGREGATED_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("latestAggregatedProfile").getter(ProfilingStatus.getter(ProfilingStatus::latestAggregatedProfile)).setter(ProfilingStatus.setter(Builder::latestAggregatedProfile)).constructor(AggregatedProfileTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAggregatedProfile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LATEST_AGENT_ORCHESTRATED_AT_FIELD, LATEST_AGENT_PROFILE_REPORTED_AT_FIELD, LATEST_AGGREGATED_PROFILE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant latestAgentOrchestratedAt;
    private final Instant latestAgentProfileReportedAt;
    private final AggregatedProfileTime latestAggregatedProfile;

    private ProfilingStatus(BuilderImpl builder) {
        this.latestAgentOrchestratedAt = builder.latestAgentOrchestratedAt;
        this.latestAgentProfileReportedAt = builder.latestAgentProfileReportedAt;
        this.latestAggregatedProfile = builder.latestAggregatedProfile;
    }

    public Instant latestAgentOrchestratedAt() {
        return this.latestAgentOrchestratedAt;
    }

    public Instant latestAgentProfileReportedAt() {
        return this.latestAgentProfileReportedAt;
    }

    public AggregatedProfileTime latestAggregatedProfile() {
        return this.latestAggregatedProfile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAgentOrchestratedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAgentProfileReportedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestAggregatedProfile());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfilingStatus)) {
            return false;
        }
        ProfilingStatus other = (ProfilingStatus)obj;
        return Objects.equals(this.latestAgentOrchestratedAt(), other.latestAgentOrchestratedAt()) && Objects.equals(this.latestAgentProfileReportedAt(), other.latestAgentProfileReportedAt()) && Objects.equals(this.latestAggregatedProfile(), other.latestAggregatedProfile());
    }

    public String toString() {
        return ToString.builder((String)"ProfilingStatus").add("LatestAgentOrchestratedAt", (Object)this.latestAgentOrchestratedAt()).add("LatestAgentProfileReportedAt", (Object)this.latestAgentProfileReportedAt()).add("LatestAggregatedProfile", (Object)this.latestAggregatedProfile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "latestAgentOrchestratedAt": {
                return Optional.ofNullable(clazz.cast(this.latestAgentOrchestratedAt()));
            }
            case "latestAgentProfileReportedAt": {
                return Optional.ofNullable(clazz.cast(this.latestAgentProfileReportedAt()));
            }
            case "latestAggregatedProfile": {
                return Optional.ofNullable(clazz.cast(this.latestAggregatedProfile()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfilingStatus, T> g) {
        return obj -> g.apply((ProfilingStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant latestAgentOrchestratedAt;
        private Instant latestAgentProfileReportedAt;
        private AggregatedProfileTime latestAggregatedProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfilingStatus model) {
            this.latestAgentOrchestratedAt(model.latestAgentOrchestratedAt);
            this.latestAgentProfileReportedAt(model.latestAgentProfileReportedAt);
            this.latestAggregatedProfile(model.latestAggregatedProfile);
        }

        public final Instant getLatestAgentOrchestratedAt() {
            return this.latestAgentOrchestratedAt;
        }

        @Override
        public final Builder latestAgentOrchestratedAt(Instant latestAgentOrchestratedAt) {
            this.latestAgentOrchestratedAt = latestAgentOrchestratedAt;
            return this;
        }

        public final void setLatestAgentOrchestratedAt(Instant latestAgentOrchestratedAt) {
            this.latestAgentOrchestratedAt = latestAgentOrchestratedAt;
        }

        public final Instant getLatestAgentProfileReportedAt() {
            return this.latestAgentProfileReportedAt;
        }

        @Override
        public final Builder latestAgentProfileReportedAt(Instant latestAgentProfileReportedAt) {
            this.latestAgentProfileReportedAt = latestAgentProfileReportedAt;
            return this;
        }

        public final void setLatestAgentProfileReportedAt(Instant latestAgentProfileReportedAt) {
            this.latestAgentProfileReportedAt = latestAgentProfileReportedAt;
        }

        public final AggregatedProfileTime.Builder getLatestAggregatedProfile() {
            return this.latestAggregatedProfile != null ? this.latestAggregatedProfile.toBuilder() : null;
        }

        @Override
        public final Builder latestAggregatedProfile(AggregatedProfileTime latestAggregatedProfile) {
            this.latestAggregatedProfile = latestAggregatedProfile;
            return this;
        }

        public final void setLatestAggregatedProfile(AggregatedProfileTime.BuilderImpl latestAggregatedProfile) {
            this.latestAggregatedProfile = latestAggregatedProfile != null ? latestAggregatedProfile.build() : null;
        }

        public ProfilingStatus build() {
            return new ProfilingStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ProfilingStatus> {
        public Builder latestAgentOrchestratedAt(Instant var1);

        public Builder latestAgentProfileReportedAt(Instant var1);

        public Builder latestAggregatedProfile(AggregatedProfileTime var1);

        default public Builder latestAggregatedProfile(Consumer<AggregatedProfileTime.Builder> latestAggregatedProfile) {
            return this.latestAggregatedProfile((AggregatedProfileTime)((AggregatedProfileTime.Builder)AggregatedProfileTime.builder().applyMutation(latestAggregatedProfile)).build());
        }
    }
}

