/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codegurureviewer.model.CodeGuruReviewerResponse;
import software.amazon.awssdk.services.codegurureviewer.model.RecommendationSummariesCopier;
import software.amazon.awssdk.services.codegurureviewer.model.RecommendationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRecommendationsResponse
extends CodeGuruReviewerResponse
implements ToCopyableBuilder<Builder, ListRecommendationsResponse> {
    private static final SdkField<List<RecommendationSummary>> RECOMMENDATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecommendationSummaries").getter(ListRecommendationsResponse.getter(ListRecommendationsResponse::recommendationSummaries)).setter(ListRecommendationsResponse.setter(Builder::recommendationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListRecommendationsResponse.getter(ListRecommendationsResponse::nextToken)).setter(ListRecommendationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<RecommendationSummary> recommendationSummaries;
    private final String nextToken;

    private ListRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.recommendationSummaries = builder.recommendationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasRecommendationSummaries() {
        return this.recommendationSummaries != null && !(this.recommendationSummaries instanceof SdkAutoConstructList);
    }

    public final List<RecommendationSummary> recommendationSummaries() {
        return this.recommendationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendationSummaries() ? this.recommendationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRecommendationsResponse)) {
            return false;
        }
        ListRecommendationsResponse other = (ListRecommendationsResponse)((Object)obj);
        return this.hasRecommendationSummaries() == other.hasRecommendationSummaries() && Objects.equals(this.recommendationSummaries(), other.recommendationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRecommendationsResponse").add("RecommendationSummaries", this.hasRecommendationSummaries() ? this.recommendationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommendationSummaries": {
                return Optional.ofNullable(clazz.cast(this.recommendationSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRecommendationsResponse, T> g) {
        return obj -> g.apply((ListRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruReviewerResponse.BuilderImpl
    implements Builder {
        private List<RecommendationSummary> recommendationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRecommendationsResponse model) {
            super(model);
            this.recommendationSummaries(model.recommendationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<RecommendationSummary.Builder> getRecommendationSummaries() {
            List<RecommendationSummary.Builder> result = RecommendationSummariesCopier.copyToBuilder(this.recommendationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendationSummaries(Collection<RecommendationSummary.BuilderImpl> recommendationSummaries) {
            this.recommendationSummaries = RecommendationSummariesCopier.copyFromBuilder(recommendationSummaries);
        }

        @Override
        @Transient
        public final Builder recommendationSummaries(Collection<RecommendationSummary> recommendationSummaries) {
            this.recommendationSummaries = RecommendationSummariesCopier.copy(recommendationSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recommendationSummaries(RecommendationSummary ... recommendationSummaries) {
            this.recommendationSummaries(Arrays.asList(recommendationSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder recommendationSummaries(Consumer<RecommendationSummary.Builder> ... recommendationSummaries) {
            this.recommendationSummaries(Stream.of(recommendationSummaries).map(c -> (RecommendationSummary)((RecommendationSummary.Builder)RecommendationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRecommendationsResponse build() {
            return new ListRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruReviewerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRecommendationsResponse> {
        public Builder recommendationSummaries(Collection<RecommendationSummary> var1);

        public Builder recommendationSummaries(RecommendationSummary ... var1);

        public Builder recommendationSummaries(Consumer<RecommendationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

