/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codegurureviewer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codegurureviewer.model.RepositoryHeadSourceCodeType;
import software.amazon.awssdk.services.codegurureviewer.model.SourceCodeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RepositoryAnalysis
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RepositoryAnalysis> {
    private static final SdkField<RepositoryHeadSourceCodeType> REPOSITORY_HEAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RepositoryHead").getter(RepositoryAnalysis.getter(RepositoryAnalysis::repositoryHead)).setter(RepositoryAnalysis.setter(Builder::repositoryHead)).constructor(RepositoryHeadSourceCodeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryHead").build()}).build();
    private static final SdkField<SourceCodeType> SOURCE_CODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SourceCodeType").getter(RepositoryAnalysis.getter(RepositoryAnalysis::sourceCodeType)).setter(RepositoryAnalysis.setter(Builder::sourceCodeType)).constructor(SourceCodeType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceCodeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_HEAD_FIELD, SOURCE_CODE_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final RepositoryHeadSourceCodeType repositoryHead;
    private final SourceCodeType sourceCodeType;

    private RepositoryAnalysis(BuilderImpl builder) {
        this.repositoryHead = builder.repositoryHead;
        this.sourceCodeType = builder.sourceCodeType;
    }

    public final RepositoryHeadSourceCodeType repositoryHead() {
        return this.repositoryHead;
    }

    public final SourceCodeType sourceCodeType() {
        return this.sourceCodeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryHead());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCodeType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryAnalysis)) {
            return false;
        }
        RepositoryAnalysis other = (RepositoryAnalysis)obj;
        return Objects.equals(this.repositoryHead(), other.repositoryHead()) && Objects.equals(this.sourceCodeType(), other.sourceCodeType());
    }

    public final String toString() {
        return ToString.builder((String)"RepositoryAnalysis").add("RepositoryHead", (Object)this.repositoryHead()).add("SourceCodeType", (Object)this.sourceCodeType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RepositoryHead": {
                return Optional.ofNullable(clazz.cast(this.repositoryHead()));
            }
            case "SourceCodeType": {
                return Optional.ofNullable(clazz.cast(this.sourceCodeType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RepositoryAnalysis, T> g) {
        return obj -> g.apply((RepositoryAnalysis)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RepositoryHeadSourceCodeType repositoryHead;
        private SourceCodeType sourceCodeType;

        private BuilderImpl() {
        }

        private BuilderImpl(RepositoryAnalysis model) {
            this.repositoryHead(model.repositoryHead);
            this.sourceCodeType(model.sourceCodeType);
        }

        public final RepositoryHeadSourceCodeType.Builder getRepositoryHead() {
            return this.repositoryHead != null ? this.repositoryHead.toBuilder() : null;
        }

        public final void setRepositoryHead(RepositoryHeadSourceCodeType.BuilderImpl repositoryHead) {
            this.repositoryHead = repositoryHead != null ? repositoryHead.build() : null;
        }

        @Override
        @Transient
        public final Builder repositoryHead(RepositoryHeadSourceCodeType repositoryHead) {
            this.repositoryHead = repositoryHead;
            return this;
        }

        public final SourceCodeType.Builder getSourceCodeType() {
            return this.sourceCodeType != null ? this.sourceCodeType.toBuilder() : null;
        }

        public final void setSourceCodeType(SourceCodeType.BuilderImpl sourceCodeType) {
            this.sourceCodeType = sourceCodeType != null ? sourceCodeType.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceCodeType(SourceCodeType sourceCodeType) {
            this.sourceCodeType = sourceCodeType;
            return this;
        }

        public RepositoryAnalysis build() {
            return new RepositoryAnalysis(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RepositoryAnalysis> {
        public Builder repositoryHead(RepositoryHeadSourceCodeType var1);

        default public Builder repositoryHead(Consumer<RepositoryHeadSourceCodeType.Builder> repositoryHead) {
            return this.repositoryHead((RepositoryHeadSourceCodeType)((RepositoryHeadSourceCodeType.Builder)RepositoryHeadSourceCodeType.builder().applyMutation(repositoryHead)).build());
        }

        public Builder sourceCodeType(SourceCodeType var1);

        default public Builder sourceCodeType(Consumer<SourceCodeType.Builder> sourceCodeType) {
            return this.sourceCodeType((SourceCodeType)((SourceCodeType.Builder)SourceCodeType.builder().applyMutation(sourceCodeType)).build());
        }
    }
}

