/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentity.model.AmbiguousRoleResolutionType;
import software.amazon.awssdk.services.cognitoidentity.model.RoleMappingType;
import software.amazon.awssdk.services.cognitoidentity.model.RulesConfigurationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RoleMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RoleMapping> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoleMapping.getter(RoleMapping::typeAsString)).setter(RoleMapping.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<String> AMBIGUOUS_ROLE_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RoleMapping.getter(RoleMapping::ambiguousRoleResolutionAsString)).setter(RoleMapping.setter(Builder::ambiguousRoleResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmbiguousRoleResolution").build()}).build();
    private static final SdkField<RulesConfigurationType> RULES_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(RoleMapping.getter(RoleMapping::rulesConfiguration)).setter(RoleMapping.setter(Builder::rulesConfiguration)).constructor(RulesConfigurationType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RulesConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, AMBIGUOUS_ROLE_RESOLUTION_FIELD, RULES_CONFIGURATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String ambiguousRoleResolution;
    private final RulesConfigurationType rulesConfiguration;

    private RoleMapping(BuilderImpl builder) {
        this.type = builder.type;
        this.ambiguousRoleResolution = builder.ambiguousRoleResolution;
        this.rulesConfiguration = builder.rulesConfiguration;
    }

    public RoleMappingType type() {
        return RoleMappingType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public AmbiguousRoleResolutionType ambiguousRoleResolution() {
        return AmbiguousRoleResolutionType.fromValue(this.ambiguousRoleResolution);
    }

    public String ambiguousRoleResolutionAsString() {
        return this.ambiguousRoleResolution;
    }

    public RulesConfigurationType rulesConfiguration() {
        return this.rulesConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ambiguousRoleResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rulesConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleMapping)) {
            return false;
        }
        RoleMapping other = (RoleMapping)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.ambiguousRoleResolutionAsString(), other.ambiguousRoleResolutionAsString()) && Objects.equals(this.rulesConfiguration(), other.rulesConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"RoleMapping").add("Type", (Object)this.typeAsString()).add("AmbiguousRoleResolution", (Object)this.ambiguousRoleResolutionAsString()).add("RulesConfiguration", (Object)this.rulesConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "AmbiguousRoleResolution": {
                return Optional.ofNullable(clazz.cast(this.ambiguousRoleResolutionAsString()));
            }
            case "RulesConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rulesConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoleMapping, T> g) {
        return obj -> g.apply((RoleMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String ambiguousRoleResolution;
        private RulesConfigurationType rulesConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleMapping model) {
            this.type(model.type);
            this.ambiguousRoleResolution(model.ambiguousRoleResolution);
            this.rulesConfiguration(model.rulesConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RoleMappingType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getAmbiguousRoleResolution() {
            return this.ambiguousRoleResolution;
        }

        @Override
        public final Builder ambiguousRoleResolution(String ambiguousRoleResolution) {
            this.ambiguousRoleResolution = ambiguousRoleResolution;
            return this;
        }

        @Override
        public final Builder ambiguousRoleResolution(AmbiguousRoleResolutionType ambiguousRoleResolution) {
            this.ambiguousRoleResolution(ambiguousRoleResolution == null ? null : ambiguousRoleResolution.toString());
            return this;
        }

        public final void setAmbiguousRoleResolution(String ambiguousRoleResolution) {
            this.ambiguousRoleResolution = ambiguousRoleResolution;
        }

        public final RulesConfigurationType.Builder getRulesConfiguration() {
            return this.rulesConfiguration != null ? this.rulesConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder rulesConfiguration(RulesConfigurationType rulesConfiguration) {
            this.rulesConfiguration = rulesConfiguration;
            return this;
        }

        public final void setRulesConfiguration(RulesConfigurationType.BuilderImpl rulesConfiguration) {
            this.rulesConfiguration = rulesConfiguration != null ? rulesConfiguration.build() : null;
        }

        public RoleMapping build() {
            return new RoleMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RoleMapping> {
        public Builder type(String var1);

        public Builder type(RoleMappingType var1);

        public Builder ambiguousRoleResolution(String var1);

        public Builder ambiguousRoleResolution(AmbiguousRoleResolutionType var1);

        public Builder rulesConfiguration(RulesConfigurationType var1);

        default public Builder rulesConfiguration(Consumer<RulesConfigurationType.Builder> rulesConfiguration) {
            return this.rulesConfiguration((RulesConfigurationType)((RulesConfigurationType.Builder)RulesConfigurationType.builder().applyMutation(rulesConfiguration)).build());
        }
    }
}

