/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentity.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CognitoIdentityProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CognitoIdentityProvider> {
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProviderName").getter(CognitoIdentityProvider.getter(CognitoIdentityProvider::providerName)).setter(CognitoIdentityProvider.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProviderName").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientId").getter(CognitoIdentityProvider.getter(CognitoIdentityProvider::clientId)).setter(CognitoIdentityProvider.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<Boolean> SERVER_SIDE_TOKEN_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ServerSideTokenCheck").getter(CognitoIdentityProvider.getter(CognitoIdentityProvider::serverSideTokenCheck)).setter(CognitoIdentityProvider.setter(Builder::serverSideTokenCheck)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideTokenCheck").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROVIDER_NAME_FIELD, CLIENT_ID_FIELD, SERVER_SIDE_TOKEN_CHECK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CognitoIdentityProvider.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String providerName;
    private final String clientId;
    private final Boolean serverSideTokenCheck;

    private CognitoIdentityProvider(BuilderImpl builder) {
        this.providerName = builder.providerName;
        this.clientId = builder.clientId;
        this.serverSideTokenCheck = builder.serverSideTokenCheck;
    }

    public final String providerName() {
        return this.providerName;
    }

    public final String clientId() {
        return this.clientId;
    }

    public final Boolean serverSideTokenCheck() {
        return this.serverSideTokenCheck;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideTokenCheck());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CognitoIdentityProvider)) {
            return false;
        }
        CognitoIdentityProvider other = (CognitoIdentityProvider)obj;
        return Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.serverSideTokenCheck(), other.serverSideTokenCheck());
    }

    public final String toString() {
        return ToString.builder((String)"CognitoIdentityProvider").add("ProviderName", (Object)this.providerName()).add("ClientId", (Object)this.clientId()).add("ServerSideTokenCheck", (Object)this.serverSideTokenCheck()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProviderName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "ServerSideTokenCheck": {
                return Optional.ofNullable(clazz.cast(this.serverSideTokenCheck()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ProviderName", PROVIDER_NAME_FIELD);
        map.put("ClientId", CLIENT_ID_FIELD);
        map.put("ServerSideTokenCheck", SERVER_SIDE_TOKEN_CHECK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CognitoIdentityProvider, T> g) {
        return obj -> g.apply((CognitoIdentityProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String providerName;
        private String clientId;
        private Boolean serverSideTokenCheck;

        private BuilderImpl() {
        }

        private BuilderImpl(CognitoIdentityProvider model) {
            this.providerName(model.providerName);
            this.clientId(model.clientId);
            this.serverSideTokenCheck(model.serverSideTokenCheck);
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final Boolean getServerSideTokenCheck() {
            return this.serverSideTokenCheck;
        }

        public final void setServerSideTokenCheck(Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
        }

        @Override
        public final Builder serverSideTokenCheck(Boolean serverSideTokenCheck) {
            this.serverSideTokenCheck = serverSideTokenCheck;
            return this;
        }

        public CognitoIdentityProvider build() {
            return new CognitoIdentityProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CognitoIdentityProvider> {
        public Builder providerName(String var1);

        public Builder clientId(String var1);

        public Builder serverSideTokenCheck(Boolean var1);
    }
}

