/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AliasAttributeType {
    PHONE_NUMBER("phone_number"),
    EMAIL("email"),
    PREFERRED_USERNAME("preferred_username"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AliasAttributeType> VALUE_MAP;
    private final String value;

    private AliasAttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AliasAttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AliasAttributeType> knownValues() {
        EnumSet<AliasAttributeType> knownValues = EnumSet.allOf(AliasAttributeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AliasAttributeType.class, AliasAttributeType::toString);
    }
}

