/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeName;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ChallengeResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChallengeResponseType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChallengeResponseType> {
    private static final SdkField<String> CHALLENGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChallengeName").getter(ChallengeResponseType.getter(ChallengeResponseType::challengeNameAsString)).setter(ChallengeResponseType.setter(Builder::challengeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeName").build()}).build();
    private static final SdkField<String> CHALLENGE_RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChallengeResponse").getter(ChallengeResponseType.getter(ChallengeResponseType::challengeResponseAsString)).setter(ChallengeResponseType.setter(Builder::challengeResponse)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChallengeResponse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHALLENGE_NAME_FIELD, CHALLENGE_RESPONSE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String challengeName;
    private final String challengeResponse;

    private ChallengeResponseType(BuilderImpl builder) {
        this.challengeName = builder.challengeName;
        this.challengeResponse = builder.challengeResponse;
    }

    public final ChallengeName challengeName() {
        return ChallengeName.fromValue(this.challengeName);
    }

    public final String challengeNameAsString() {
        return this.challengeName;
    }

    public final ChallengeResponse challengeResponse() {
        return ChallengeResponse.fromValue(this.challengeResponse);
    }

    public final String challengeResponseAsString() {
        return this.challengeResponse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.challengeResponseAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChallengeResponseType)) {
            return false;
        }
        ChallengeResponseType other = (ChallengeResponseType)obj;
        return Objects.equals(this.challengeNameAsString(), other.challengeNameAsString()) && Objects.equals(this.challengeResponseAsString(), other.challengeResponseAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ChallengeResponseType").add("ChallengeName", (Object)this.challengeNameAsString()).add("ChallengeResponse", (Object)this.challengeResponseAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChallengeName": {
                return Optional.ofNullable(clazz.cast(this.challengeNameAsString()));
            }
            case "ChallengeResponse": {
                return Optional.ofNullable(clazz.cast(this.challengeResponseAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChallengeResponseType, T> g) {
        return obj -> g.apply((ChallengeResponseType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String challengeName;
        private String challengeResponse;

        private BuilderImpl() {
        }

        private BuilderImpl(ChallengeResponseType model) {
            this.challengeName(model.challengeName);
            this.challengeResponse(model.challengeResponse);
        }

        public final String getChallengeName() {
            return this.challengeName;
        }

        public final void setChallengeName(String challengeName) {
            this.challengeName = challengeName;
        }

        @Override
        public final Builder challengeName(String challengeName) {
            this.challengeName = challengeName;
            return this;
        }

        @Override
        public final Builder challengeName(ChallengeName challengeName) {
            this.challengeName(challengeName == null ? null : challengeName.toString());
            return this;
        }

        public final String getChallengeResponse() {
            return this.challengeResponse;
        }

        public final void setChallengeResponse(String challengeResponse) {
            this.challengeResponse = challengeResponse;
        }

        @Override
        public final Builder challengeResponse(String challengeResponse) {
            this.challengeResponse = challengeResponse;
            return this;
        }

        @Override
        public final Builder challengeResponse(ChallengeResponse challengeResponse) {
            this.challengeResponse(challengeResponse == null ? null : challengeResponse.toString());
            return this;
        }

        public ChallengeResponseType build() {
            return new ChallengeResponseType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChallengeResponseType> {
        public Builder challengeName(String var1);

        public Builder challengeName(ChallengeName var1);

        public Builder challengeResponse(String var1);

        public Builder challengeResponse(ChallengeResponse var1);
    }
}

