/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cognitoidentityprovider.CognitoIdentityProviderAsyncClient;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsRequest;
import software.amazon.awssdk.services.cognitoidentityprovider.model.ListUserPoolClientsResponse;
import software.amazon.awssdk.services.cognitoidentityprovider.model.UserPoolClientDescription;

public class ListUserPoolClientsPublisher
implements SdkPublisher<ListUserPoolClientsResponse> {
    private final CognitoIdentityProviderAsyncClient client;
    private final ListUserPoolClientsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUserPoolClientsPublisher(CognitoIdentityProviderAsyncClient client, ListUserPoolClientsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUserPoolClientsPublisher(CognitoIdentityProviderAsyncClient client, ListUserPoolClientsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUserPoolClientsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUserPoolClientsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<UserPoolClientDescription> userPoolClients() {
        Function<ListUserPoolClientsResponse, Iterator> getIterator = response -> {
            if (response != null && response.userPoolClients() != null) {
                return response.userPoolClients().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListUserPoolClientsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListUserPoolClientsResponseFetcher
    implements AsyncPageFetcher<ListUserPoolClientsResponse> {
        private ListUserPoolClientsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserPoolClientsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUserPoolClientsResponse> nextPage(ListUserPoolClientsResponse previousPage) {
            if (previousPage == null) {
                return ListUserPoolClientsPublisher.this.client.listUserPoolClients(ListUserPoolClientsPublisher.this.firstRequest);
            }
            return ListUserPoolClientsPublisher.this.client.listUserPoolClients((ListUserPoolClientsRequest)((Object)ListUserPoolClientsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

