/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An augmented manifest file that provides training data for your custom model. An augmented manifest file is a labeled
 * dataset that is produced by Amazon SageMaker Ground Truth.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AugmentedManifestsListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AugmentedManifestsListItem.Builder, AugmentedManifestsListItem> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(AugmentedManifestsListItem::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> SPLIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Split")
            .getter(getter(AugmentedManifestsListItem::splitAsString)).setter(setter(Builder::split))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Split").build()).build();

    private static final SdkField<List<String>> ATTRIBUTE_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributeNames")
            .getter(getter(AugmentedManifestsListItem::attributeNames))
            .setter(setter(Builder::attributeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ANNOTATION_DATA_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnnotationDataS3Uri").getter(getter(AugmentedManifestsListItem::annotationDataS3Uri))
            .setter(setter(Builder::annotationDataS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnnotationDataS3Uri").build())
            .build();

    private static final SdkField<String> SOURCE_DOCUMENTS_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDocumentsS3Uri").getter(getter(AugmentedManifestsListItem::sourceDocumentsS3Uri))
            .setter(setter(Builder::sourceDocumentsS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDocumentsS3Uri").build())
            .build();

    private static final SdkField<String> DOCUMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentType").getter(getter(AugmentedManifestsListItem::documentTypeAsString))
            .setter(setter(Builder::documentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, SPLIT_FIELD,
            ATTRIBUTE_NAMES_FIELD, ANNOTATION_DATA_S3_URI_FIELD, SOURCE_DOCUMENTS_S3_URI_FIELD, DOCUMENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String split;

    private final List<String> attributeNames;

    private final String annotationDataS3Uri;

    private final String sourceDocumentsS3Uri;

    private final String documentType;

    private AugmentedManifestsListItem(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.split = builder.split;
        this.attributeNames = builder.attributeNames;
        this.annotationDataS3Uri = builder.annotationDataS3Uri;
        this.sourceDocumentsS3Uri = builder.sourceDocumentsS3Uri;
        this.documentType = builder.documentType;
    }

    /**
     * <p>
     * The Amazon S3 location of the augmented manifest file.
     * </p>
     * 
     * @return The Amazon S3 location of the augmented manifest file.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you
     * don't specify, the default is train.
     * </p>
     * <p>
     * TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon
     * Comprehend will automatically reserve a portion of the training documents for testing.
     * </p>
     * <p>
     * TEST - all of the documents in the manifest will be used for testing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #split} will return
     * {@link Split#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #splitAsString}.
     * </p>
     * 
     * @return The purpose of the data you've provided in the augmented manifest. You can either train or test this
     *         data. If you don't specify, the default is train.</p>
     *         <p>
     *         TRAIN - all of the documents in the manifest will be used for training. If no test documents are
     *         provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.
     *         </p>
     *         <p>
     *         TEST - all of the documents in the manifest will be used for testing.
     * @see Split
     */
    public final Split split() {
        return Split.fromValue(split);
    }

    /**
     * <p>
     * The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If you
     * don't specify, the default is train.
     * </p>
     * <p>
     * TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided, Amazon
     * Comprehend will automatically reserve a portion of the training documents for testing.
     * </p>
     * <p>
     * TEST - all of the documents in the manifest will be used for testing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #split} will return
     * {@link Split#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #splitAsString}.
     * </p>
     * 
     * @return The purpose of the data you've provided in the augmented manifest. You can either train or test this
     *         data. If you don't specify, the default is train.</p>
     *         <p>
     *         TRAIN - all of the documents in the manifest will be used for training. If no test documents are
     *         provided, Amazon Comprehend will automatically reserve a portion of the training documents for testing.
     *         </p>
     *         <p>
     *         TEST - all of the documents in the manifest will be used for testing.
     * @see Split
     */
    public final String splitAsString() {
        return split;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeNames() {
        return attributeNames != null && !(attributeNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The JSON attribute that contains the annotations for your training documents. The number of attribute names that
     * you specify depends on whether your augmented manifest file is the output of a single labeling job or a chained
     * labeling job.
     * </p>
     * <p>
     * If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when the
     * job was created in Ground Truth.
     * </p>
     * <p>
     * If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs in
     * the chain. Each LabelAttributeName key provides the annotations from an individual job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeNames} method.
     * </p>
     * 
     * @return The JSON attribute that contains the annotations for your training documents. The number of attribute
     *         names that you specify depends on whether your augmented manifest file is the output of a single labeling
     *         job or a chained labeling job.</p>
     *         <p>
     *         If your file is the output of a single labeling job, specify the LabelAttributeName key that was used
     *         when the job was created in Ground Truth.
     *         </p>
     *         <p>
     *         If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more
     *         jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.
     */
    public final List<String> attributeNames() {
        return attributeNames;
    }

    /**
     * <p>
     * The S3 prefix to the annotation files that are referred in the augmented manifest file.
     * </p>
     * 
     * @return The S3 prefix to the annotation files that are referred in the augmented manifest file.
     */
    public final String annotationDataS3Uri() {
        return annotationDataS3Uri;
    }

    /**
     * <p>
     * The S3 prefix to the source files (PDFs) that are referred to in the augmented manifest file.
     * </p>
     * 
     * @return The S3 prefix to the source files (PDFs) that are referred to in the augmented manifest file.
     */
    public final String sourceDocumentsS3Uri() {
        return sourceDocumentsS3Uri;
    }

    /**
     * <p>
     * The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the default is
     * PlainTextDocument.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a PDF. For
     * training with Amazon Comprehend, only PDFs are supported. For inference, Amazon Comprehend support PDFs, DOCX and
     * TXT.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentType} will
     * return {@link AugmentedManifestsDocumentTypeFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #documentTypeAsString}.
     * </p>
     * 
     * @return The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the
     *         default is PlainTextDocument. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in
     *         UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a PDF.
     *         For training with Amazon Comprehend, only PDFs are supported. For inference, Amazon Comprehend support
     *         PDFs, DOCX and TXT.
     *         </p>
     *         </li>
     * @see AugmentedManifestsDocumentTypeFormat
     */
    public final AugmentedManifestsDocumentTypeFormat documentType() {
        return AugmentedManifestsDocumentTypeFormat.fromValue(documentType);
    }

    /**
     * <p>
     * The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the default is
     * PlainTextDocument.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in UTF-8.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a PDF. For
     * training with Amazon Comprehend, only PDFs are supported. For inference, Amazon Comprehend support PDFs, DOCX and
     * TXT.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentType} will
     * return {@link AugmentedManifestsDocumentTypeFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #documentTypeAsString}.
     * </p>
     * 
     * @return The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the
     *         default is PlainTextDocument. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in
     *         UTF-8.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a PDF.
     *         For training with Amazon Comprehend, only PDFs are supported. For inference, Amazon Comprehend support
     *         PDFs, DOCX and TXT.
     *         </p>
     *         </li>
     * @see AugmentedManifestsDocumentTypeFormat
     */
    public final String documentTypeAsString() {
        return documentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(splitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeNames() ? attributeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(annotationDataS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(sourceDocumentsS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(documentTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AugmentedManifestsListItem)) {
            return false;
        }
        AugmentedManifestsListItem other = (AugmentedManifestsListItem) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(splitAsString(), other.splitAsString())
                && hasAttributeNames() == other.hasAttributeNames() && Objects.equals(attributeNames(), other.attributeNames())
                && Objects.equals(annotationDataS3Uri(), other.annotationDataS3Uri())
                && Objects.equals(sourceDocumentsS3Uri(), other.sourceDocumentsS3Uri())
                && Objects.equals(documentTypeAsString(), other.documentTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AugmentedManifestsListItem").add("S3Uri", s3Uri()).add("Split", splitAsString())
                .add("AttributeNames", hasAttributeNames() ? attributeNames() : null)
                .add("AnnotationDataS3Uri", annotationDataS3Uri()).add("SourceDocumentsS3Uri", sourceDocumentsS3Uri())
                .add("DocumentType", documentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "Split":
            return Optional.ofNullable(clazz.cast(splitAsString()));
        case "AttributeNames":
            return Optional.ofNullable(clazz.cast(attributeNames()));
        case "AnnotationDataS3Uri":
            return Optional.ofNullable(clazz.cast(annotationDataS3Uri()));
        case "SourceDocumentsS3Uri":
            return Optional.ofNullable(clazz.cast(sourceDocumentsS3Uri()));
        case "DocumentType":
            return Optional.ofNullable(clazz.cast(documentTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AugmentedManifestsListItem, T> g) {
        return obj -> g.apply((AugmentedManifestsListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AugmentedManifestsListItem> {
        /**
         * <p>
         * The Amazon S3 location of the augmented manifest file.
         * </p>
         * 
         * @param s3Uri
         *        The Amazon S3 location of the augmented manifest file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If
         * you don't specify, the default is train.
         * </p>
         * <p>
         * TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided,
         * Amazon Comprehend will automatically reserve a portion of the training documents for testing.
         * </p>
         * <p>
         * TEST - all of the documents in the manifest will be used for testing.
         * </p>
         * 
         * @param split
         *        The purpose of the data you've provided in the augmented manifest. You can either train or test this
         *        data. If you don't specify, the default is train.</p>
         *        <p>
         *        TRAIN - all of the documents in the manifest will be used for training. If no test documents are
         *        provided, Amazon Comprehend will automatically reserve a portion of the training documents for
         *        testing.
         *        </p>
         *        <p>
         *        TEST - all of the documents in the manifest will be used for testing.
         * @see Split
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Split
         */
        Builder split(String split);

        /**
         * <p>
         * The purpose of the data you've provided in the augmented manifest. You can either train or test this data. If
         * you don't specify, the default is train.
         * </p>
         * <p>
         * TRAIN - all of the documents in the manifest will be used for training. If no test documents are provided,
         * Amazon Comprehend will automatically reserve a portion of the training documents for testing.
         * </p>
         * <p>
         * TEST - all of the documents in the manifest will be used for testing.
         * </p>
         * 
         * @param split
         *        The purpose of the data you've provided in the augmented manifest. You can either train or test this
         *        data. If you don't specify, the default is train.</p>
         *        <p>
         *        TRAIN - all of the documents in the manifest will be used for training. If no test documents are
         *        provided, Amazon Comprehend will automatically reserve a portion of the training documents for
         *        testing.
         *        </p>
         *        <p>
         *        TEST - all of the documents in the manifest will be used for testing.
         * @see Split
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Split
         */
        Builder split(Split split);

        /**
         * <p>
         * The JSON attribute that contains the annotations for your training documents. The number of attribute names
         * that you specify depends on whether your augmented manifest file is the output of a single labeling job or a
         * chained labeling job.
         * </p>
         * <p>
         * If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when
         * the job was created in Ground Truth.
         * </p>
         * <p>
         * If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs
         * in the chain. Each LabelAttributeName key provides the annotations from an individual job.
         * </p>
         * 
         * @param attributeNames
         *        The JSON attribute that contains the annotations for your training documents. The number of attribute
         *        names that you specify depends on whether your augmented manifest file is the output of a single
         *        labeling job or a chained labeling job.</p>
         *        <p>
         *        If your file is the output of a single labeling job, specify the LabelAttributeName key that was used
         *        when the job was created in Ground Truth.
         *        </p>
         *        <p>
         *        If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or
         *        more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(Collection<String> attributeNames);

        /**
         * <p>
         * The JSON attribute that contains the annotations for your training documents. The number of attribute names
         * that you specify depends on whether your augmented manifest file is the output of a single labeling job or a
         * chained labeling job.
         * </p>
         * <p>
         * If your file is the output of a single labeling job, specify the LabelAttributeName key that was used when
         * the job was created in Ground Truth.
         * </p>
         * <p>
         * If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or more jobs
         * in the chain. Each LabelAttributeName key provides the annotations from an individual job.
         * </p>
         * 
         * @param attributeNames
         *        The JSON attribute that contains the annotations for your training documents. The number of attribute
         *        names that you specify depends on whether your augmented manifest file is the output of a single
         *        labeling job or a chained labeling job.</p>
         *        <p>
         *        If your file is the output of a single labeling job, specify the LabelAttributeName key that was used
         *        when the job was created in Ground Truth.
         *        </p>
         *        <p>
         *        If your file is the output of a chained labeling job, specify the LabelAttributeName key for one or
         *        more jobs in the chain. Each LabelAttributeName key provides the annotations from an individual job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeNames(String... attributeNames);

        /**
         * <p>
         * The S3 prefix to the annotation files that are referred in the augmented manifest file.
         * </p>
         * 
         * @param annotationDataS3Uri
         *        The S3 prefix to the annotation files that are referred in the augmented manifest file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder annotationDataS3Uri(String annotationDataS3Uri);

        /**
         * <p>
         * The S3 prefix to the source files (PDFs) that are referred to in the augmented manifest file.
         * </p>
         * 
         * @param sourceDocumentsS3Uri
         *        The S3 prefix to the source files (PDFs) that are referred to in the augmented manifest file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDocumentsS3Uri(String sourceDocumentsS3Uri);

        /**
         * <p>
         * The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the
         * default is PlainTextDocument.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a PDF. For
         * training with Amazon Comprehend, only PDFs are supported. For inference, Amazon Comprehend support PDFs, DOCX
         * and TXT.
         * </p>
         * </li>
         * </ul>
         * 
         * @param documentType
         *        The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the
         *        default is PlainTextDocument. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in
         *        UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a
         *        PDF. For training with Amazon Comprehend, only PDFs are supported. For inference, Amazon Comprehend
         *        support PDFs, DOCX and TXT.
         *        </p>
         *        </li>
         * @see AugmentedManifestsDocumentTypeFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AugmentedManifestsDocumentTypeFormat
         */
        Builder documentType(String documentType);

        /**
         * <p>
         * The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the
         * default is PlainTextDocument.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in UTF-8.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a PDF. For
         * training with Amazon Comprehend, only PDFs are supported. For inference, Amazon Comprehend support PDFs, DOCX
         * and TXT.
         * </p>
         * </li>
         * </ul>
         * 
         * @param documentType
         *        The type of augmented manifest. PlainTextDocument or SemiStructuredDocument. If you don't specify, the
         *        default is PlainTextDocument. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PLAIN_TEXT_DOCUMENT</code> A document type that represents any unicode text that is encoded in
         *        UTF-8.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SEMI_STRUCTURED_DOCUMENT</code> A document type with positional and structural context, like a
         *        PDF. For training with Amazon Comprehend, only PDFs are supported. For inference, Amazon Comprehend
         *        support PDFs, DOCX and TXT.
         *        </p>
         *        </li>
         * @see AugmentedManifestsDocumentTypeFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AugmentedManifestsDocumentTypeFormat
         */
        Builder documentType(AugmentedManifestsDocumentTypeFormat documentType);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String split;

        private List<String> attributeNames = DefaultSdkAutoConstructList.getInstance();

        private String annotationDataS3Uri;

        private String sourceDocumentsS3Uri;

        private String documentType;

        private BuilderImpl() {
        }

        private BuilderImpl(AugmentedManifestsListItem model) {
            s3Uri(model.s3Uri);
            split(model.split);
            attributeNames(model.attributeNames);
            annotationDataS3Uri(model.annotationDataS3Uri);
            sourceDocumentsS3Uri(model.sourceDocumentsS3Uri);
            documentType(model.documentType);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getSplit() {
            return split;
        }

        public final void setSplit(String split) {
            this.split = split;
        }

        @Override
        public final Builder split(String split) {
            this.split = split;
            return this;
        }

        @Override
        public final Builder split(Split split) {
            this.split(split == null ? null : split.toString());
            return this;
        }

        public final Collection<String> getAttributeNames() {
            if (attributeNames instanceof SdkAutoConstructList) {
                return null;
            }
            return attributeNames;
        }

        public final void setAttributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNamesListCopier.copy(attributeNames);
        }

        @Override
        public final Builder attributeNames(Collection<String> attributeNames) {
            this.attributeNames = AttributeNamesListCopier.copy(attributeNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeNames(String... attributeNames) {
            attributeNames(Arrays.asList(attributeNames));
            return this;
        }

        public final String getAnnotationDataS3Uri() {
            return annotationDataS3Uri;
        }

        public final void setAnnotationDataS3Uri(String annotationDataS3Uri) {
            this.annotationDataS3Uri = annotationDataS3Uri;
        }

        @Override
        public final Builder annotationDataS3Uri(String annotationDataS3Uri) {
            this.annotationDataS3Uri = annotationDataS3Uri;
            return this;
        }

        public final String getSourceDocumentsS3Uri() {
            return sourceDocumentsS3Uri;
        }

        public final void setSourceDocumentsS3Uri(String sourceDocumentsS3Uri) {
            this.sourceDocumentsS3Uri = sourceDocumentsS3Uri;
        }

        @Override
        public final Builder sourceDocumentsS3Uri(String sourceDocumentsS3Uri) {
            this.sourceDocumentsS3Uri = sourceDocumentsS3Uri;
            return this;
        }

        public final String getDocumentType() {
            return documentType;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(AugmentedManifestsDocumentTypeFormat documentType) {
            this.documentType(documentType == null ? null : documentType.toString());
            return this;
        }

        @Override
        public AugmentedManifestsListItem build() {
            return new AugmentedManifestsListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
