/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.comprehend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the training documents submitted with an entity recognizer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityRecognizerDocuments implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityRecognizerDocuments.Builder, EntityRecognizerDocuments> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("S3Uri")
            .getter(getter(EntityRecognizerDocuments::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> TEST_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TestS3Uri").getter(getter(EntityRecognizerDocuments::testS3Uri)).setter(setter(Builder::testS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestS3Uri").build()).build();

    private static final SdkField<String> INPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InputFormat").getter(getter(EntityRecognizerDocuments::inputFormatAsString))
            .setter(setter(Builder::inputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputFormat").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            TEST_S3_URI_FIELD, INPUT_FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String testS3Uri;

    private final String inputFormat;

    private EntityRecognizerDocuments(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.testS3Uri = builder.testS3Uri;
        this.inputFormat = builder.inputFormat;
    }

    /**
     * <p>
     * Specifies the Amazon S3 location where the training documents for an entity recognizer are located. The URI must
     * be in the same region as the API endpoint that you are calling.
     * </p>
     * 
     * @return Specifies the Amazon S3 location where the training documents for an entity recognizer are located. The
     *         URI must be in the same region as the API endpoint that you are calling.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * Specifies the Amazon S3 location where the test documents for an entity recognizer are located. The URI must be
     * in the same AWS Region as the API endpoint that you are calling.
     * </p>
     * 
     * @return Specifies the Amazon S3 location where the test documents for an entity recognizer are located. The URI
     *         must be in the same AWS Region as the API endpoint that you are calling.
     */
    public final String testS3Uri() {
        return testS3Uri;
    }

    /**
     * <p>
     * Specifies how the text in an input file should be processed. This is optional, and the default is
     * ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when you are
     * processing large documents, such as newspaper articles or scientific papers. ONE_DOC_PER_LINE - Each line in a
     * file is considered a separate document. Use this option when you are processing many short documents, such as
     * text messages.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputFormat} will
     * return {@link InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputFormatAsString}.
     * </p>
     * 
     * @return Specifies how the text in an input file should be processed. This is optional, and the default is
     *         ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when
     *         you are processing large documents, such as newspaper articles or scientific papers. ONE_DOC_PER_LINE -
     *         Each line in a file is considered a separate document. Use this option when you are processing many short
     *         documents, such as text messages.
     * @see InputFormat
     */
    public final InputFormat inputFormat() {
        return InputFormat.fromValue(inputFormat);
    }

    /**
     * <p>
     * Specifies how the text in an input file should be processed. This is optional, and the default is
     * ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when you are
     * processing large documents, such as newspaper articles or scientific papers. ONE_DOC_PER_LINE - Each line in a
     * file is considered a separate document. Use this option when you are processing many short documents, such as
     * text messages.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #inputFormat} will
     * return {@link InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #inputFormatAsString}.
     * </p>
     * 
     * @return Specifies how the text in an input file should be processed. This is optional, and the default is
     *         ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when
     *         you are processing large documents, such as newspaper articles or scientific papers. ONE_DOC_PER_LINE -
     *         Each line in a file is considered a separate document. Use this option when you are processing many short
     *         documents, such as text messages.
     * @see InputFormat
     */
    public final String inputFormatAsString() {
        return inputFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(testS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(inputFormatAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityRecognizerDocuments)) {
            return false;
        }
        EntityRecognizerDocuments other = (EntityRecognizerDocuments) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(testS3Uri(), other.testS3Uri())
                && Objects.equals(inputFormatAsString(), other.inputFormatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EntityRecognizerDocuments").add("S3Uri", s3Uri()).add("TestS3Uri", testS3Uri())
                .add("InputFormat", inputFormatAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "TestS3Uri":
            return Optional.ofNullable(clazz.cast(testS3Uri()));
        case "InputFormat":
            return Optional.ofNullable(clazz.cast(inputFormatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityRecognizerDocuments, T> g) {
        return obj -> g.apply((EntityRecognizerDocuments) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityRecognizerDocuments> {
        /**
         * <p>
         * Specifies the Amazon S3 location where the training documents for an entity recognizer are located. The URI
         * must be in the same region as the API endpoint that you are calling.
         * </p>
         * 
         * @param s3Uri
         *        Specifies the Amazon S3 location where the training documents for an entity recognizer are located.
         *        The URI must be in the same region as the API endpoint that you are calling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * Specifies the Amazon S3 location where the test documents for an entity recognizer are located. The URI must
         * be in the same AWS Region as the API endpoint that you are calling.
         * </p>
         * 
         * @param testS3Uri
         *        Specifies the Amazon S3 location where the test documents for an entity recognizer are located. The
         *        URI must be in the same AWS Region as the API endpoint that you are calling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testS3Uri(String testS3Uri);

        /**
         * <p>
         * Specifies how the text in an input file should be processed. This is optional, and the default is
         * ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when you
         * are processing large documents, such as newspaper articles or scientific papers. ONE_DOC_PER_LINE - Each line
         * in a file is considered a separate document. Use this option when you are processing many short documents,
         * such as text messages.
         * </p>
         * 
         * @param inputFormat
         *        Specifies how the text in an input file should be processed. This is optional, and the default is
         *        ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when
         *        you are processing large documents, such as newspaper articles or scientific papers. ONE_DOC_PER_LINE
         *        - Each line in a file is considered a separate document. Use this option when you are processing many
         *        short documents, such as text messages.
         * @see InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFormat
         */
        Builder inputFormat(String inputFormat);

        /**
         * <p>
         * Specifies how the text in an input file should be processed. This is optional, and the default is
         * ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when you
         * are processing large documents, such as newspaper articles or scientific papers. ONE_DOC_PER_LINE - Each line
         * in a file is considered a separate document. Use this option when you are processing many short documents,
         * such as text messages.
         * </p>
         * 
         * @param inputFormat
         *        Specifies how the text in an input file should be processed. This is optional, and the default is
         *        ONE_DOC_PER_LINE. ONE_DOC_PER_FILE - Each file is considered a separate document. Use this option when
         *        you are processing large documents, such as newspaper articles or scientific papers. ONE_DOC_PER_LINE
         *        - Each line in a file is considered a separate document. Use this option when you are processing many
         *        short documents, such as text messages.
         * @see InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InputFormat
         */
        Builder inputFormat(InputFormat inputFormat);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String testS3Uri;

        private String inputFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityRecognizerDocuments model) {
            s3Uri(model.s3Uri);
            testS3Uri(model.testS3Uri);
            inputFormat(model.inputFormat);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final String getTestS3Uri() {
            return testS3Uri;
        }

        public final void setTestS3Uri(String testS3Uri) {
            this.testS3Uri = testS3Uri;
        }

        @Override
        public final Builder testS3Uri(String testS3Uri) {
            this.testS3Uri = testS3Uri;
            return this;
        }

        public final String getInputFormat() {
            return inputFormat;
        }

        public final void setInputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
        }

        @Override
        public final Builder inputFormat(String inputFormat) {
            this.inputFormat = inputFormat;
            return this;
        }

        @Override
        public final Builder inputFormat(InputFormat inputFormat) {
            this.inputFormat(inputFormat == null ? null : inputFormat.toString());
            return this;
        }

        @Override
        public EntityRecognizerDocuments build() {
            return new EntityRecognizerDocuments(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
